/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.control;

import com.testin.javafx.Main;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.control.InputDialog;
import com.testin.javafx.ui.control.WebLoadingController;
import java.io.IOException;
import java.io.InputStream;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.BuilderFactory;
import org.apache.log4j.Logger;

public class WebLoading {
    static Logger log = Logger.getLogger(WebLoading.class);
    private WebLoadingController controller;

    public void show(final String message) {
        if (Platform.isFxApplicationThread()) {
            this.init(message);
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    WebLoading.this.init(message);
                }
            });
        }
    }

    private void init(String message) {
        AnchorPane page;
        String fxml = "/com/testin/javafx/ui/control/ProgressDialog.fxml";
        FXMLLoader loader = new FXMLLoader();
        InputStream in = InputDialog.class.getResourceAsStream(fxml);
        loader.setBuilderFactory((BuilderFactory)new JavaFXBuilderFactory());
        loader.setLocation(InputDialog.class.getResource(fxml));
        try {
            try {
                loader.setResources(Main.getResourceBundle());
                page = (AnchorPane)loader.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        Stage stage = new Stage();
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.initOwner((Window)TestinStage.getPrimaryStage());
        stage.initStyle(StageStyle.UNDECORATED);
        stage.setResizable(false);
        Scene scene = new Scene((Parent)page);
        stage.setScene(scene);
        this.controller = (WebLoadingController)((Object)loader.getController());
        this.controller.setMessage(message);
        this.controller.setStage(stage);
    }

    public void show() {
        if (Platform.isFxApplicationThread()) {
            if (this.controller != null) {
                this.controller.show();
            }
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (WebLoading.this.controller != null) {
                        WebLoading.this.controller.show();
                    }
                }
            });
        }
    }

    public void setMessage(final String msg) {
        if (Platform.isFxApplicationThread()) {
            if (this.controller != null) {
                this.controller.setMessage(msg);
            }
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (WebLoading.this.controller != null) {
                        WebLoading.this.controller.setMessage(msg);
                    }
                }
            });
        }
    }

    public void close() {
        if (Platform.isFxApplicationThread()) {
            if (this.controller != null) {
                this.controller.close();
            }
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (WebLoading.this.controller != null) {
                        WebLoading.this.controller.close();
                    }
                }
            });
        }
    }
}

