/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.include;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.testin.itestin.util.Point;
import com.testin.javafx.ui.include.MouseEventListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import org.apache.log4j.Logger;

public final class CoordEmulatorCanvas
extends Canvas {
    static Logger log = Logger.getLogger(CoordEmulatorCanvas.class);
    private static final int IMG_BORDER = 2;
    private int mDx;
    private int mDy;
    private double mScale = 1.0;
    private int mOrientation;
    private Image mScreenshot;
    private int mImageW;
    private int mImageH;
    private double mPointX = -1.0;
    private double mPointY = -1.0;
    private JSONArray mRecordPoints = null;
    private long mMouseDownTime = 0L;
    private MouseEventListener mListener;
    private static List<Point> pointList;
    private static int touch;
    Duration maxTimeBetweenSequentialClicks = Duration.millis((double)500.0);
    PauseTransition clickTimer = new PauseTransition(this.maxTimeBetweenSequentialClicks);
    final IntegerProperty sequentialClickCount = new SimpleIntegerProperty(0);
    private int clickCount = 0;
    private static List<Point> releasePoint;
    private EventHandler<MouseEvent> mouseMovedAdapter = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            event.getButton();
        }
    };
    private EventHandler<MouseEvent> mouseDraggedAdapter = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (event.getButton() == MouseButton.PRIMARY) {
                double y;
                double x = event.getX();
                if (CoordEmulatorCanvas.this.pointInScreenRect(x, y = event.getY())) {
                    CoordEmulatorCanvas.this.mPointX = CoordEmulatorCanvas.this.pointXinScreen(x);
                    CoordEmulatorCanvas.this.mPointY = CoordEmulatorCanvas.this.pointYInScreen(y);
                    if (CoordEmulatorCanvas.this.mRecordPoints != null) {
                        CoordEmulatorCanvas.this.mRecordPoints.add((Object)JSON.parseArray((String)("[" + CoordEmulatorCanvas.this.mPointX + "," + CoordEmulatorCanvas.this.mPointY + "]")));
                    }
                } else {
                    CoordEmulatorCanvas.this.mPointX = -1.0;
                    CoordEmulatorCanvas.this.mPointY = -1.0;
                }
            }
        }
    };
    private EventHandler<MouseEvent> mousePressedAdapter = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            double y;
            double x;
            if (event.getButton() == MouseButton.PRIMARY && CoordEmulatorCanvas.this.pointInScreenRect(x = event.getX(), y = event.getY())) {
                CoordEmulatorCanvas.this.mMouseDownTime = System.currentTimeMillis();
                CoordEmulatorCanvas.this.mRecordPoints = new JSONArray();
                CoordEmulatorCanvas.this.mPointX = CoordEmulatorCanvas.this.pointXinScreen(x);
                CoordEmulatorCanvas.this.mPointY = CoordEmulatorCanvas.this.pointYInScreen(y);
                CoordEmulatorCanvas.this.mRecordPoints.add((Object)JSON.parseArray((String)("[" + CoordEmulatorCanvas.this.mPointX + "," + CoordEmulatorCanvas.this.mPointY + "]")));
            }
        }
    };
    boolean longtouch = false;
    private EventHandler<MouseEvent> mouseReleasedAdapter = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (event.getButton() == MouseButton.PRIMARY) {
                Point p = new Point();
                p.x = event.getX();
                p.y = event.getY();
                releasePoint.add(p);
                CoordEmulatorCanvas.this.sequentialClickCount.set(CoordEmulatorCanvas.this.sequentialClickCount.get() + 1);
                CoordEmulatorCanvas.this.clickTimer.playFromStart();
            }
        }
    };

    static {
        releasePoint = new ArrayList<Point>();
    }

    public CoordEmulatorCanvas(double width, double height, MouseEventListener listener) {
        super(width, height);
        this.mListener = listener;
        this.setOnMouseDragged(this.mouseDraggedAdapter);
        this.setOnMouseMoved(this.mouseMovedAdapter);
        this.setOnMousePressed(this.mousePressedAdapter);
        this.setOnMouseReleased(this.mouseReleasedAdapter);
        this.clickTimer.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                CoordEmulatorCanvas.this.clickCount = CoordEmulatorCanvas.this.sequentialClickCount.get();
                int c = 1;
                if (releasePoint.size() > 1) {
                    c = releasePoint.size();
                }
                int i = 0;
                while (i < c) {
                    if (CoordEmulatorCanvas.this.pointInScreenRect(((Point)releasePoint.get((int)i)).x, ((Point)releasePoint.get((int)i)).y)) {
                        CoordEmulatorCanvas.this.mPointX = CoordEmulatorCanvas.this.pointXinScreen(((Point)releasePoint.get((int)i)).x);
                        CoordEmulatorCanvas.this.mPointY = CoordEmulatorCanvas.this.pointYInScreen(((Point)releasePoint.get((int)i)).y);
                        if (CoordEmulatorCanvas.this.clickCount == 2) {
                            int co = CoordEmulatorCanvas.this.mRecordPoints.size();
                            int j = 0;
                            while (j < 3 - co) {
                                CoordEmulatorCanvas.this.mRecordPoints.add((Object)JSON.parseArray((String)("[" + CoordEmulatorCanvas.this.mPointX + "," + CoordEmulatorCanvas.this.mPointY + "]")));
                                ++j;
                            }
                            if (CoordEmulatorCanvas.this.mRecordPoints == null) break;
                            if (CoordEmulatorCanvas.this.mListener != null) {
                                CoordEmulatorCanvas.this.mRecordPoints.add(0, (Object)JSON.parseArray((String)("[" + CoordEmulatorCanvas.this.mOrientation + "]")));
                                CoordEmulatorCanvas.this.mListener.onDoubleClickEvent(CoordEmulatorCanvas.this.mRecordPoints.toString());
                            }
                            CoordEmulatorCanvas.this.mRecordPoints = null;
                            break;
                        }
                        if (CoordEmulatorCanvas.this.mRecordPoints != null) {
                            CoordEmulatorCanvas.this.mRecordPoints.add((Object)JSON.parseArray((String)("[" + CoordEmulatorCanvas.this.mPointX + "," + CoordEmulatorCanvas.this.mPointY + "]")));
                            if (CoordEmulatorCanvas.this.mRecordPoints.size() <= 3) {
                                long temp = System.currentTimeMillis();
                                long touchtime = temp - CoordEmulatorCanvas.this.mMouseDownTime;
                                if (touchtime < 1000L) {
                                    int co = CoordEmulatorCanvas.this.mRecordPoints.size();
                                    int j = 0;
                                    while (j < 3 - co) {
                                        CoordEmulatorCanvas.this.mRecordPoints.add((Object)JSON.parseArray((String)("[" + CoordEmulatorCanvas.this.mPointX + "," + CoordEmulatorCanvas.this.mPointY + "]")));
                                        ++j;
                                    }
                                } else {
                                    CoordEmulatorCanvas.this.longtouch = true;
                                    if (CoordEmulatorCanvas.this.mRecordPoints != null) {
                                        CoordEmulatorCanvas.this.mRecordPoints.add(0, (Object)JSON.parseArray((String)("[" + touchtime + "]")));
                                        CoordEmulatorCanvas.this.mRecordPoints.add((Object)JSON.parseArray((String)("[" + CoordEmulatorCanvas.this.mPointX + "," + CoordEmulatorCanvas.this.mPointY + "]")));
                                    }
                                }
                            }
                            if (CoordEmulatorCanvas.this.mListener != null) {
                                CoordEmulatorCanvas.this.mRecordPoints.add(0, (Object)JSON.parseArray((String)("[" + CoordEmulatorCanvas.this.mOrientation + "]")));
                                CoordEmulatorCanvas.this.mListener.onMouseEvent(CoordEmulatorCanvas.this.mRecordPoints.toString(), CoordEmulatorCanvas.this.longtouch);
                                CoordEmulatorCanvas.this.longtouch = false;
                            }
                            CoordEmulatorCanvas.this.mRecordPoints.clear();
                        }
                    }
                    ++i;
                }
                CoordEmulatorCanvas.this.mRecordPoints = null;
                releasePoint.clear();
                CoordEmulatorCanvas.this.sequentialClickCount.set(0);
            }
        });
    }

    public void drawPos(int touch) {
        if (pointList != null) {
            GraphicsContext gc = this.getGraphicsContext2D();
            gc.setStroke((Paint)Color.BLUE);
            if (touch == 1 || touch == 2) {
                double x = this.pointXInCanvas(CoordEmulatorCanvas.pointList.get((int)0).x);
                double y = this.pointYInCanvas(CoordEmulatorCanvas.pointList.get((int)0).y);
                gc.setLineWidth(6.0);
                gc.strokeLine(x, y, x, y);
            } else if (touch == 0) {
                double x1 = 0.0;
                double y1 = 0.0;
                double x2 = 0.0;
                double y2 = 0.0;
                gc.setLineWidth(1.0);
                int i = 0;
                while (i < pointList.size() - 1) {
                    x1 = CoordEmulatorCanvas.pointList.get((int)i).x;
                    y1 = CoordEmulatorCanvas.pointList.get((int)i).y;
                    x2 = CoordEmulatorCanvas.pointList.get((int)(i + 1)).x;
                    y2 = CoordEmulatorCanvas.pointList.get((int)(i + 1)).y;
                    gc.strokeLine((double)this.pointXInCanvas(x1), (double)this.pointYInCanvas(y1), (double)this.pointXInCanvas(x2), (double)this.pointYInCanvas(y2));
                    ++i;
                }
                gc.setLineWidth(3.0);
                gc.strokeLine((double)(this.pointXInCanvas(x2) - 2), (double)this.pointYInCanvas(y2), (double)(this.pointXInCanvas(x2) + 1), (double)this.pointYInCanvas(y2));
                gc.strokeLine((double)(this.pointXInCanvas(x2) - 2), (double)this.pointYInCanvas(y2), (double)this.pointXInCanvas(x2), (double)(this.pointYInCanvas(y2) - 3));
                gc.strokeLine((double)(this.pointXInCanvas(x2) + 2), (double)this.pointYInCanvas(y2), (double)this.pointXInCanvas(x2), (double)(this.pointYInCanvas(y2) - 3));
            }
        } else {
            this.repaint();
        }
    }

    public double getScaledSize(double size) {
        if (this.mScale == 1.0) {
            return new Double(size);
        }
        return new Double(size * this.mScale);
    }

    public double getInverseScaledSize(double size) {
        if (this.mScale == 1.0) {
            return new Double(size);
        }
        return new Double(size / this.mScale);
    }

    public void setModel(int orientation, Image screenshot) {
        this.mOrientation = orientation;
        this.mScreenshot = screenshot;
        if (screenshot != null) {
            this.mImageW = (int)screenshot.getWidth();
            this.mImageH = (int)screenshot.getHeight();
            this.repaint();
        } else {
            this.setPointList(null);
        }
    }

    private void updateScreenshotTransformation() {
        double scaleX = (this.getWidth() - 4.0 - 1.0) / this.mScreenshot.getWidth();
        double scaleY = (this.getHeight() - 4.0 - 1.0) / this.mScreenshot.getHeight();
        this.mScale = Math.min(scaleX, scaleY);
        this.mDx = (int)((this.getWidth() - this.getScaledSize(this.mScreenshot.getWidth()) - 4.0) / 2.0 + 2.0);
        this.mDy = (int)((this.getHeight() - this.getScaledSize(this.mScreenshot.getHeight()) - 4.0) / 2.0 + 2.0);
    }

    public void repaint() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                GraphicsContext gc = CoordEmulatorCanvas.this.getGraphicsContext2D();
                if (CoordEmulatorCanvas.this.mScreenshot == null) {
                    gc.clearRect(0.0, 0.0, CoordEmulatorCanvas.this.getWidth(), CoordEmulatorCanvas.this.getHeight());
                    return;
                }
                CoordEmulatorCanvas.this.updateScreenshotTransformation();
                CoordEmulatorCanvas.this.setTranslateX(CoordEmulatorCanvas.this.mDx);
                CoordEmulatorCanvas.this.setTranslateY(CoordEmulatorCanvas.this.mDy);
                gc.clearRect(0.0, 0.0, CoordEmulatorCanvas.this.getWidth(), CoordEmulatorCanvas.this.getHeight());
                gc.drawImage(CoordEmulatorCanvas.this.mScreenshot, 0.0, 0.0, CoordEmulatorCanvas.this.getScaledSize(CoordEmulatorCanvas.this.mScreenshot.getWidth()), CoordEmulatorCanvas.this.getScaledSize(CoordEmulatorCanvas.this.mScreenshot.getHeight()));
                if (pointList != null) {
                    CoordEmulatorCanvas.this.drawPos(touch);
                }
            }
        });
    }

    private boolean pointInScreenRect(double x, double y) {
        double l = 0.0;
        double r = this.getScaledSize(this.mImageW);
        double t = 0.0;
        double b = this.getScaledSize(this.mImageH);
        return x >= l && x < r && y >= t && y < b;
    }

    private double pointXinScreen(double x) {
        int w = this.mOrientation == 0 || this.mOrientation == 2 ? this.mImageW : this.mImageH;
        DecimalFormat df = new DecimalFormat("#.0000");
        return Double.parseDouble(df.format(this.getInverseScaledSize(x) / (double)w));
    }

    private double pointYInScreen(double y) {
        int h = this.mOrientation == 0 || this.mOrientation == 2 ? this.mImageH : this.mImageW;
        DecimalFormat df = new DecimalFormat("#.0000");
        return Double.parseDouble(df.format(this.getInverseScaledSize(y) / (double)h));
    }

    private int pointXInCanvas(Double x) {
        int w = this.mOrientation == 0 || this.mOrientation == 2 ? this.mImageW : this.mImageH;
        int x1 = this.mScale == 1.0 ? (int)(x * (double)w) : (int)(x * (double)w * this.mScale);
        return x1;
    }

    private int pointYInCanvas(Double y) {
        int h = this.mOrientation == 0 || this.mOrientation == 2 ? this.mImageH : this.mImageW;
        int y1 = this.mScale == 1.0 ? (int)(y * (double)h) : (int)(y * (double)h * this.mScale);
        return y1;
    }

    public void setPointList(List<Point> pointList) {
        CoordEmulatorCanvas.pointList = null;
        this.repaint();
        CoordEmulatorCanvas.pointList = pointList;
    }

    public void setTouch(int touch) {
        CoordEmulatorCanvas.touch = touch;
    }
}

