/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.include;

import com.testin.itestin.business.CoordScriptHandler;
import com.testin.itestin.business.SingleTestCase;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.device.DevicesManager;
import com.testin.itestin.device.IDeviceShell;
import com.testin.itestin.device.event.Action;
import com.testin.itestin.device.event.Event;
import com.testin.itestin.device.event.EventListener;
import com.testin.itestin.device.event.Pointer;
import com.testin.itestin.os.Handler;
import com.testin.itestin.os.Message;
import com.testin.itestin.threadpool.ThreadPool;
import com.testin.itestin.util.MessageQueue;
import com.testin.itestin.util.Point;
import com.testin.itestin.util.Utils;
import com.testin.javafx.Main;
import com.testin.javafx.ui.control.DialogResponse;
import com.testin.javafx.ui.control.InputDialog;
import com.testin.javafx.ui.include.CoordEmulatorCanvas;
import com.testin.javafx.ui.include.CoordScriptShowController;
import com.testin.javafx.ui.include.MouseEventListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import net.sf.json.JSONArray;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CoordEmulatorController
extends AnchorPane
implements Initializable,
MouseEventListener,
CoordScriptShowController.ScriptShowMouseEventListener,
EventListener {
    @FXML
    AnchorPane emulator;
    @FXML
    AnchorPane emulatorToolBar;
    @FXML
    AnchorPane emulatorMobile;
    @FXML
    Label screenrecord_indicator;
    @FXML
    Label btnMenu;
    @FXML
    Label btnBack;
    static Logger log = Logger.getLogger(CoordEmulatorController.class);
    private boolean isReplaying;
    private CoordEmulatorCanvas canvas;
    private Thread threadCoordSendTestAction;
    private Thread threadExecActions;
    private Queue<Message> queueActions;
    private Queue<ActionDatas> queueExecActions;
    private boolean isTakeScreenShoting;
    private int imgName = 1;
    private ContextMenu contextMenu = new ContextMenu();
    private String screenrecordTag = "screenrecord:";
    private static List<MenuItem> MenuItems = new ArrayList<MenuItem>();
    private Handler handler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.getStatus()) {
                case 769: {
                    CoordEmulatorController.this.imgName = 1;
                    SingleTestCase.getInstance().setRecording(true);
                    MessageQueue.add(Main.getInternationalString("screen.event.detector.control.prompt"));
                    UIController.updateDeviceSideRecordStatusDisplay();
                    UIController.setLastActionTimeToCurrentTime();
                    CoordEmulatorController.this.handleDumpWindow();
                    CoordEmulatorController.this.initDatas();
                    UIController.setScreenEventListener(CoordEmulatorController.this);
                    UIController.startScreenEventListener();
                    break;
                }
                case 770: {
                    SingleTestCase.getInstance().setRecording(false);
                    CoordEmulatorController.this.addLastTakeScreen();
                    CoordEmulatorController.this.imgName = 1;
                    UIController.setLastActionTime(0L);
                    CoordEmulatorController.this.handleClearScreen();
                    CoordEmulatorController.this.setScreenRecordAsNotReady();
                    UIController.endScreenEventListener();
                    break;
                }
                case 1025: {
                    CoordEmulatorController.this.isReplaying = true;
                    UIController.setLastActionTimeToCurrentTime();
                    CoordEmulatorController.this.handleDumpWindow();
                    break;
                }
                case 1026: {
                    CoordEmulatorController.this.isReplaying = false;
                    UIController.setLastActionTime(0L);
                    CoordEmulatorController.this.handleClearScreen();
                    break;
                }
                case 771: {
                    if (SingleTestCase.getInstance().isRecording()) {
                        UIController.setLastActionTimeToCurrentTime();
                    }
                    CoordEmulatorController.this.setScreenRecordAsEnabled();
                    break;
                }
                case 772: {
                    CoordEmulatorController.this.handleTakeScreenshot();
                    break;
                }
                case 768: {
                    CoordEmulatorController.this.handleClearScreen();
                    break;
                }
                case 1283: {
                    CoordEmulatorController.this.updateScreenRecordIndicator();
                    break;
                }
            }
        }
    };

    static {
        MenuItems.add(CoordEmulatorController.createMenuItem(Main.getInternationalString("coordemulatorcontroller.menuitems1"), "text"));
        MenuItems.add(CoordEmulatorController.createMenuItem(Main.getInternationalString("coordemulatorcontroller.menuitems2"), "username"));
        MenuItems.add(CoordEmulatorController.createMenuItem(Main.getInternationalString("coordemulatorcontroller.menuitems3"), "password"));
        MenuItems.add(CoordEmulatorController.createMenuItem(Main.getInternationalString("coordemulatorcontroller.menuitems4"), "randomtext"));
        MenuItems.add((MenuItem)CoordEmulatorController.createSeparatorMenuItem());
        MenuItems.add(CoordEmulatorController.createMenuItem(Main.getInternationalString("coordemulatorcontroller.menuitems5"), "assert"));
    }

    public CoordEmulatorController() {
        UIController.setCoordEmulatorHandler(this.handler);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.initContextMenu();
        this.btnBack.setTooltip(new Tooltip(Main.getInternationalString("coordemulator.button.back")));
        this.btnMenu.setTooltip(new Tooltip(Main.getInternationalString("coordemulator.button.menu")));
        int width = (int)this.emulatorMobile.getPrefWidth();
        int height = (int)this.emulatorMobile.getPrefHeight();
        this.canvas = new CoordEmulatorCanvas(width, height, this);
        CoordScriptShowController a = new CoordScriptShowController();
        a.SetScriptShowListener(this);
        this.emulatorMobile.getChildren().add((Object)this.canvas);
    }

    private static MenuItem createMenuItem(String text, String id) {
        Label lbl = new Label(text);
        lbl.setPrefWidth(130.0);
        lbl.setWrapText(true);
        MenuItem menuItem = new MenuItem();
        menuItem.setId(id);
        menuItem.setGraphic((Node)lbl);
        return menuItem;
    }

    private static SeparatorMenuItem createSeparatorMenuItem() {
        SeparatorMenuItem menuItem = new SeparatorMenuItem();
        return menuItem;
    }

    private void addLastTakeScreen() {
        if (SingleTestCase.getInstance().isAutoShot()) {
            String takeScreenAction = "screen:pic_" + String.valueOf(this.imgName);
            Message tableMsg = new Message();
            tableMsg.setStatus(773);
            tableMsg.setContent(takeScreenAction);
            this.queueActions.offer(tableMsg);
            ++this.imgName;
        }
    }

    private void initDatas() {
        if (this.threadCoordSendTestAction != null) {
            this.threadCoordSendTestAction = null;
        }
        if (this.threadExecActions != null) {
            this.threadExecActions = null;
        }
        if (this.queueActions != null) {
            this.queueActions.clear();
        }
        if (this.queueExecActions != null) {
            this.queueExecActions.clear();
        }
    }

    private Image takeScreenShot(int flag) {
        byte[] imagedata;
        Image screenshot = null;
        if (DevicesManager.getShell() != null && (imagedata = DevicesManager.getShell().getScreenshot(flag)) != null) {
            screenshot = new Image((InputStream)new ByteArrayInputStream(imagedata));
        }
        return screenshot;
    }

    private void handleDumpWindow() {
        Thread t = new Thread("Coord-DumpWindowHandler"){

            @Override
            public void run() {
                while (SingleTestCase.getInstance().isRecording() || CoordEmulatorController.this.isReplaying) {
                    long wait_time_for_next_screenshot;
                    if (!CoordEmulatorController.this.isTakeScreenShoting && (wait_time_for_next_screenshot = System.currentTimeMillis() - Utils.CURRENT_SCREENSHOT_TAKEN_TIME) > (long)Utils.SCREENSHOT_INTERVAL) {
                        try {
                            if (!DevicesManager.isDeviceOK(DevicesManager.getDevice())) {
                                log.info((Object)"\u8bbe\u5907\u5df2\u7ecf\u6389\u7ebf\uff01");
                                break;
                            }
                            int rotation = CoordEmulatorController.this.getRotation();
                            Image screenshot = CoordEmulatorController.this.takeScreenShot(rotation);
                            CoordEmulatorController.this.canvas.setModel(rotation, screenshot);
                        }
                        catch (Exception ex) {
                            log.error((Object)ex.getMessage(), (Throwable)ex);
                        }
                    }
                    Utils.sleep(Utils.SCREENSHOT_INTERVAL);
                }
                Utils.gc();
            }
        };
        ThreadPool.execute(t);
    }

    private void handleTakeScreenshot() {
        Thread t = new Thread("Coord-TakeScreenshot"){

            @Override
            public void run() {
                int rotation = CoordEmulatorController.this.getRotation();
                Image screenshot = CoordEmulatorController.this.takeScreenShot(rotation);
                CoordEmulatorController.this.canvas.setModel(rotation, screenshot);
                Utils.gc();
            }
        };
        ThreadPool.execute(t);
    }

    private void sendActionTakeScreenshot() {
        if (this.isTakeScreenShoting) {
            return;
        }
        Thread t = new Thread("Coord-TakeScreenshot"){

            @Override
            public void run() {
                try {
                    CoordEmulatorController.this.isTakeScreenShoting = true;
                    int delay = 500;
                    Utils.sleep(500L);
                    int rotation = CoordEmulatorController.this.getRotation();
                    Image screenshot = CoordEmulatorController.this.takeScreenShot(rotation);
                    CoordEmulatorController.this.canvas.setModel(rotation, screenshot);
                }
                finally {
                    CoordEmulatorController.this.isTakeScreenShoting = false;
                }
            }
        };
        ThreadPool.execute(t);
    }

    private void handleClearScreen() {
        this.canvas.setModel(0, null);
    }

    private void initContextMenu() {
        this.contextMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MenuItem item = (MenuItem)event.getTarget();
                CoordEmulatorController.this.handleMenuItem(item.getId());
                CoordEmulatorController.this.hideContextMenu();
            }
        });
        this.contextMenu.getItems().addAll(MenuItems);
    }

    private String getRandomString(int len) {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < len) {
            int num = random.nextInt(i == 0 ? 52 : 62);
            buf.append(str.charAt(num));
            ++i;
        }
        return buf.toString();
    }

    private void handleMenuItem(String id) {
        if (id == null) {
            return;
        }
        String action = null;
        if (id.equals("text")) {
            DialogResponse response = InputDialog.show(Main.getInternationalString("coordemulatorcontroller.handlemenuitem.text1"), "");
            if (response.option == DialogResponse.Options.OK) {
                String value = response.value;
                action = "input:" + value;
            }
        } else if (id.equals("username")) {
            DialogResponse response = InputDialog.show(Main.getInternationalString("coordemulatorcontroller.handlemenuitem.text2"), "");
            if (response.option == DialogResponse.Options.OK) {
                String value = response.value;
                action = "input:%username%" + value;
            }
        } else if (id.equals("password")) {
            DialogResponse response = InputDialog.show(Main.getInternationalString("coordemulatorcontroller.handlemenuitem.text3"), "");
            if (response.option == DialogResponse.Options.OK) {
                String value = response.value;
                action = "input:%password%" + value;
            }
        } else if (id.equals("randomtext")) {
            DialogResponse response = InputDialog.show(Main.getInternationalString("coordemulatorcontroller.handlemenuitem.text4"), "4");
            if (response.option == DialogResponse.Options.OK) {
                String value = response.value;
                action = "input:%randomtext%" + this.getRandomString(Integer.parseInt(value));
            }
        } else if (id.equals("assert")) {
            DialogResponse response = InputDialog.show(Main.getInternationalString("coordemulatorcontroller.handlemenuitem.text5"), "");
            if (response.option == DialogResponse.Options.OK) {
                String value = response.value;
                action = "assert:30:" + value;
            }
        }
        if (action != null && StringUtils.isNotEmpty(action)) {
            this.sendTestAction(action);
        }
    }

    private void sendTestAction(String action) {
        Pattern p;
        Matcher m;
        if (this.queueActions == null) {
            this.queueActions = new LinkedBlockingQueue<Message>();
        }
        if (this.queueExecActions == null) {
            this.queueExecActions = new LinkedBlockingQueue<ActionDatas>();
        }
        boolean needExecute = true;
        if (action.startsWith(this.screenrecordTag)) {
            needExecute = false;
            action = action.replace(this.screenrecordTag, "");
        }
        if ((m = (p = Pattern.compile("^(\\w+):(.*?)$")).matcher(action)).find()) {
            String act = m.group(1);
            String data = m.group(2);
            if (needExecute) {
                this.queueExecActions.offer(new ActionDatas(act, data));
            }
            if (!act.equals("sleep")) {
                if (UIController.getLastActionTime() != 0L) {
                    long sleep = UIController.getLastActionElapseTime();
                    String sleepAction = "sleep:" + (int)sleep;
                    if (UIController.getCoordscriptShowHandler() != null) {
                        Message tableMsg = new Message();
                        tableMsg.setStatus(773);
                        tableMsg.setContent(sleepAction);
                        this.queueActions.offer(tableMsg);
                        if (SingleTestCase.getInstance().isAutoShot()) {
                            String takeScreenAction = "screen:pic_" + String.valueOf(this.imgName);
                            tableMsg = new Message();
                            tableMsg.setStatus(773);
                            tableMsg.setContent(takeScreenAction);
                            this.queueActions.offer(tableMsg);
                            ++this.imgName;
                        }
                    }
                }
                UIController.setLastActionTimeToCurrentTime();
                if (UIController.getCoordscriptShowHandler() != null) {
                    Message tableMsg = new Message();
                    tableMsg.setStatus(773);
                    tableMsg.setContent(action);
                    this.queueActions.offer(tableMsg);
                }
            }
        }
        if (this.threadCoordSendTestAction == null) {
            this.threadCoordSendTestAction = new Thread("Coord-SendTestAction"){

                @Override
                public void run() {
                    while (SingleTestCase.getInstance().isRecording()) {
                        Message tableMsg = (Message)CoordEmulatorController.this.queueActions.poll();
                        if (tableMsg != null) {
                            UIController.getCoordscriptShowHandler().sendMessage(tableMsg);
                        }
                        Utils.sleep(5L);
                    }
                }
            };
            ThreadPool.execute(this.threadCoordSendTestAction);
        }
        if (this.threadExecActions == null) {
            this.threadExecActions = new Thread("Coord-ExecActions"){

                @Override
                public void run() {
                    while (SingleTestCase.getInstance().isRecording()) {
                        ActionDatas datas = (ActionDatas)CoordEmulatorController.this.queueExecActions.poll();
                        if (datas != null) {
                            CoordEmulatorController.this.exeAction(datas.getAction(), datas.getData());
                            CoordEmulatorController.this.sendActionTakeScreenshot();
                        }
                        Utils.sleep(5L);
                    }
                }
            };
            ThreadPool.execute(this.threadExecActions);
        }
    }

    private boolean exeAction(String act, String data) {
        if (act.equals("assert") || act.equals("screen") || act.equals("sleep")) {
            return true;
        }
        return this.runCmd(act, data);
    }

    private boolean runCmd(String act, String data) {
        if (!SingleTestCase.getInstance().isRecording()) {
            return false;
        }
        return CoordScriptHandler.runCmd(DevicesManager.getDevice(), act, data).getStatus() == 0;
    }

    private boolean isSingleCaseIsRecording() {
        return SingleTestCase.getInstance().isRecording();
    }

    @FXML
    public void clickMenu(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            if (this.isSingleCaseIsRecording()) {
                String action = "press:82";
                this.sendTestAction(action);
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            if (this.isSingleCaseIsRecording()) {
                UIController.updateNodeSytleClass((Node)this.btnMenu, "menubtnBkgEnter");
            } else {
                UIController.updateNodeSytleClass((Node)this.btnMenu, "menubtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_EXITED")) {
            if (this.isSingleCaseIsRecording()) {
                UIController.updateNodeSytleClass((Node)this.btnMenu, "menubtnBkg");
            } else {
                UIController.updateNodeSytleClass((Node)this.btnMenu, "menubtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_PRESSED")) {
            if (this.isSingleCaseIsRecording()) {
                UIController.updateNodeSytleClass((Node)this.btnMenu, "menubtnBkgPress");
            } else {
                UIController.updateNodeSytleClass((Node)this.btnMenu, "menubtnBkgDisable");
            }
        }
    }

    @FXML
    public void clickBack(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            if (this.isSingleCaseIsRecording()) {
                String action = "press:4";
                this.sendTestAction(action);
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            if (this.isSingleCaseIsRecording()) {
                UIController.updateNodeSytleClass((Node)this.btnBack, "backbtnBkgEnter");
            } else {
                UIController.updateNodeSytleClass((Node)this.btnBack, "backbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_EXITED")) {
            if (this.isSingleCaseIsRecording()) {
                UIController.updateNodeSytleClass((Node)this.btnBack, "backbtnBkg");
            } else {
                UIController.updateNodeSytleClass((Node)this.btnBack, "backbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_PRESSED")) {
            if (this.isSingleCaseIsRecording()) {
                UIController.updateNodeSytleClass((Node)this.btnBack, "backbtnBkgPress");
            } else {
                UIController.updateNodeSytleClass((Node)this.btnBack, "backbtnBkgDisable");
            }
        }
    }

    @FXML
    public void clickScreenShot(MouseEvent event) {
        if (SingleTestCase.getInstance().isRecording()) {
            String action = "screen:pic_" + String.valueOf(this.imgName);
            this.sendTestAction(action);
            ++this.imgName;
        }
    }

    @Override
    public void onMouseEvent(String json, boolean isLong) {
        if (SingleTestCase.getInstance().isRecording()) {
            if (isLong) {
                String action = "longtouch:" + json;
                this.sendTestAction(action);
                log.debug((Object)json);
            } else {
                String action = "touch:" + json;
                this.sendTestAction(action);
                log.debug((Object)json);
            }
        }
    }

    @FXML
    public void clickEmulator(MouseEvent event) {
        if (SingleTestCase.getInstance().isRecording()) {
            MouseButton button = event.getButton();
            switch (button) {
                case PRIMARY: {
                    this.hideContextMenu();
                    break;
                }
                case SECONDARY: {
                    break;
                }
            }
        }
    }

    private void hideContextMenu() {
        if (this.contextMenu.isShowing()) {
            this.contextMenu.hide();
        }
    }

    @FXML
    public void showContextMenu(ContextMenuEvent event) {
        if (SingleTestCase.getInstance().isRecording()) {
            this.contextMenu.show((Node)this.canvas, event.getScreenX(), event.getScreenY());
        }
    }

    @FXML
    public void clickScreenRecord(MouseEvent event) {
        if (!SingleTestCase.getInstance().isRecording()) {
            this.setScreenRecordAsNotReady();
            return;
        }
        if (Utils.enableScreenEventDetector) {
            this.setScreenRecordAsDisabled();
        } else {
            this.setScreenRecordAsEnabled();
        }
    }

    private void updateScreenRecordIndicator() {
        if (!SingleTestCase.getInstance().isRecording()) {
            this.setScreenRecordAsNotReady();
            return;
        }
        if (Utils.enableScreenEventDetector) {
            this.setScreenRecordAsEnabled();
        } else {
            this.setScreenRecordAsDisabled();
        }
    }

    private void setScreenRecordAsNotReady() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                CoordEmulatorController.this.screenrecord_indicator.setTooltip(new Tooltip(Main.getInternationalString("screen.event.detector.info")));
                CoordEmulatorController.this.screenrecord_indicator.getStyleClass().clear();
                CoordEmulatorController.this.screenrecord_indicator.getStyleClass().add((Object)"screenRecordNotReady");
            }
        });
    }

    private void setScreenRecordAsEnabled() {
        Utils.enableScreenEventDetector = true;
        if (UIController.isEventDetectorRunning()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    CoordEmulatorController.this.screenrecord_indicator.getStyleClass().clear();
                    CoordEmulatorController.this.screenrecord_indicator.getStyleClass().add((Object)"screenRecordEnabled");
                    CoordEmulatorController.this.screenrecord_indicator.setTooltip(new Tooltip(Main.getInternationalString("screen.event.detector.enabled")));
                }
            });
        } else {
            log.info((Object)"screen detector thread is not running, still set indicator as not ready.");
            this.setScreenRecordAsNotReady();
        }
    }

    private void setScreenRecordAsDisabled() {
        Utils.enableScreenEventDetector = false;
        if (UIController.isEventDetectorRunning()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    CoordEmulatorController.this.screenrecord_indicator.getStyleClass().clear();
                    CoordEmulatorController.this.screenrecord_indicator.getStyleClass().add((Object)"screenRecordDisabled");
                    CoordEmulatorController.this.screenrecord_indicator.setTooltip(new Tooltip(Main.getInternationalString("screen.event.detector.disabled")));
                }
            });
        } else {
            log.info((Object)"screen detector thread is not running, still set indicator as not ready.");
            this.setScreenRecordAsNotReady();
        }
    }

    @Override
    public void onScriptShowMouseEvent(List<Point> pointList, int touch) {
        if (SingleTestCase.getInstance().isRecording()) {
            this.canvas.drawPos(touch);
        }
    }

    @Override
    public void setData(List<Point> pointList, int touch) {
        this.canvas.setPointList(pointList);
        this.canvas.setTouch(touch);
    }

    @Override
    public void onDoubleClickEvent(String json) {
        if (SingleTestCase.getInstance().isRecording()) {
            String action = "doubletouch:" + json;
            this.sendTestAction(action);
            log.debug((Object)json);
        }
    }

    private int getRotation() {
        int rotation = 0;
        try {
            rotation = DevicesManager.getShell().getRotation();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return rotation;
    }

    private JSONArray getRelativePointer(Pointer point, int rotation) {
        if (point != null && DevicesManager.isDeviceOK()) {
            float screenwidth = DevicesManager.getDevice().getScreenDpiWidth();
            float screenheight = DevicesManager.getDevice().getScreenDpiHeight();
            float x = this.getX(point, screenwidth, screenheight, rotation);
            float y = this.getY(point, screenwidth, screenheight, rotation);
            JSONArray pointValue = new JSONArray();
            pointValue.add((Object)Float.valueOf(x));
            pointValue.add((Object)Float.valueOf(y));
            return pointValue;
        }
        if (point != null) {
            JSONArray pointValue = new JSONArray();
            pointValue.add((Object)Float.valueOf(point.getX()));
            pointValue.add((Object)Float.valueOf(point.getY()));
            return pointValue;
        }
        return null;
    }

    private float getX(Pointer point, float sourceWidth, float sourceHeight, int rotation) {
        if (rotation == 0) {
            if (point != null) {
                if (sourceWidth > 0.0f) {
                    return (float)point.getX() / sourceWidth;
                }
                return point.getX();
            }
        } else if (rotation == 1) {
            if (point != null) {
                if (sourceWidth > 0.0f) {
                    return (float)point.getY() / sourceWidth;
                }
                return point.getY();
            }
        } else if (rotation == 3 && point != null) {
            if (sourceWidth > 0.0f) {
                return (sourceHeight - (float)point.getY()) / sourceWidth;
            }
            return (sourceHeight - (float)point.getY()) / sourceWidth;
        }
        return 0.0f;
    }

    private float getY(Pointer point, float sourceWidth, float sourceHeight, int rotation) {
        if (rotation == 0) {
            if (point != null) {
                if (sourceHeight > 0.0f) {
                    return (float)point.getY() / sourceHeight;
                }
                return point.getY();
            }
        } else if (rotation == 1) {
            if (point != null) {
                if (sourceHeight > 0.0f) {
                    return (sourceWidth - (float)point.getX()) / sourceHeight;
                }
                return (sourceWidth - (float)point.getX()) / sourceHeight;
            }
        } else if (rotation == 3 && point != null) {
            if (sourceHeight > 0.0f) {
                return (float)point.getX() / sourceHeight;
            }
            return (float)point.getX() / sourceHeight;
        }
        return 0.0f;
    }

    private JSONArray generateClickActionStr(Event event) {
        if (event != null && (event.getType() == 0 || event.getType() == 1 || event.getType() == 4)) {
            JSONArray action = new JSONArray();
            JSONArray rotation = new JSONArray();
            int rotationValue = this.getRotation();
            rotation.add((Object)rotationValue);
            action.add((Object)rotation);
            if (event.getType() == 1) {
                JSONArray timeUsed = new JSONArray();
                timeUsed.add((Object)(event.getEndTime() - event.getStartTime()));
                action.add((Object)timeUsed);
            }
            action.add((Object)this.getRelativePointer(event.getCenter(), rotationValue));
            action.add((Object)this.getRelativePointer(event.getCenter(), rotationValue));
            action.add((Object)this.getRelativePointer(event.getCenter(), rotationValue));
            return action;
        }
        log.error((Object)"this is not click or long click event, cannot use it to generate click or long click action string.");
        return null;
    }

    private JSONArray generateDragActionStr(Event event) {
        if (event != null && event.getType() == 2) {
            JSONArray action = new JSONArray();
            JSONArray rotation = new JSONArray();
            int rotationValue = this.getRotation();
            rotation.add((Object)rotationValue);
            action.add((Object)rotation);
            ArrayList<Action> actionList = event.getActionList();
            if (actionList != null) {
                for (Action a : actionList) {
                    JSONArray pointValue;
                    if (a.getPoint().isZero() || (pointValue = this.getRelativePointer(a.getPoint(), rotationValue)) == null) continue;
                    action.add((Object)this.getRelativePointer(a.getPoint(), rotationValue));
                }
            }
            return action;
        }
        log.error((Object)"this is not drag event, cannot use it to generate drag action string.");
        return null;
    }

    @Override
    public void handleEvent(Event event) {
        log.info((Object)("detected screen event: " + event));
        if (!SingleTestCase.getInstance().isRecording()) {
            log.info((Object)"It's not under recording state right now, ignore the event.");
            return;
        }
        if (event == null || !DevicesManager.isDeviceOK()) {
            log.error((Object)"event is invalid, or device is not online, ignore this event.");
            return;
        }
        JSONArray action = new JSONArray();
        if (event.getType() == 0 || event.getType() == 1 || event.getType() == 4) {
            String actionTag;
            action = this.generateClickActionStr(event);
            String string = event.getType() == 0 ? "touch:" : (actionTag = event.getType() == 1 ? "longtouch:" : "doubletouch:");
            if (action != null) {
                this.sendTestAction(String.format("%s%s%s", this.screenrecordTag, actionTag, action.toString()));
            }
        }
        if (event.getType() == 2 && (action = this.generateDragActionStr(event)) != null) {
            this.sendTestAction(String.format("%s%s%s", this.screenrecordTag, "touch:", action.toString()));
        }
        if (event.getType() == 3) {
            String actionStr;
            if (event.getKeycode().equals((Object)IDeviceShell.KeyCode.BACK)) {
                actionStr = String.valueOf(this.screenrecordTag) + "press:4";
                this.sendTestAction(actionStr);
            }
            if (event.getKeycode().equals((Object)IDeviceShell.KeyCode.MENU)) {
                actionStr = String.valueOf(this.screenrecordTag) + "press:82";
                this.sendTestAction(actionStr);
            }
        }
    }

    private static class ActionDatas {
        private String action;
        private String data;

        public ActionDatas(String act, String data) {
            this.action = act;
            this.data = data;
        }

        public String getAction() {
            return this.action;
        }

        public String getData() {
            return this.data;
        }
    }
}

