/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.include;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.testin.itestin.business.SingleTestCase;
import com.testin.itestin.business.TestFileUtils;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.os.Handler;
import com.testin.itestin.os.Message;
import com.testin.itestin.util.Point;
import com.testin.javafx.Main;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.control.AlertDialog;
import com.testin.javafx.ui.control.DialogResponse;
import com.testin.javafx.ui.control.InputDialog;
import com.testin.javafx.ui.control.ScriptAlterDialog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CoordScriptShowController
extends AnchorPane
implements Initializable {
    static Logger log = Logger.getLogger(CoordScriptShowController.class);
    @FXML
    TableView<Script> tableview;
    @FXML
    TextArea textArea;
    @FXML
    Label text;
    @FXML
    Label script;
    @FXML
    Label sleepbtn;
    @FXML
    Label shotbtn;
    @FXML
    Label editbtn;
    @FXML
    Label delbtn;
    @FXML
    Label descbtn;
    private ContextMenu contextMenu = new ContextMenu();
    private Vector<String> scriptEdit = new Vector();
    private String scriptPath;
    private static boolean Edit = false;
    private static List<MenuItem> MenuItems = new ArrayList<MenuItem>();
    private static MenuItem alterItem;
    private static ScriptShowMouseEventListener sSMListener;
    private Handler handler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.getStatus()) {
                case 773: {
                    CoordScriptShowController.this.addScriptRecord(msg.getContent(), false);
                    if (SingleTestCase.getInstance().isRecording()) break;
                    CoordScriptShowController.this.saveScript(CoordScriptShowController.this.scriptPath);
                    break;
                }
                case 774: {
                    CoordScriptShowController.this.scriptPath = msg.getContent();
                    CoordScriptShowController.this.saveScript(CoordScriptShowController.this.scriptPath);
                    break;
                }
                case 769: {
                    if (!SingleTestCase.getInstance().isEditing()) {
                        CoordScriptShowController.this.clearScriptUI();
                    }
                    CoordScriptShowController.this.enableBottomButtonsStyle();
                    break;
                }
                case 1282: {
                    CoordScriptShowController.this.clearScriptUI();
                    CoordScriptShowController.this.scriptPath = SingleTestCase.getInstance().getCoordScriptPath();
                    CoordScriptShowController.this.show(CoordScriptShowController.this.scriptPath);
                    break;
                }
                case 1027: {
                    int index = Integer.parseInt(msg.getContent());
                    CoordScriptShowController.this.tableview.scrollTo(index - 1);
                    CoordScriptShowController.this.tableview.getSelectionModel().select(index - 1);
                    break;
                }
                case 1026: {
                    if (msg.getContent(Integer.class) == null) {
                        return;
                    }
                    CoordScriptShowController.this.stopReplay(msg);
                    break;
                }
                case 770: {
                    SingleTestCase.getInstance().setRecording(false);
                    SingleTestCase.getInstance().setEditing(false);
                    break;
                }
                case 768: {
                    CoordScriptShowController.this.clearScriptUI();
                    CoordScriptShowController.this.disableBottomButtonsSytle();
                    break;
                }
            }
        }
    };

    static {
        MenuItems.add(CoordScriptShowController.createMenuItem(Main.getInternationalString("coordscriptshowcontroller.menuitem1"), "sleep"));
        MenuItems.add(CoordScriptShowController.createMenuItem(Main.getInternationalString("coordscriptshowcontroller.menuitem2"), "screenshot"));
        MenuItems.add((MenuItem)CoordScriptShowController.createSeparatorMenuItem());
        alterItem = CoordScriptShowController.createMenuItem(Main.getInternationalString("coordscriptshowcontroller.menuitem3"), "alter");
        MenuItems.add(alterItem);
        MenuItems.add(CoordScriptShowController.createMenuItem(Main.getInternationalString("coordscriptshowcontroller.menuitem4"), "delete"));
    }

    public void SetScriptShowListener(ScriptShowMouseEventListener listener) {
        sSMListener = listener;
    }

    @FXML
    public void showContextMenu(ContextMenuEvent event) {
        if (this.tableview.getItems().size() > 0 && SingleTestCase.getInstance().getRunType() == 0) {
            alterItem.setDisable(false);
            this.contextMenu.show(this.tableview, event.getScreenX(), event.getScreenY());
        }
    }

    private static SeparatorMenuItem createSeparatorMenuItem() {
        SeparatorMenuItem menuItem = new SeparatorMenuItem();
        return menuItem;
    }

    private void initContextMenu() {
        this.contextMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MenuItem item = (MenuItem)event.getTarget();
                CoordScriptShowController.this.handleMenuItem(item.getId());
                CoordScriptShowController.this.hideContextMenu();
            }
        });
        this.contextMenu.getItems().addAll(MenuItems);
    }

    private void handleMenuItem(String id) {
        if (id == null) {
            return;
        }
        int index = this.tableview.getSelectionModel().getSelectedIndex();
        if (!(this.tableview.getItems().size() <= 0 && !id.equals("delete") && !id.equals("alter") || index >= 0 || id.equals("step") || id.equals("sleep") || id.equals("screenshot"))) {
            AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("coordscriptshowcontroller.handlemenuitem.selectedline"));
            return;
        }
        if (id.equals("sleep")) {
            DialogResponse sleep = InputDialog.show(Main.getInternationalString("coordscriptshowcontroller.handlemenuitem.inputdelaytime"), "2000");
            if (sleep.option == DialogResponse.Options.OK) {
                String time = sleep.value;
                this.addScriptRecordAndSave("sleep:", time);
            }
        } else if (id.equals("screenshot")) {
            int imgNum = this.screenshotNum(this.scriptEdit);
            String nextImgName = "pic_" + String.valueOf(++imgNum);
            this.addScriptRecordAndSave("screen:", nextImgName);
        } else if (id.equals("delete")) {
            this.deleteScriptRecord();
        } else if (id.equals("step")) {
            DialogResponse description = InputDialog.show(Main.getInternationalString("coordscriptshowcontroller.menuitem5"), "//");
            if (description.option == DialogResponse.Options.OK) {
                if (description.value.equals("")) {
                    AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("scriptshowcontroller.handlemenuitem.alterconnull"));
                    return;
                }
                String value = description.value;
                this.addScriptRecordAndSave("note:", value);
            }
        } else if (id.equals("alter")) {
            String alterContext = ((Script)this.tableview.getSelectionModel().getSelectedItem()).getEle();
            if ("".equals(alterContext)) {
                return;
            }
            String con = ((Script)this.tableview.getSelectionModel().getSelectedItem()).getAct();
            String longtouch = "";
            String longtouchtmp = "";
            if (con.trim().equals(Main.getInternationalString("emulatorcontroller.menuitems13"))) {
                alterContext = alterContext.substring(3);
            } else if (con.trim().equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.longtouch"))) {
                longtouch = alterContext;
                longtouchtmp = alterContext.split(",")[1];
                alterContext = longtouchtmp.replace("[", "").replace("]", "");
            }
            DialogResponse alter = ScriptAlterDialog.show(Main.getInternationalString("coordscriptshowcontroller.handlemenuitem.inputaltercontent"), alterContext);
            if (alter.option == DialogResponse.Options.OK) {
                String value = alter.value;
                this.editScriptRecord(con, value, longtouch, longtouchtmp);
            }
        }
    }

    private void editTextArea(Vector<String> script) {
        this.textArea.clear();
        for (String v : script) {
            this.textArea.appendText(String.valueOf(v) + "\r\n");
        }
    }

    private TableColumn<String, String> createTableColumn(double width, String show, String data) {
        TableColumn col = new TableColumn(show);
        col.setResizable(false);
        col.setSortable(false);
        col.setPrefWidth(width);
        col.setCellValueFactory((Callback)new PropertyValueFactory(data));
        return col;
    }

    public void initialize(URL arg0, ResourceBundle arg1) {
        UIController.setCoordscriptShowHandler(this.handler);
        this.initContextMenu();
        this.textArea.setEditable(true);
        this.textArea.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (TestinStage.getRecordController() != null) {
                    if (CoordScriptShowController.this.isScriptTextChanged()) {
                        TestinStage.getRecordController().setSaveScript(true);
                    } else {
                        TestinStage.getRecordController().setSaveScript(false);
                    }
                }
            }
        });
        this.sleepbtn.setTooltip(new Tooltip(Main.getInternationalString("coordscriptshowcontroller.menuitem1")));
        this.shotbtn.setTooltip(new Tooltip(Main.getInternationalString("coordscriptshowcontroller.menuitem2")));
        this.editbtn.setTooltip(new Tooltip(Main.getInternationalString("coordscriptshowcontroller.menuitem3")));
        this.delbtn.setTooltip(new Tooltip(Main.getInternationalString("coordscriptshowcontroller.menuitem4")));
        this.descbtn.setTooltip(new Tooltip(Main.getInternationalString("coordscriptshowcontroller.menuitem5")));
        Object[] columns = new TableColumn[]{this.createTableColumn(100.0, Main.getInternationalString("coordscriptshowcontroller.initialize.action"), "act"), this.createTableColumn(371.0, Main.getInternationalString("coordscriptshowcontroller.initialize.element"), "ele")};
        this.tableview.getColumns().setAll(columns);
        this.tableview.getColumns().addListener((ListChangeListener)new ListChangeListener<Object>((TableColumn[])columns){
            public boolean suspended = true;
            private final /* synthetic */ TableColumn[] val$columns;
            {
                this.val$columns = tableColumnArray;
            }

            public void onChanged(ListChangeListener.Change<?> change) {
                change.next();
                if (change.wasReplaced() && this.suspended) {
                    this.suspended = false;
                    CoordScriptShowController.this.tableview.getColumns().setAll((Object[])this.val$columns);
                    this.suspended = true;
                }
            }
        });
        this.tableview.visibleProperty().set(true);
        this.textArea.setVisible(false);
        UIController.updateNodeSytleClass((Node)this.text, "tab-unclick");
        UIController.updateNodeSytleClass((Node)this.script, "tab-click");
        this.tableview.getItems().add((Object)new Script("", ""));
    }

    protected boolean isScriptTextChanged() {
        return false;
    }

    private static MenuItem createMenuItem(String text, String id) {
        Label lbl = new Label(text);
        lbl.setPrefWidth(130.0);
        lbl.setWrapText(true);
        MenuItem menuItem = new MenuItem();
        menuItem.setId(id);
        menuItem.setGraphic((Node)lbl);
        return menuItem;
    }

    private Script getScriptFromString(String str) {
        String act = null;
        String show = null;
        if (str.startsWith("launch:")) {
            act = "        " + Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.launch");
            show = str.substring(str.indexOf(":") + 1);
        } else if (str.startsWith("sleep:")) {
            act = "        " + Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.delay");
            show = str.substring(str.indexOf(":") + 1);
        } else if (str.startsWith("touch:")) {
            act = "        " + Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.touch");
            show = str.substring(str.indexOf(":") + 1);
        } else if (str.startsWith("doubletouch:")) {
            act = "        " + Main.getInternationalString("emulatorcontroller.doubleclick");
            show = str.substring(str.indexOf(":") + 1);
        } else if (str.startsWith("longtouch:")) {
            act = "        " + Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.longtouch");
            show = str.substring(str.indexOf(":") + 1);
        } else if (str.startsWith("press:")) {
            act = "        " + Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.press");
            show = str.substring(str.indexOf(":") + 1);
        } else if (str.startsWith("assert:")) {
            act = "        " + Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.assert");
            show = str.substring(str.indexOf(":") + 1);
        } else if (str.startsWith("screen:")) {
            act = "        " + Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.screen");
            show = str.substring(str.indexOf(":") + 1);
        } else if (str.startsWith("input:")) {
            String subStr = str.substring(str.indexOf(":") + 1);
            if (subStr.startsWith("%randomtext%")) {
                act = "        " + Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.randomtext");
                show = subStr.substring("%randomtext%".length());
            } else if (subStr.startsWith("%username%")) {
                act = "        " + Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.username");
                show = subStr.substring("%username%".length());
            } else if (subStr.startsWith("%password%")) {
                act = "        " + Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.password");
                show = subStr.substring("%password%".length());
            } else {
                act = "        " + Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.text");
                show = subStr;
            }
        } else if (str.startsWith("note:")) {
            act = Main.getInternationalString("coordscriptshowcontroller.menuitem5");
            show = str.substring(str.indexOf(":") + 1);
        }
        return new Script(act, show);
    }

    private void scriptShowInTable(int index, String str) {
        this.addToTableView(index, this.getScriptFromString(str));
    }

    private void saveScript(String savePath) {
        String str;
        log.info((Object)("Save script to: " + savePath));
        if (!new File(new File(savePath).getParent()).exists()) {
            new File(new File(savePath).getParent()).mkdirs();
        }
        StringBuffer buffer = new StringBuffer();
        ObservableList scripts = this.tableview.getItems();
        if (scripts != null && scripts.size() > 0) {
            for (Script s : scripts) {
                if (s.getAct() == null) continue;
                String action = s.getAct().replaceAll(" ", "");
                if (action.equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.delay"))) {
                    int sleep = Integer.parseInt(s.getEle());
                    sleep = sleep < 10 ? 10 : sleep;
                    buffer.append("sleep:" + sleep);
                } else if (action.equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.launch"))) {
                    buffer.append("launch:" + s.getEle());
                } else if (action.equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.username"))) {
                    buffer.append("input:%username%" + s.getEle());
                } else if (action.equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.password"))) {
                    buffer.append("input:%password%" + s.getEle());
                } else if (action.equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.randomtext"))) {
                    buffer.append("input:%randomtext%" + s.getEle());
                } else if (action.equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.text"))) {
                    buffer.append("input:" + s.getEle());
                } else if (action.equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.press"))) {
                    int code = Integer.parseInt(s.getEle());
                    if (code == 4 || code == 82) {
                        buffer.append("press:" + code);
                    }
                } else if (action.equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.touch"))) {
                    try {
                        JSONArray array = JSON.parseArray((String)s.getEle());
                        if (array.size() >= 2) {
                            buffer.append("touch:" + s.getEle());
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                } else if (action.equals(Main.getInternationalString("emulatorcontroller.doubleclick"))) {
                    try {
                        JSONArray array = JSON.parseArray((String)s.getEle());
                        if (array.size() >= 2) {
                            buffer.append("doubletouch:" + s.getEle());
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                } else if (action.equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.longtouch"))) {
                    try {
                        JSONArray array = JSON.parseArray((String)s.getEle());
                        if (array.size() >= 2) {
                            buffer.append("longtouch:" + s.getEle());
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                } else if (action.equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.screen"))) {
                    buffer.append("screen:" + s.getEle());
                } else if (action.equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.assert"))) {
                    buffer.append("assert:" + s.getEle());
                } else if (action.equals("//")) {
                    buffer.append(s.getEle());
                } else if (action.equals(Main.getInternationalString("coordscriptshowcontroller.menuitem5"))) {
                    buffer.append("note:" + s.getEle());
                }
                buffer.append("\r\n");
            }
        }
        if ((str = buffer.toString()).length() > 0) {
            try {
                FileOutputStream out = new FileOutputStream(new File(savePath));
                out.write(str.getBytes());
                out.close();
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (TestinStage.getCoordRecordController() != null) {
            TestinStage.getCoordRecordController().setSaveScript(false);
        }
    }

    private void show(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return;
        }
        if (this.scriptEdit != null) {
            this.scriptEdit.clear();
        }
        String realPath = TestFileUtils.getRealCoordScriptPath(path);
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(realPath)));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                this.scriptEdit.add(line);
                this.tableview.getItems().add((Object)this.getScriptFromString(line));
            }
            br.close();
            this.editTextArea(this.scriptEdit);
            this.tableview.getItems().add((Object)new Script("", ""));
            SingleTestCase.getInstance().setSaved(true);
        }
        catch (FileNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private int screenshotNum(Vector<String> v) {
        if (v.size() == 0) {
            return 0;
        }
        int num = 0;
        int i = 0;
        while (i < v.size()) {
            String str = v.get(i);
            if (str.contains("screen:")) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    @FXML
    private void scriptClick(MouseEvent event) {
        if (this.tableview.isVisible()) {
            return;
        }
        String[] lines = this.textArea.getText().split("\r?\n");
        this.scriptEdit.clear();
        this.tableview.getItems().clear();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.scriptEdit.add(line);
            this.tableview.getItems().add((Object)this.getScriptFromString(line));
            ++n2;
        }
        this.tableview.getItems().add((Object)new Script("", ""));
        this.tableview.setVisible(true);
        this.textArea.setVisible(false);
        UIController.updateNodeSytleClass((Node)this.text, "tab-unclick");
        UIController.updateNodeSytleClass((Node)this.script, "tab-click");
    }

    @FXML
    private void textClick(MouseEvent event) {
        this.tableview.setVisible(false);
        this.textArea.setVisible(true);
        UIController.updateNodeSytleClass((Node)this.text, "tab-click");
        UIController.updateNodeSytleClass((Node)this.script, "tab-unclick");
    }

    @FXML
    public void leftClick(MouseEvent event) {
        if (event.getClickCount() > 1) {
            this.handleMenuItem("alter");
        } else {
            MouseButton button = event.getButton();
            switch (button) {
                case PRIMARY: {
                    this.hideContextMenu();
                    this.showPos();
                    break;
                }
                case SECONDARY: {
                    break;
                }
            }
        }
    }

    @FXML
    public void sleepClick(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            if (this.isSingleCaseHaveName()) {
                this.handleMenuItem("sleep");
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.sleepbtn, "sleepbtnBkgEnter");
            } else {
                UIController.updateNodeSytleClass((Node)this.sleepbtn, "sleepbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_EXITED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.sleepbtn, "sleepbtnBkg");
            } else {
                UIController.updateNodeSytleClass((Node)this.sleepbtn, "sleepbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_PRESSED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.sleepbtn, "sleepbtnBkgPress");
            } else {
                UIController.updateNodeSytleClass((Node)this.sleepbtn, "sleepbtnBkgDisable");
            }
        }
    }

    @FXML
    public void shotClick(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            if (this.isSingleCaseHaveName()) {
                this.handleMenuItem("screenshot");
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.shotbtn, "shotbtnBkgEnter");
            } else {
                UIController.updateNodeSytleClass((Node)this.shotbtn, "shotbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_EXITED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.shotbtn, "shotbtnBkg");
            } else {
                UIController.updateNodeSytleClass((Node)this.shotbtn, "shotbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_PRESSED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.shotbtn, "shotbtnBkgPress");
            } else {
                UIController.updateNodeSytleClass((Node)this.shotbtn, "shotbtnBkgDisable");
            }
        }
    }

    @FXML
    public void stepClick(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            if (this.isSingleCaseHaveName()) {
                this.handleMenuItem("step");
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.descbtn, "descbtnBkgEnter");
            } else {
                UIController.updateNodeSytleClass((Node)this.descbtn, "descbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_EXITED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.descbtn, "descbtnBkg");
            } else {
                UIController.updateNodeSytleClass((Node)this.descbtn, "descbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_PRESSED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.descbtn, "descbtnBkgPress");
            } else {
                UIController.updateNodeSytleClass((Node)this.descbtn, "descbtnBkgDisable");
            }
        }
    }

    @FXML
    public void alterClick(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            if (this.isSingleCaseHaveName()) {
                this.handleMenuItem("alter");
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.editbtn, "editbtnBkgEnter");
            } else {
                UIController.updateNodeSytleClass((Node)this.editbtn, "editbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_EXITED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.editbtn, "editbtnBkg");
            } else {
                UIController.updateNodeSytleClass((Node)this.editbtn, "editbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_PRESSED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.editbtn, "editbtnBkgPress");
            } else {
                UIController.updateNodeSytleClass((Node)this.editbtn, "editbtnBkgDisable");
            }
        }
    }

    @FXML
    public void deleteClick(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            if (this.isSingleCaseHaveName()) {
                this.handleMenuItem("delete");
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.delbtn, "delbtnBkgEnter");
            } else {
                UIController.updateNodeSytleClass((Node)this.delbtn, "delbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_EXITED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.delbtn, "delbtnBkg");
            } else {
                UIController.updateNodeSytleClass((Node)this.delbtn, "delbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_PRESSED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.delbtn, "delbtnBkgPress");
            } else {
                UIController.updateNodeSytleClass((Node)this.delbtn, "delbtnBkgDisable");
            }
        }
    }

    private void enableBottomButtonsStyle() {
        UIController.updateNodeSytleClass((Node)this.delbtn, "delbtnBkg");
        UIController.updateNodeSytleClass((Node)this.editbtn, "editbtnBkg");
        UIController.updateNodeSytleClass((Node)this.descbtn, "descbtnBkg");
        UIController.updateNodeSytleClass((Node)this.shotbtn, "shotbtnBkg");
        UIController.updateNodeSytleClass((Node)this.sleepbtn, "sleepbtnBkg");
    }

    private void disableBottomButtonsSytle() {
        UIController.updateNodeSytleClass((Node)this.delbtn, "delbtnBkgDisable");
        UIController.updateNodeSytleClass((Node)this.editbtn, "editbtnBkgDisable");
        UIController.updateNodeSytleClass((Node)this.descbtn, "descbtnBkgDisable");
        UIController.updateNodeSytleClass((Node)this.shotbtn, "shotbtnBkgDisable");
        UIController.updateNodeSytleClass((Node)this.sleepbtn, "sleepbtnBkgDisable");
    }

    private boolean isSingleCaseHaveName() {
        return SingleTestCase.getInstance().getName() != null;
    }

    private void hideContextMenu() {
        if (this.contextMenu.isShowing()) {
            this.contextMenu.hide();
        }
    }

    private void showPos() {
        if (this.tableview.getSelectionModel().isEmpty()) {
            return;
        }
        int touch = 0;
        ArrayList<Point> tempPointList = new ArrayList<Point>();
        Point newPoint = new Point();
        Point oldPoint = new Point();
        int num = 0;
        if (((Script)this.tableview.getSelectionModel().getSelectedItem()).getAct() == null) {
            return;
        }
        String selectAction = ((Script)this.tableview.getSelectionModel().getSelectedItem()).getAct().replace(" ", "");
        if (selectAction.equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.touch")) || selectAction.equals(Main.getInternationalString("emulatorcontroller.menuitems2")) || selectAction.equals(Main.getInternationalString("emulatorcontroller.doubleclick"))) {
            String selectData = ((Script)this.tableview.getSelectionModel().getSelectedItem()).getEle();
            JSONArray points = JSON.parseArray((String)selectData);
            JSONArray first = points.getJSONArray(0);
            JSONArray second = points.getJSONArray(1);
            if (first.size() == 1) {
                points.remove(0);
            }
            if (second.size() == 1) {
                points.remove(0);
            }
            JSONArray point = points.getJSONArray(0);
            oldPoint.x = point.getDouble(0);
            oldPoint.y = point.getDouble(1);
            int i = 0;
            while (i < points.size() - 1) {
                point = points.getJSONArray(i + 1);
                newPoint.x = point.getDouble(0);
                newPoint.y = point.getDouble(1);
                if (selectAction.equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.touch")) || selectAction.equals(Main.getInternationalString("emulatorcontroller.doubleclick"))) {
                    if (newPoint.x == oldPoint.x && newPoint.y == oldPoint.y) {
                        if (points.size() <= 5 || num <= 3) {
                            touch = 1;
                        }
                    } else {
                        oldPoint.x = newPoint.x;
                        oldPoint.y = newPoint.y;
                        touch = 0;
                        ++num;
                    }
                } else if (selectAction.equals(Main.getInternationalString("emulatorcontroller.menuitems2"))) {
                    touch = 2;
                }
                Point p = new Point();
                p.x = oldPoint.x;
                p.y = oldPoint.y;
                tempPointList.add(p);
                ++i;
            }
            sSMListener.setData(tempPointList, touch);
        } else {
            sSMListener.setData(null, 0);
        }
        sSMListener.onScriptShowMouseEvent(tempPointList, touch);
    }

    private void deleteScriptRecord() {
        int index = this.tableview.getSelectionModel().getSelectedIndex();
        if (index < this.scriptEdit.size()) {
            String content = this.scriptEdit.get(index);
            if (content.startsWith("sleep")) {
                content = content.substring(6);
            }
            if (this.tableview.getItems().isEmpty()) {
                return;
            }
            this.tableview.getItems().remove(index);
            this.scriptEdit.remove(index);
            this.editTextArea(this.scriptEdit);
            Edit = true;
            if (TestinStage.getCoordRecordController() != null) {
                TestinStage.getCoordRecordController().setSaveScript(Edit);
            }
        }
    }

    private void addScriptRecord(String obj, boolean isshow) {
        int index = -1;
        if (SingleTestCase.getInstance().isEditing()) {
            if (isshow) {
                this.scriptEdit.add(obj);
            } else {
                index = this.tableview.getSelectionModel().getSelectedIndex();
                if (this.tableview.getSelectionModel().isEmpty()) {
                    index = this.tableview.getItems().size() - 1;
                    this.scriptEdit.add(obj);
                } else {
                    this.scriptEdit.insertElementAt(obj, index);
                }
            }
        } else {
            this.scriptEdit.add(obj);
        }
        this.scriptShowInTable(index, obj);
        this.editTextArea(this.scriptEdit);
    }

    private void addScriptRecordAndSave(String flag, String content) {
        int index = this.tableview.getSelectionModel().getSelectedIndex();
        Script script = null;
        if (flag.equals("sleep:")) {
            script = new Script("        " + Main.getInternationalString("coordscriptshowcontroller.handlemenuitem.delay"), content);
        } else if (flag.equals("screen:")) {
            script = new Script("        " + Main.getInternationalString("coordscriptshowcontroller.handlemenuitem.screenshot"), content);
        } else if (flag.equals("note:")) {
            script = new Script(Main.getInternationalString("coordscriptshowcontroller.menuitem5"), content);
        }
        if (index < 0) {
            this.addToTableView(this.scriptEdit.size(), script);
            this.scriptEdit.add(this.scriptEdit.size(), String.valueOf(flag) + content);
        } else {
            this.addToTableView(index, script);
            this.scriptEdit.add(index, String.valueOf(flag) + content);
        }
        this.editTextArea(this.scriptEdit);
        Edit = true;
        if (TestinStage.getCoordRecordController() != null) {
            TestinStage.getCoordRecordController().setSaveScript(Edit);
        }
    }

    private void editScriptRecord(String con, String value, String longtouch, String longtouchtmp) {
        int index = this.tableview.getSelectionModel().getSelectedIndex();
        if (con.equals(Main.getInternationalString("emulatorcontroller.menuitems13"))) {
            this.tableview.getItems().set(index, (Object)new Script(con, "30:" + value));
        } else {
            if (con.trim().equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.longtouch"))) {
                value = longtouch.replace(longtouchtmp, "[" + value + "]");
            }
            this.tableview.getItems().set(index, (Object)new Script(con, value));
        }
        con = con.replace(" ", "");
        if (con.equals(Main.getInternationalString("coordscriptshowcontroller.handlemenuitem.delay"))) {
            this.scriptEdit.set(index, "sleep:" + value);
        } else if (con.equals(Main.getInternationalString("coordscriptshowcontroller.handlemenuitem.screenshot"))) {
            this.scriptEdit.set(index, "screen:" + value);
        } else if (con.equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.touch"))) {
            this.scriptEdit.set(index, "touch:" + value);
        } else if (con.equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.longtouch"))) {
            this.scriptEdit.set(index, "longtouch:" + value);
        } else if (con.equals(Main.getInternationalString("emulatorcontroller.menuitems9"))) {
            this.scriptEdit.set(index, "input:" + value);
        } else if (con.equals(Main.getInternationalString("emulatorcontroller.menuitems12"))) {
            this.scriptEdit.set(index, "input:%randomtext%" + value);
        } else if (con.equals(Main.getInternationalString("emulatorcontroller.menuitems10"))) {
            this.scriptEdit.set(index, "input:%username%" + value);
        } else if (con.equals(Main.getInternationalString("emulatorcontroller.menuitems11"))) {
            this.scriptEdit.set(index, "input:%password%" + value);
        } else if (con.equals(Main.getInternationalString("emulatorcontroller.menuitems13"))) {
            this.scriptEdit.set(index, "assert:30:" + value);
        } else if (con.equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.press"))) {
            this.scriptEdit.set(index, "press:" + value);
        } else if (con.equals(Main.getInternationalString("coordscriptshowcontroller.menuitem5"))) {
            this.scriptEdit.set(index, "note:" + value);
        }
        this.editTextArea(this.scriptEdit);
        Edit = true;
        if (TestinStage.getCoordRecordController() != null) {
            TestinStage.getCoordRecordController().setSaveScript(Edit);
        }
    }

    private void addToTableView(int index, Script script) {
        if (this.tableview.getItems().size() > 0) {
            this.tableview.getItems().remove(this.tableview.getItems().size() - 1);
        }
        if (index < 0) {
            this.tableview.getItems().add((Object)script);
        } else {
            this.tableview.getItems().add(index, (Object)script);
        }
        this.tableview.getItems().add((Object)new Script("", ""));
        this.tableview.getSelectionModel().select(index + 1);
        if (this.tableview.getItems().size() >= 8) {
            this.tableview.scrollTo(this.tableview.getItems().size());
        }
    }

    private void stopReplay(Message msg) {
        int state = (Integer)msg.getContent(Integer.class);
        if (state == 0) {
            String name = new File(this.scriptPath).getName();
            name = String.valueOf(name.substring(0, name.lastIndexOf("_"))) + "_1.script";
            String newName = String.valueOf(new File(this.scriptPath).getParent()) + File.separator + name;
            new File(this.scriptPath).renameTo(new File(newName));
            File ini = new File(String.valueOf(new File(this.scriptPath).getParent()) + File.separator + "default.ini");
            if (ini.exists()) {
                FileUtils.deleteQuietly((File)ini);
            }
            try {
                FileOutputStream out = new FileOutputStream(ini);
                String text = String.valueOf(name.substring(0, name.indexOf("_"))) + "\r\n";
                out.write(text.getBytes());
                out.close();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            String name = new File(this.scriptPath).getName();
            name = String.valueOf(name.substring(0, name.lastIndexOf("_"))) + "_2.script";
            String newName = String.valueOf(new File(this.scriptPath).getParent()) + File.separator + name;
            new File(this.scriptPath).renameTo(new File(newName));
        }
    }

    private void clearScriptUI() {
        this.scriptEdit.clear();
        this.tableview.getItems().clear();
        this.textArea.clear();
        this.tableview.scrollTo(0);
    }

    public class Script {
        private String act;
        private String ele;

        public Script(String id, String ele) {
            this.act = id;
            this.ele = ele;
        }

        public String getAct() {
            return this.act;
        }

        public void setAct(String act) {
            this.act = act;
        }

        public String getEle() {
            return this.ele;
        }

        public void setEle(String ele) {
            this.ele = ele;
        }
    }

    public static interface ScriptShowMouseEventListener {
        public void onScriptShowMouseEvent(List<Point> var1, int var2);

        public void setData(List<Point> var1, int var2);
    }
}

