/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.include;

import com.testin.itestin.business.MyRectangle;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.device.DevicesManager;
import com.testin.itestin.uiautomator.UiAutomatorModel;
import com.testin.itestin.uiautomator.tree.BasicTreeNode;
import java.text.DecimalFormat;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import org.apache.log4j.Logger;

public final class EmulatorCanvas
extends Canvas {
    static Logger log = Logger.getLogger(EmulatorCanvas.class);
    private static final int IMG_BORDER = 2;
    private int mDx;
    private int mDy;
    private boolean isMainPackage = true;
    private double mScale = 1.0;
    private UiAutomatorModel mModel;
    private BasicTreeNode mSelectedNode;
    private double pointX = -1.0;
    private double pointY = -1.0;
    private boolean isCoordC = false;
    private MouseEventListener mListener;
    private boolean dragFlag = false;
    private double fromX = -1.0;
    private double fromY = -1.0;
    private double toX = -1.0;
    private double toY = -1.0;
    private Image mScreenshot;
    private double screenWidth = 0.0;
    private double screenHeight = 0.0;
    private EventHandler<MouseEvent> mouseMovedAdapter = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            String eventType = event.getEventType().getName();
            if (eventType.equals("MOUSE_MOVED") && EmulatorCanvas.this.mModel != null && EmulatorCanvas.this.mModel.isExploreMode()) {
                BasicTreeNode node;
                EmulatorCanvas.this.pointX = event.getX();
                EmulatorCanvas.this.pointY = event.getY();
                if (EmulatorCanvas.this.isScreenInfoValid() && EmulatorCanvas.this.pointX <= EmulatorCanvas.this.getScreenWidth() && EmulatorCanvas.this.pointY <= EmulatorCanvas.this.getScreenHeight() && (node = EmulatorCanvas.this.mModel.getSelectedNodeByCoordinates((int)EmulatorCanvas.this.getInverseScaledSize((int)EmulatorCanvas.this.pointX), (int)EmulatorCanvas.this.getInverseScaledSize((int)EmulatorCanvas.this.pointY))) != null) {
                    EmulatorCanvas.this.mModel.setSelectedNode(node);
                    EmulatorCanvas.this.repaint();
                }
            }
        }
    };
    private EventHandler<MouseEvent> mousePressedAdapter = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            MouseButton mouseButton = event.getButton();
            String eventType = event.getEventType().getName();
            if (eventType.equals("MOUSE_PRESSED") && mouseButton == MouseButton.PRIMARY) {
                log.debug((Object)String.format("Detect mouse press on (%s, %s).", event.getX(), event.getY()));
                double x = event.getX();
                double y = event.getY();
                if (EmulatorCanvas.this.isInsideScreen(x, y)) {
                    EmulatorCanvas.this.fromX = EmulatorCanvas.this.pointXInScreen(x);
                    EmulatorCanvas.this.fromY = EmulatorCanvas.this.pointYInScreen(y);
                }
            }
        }
    };
    private EventHandler<MouseEvent> mouseDraggedAdapter = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            MouseButton mouseButton = event.getButton();
            String eventType = event.getEventType().getName();
            if (eventType.equals("MOUSE_DRAGGED") && mouseButton == MouseButton.PRIMARY) {
                EmulatorCanvas.this.dragFlag = true;
            }
        }
    };
    private EventHandler<MouseEvent> mouseReleasedAdapter = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            MouseButton mouseButton = event.getButton();
            String eventType = event.getEventType().getName();
            if (eventType.equals("MOUSE_RELEASED") && mouseButton == MouseButton.PRIMARY) {
                log.debug((Object)String.format("Detect mouse release on (%s, %s).", event.getX(), event.getY()));
                if (EmulatorCanvas.this.mModel != null) {
                    EmulatorCanvas.this.isCoordC = EmulatorCanvas.this.isCoordClick(EmulatorCanvas.this.getSelectedNode(), EmulatorCanvas.this.mModel.getSelectedNode());
                    EmulatorCanvas.this.updateTreeSelection(EmulatorCanvas.this.mModel.getSelectedNode());
                    EmulatorCanvas.this.repaint();
                }
                if (EmulatorCanvas.this.dragFlag) {
                    EmulatorCanvas.this.dragFlag = false;
                    double x = event.getX();
                    double y = event.getY();
                    if (EmulatorCanvas.this.isInsideScreen(x, y)) {
                        EmulatorCanvas.this.toX = EmulatorCanvas.this.pointXInScreen(x);
                        EmulatorCanvas.this.toY = EmulatorCanvas.this.pointYInScreen(y);
                        if (!EmulatorCanvas.this.isMainPackage()) {
                            EmulatorCanvas.this.mListener.onRemoteDrag(UIController.getRotation(), (float)EmulatorCanvas.this.fromX, (float)EmulatorCanvas.this.toX, (float)EmulatorCanvas.this.fromY, (float)EmulatorCanvas.this.toY);
                        } else {
                            EmulatorCanvas.this.mListener.onLocalDrag(UIController.getRotation(), (float)EmulatorCanvas.this.fromX, (float)EmulatorCanvas.this.toX, (float)EmulatorCanvas.this.fromY, (float)EmulatorCanvas.this.toY);
                        }
                    }
                }
            }
        }
    };
    private EventHandler<MouseEvent> mouseClickedAdapter = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            MouseButton mouseButton = event.getButton();
            String eventType = event.getEventType().getName();
            if (eventType.equals("MOUSE_CLICKED") && mouseButton == MouseButton.PRIMARY) {
                log.debug((Object)String.format("Detect mouse click on (%s, %s).", event.getX(), event.getY()));
                double x = event.getX();
                double y = event.getY();
                double dx = EmulatorCanvas.this.pointXInScreen(x);
                double dy = EmulatorCanvas.this.pointYInScreen(y);
                if (EmulatorCanvas.this.isInsideScreen(x, y)) {
                    if (!EmulatorCanvas.this.isMainPackage()) {
                        EmulatorCanvas.this.mListener.onRemoteClick(UIController.getRotation(), dx, dy);
                    } else if (dx >= 1.0 || dy >= 1.0) {
                        EmulatorCanvas.this.mListener.onRemoteClick(UIController.getRotation(), dx, dy);
                    } else if (EmulatorCanvas.this.isCoordC) {
                        EmulatorCanvas.this.mListener.onLocalClick(UIController.getRotation(), dx, dy);
                    }
                }
            }
        }
    };

    public EmulatorCanvas(double width, double height, MouseEventListener listener) {
        super(width, height);
        this.setOnMouseMoved(this.mouseMovedAdapter);
        this.setOnMouseReleased(this.mouseReleasedAdapter);
        this.setOnMouseDragged(this.mouseDraggedAdapter);
        this.setOnMouseClicked(this.mouseClickedAdapter);
        this.setOnMousePressed(this.mousePressedAdapter);
        this.mListener = listener;
    }

    private boolean isInsideScreen(double x, double y) {
        if (!this.isScreenInfoValid()) {
            return false;
        }
        double left = 0.0;
        double screenWidth = this.getScaledScreenWidth();
        double top = 0.0;
        double screenHeight = this.getScaledScreenHeight();
        return x >= left && x < screenWidth && y >= top && y < screenHeight;
    }

    private double pointXInScreen(double x) {
        if (!DevicesManager.isDeviceOK()) {
            return 0.0;
        }
        int w = UIController.getRotation() == 0 || UIController.getRotation() == 2 ? DevicesManager.getDevice().getDisplayWidth() : DevicesManager.getDevice().getDisplayHeight();
        DecimalFormat df = new DecimalFormat("#.0000");
        return Double.parseDouble(df.format(this.getInverseScaledSize(x) / (double)w));
    }

    private double pointYInScreen(double y) {
        if (!DevicesManager.isDeviceOK()) {
            return 0.0;
        }
        int h = UIController.getRotation() == 0 || UIController.getRotation() == 2 ? DevicesManager.getDevice().getDisplayHeight() : DevicesManager.getDevice().getDisplayWidth();
        DecimalFormat df = new DecimalFormat("#.0000");
        return Double.parseDouble(df.format(this.getInverseScaledSize(y) / (double)h));
    }

    private boolean isCoordClick(BasicTreeNode oldNode, BasicTreeNode newNode) {
        boolean res = false;
        if (oldNode == null) {
            return res;
        }
        if (newNode == null) {
            return true;
        }
        log.debug((Object)("old: " + oldNode.getX() + "," + oldNode.getY() + "," + oldNode.getWidth() + "," + oldNode.getHeight()));
        log.debug((Object)("new: " + newNode.getX() + "," + newNode.getY() + "," + newNode.getWidth() + "," + newNode.getHeight()));
        if (oldNode.getX() == newNode.getX() && oldNode.getY() == newNode.getY() && oldNode.getWidth() == newNode.getWidth() && oldNode.getHeight() == newNode.getHeight()) {
            res = true;
        }
        return res;
    }

    public double getScaledSize(double size) {
        if (this.mScale == 1.0) {
            return new Double(size);
        }
        return new Double(size * this.mScale);
    }

    public double getInverseScaledSize(double size) {
        if (this.mScale == 1.0) {
            return new Double(size);
        }
        return new Double(size / this.mScale);
    }

    public BasicTreeNode getSelectedNode() {
        return this.mSelectedNode;
    }

    public void updateTreeSelection(BasicTreeNode node) {
        this.mSelectedNode = node;
        this.repaint();
    }

    public void setModel(boolean isMain, int orientation, Image screenshot) {
        this.setMainPackage(isMain);
        UIController.setRotation(orientation);
        this.setScreenshot(screenshot);
    }

    public void setModel(boolean isMain, int orientation, UiAutomatorModel model, Image screenshot) {
        if (model == null || screenshot == null) {
            return;
        }
        this.setMainPackage(isMain);
        UIController.setRotation(orientation);
        this.mModel = model;
        this.setScreenshot(screenshot);
        if (this.isScreenInfoValid()) {
            BasicTreeNode node;
            double imgWidth = this.getScaledScreenWidth();
            double imgHeight = this.getScaledScreenHeight();
            if (this.pointX <= imgWidth && this.pointY <= imgHeight && this.mModel != null && (node = this.mModel.getSelectedNodeByCoordinates((int)this.getInverseScaledSize((int)this.pointX), (int)this.getInverseScaledSize((int)this.pointY))) != null) {
                this.mModel.setSelectedNode(node);
            }
            this.repaint();
        }
    }

    private void updateScreenshotTransformation() {
        double scaleX = (this.getWidth() - 4.0 - 1.0) / this.getScreenWidth();
        double scaleY = (this.getHeight() - 4.0 - 1.0) / this.getScreenHeight();
        this.mScale = Math.min(scaleX, scaleY);
        this.mDx = (int)((this.getWidth() - this.getScaledScreenWidth() - 4.0) / 2.0 + 2.0);
        this.mDy = (int)((this.getHeight() - this.getScaledScreenHeight() - 4.0) / 2.0 + 2.0);
        if (this.mDx < 0) {
            this.mDx = 0;
        }
        if (this.mDy < 0) {
            this.mDy = 0;
        }
        this.setTranslateX(this.mDx);
        this.setTranslateY(this.mDy);
    }

    public void repaint() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                double dheight;
                log.debug((Object)"Repaint canvas.");
                GraphicsContext gc = EmulatorCanvas.this.getGraphicsContext2D();
                if (EmulatorCanvas.this.getScreenshot() == null) {
                    gc.clearRect(0.0, 0.0, EmulatorCanvas.this.getWidth(), EmulatorCanvas.this.getHeight());
                    return;
                }
                EmulatorCanvas.this.updateScreenshotTransformation();
                gc.clearRect(0.0, 0.0, EmulatorCanvas.this.getWidth(), EmulatorCanvas.this.getHeight());
                double dwidth = EmulatorCanvas.this.getScaledScreenWidth();
                if (dwidth < 0.0) {
                    dwidth = 0.0;
                }
                if ((dheight = EmulatorCanvas.this.getScaledScreenHeight()) < 0.0) {
                    dheight = 0.0;
                }
                gc.drawImage(EmulatorCanvas.this.getScreenshot(), 0.0, 0.0, dwidth, dheight);
                if (EmulatorCanvas.this.isMainPackage()) {
                    MyRectangle mRect;
                    if (EmulatorCanvas.this.mModel != null && (mRect = EmulatorCanvas.this.mModel.getCurrentDrawingRect()) != null && !((double)mRect.x >= EmulatorCanvas.this.getScreenWidth()) && !((double)mRect.y >= EmulatorCanvas.this.getScreenHeight())) {
                        int h1;
                        int w1;
                        int y1;
                        Rectangle rect = new Rectangle((double)mRect.x, (double)mRect.y, (double)mRect.width, (double)mRect.height);
                        gc.setLineWidth(1.0);
                        gc.setStroke((Paint)Color.RED);
                        int x1 = (int)EmulatorCanvas.this.getScaledSize(rect.getX());
                        if (x1 < 0) {
                            x1 = 0;
                        }
                        if ((y1 = (int)EmulatorCanvas.this.getScaledSize(rect.getY())) < 0) {
                            y1 = 0;
                        }
                        if ((w1 = (int)EmulatorCanvas.this.getScaledSize(rect.getWidth())) < 0) {
                            w1 = 0;
                        }
                        if ((h1 = (int)EmulatorCanvas.this.getScaledSize(rect.getHeight())) < 0) {
                            h1 = 0;
                        }
                        EmulatorCanvas.this.strokeRect(gc, x1, y1, w1, h1);
                    }
                    if (EmulatorCanvas.this.getSelectedNode() != null) {
                        double h1;
                        double w1;
                        double y1;
                        gc.setLineWidth(2.0);
                        gc.setStroke((Paint)Color.RED);
                        double x1 = EmulatorCanvas.this.getScaledSize(EmulatorCanvas.this.getSelectedNode().getX());
                        if (x1 < 0.0) {
                            x1 = 0.0;
                        }
                        if ((y1 = EmulatorCanvas.this.getScaledSize(EmulatorCanvas.this.getSelectedNode().getY())) < 0.0) {
                            y1 = 0.0;
                        }
                        if ((w1 = EmulatorCanvas.this.getScaledSize(EmulatorCanvas.this.getSelectedNode().getWidth())) < 0.0) {
                            w1 = 0.0;
                        }
                        if ((h1 = EmulatorCanvas.this.getScaledSize(EmulatorCanvas.this.getSelectedNode().getHeight())) < 0.0) {
                            h1 = 0.0;
                        }
                        gc.strokeRect(x1, y1, w1, h1);
                    }
                } else {
                    double h1;
                    gc.setLineWidth(2.0);
                    gc.setStroke((Paint)Color.RED);
                    double w1 = EmulatorCanvas.this.getScaledScreenWidth();
                    if (w1 < 0.0) {
                        w1 = 0.0;
                    }
                    if ((h1 = EmulatorCanvas.this.getScaledScreenHeight()) < 0.0) {
                        h1 = 0.0;
                    }
                    gc.strokeRect(0.0, 0.0, w1, h1);
                }
            }
        });
    }

    private void strokeRect(GraphicsContext gc, int x, int y, int width, int height) {
        int dash = 8;
        int i = x;
        while (i < x + width) {
            if (i % dash == 0) {
                int toX = i + dash;
                toX = toX > x + width ? x + width : toX;
                gc.strokeLine((double)i, (double)y, (double)toX, (double)y);
                gc.strokeLine((double)i, (double)(y + height), (double)toX, (double)(y + height));
                i = toX + dash;
            }
            ++i;
        }
        i = y;
        while (i < y + height) {
            if (i % dash == 0) {
                int toY = i + dash;
                toY = toY > y + height ? y + height : toY;
                gc.strokeLine((double)x, (double)i, (double)x, (double)toY);
                gc.strokeLine((double)(x + width), (double)i, (double)(x + width), (double)toY);
                i = toY + dash;
            }
            ++i;
        }
    }

    public double getScreenWidth() {
        return this.screenWidth;
    }

    public void setScreenWidth(double screenWidth) {
        if (screenWidth > 0.0) {
            log.debug((Object)String.format("Set Screen Height to %s.", screenWidth));
            this.screenWidth = screenWidth;
        }
    }

    public double getScreenHeight() {
        return this.screenHeight;
    }

    public void setScreenHeight(double screenHeight) {
        if (screenHeight > 0.0) {
            log.debug((Object)String.format("Set Screen Height to: %s.", screenHeight));
            this.screenHeight = screenHeight;
        }
    }

    public double getScaledScreenWidth() {
        return this.getScaledSize(this.getScreenWidth());
    }

    public double getScaledScreenHeight() {
        return this.getScaledSize(this.getScreenHeight());
    }

    public Image getScreenshot() {
        return this.mScreenshot;
    }

    public void setScreenshot(Image screenshot) {
        this.mScreenshot = screenshot;
        if (this.mScreenshot != null) {
            this.setScreenHeight(this.mScreenshot.getHeight());
            this.setScreenWidth(this.mScreenshot.getWidth());
            this.repaint();
        }
    }

    private boolean isScreenInfoValid() {
        return this.getScreenHeight() > 0.0 && this.getScreenWidth() > 0.0;
    }

    public boolean isMainPackage() {
        return this.isMainPackage;
    }

    public void setMainPackage(boolean isMain) {
        this.isMainPackage = isMain;
    }

    public static interface MouseEventListener {
        public void onRemoteClick(int var1, double var2, double var4);

        public void onRemoteDrag(int var1, float var2, float var3, float var4, float var5);

        public void onLocalClick(int var1, double var2, double var4);

        public void onLocalDrag(int var1, float var2, float var3, float var4, float var5);
    }
}

