/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.include;

import com.android.ddmlib.ViewClient;
import com.testin.itestin.business.SingleTestCase;
import com.testin.itestin.business.TestViewNode;
import com.testin.itestin.business.UiNodeSelector;
import com.testin.itestin.business.actions.ActionDrag;
import com.testin.itestin.business.actions.ActionRule;
import com.testin.itestin.business.actions.ActionTouch;
import com.testin.itestin.business.actions.ActionType;
import com.testin.itestin.business.actions.RemoteActionKey;
import com.testin.itestin.business.actions.RemoteActionType;
import com.testin.itestin.business.actions.TestAction;
import com.testin.itestin.business.actions.TestActionAssert;
import com.testin.itestin.business.actions.TestActionCheck;
import com.testin.itestin.business.actions.TestActionClick;
import com.testin.itestin.business.actions.TestActionDrag;
import com.testin.itestin.business.actions.TestActionInputkey;
import com.testin.itestin.business.actions.TestActionInputtext;
import com.testin.itestin.business.actions.TestActionScreenshot;
import com.testin.itestin.business.actions.TestActionSleep;
import com.testin.itestin.business.utils.StatusMgt;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.device.DevicesManager;
import com.testin.itestin.os.Handler;
import com.testin.itestin.os.Message;
import com.testin.itestin.threadpool.ThreadPool;
import com.testin.itestin.uiautomator.UiAutomatorModel;
import com.testin.itestin.uiautomator.tree.BasicTreeNode;
import com.testin.itestin.uiautomator.tree.RootWindowNode;
import com.testin.itestin.uiautomator.tree.UiNode;
import com.testin.itestin.util.MessageQueue;
import com.testin.itestin.util.Utils;
import com.testin.javafx.Main;
import com.testin.javafx.ui.control.DialogResponse;
import com.testin.javafx.ui.control.InputDialog;
import com.testin.javafx.ui.include.EmulatorCanvas;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EmulatorController
extends AnchorPane
implements Initializable,
EmulatorCanvas.MouseEventListener {
    @FXML
    AnchorPane emulator;
    @FXML
    AnchorPane emulatorToolBar;
    @FXML
    Label screenrecord_indicator;
    @FXML
    Label auto_refresh_indicator;
    @FXML
    Label btnMenu;
    @FXML
    Label btnBack;
    @FXML
    AnchorPane emulatorMobile;
    @FXML
    ImageView busyindicator;
    static Logger log = Logger.getLogger(EmulatorController.class);
    private int mLastRotation = -1;
    private boolean isReplaying;
    private UiAutomatorModel mModel;
    private EmulatorCanvas canvas;
    private ContextMenu contextMenu = new ContextMenu();
    private List<MenuItem> MenuItems = null;
    private MenuItem checkItem;
    private MenuItem uncheckItem;
    private MenuItem usernameItem;
    private MenuItem textItem;
    private MenuItem pwdItem;
    private MenuItem randomItem;
    private int screenshotCount = 0;
    private int thread_count = 0;
    private Handler handler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            log.debug((Object)String.format("Received new message, msg.status: %s msg.content: %s", msg.getStatus(), msg.getContent()));
            switch (msg.getStatus()) {
                case 769: {
                    log.info((Object)"Handling MESSAGE_ACTION_RECORD_START.");
                    UIController.setAutoImgName(1);
                    MessageQueue.add(Main.getInternationalString("screen.event.detector.control.prompt"));
                    UIController.updateDeviceSideRecordStatusDisplay();
                    UIController.setLastActionTimeToCurrentTime();
                    EmulatorController.this.syncScreen();
                    break;
                }
                case 770: {
                    log.info((Object)"Handling MESSAGE_ACTION_RECORD_STOP.");
                    UIController.setAutoImgName(1);
                    SingleTestCase.getInstance().setRecording(false);
                    UIController.setLastActionTime(0L);
                    EmulatorController.this.handleClearScreen();
                    EmulatorController.this.setScreenRecordAsNotReady();
                    EmulatorController.this.setAutoRefreshAsNotReady();
                    break;
                }
                case 1025: {
                    log.info((Object)"Handling MESSAGE_ACTION_RUN_START.");
                    EmulatorController.this.isReplaying = true;
                    UIController.setLastActionTimeToCurrentTime();
                    EmulatorController.this.syncScreen();
                    break;
                }
                case 1026: {
                    log.info((Object)"Handling MESSAGE_ACTION_RUN_STOP.");
                    EmulatorController.this.isReplaying = false;
                    UIController.setLastActionTime(0L);
                    EmulatorController.this.handleClearScreen();
                    break;
                }
                case 771: {
                    log.info((Object)"Handling MESSAGE_ACTION_APP_STARTED.");
                    if (SingleTestCase.getInstance().isRecording()) {
                        UIController.setLastActionTimeToCurrentTime();
                    }
                    EmulatorController.this.setScreenRecordAsEnabled();
                    EmulatorController.this.setAutoRefresh();
                    break;
                }
                case 772: {
                    log.debug((Object)"Handling MESSAGE_ACTION_TAKE_SCREENSHOT.");
                    if (SingleTestCase.getInstance().isRecording()) {
                        EmulatorController.this.syncScreen(msg.getContent());
                        break;
                    }
                    if (!EmulatorController.this.isReplaying) break;
                    EmulatorController.this.syncScreen();
                    break;
                }
                case 768: {
                    log.info((Object)"Handling MESSAGE_NOTIFY_CLEAR.");
                    EmulatorController.this.handleClearScreen();
                    break;
                }
                case 776: {
                    boolean isMainPackageName = msg.getArg1() == 0;
                    log.debug((Object)("Package changed, isMainPackage: " + isMainPackageName));
                    StatusMgt.setInsideApp(isMainPackageName);
                    break;
                }
                case 1283: {
                    EmulatorController.this.updateScreenRecordIndicator();
                    break;
                }
                case 1552: {
                    EmulatorController.this.manualFetchWindowInfoStart();
                    break;
                }
                case 1553: {
                    EmulatorController.this.manualFetchWindowInfoEnd();
                    break;
                }
            }
        }
    };

    public EmulatorController() {
        this.createMenuItems();
        UIController.setEmulatorHandler(this.handler);
        this.refreshScreen();
    }

    private void createMenuItems() {
        if (this.MenuItems == null) {
            this.MenuItems = new ArrayList<MenuItem>();
        }
        this.MenuItems.add(this.makeMenuItem(Main.getInternationalString("emulatorcontroller.menuitems1"), "click"));
        this.MenuItems.add(this.makeMenuItem(Main.getInternationalString("emulatorcontroller.doubleclick"), "doubleclick"));
        this.MenuItems.add(this.makeMenuItem(Main.getInternationalString("emulatorcontroller.menuitems2"), "longclick"));
        this.MenuItems.add((MenuItem)this.makeSeparatorMenuItem());
        this.MenuItems.add(this.makeMenuItem(Main.getInternationalString("emulatorcontroller.menuitems3"), "updrag"));
        this.MenuItems.add(this.makeMenuItem(Main.getInternationalString("emulatorcontroller.menuitems4"), "downdrag"));
        this.MenuItems.add(this.makeMenuItem(Main.getInternationalString("emulatorcontroller.menuitems5"), "leftdrag"));
        this.MenuItems.add(this.makeMenuItem(Main.getInternationalString("emulatorcontroller.menuitems6"), "rightdrag"));
        this.MenuItems.add((MenuItem)this.makeSeparatorMenuItem());
        this.checkItem = this.makeMenuItem(Main.getInternationalString("emulatorcontroller.menuitems7"), "check");
        this.MenuItems.add(this.checkItem);
        this.uncheckItem = this.makeMenuItem(Main.getInternationalString("emulatorcontroller.menuitems8"), "uncheck");
        this.MenuItems.add(this.uncheckItem);
        this.MenuItems.add((MenuItem)this.makeSeparatorMenuItem());
        this.textItem = this.makeMenuItem(Main.getInternationalString("emulatorcontroller.menuitems9"), "text");
        this.MenuItems.add(this.textItem);
        this.usernameItem = this.makeMenuItem(Main.getInternationalString("emulatorcontroller.menuitems10"), "username");
        this.MenuItems.add(this.usernameItem);
        this.pwdItem = this.makeMenuItem(Main.getInternationalString("emulatorcontroller.menuitems11"), "password");
        this.MenuItems.add(this.pwdItem);
        this.randomItem = this.makeMenuItem(Main.getInternationalString("emulatorcontroller.menuitems12"), "randomtext");
        this.MenuItems.add(this.randomItem);
        this.MenuItems.add((MenuItem)this.makeSeparatorMenuItem());
        this.MenuItems.add(this.makeMenuItem(Main.getInternationalString("emulatorcontroller.menuitems13"), "assert"));
    }

    private MenuItem makeMenuItem(String text, String id) {
        MenuItem menuItem = new MenuItem();
        menuItem.setId(id);
        menuItem.setText(text);
        menuItem.setStyle("-fx-font-size: 12px;-fx-font-family: \"Microsoft Yahei\",Tahoma,Arial,Helvetica,STHeiti;-fx-padding:0px 50px 0px 0px;");
        return menuItem;
    }

    private SeparatorMenuItem makeSeparatorMenuItem() {
        SeparatorMenuItem menuItem = new SeparatorMenuItem();
        return menuItem;
    }

    private int getLocalRotation() {
        BasicTreeNode tmpNode;
        if (this.mModel != null && (tmpNode = this.mModel.getXmlRootNode()) instanceof RootWindowNode) {
            int rotation = ((RootWindowNode)tmpNode).rotation;
            return rotation;
        }
        return 0;
    }

    private Image takeScreenShot(int flag) {
        if (!DevicesManager.isDeviceOK()) {
            return null;
        }
        long t1 = System.currentTimeMillis();
        Image screenshot = null;
        byte[] imagedata = DevicesManager.getShell().getScreenshot(flag);
        if (imagedata != null) {
            screenshot = new Image((InputStream)new ByteArrayInputStream(imagedata));
        }
        long t2 = System.currentTimeMillis();
        ++this.screenshotCount;
        log.info((Object)("Screenshot taken. " + (t2 - t1) + " ms used." + " Count: " + this.screenshotCount));
        return screenshot;
    }

    private void syncScreen() {
        if (Utils.IS_SYNCING_SCREEN) {
            log.info((Object)"A thread is syncing screen, ignore this request.");
            return;
        }
        Thread t = new Thread("SyncScreen-No-WindowInfo"){

            @Override
            public void run() {
                log.debug((Object)"Calling syncScreen without window info.");
                try {
                    try {
                        Utils.IS_SYNCING_SCREEN = true;
                        if (DevicesManager.isDeviceOK()) {
                            int rotation = DevicesManager.getShell().getRotation();
                            if (EmulatorController.this.mLastRotation != rotation) {
                                EmulatorController.this.mLastRotation = rotation;
                                DevicesManager.getShell().updateDisplayWH(rotation);
                            }
                            EmulatorController.this.canvas.setModel(StatusMgt.isInsideApp(), rotation, EmulatorController.this.takeScreenShot(rotation));
                            EmulatorController.this.canvas.updateTreeSelection(null);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)String.format("UpdateEmulatorDisplay-NoWindowInfo error. %s", e.getMessage()), (Throwable)e);
                        Utils.IS_SYNCING_SCREEN = false;
                        Utils.gc();
                    }
                }
                finally {
                    Utils.IS_SYNCING_SCREEN = false;
                    Utils.gc();
                }
            }
        };
        ThreadPool.execute(t);
    }

    private void syncScreen(final String windowInfo) {
        if (!Utils.isWindowInfoValid(windowInfo)) {
            log.info((Object)"Window Info is invalid, ignore this request.");
            return;
        }
        if (Utils.IS_SYNCING_SCREEN) {
            log.info((Object)"A thread is sync screen, IGNORE this request.");
            return;
        }
        ++this.thread_count;
        Thread t = new Thread(String.format("SyncScreen-%d", this.thread_count)){

            @Override
            public void run() {
                try {
                    Utils.IS_SYNCING_SCREEN = true;
                    log.info((Object)"Syncing Screen");
                    BasicTreeNode mSelectedNode = EmulatorController.this.canvas.getSelectedNode();
                    if (mSelectedNode != null) {
                        String xpath = ((UiNode)mSelectedNode).getAttribute("xpath");
                        String clazz = ((UiNode)mSelectedNode).getAttribute("class");
                        String text = ((UiNode)mSelectedNode).getAttribute("text");
                        if (text == null) {
                            text = "";
                        }
                        if (!UiNodeSelector.findSelectUiNode(windowInfo, xpath, clazz, text)) {
                            mSelectedNode = null;
                        }
                    }
                    EmulatorController.this.mModel = new UiAutomatorModel(windowInfo);
                    if (DevicesManager.isDeviceOK()) {
                        int rotation = DevicesManager.getShell().getRotation();
                        if (EmulatorController.this.mLastRotation != rotation) {
                            EmulatorController.this.mLastRotation = rotation;
                            DevicesManager.getShell().updateDisplayWH(rotation);
                        }
                        EmulatorController.this.canvas.setModel(StatusMgt.isInsideApp(), rotation, EmulatorController.this.mModel, EmulatorController.this.takeScreenShot(rotation));
                    }
                    Utils.gc();
                }
                finally {
                    Utils.IS_SYNCING_SCREEN = false;
                    Utils.gc();
                }
            }
        };
        ThreadPool.execute(t);
    }

    private void handleClearScreen() {
        log.debug((Object)"Clear screen.");
        this.syncScreen();
    }

    private void initContextMenu() {
        log.info((Object)"Init context menu.");
        this.contextMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MenuItem item = (MenuItem)event.getTarget();
                EmulatorController.this.handleMenuItem(item.getId());
                EmulatorController.this.hideContextMenu();
            }
        });
        this.contextMenu.getItems().addAll(this.MenuItems);
    }

    private void handleMenuItem(String id) {
        log.info((Object)String.format("Menu item with id#%s triggered.", id));
        if (id == null) {
            return;
        }
        BasicTreeNode mSelectedNode = this.canvas.getSelectedNode();
        UiNode tmp = (UiNode)mSelectedNode;
        boolean editable = false;
        try {
            editable = Boolean.parseBoolean(tmp.getAttribute("editable"));
        }
        catch (Exception e) {
            log.error((Object)String.format("Menu item with id#%s editable not found.", id), (Throwable)e);
        }
        TestAction action = null;
        if (id.equals("click")) {
            action = this.generateTestAction(ActionType.click, ActionRule.shortaction, mSelectedNode, null, null, null, 0);
        } else if (id.equals("doubleclick")) {
            action = this.generateTestAction(ActionType.click, ActionRule.doubleaction, mSelectedNode, null, null, null, 0);
        } else if (id.equals("longclick")) {
            action = this.generateTestAction(ActionType.click, ActionRule.longaction, mSelectedNode, null, null, null, 0);
        } else if (id.equals("updrag")) {
            action = this.generateTestAction(ActionType.drag, ActionRule.up, mSelectedNode, null, null, null, 0);
        } else if (id.equals("downdrag")) {
            action = this.generateTestAction(ActionType.drag, ActionRule.down, mSelectedNode, null, null, null, 0);
        } else if (id.equals("leftdrag")) {
            action = this.generateTestAction(ActionType.drag, ActionRule.left, mSelectedNode, null, null, null, 0);
        } else if (id.equals("rightdrag")) {
            action = this.generateTestAction(ActionType.drag, ActionRule.right, mSelectedNode, null, null, null, 0);
        } else if (id.equals("check")) {
            action = this.generateTestAction(ActionType.check, ActionRule.check, mSelectedNode, null, null, null, 0);
        } else if (id.equals("uncheck")) {
            action = this.generateTestAction(ActionType.check, ActionRule.uncheck, mSelectedNode, null, null, null, 0);
        } else if (id.equals("text")) {
            DialogResponse response = InputDialog.show(Main.getInternationalString("emulatorcontroller.handlemenuitem.inputtext"), "");
            if (response.option == DialogResponse.Options.OK) {
                String value = response.value;
                action = editable ? this.generateTestAction(ActionType.inputtext, ActionRule.text, mSelectedNode, value, null, null, 0) : this.recordRemoteActionType(ActionRule.text, value);
            }
        } else if (id.equals("username")) {
            DialogResponse response = InputDialog.show(Main.getInternationalString("emulatorcontroller.handlemenuitem.inputusername"), "");
            if (response.option == DialogResponse.Options.OK) {
                String value = response.value;
                action = editable ? this.generateTestAction(ActionType.inputtext, ActionRule.username, mSelectedNode, value, null, null, 0) : this.recordRemoteActionType(ActionRule.username, value);
            }
        } else if (id.equals("password")) {
            DialogResponse response = InputDialog.show(Main.getInternationalString("emulatorcontroller.handlemenuitem.inputpassword"), "");
            if (response.option == DialogResponse.Options.OK) {
                String value = response.value;
                action = editable ? this.generateTestAction(ActionType.inputtext, ActionRule.password, mSelectedNode, value, null, null, 0) : this.recordRemoteActionType(ActionRule.password, value);
            }
        } else if (id.equals("randomtext")) {
            DialogResponse response = InputDialog.show(Main.getInternationalString("emulatorcontroller.handlemenuitem.inputtextlength"), "4");
            if (response.option == DialogResponse.Options.OK) {
                String value = response.value;
                action = editable ? this.generateTestAction(ActionType.inputtext, ActionRule.randomtext, mSelectedNode, value, null, null, 0) : this.recordRemoteActionType(ActionRule.randomtext, value);
            }
        } else if (id.equals("assert") && mSelectedNode != null) {
            UiNode node = (UiNode)mSelectedNode;
            String text = node.getAttribute("text");
            action = text != null && !text.equals("") ? this.generateTestAction(ActionType.assertfor, ActionRule.waittext, mSelectedNode, text, null, null, 0) : this.generateTestAction(ActionType.assertfor, ActionRule.waitwidget, mSelectedNode, null, null, null, 0);
        }
        if (action != null && StringUtils.isNotEmpty((String)action.show())) {
            this.sendTestAction(action);
        }
    }

    private TestAction recordActionTouch(ActionType actionOption, ActionRule rule, int rotation, float x, float y) {
        ActionTouch action = new ActionTouch();
        action.setAction(actionOption);
        action.setRule(rule);
        action.setRotation(rotation);
        action.setX(x);
        action.setY(y);
        return action;
    }

    private TestAction recordActionDrag(ActionType actionOption, ActionRule rule, int rotation, float fromX, float toX, float fromY, float toY) {
        ActionDrag action = new ActionDrag();
        action.setAction(actionOption);
        action.setRule(rule);
        action.setRotation(rotation);
        action.setFromX(fromX);
        action.setToX(toX);
        action.setFromY(fromY);
        action.setToY(toY);
        return action;
    }

    private TestAction recordRemoteActionKey(ActionRule rule, String keyName) {
        RemoteActionKey action = new RemoteActionKey();
        action.setAction(ActionType.remote_key);
        action.setRule(rule);
        action.setKeyName(keyName);
        return action;
    }

    private TestAction recordRemoteActionType(ActionRule rule, String text) {
        RemoteActionType action = new RemoteActionType();
        action.setAction(ActionType.remote_type);
        action.setRule(rule);
        if (rule == ActionRule.randomtext) {
            action.setLen(Integer.parseInt(text));
            action.setText(text);
        } else {
            action.setText(text);
        }
        return action;
    }

    private TestAction generateTestAction(ActionType action, ActionRule rule, BasicTreeNode selectUiNode, String text, String keyName, String imgName, int sleep) {
        TestAction testAction = null;
        int rotation = this.getLocalRotation();
        switch (action) {
            case click: {
                TestActionClick action_click = new TestActionClick();
                action_click.setAction(ActionType.click);
                action_click.setRule(rule);
                action_click.setRotation(rotation);
                action_click.setViewNode(TestViewNode.Factory.getInstance(selectUiNode));
                testAction = action_click;
                break;
            }
            case drag: {
                TestActionDrag action_drag = new TestActionDrag();
                action_drag.setAction(ActionType.drag);
                action_drag.setRule(rule);
                action_drag.setRotation(rotation);
                action_drag.setViewNode(TestViewNode.Factory.getInstance(selectUiNode));
                testAction = action_drag;
                break;
            }
            case inputtext: {
                TestActionInputtext action_inputtext = new TestActionInputtext();
                action_inputtext.setAction(ActionType.inputtext);
                action_inputtext.setRule(rule);
                if (rule == ActionRule.randomtext) {
                    action_inputtext.setLen(Integer.parseInt(text));
                }
                action_inputtext.setText(text);
                action_inputtext.setViewNode(TestViewNode.Factory.getInstance(selectUiNode));
                testAction = action_inputtext;
                break;
            }
            case check: {
                TestActionCheck action_check = new TestActionCheck();
                action_check.setAction(ActionType.check);
                action_check.setRule(rule);
                action_check.setViewNode(TestViewNode.Factory.getInstance(selectUiNode));
                testAction = action_check;
                break;
            }
            case assertfor: {
                TestActionAssert action_assert = new TestActionAssert();
                action_assert.setAction(ActionType.assertfor);
                action_assert.setRule(rule);
                action_assert.setRotation(rotation);
                if (rule == ActionRule.waittext) {
                    action_assert.setText(text);
                } else if (rule == ActionRule.waitwidget) {
                    action_assert.setText("");
                }
                action_assert.setTimeout(30000);
                action_assert.setViewNode(TestViewNode.Factory.getInstance(selectUiNode));
                testAction = action_assert;
                break;
            }
            case inputkey: {
                TestActionInputkey action_inputkey = new TestActionInputkey();
                action_inputkey.setAction(ActionType.inputkey);
                action_inputkey.setRule(rule);
                action_inputkey.setKeyName(keyName);
                testAction = action_inputkey;
                break;
            }
            case screenshot: {
                TestActionScreenshot action_screenshot = new TestActionScreenshot();
                action_screenshot.setAction(ActionType.screenshot);
                action_screenshot.setRule(ActionRule.none);
                action_screenshot.setImageName(UIController.getNextAutoImgName());
                testAction = action_screenshot;
                break;
            }
            case sleep: {
                TestActionSleep action_sleep = new TestActionSleep();
                action_sleep.setAction(ActionType.sleep);
                action_sleep.setRule(ActionRule.none);
                action_sleep.setSleep(sleep);
                testAction = action_sleep;
                break;
            }
        }
        return testAction;
    }

    private boolean executeAction(TestAction act) {
        if (act.isForDevice()) {
            String command = act.expr();
            return ViewClient.runCommand(command).getStatus() == 0;
        }
        return true;
    }

    private void sendTestAction(final TestAction action) {
        log.info((Object)("SendTestAction: " + action));
        Thread t = new Thread(){

            @Override
            public void run() {
                if (EmulatorController.this.executeAction(action)) {
                    EmulatorController.this.canvas.updateTreeSelection(null);
                    if (action.getActionType() == ActionType.screenshot) {
                        long sleep = UIController.getLastActionElapseTime();
                        TestAction sleepAction = null;
                        sleepAction = EmulatorController.this.generateTestAction(ActionType.sleep, ActionRule.none, null, null, null, null, (int)sleep);
                        Message tableMsg = null;
                        if (UIController.getScriptShowHandler() != null) {
                            tableMsg = new Message();
                            tableMsg.setStatus(773);
                            tableMsg.setContent(sleepAction);
                            UIController.getScriptShowHandler().sendMessage(tableMsg);
                            Utils.sleep(10L);
                            UIController.setLastActionTimeToCurrentTime();
                        }
                        TestAction takeScreenAction = null;
                        takeScreenAction = EmulatorController.this.generateTestAction(ActionType.screenshot, ActionRule.none, null, null, null, UIController.getNextAutoImgName(), 0);
                        tableMsg = new Message();
                        tableMsg.setStatus(773);
                        tableMsg.setContent(takeScreenAction);
                        UIController.getScriptShowHandler().sendMessage(tableMsg);
                        Utils.sleep(10L);
                    } else if (action.getActionType() != ActionType.sleep) {
                        if (UIController.getLastActionTime() != 0L) {
                            long sleep = UIController.getLastActionElapseTime();
                            TestAction sleepAction = null;
                            sleepAction = EmulatorController.this.generateTestAction(ActionType.sleep, ActionRule.none, null, null, null, null, (int)sleep);
                            Message tableMsg = new Message();
                            if (UIController.getScriptShowHandler() != null) {
                                tableMsg.setStatus(773);
                                tableMsg.setContent(sleepAction);
                                UIController.getScriptShowHandler().sendMessage(tableMsg);
                                Utils.sleep(10L);
                                if (SingleTestCase.getInstance().isAutoShot()) {
                                    TestAction takeScreenAction = null;
                                    takeScreenAction = EmulatorController.this.generateTestAction(ActionType.screenshot, ActionRule.none, null, null, null, UIController.getNextAutoImgName(), 0);
                                    tableMsg = new Message();
                                    tableMsg.setStatus(773);
                                    tableMsg.setContent(takeScreenAction);
                                    UIController.getScriptShowHandler().sendMessage(tableMsg);
                                    Utils.sleep(10L);
                                }
                            }
                        }
                        UIController.setLastActionTimeToCurrentTime();
                        if (UIController.getScriptShowHandler() != null) {
                            Message tableMsg = new Message();
                            tableMsg.setStatus(773);
                            tableMsg.setContent(action);
                            UIController.getScriptShowHandler().sendMessage(tableMsg);
                        }
                    }
                }
            }
        };
        ThreadPool.execute(t);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.initContextMenu();
        this.btnBack.setTooltip(new Tooltip(Main.getInternationalString("coordemulator.button.back")));
        this.btnMenu.setTooltip(new Tooltip(Main.getInternationalString("coordemulator.button.menu")));
        this.setScreenRecordAsNotReady();
        this.setAutoRefreshAsNotReady();
        int width = (int)this.emulatorMobile.getPrefWidth();
        int height = (int)this.emulatorMobile.getPrefHeight();
        this.canvas = new EmulatorCanvas(width, height, this);
        this.emulatorMobile.getChildren().add((Object)this.canvas);
    }

    private boolean isSingleCaseIsRecording() {
        return SingleTestCase.getInstance() != null && SingleTestCase.getInstance().isRecording();
    }

    @FXML
    public void clickMenu(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            if (this.isSingleCaseIsRecording()) {
                TestAction action = null;
                action = StatusMgt.isInsideApp() ? this.generateTestAction(ActionType.inputkey, ActionRule.shortaction, null, null, "KEYCODE_MENU", null, 0) : this.recordRemoteActionKey(ActionRule.press, "KEYCODE_MENU");
                log.info((Object)String.format("Click menu. Action: %s", action.toString()));
                this.sendTestAction(action);
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            if (this.isSingleCaseIsRecording()) {
                UIController.updateNodeSytleClass((Node)this.btnMenu, "menubtnBkgEnter");
            } else {
                UIController.updateNodeSytleClass((Node)this.btnMenu, "menubtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_EXITED")) {
            if (this.isSingleCaseIsRecording()) {
                UIController.updateNodeSytleClass((Node)this.btnMenu, "menubtnBkg");
            } else {
                UIController.updateNodeSytleClass((Node)this.btnMenu, "menubtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_PRESSED")) {
            if (this.isSingleCaseIsRecording()) {
                UIController.updateNodeSytleClass((Node)this.btnMenu, "menubtnBkgPress");
            } else {
                UIController.updateNodeSytleClass((Node)this.btnMenu, "menubtnBkgDisable");
            }
        }
    }

    @FXML
    public void clickBack(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            if (this.isSingleCaseIsRecording()) {
                log.info((Object)String.format("Click Back. isRecording: %s, isMainPackageName: %s", SingleTestCase.getInstance().isRecording(), StatusMgt.isInsideApp()));
                TestAction action = null;
                action = StatusMgt.isInsideApp() ? this.generateTestAction(ActionType.inputkey, ActionRule.shortaction, null, null, "KEYCODE_BACK", null, 0) : this.recordRemoteActionKey(ActionRule.press, "KEYCODE_BACK");
                this.sendTestAction(action);
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            if (this.isSingleCaseIsRecording()) {
                UIController.updateNodeSytleClass((Node)this.btnBack, "backbtnBkgEnter");
            } else {
                UIController.updateNodeSytleClass((Node)this.btnBack, "backbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_EXITED")) {
            if (this.isSingleCaseIsRecording()) {
                UIController.updateNodeSytleClass((Node)this.btnBack, "backbtnBkg");
            } else {
                UIController.updateNodeSytleClass((Node)this.btnBack, "backbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_PRESSED")) {
            if (this.isSingleCaseIsRecording()) {
                UIController.updateNodeSytleClass((Node)this.btnBack, "backbtnBkgPress");
            } else {
                UIController.updateNodeSytleClass((Node)this.btnBack, "backbtnBkgDisable");
            }
        }
    }

    @FXML
    public void clickScreenCamera(MouseEvent event) {
        log.info((Object)String.format("Click Screen Camera. isRecording: %s", SingleTestCase.getInstance().isRecording()));
        if (SingleTestCase.getInstance().isRecording()) {
            TestAction action = null;
            action = this.recordRemoteActionKey(ActionRule.press, "KEYCODE_CAMERA");
            this.sendTestAction(action);
        }
    }

    @FXML
    public void clickEmulator(MouseEvent event) {
        if (SingleTestCase.getInstance().isRecording()) {
            MouseButton button = event.getButton();
            log.info((Object)String.format("Click Emulator. %s", button.toString().equals("PRIMARY") ? "Mouse Left Button" : (button.toString().equals("SECONDARY") ? "Mouse Right Button" : button.toString())));
            switch (button) {
                case PRIMARY: {
                    this.hideContextMenu();
                    break;
                }
                case SECONDARY: {
                    break;
                }
            }
        }
    }

    @FXML
    public void clickScreenRecord(MouseEvent event) {
        if (!SingleTestCase.getInstance().isRecording()) {
            this.setScreenRecordAsNotReady();
            return;
        }
        if (Utils.enableScreenEventDetector) {
            this.setScreenRecordAsDisabled();
        } else {
            this.setScreenRecordAsEnabled();
        }
    }

    private void updateScreenRecordIndicator() {
        if (!SingleTestCase.getInstance().isRecording()) {
            this.setScreenRecordAsNotReady();
            return;
        }
        if (Utils.enableScreenEventDetector) {
            this.setScreenRecordAsEnabled();
        } else {
            this.setScreenRecordAsDisabled();
        }
    }

    private void setScreenRecordAsNotReady() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EmulatorController.this.screenrecord_indicator.setTooltip(new Tooltip(Main.getInternationalString("screen.event.detector.info")));
                UIController.updateNodeSytleClass((Node)EmulatorController.this.screenrecord_indicator, "screenRecordNotReady");
            }
        });
    }

    private void setScreenRecordAsEnabled() {
        Utils.enableScreenEventDetector = true;
        if (UIController.isEventDetectorRunning()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    UIController.updateNodeSytleClass((Node)EmulatorController.this.screenrecord_indicator, "screenRecordEnabled");
                    EmulatorController.this.screenrecord_indicator.setTooltip(new Tooltip(Main.getInternationalString("screen.event.detector.enabled")));
                }
            });
        } else {
            log.info((Object)"screen detector thread is not running, still set indicator as not ready.");
            this.setScreenRecordAsNotReady();
        }
    }

    private void setScreenRecordAsDisabled() {
        Utils.enableScreenEventDetector = false;
        if (UIController.isEventDetectorRunning()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    UIController.updateNodeSytleClass((Node)EmulatorController.this.screenrecord_indicator, "screenRecordDisabled");
                    EmulatorController.this.screenrecord_indicator.setTooltip(new Tooltip(Main.getInternationalString("screen.event.detector.disabled")));
                }
            });
        } else {
            log.info((Object)"screen detector thread is not running, still set indicator as not ready.");
            this.setScreenRecordAsNotReady();
        }
    }

    private void hideContextMenu() {
        if (this.contextMenu.isShowing()) {
            log.debug((Object)"Hide context menu.");
            this.contextMenu.hide();
        }
    }

    @FXML
    public void showContextMenu(ContextMenuEvent event) {
        if (SingleTestCase.getInstance().isRecording()) {
            log.debug((Object)"Show context menu.");
            BasicTreeNode mSelectedNode = this.canvas.getSelectedNode();
            if (mSelectedNode != null) {
                UiNode node = (UiNode)mSelectedNode;
                boolean editable = Boolean.parseBoolean(node.getAttribute("editable"));
                boolean checkable = Boolean.parseBoolean(node.getAttribute("checkable"));
                this.setInputtextMenu(!editable);
                this.setCheckMenu(!checkable);
                log.debug((Object)String.format("SelectedNode: %s, editable: %s, checkable: %s.", node.toString(), editable, checkable));
                double x = 0.0;
                double y = 0.0;
                if (this.contextMenu.getWidth() > 0.0 && event.getX() + this.contextMenu.getWidth() > 400.0) {
                    x = event.getScreenX() - this.contextMenu.getWidth();
                    if (x < 0.0) {
                        x = event.getScreenX();
                    }
                } else {
                    x = event.getScreenX();
                }
                if (this.contextMenu.getHeight() > 0.0 && event.getY() + this.contextMenu.getHeight() > 400.0) {
                    y = event.getScreenY() - this.contextMenu.getHeight();
                    if (y < 0.0) {
                        y = event.getScreenY();
                    }
                } else {
                    y = event.getScreenY();
                }
                this.contextMenu.show((Node)this.canvas, x, y);
            }
        }
    }

    private void setCheckMenu(boolean disable) {
        this.checkItem.setDisable(disable);
        this.uncheckItem.setDisable(disable);
    }

    private void setInputtextMenu(boolean disable) {
        this.usernameItem.setDisable(disable);
        this.textItem.setDisable(disable);
        this.pwdItem.setDisable(disable);
        this.randomItem.setDisable(disable);
    }

    @Override
    public void onRemoteClick(int orientation, double x, double y) {
        if (SingleTestCase.getInstance().isRecording()) {
            log.info((Object)String.format("On remote click. orientation: %s, x: %s, y: %s.", orientation, x, y));
            TestAction action = null;
            action = this.recordActionTouch(ActionType.remote_touch, ActionRule.tap, orientation, (float)x, (float)y);
            this.sendTestAction(action);
        }
    }

    @Override
    public void onRemoteDrag(int orientation, float fromX, float toX, float fromY, float toY) {
        if (SingleTestCase.getInstance().isRecording()) {
            log.info((Object)String.format("On remote drag. orientation: %s, from(%s, %s), to (%s, %s).", orientation, Float.valueOf(fromX), Float.valueOf(fromY), Float.valueOf(toX), Float.valueOf(toY)));
            TestAction action = null;
            action = this.recordActionDrag(ActionType.remote_drag, ActionRule.none, orientation, fromX, toX, fromY, toY);
            this.sendTestAction(action);
        }
    }

    @Override
    public void onLocalClick(int orientation, double x, double y) {
        if (SingleTestCase.getInstance().isRecording()) {
            log.info((Object)String.format("On Local Click. orientation: %s, (%s, %s)", orientation, x, y));
            TestAction action = null;
            action = this.recordActionTouch(ActionType.local_touch, ActionRule.tap, orientation, (float)x, (float)y);
            this.sendTestAction(action);
        }
    }

    @Override
    public void onLocalDrag(int orientation, float fromX, float toX, float fromY, float toY) {
        if (SingleTestCase.getInstance().isRecording()) {
            log.info((Object)String.format("On local drag. orientation: %s, from(%s, %s), to (%s, %s).", orientation, Float.valueOf(fromX), Float.valueOf(fromY), Float.valueOf(toX), Float.valueOf(toY)));
            TestAction action = null;
            action = this.recordActionDrag(ActionType.local_drag, ActionRule.none, orientation, fromX, toX, fromY, toY);
            this.sendTestAction(action);
        }
    }

    public void refreshScreen() {
        log.info((Object)"RefreshScreen Thread Started.");
        Thread refreshScreenThread = new Thread("refresh-screen"){

            @Override
            public void run() {
                while (true) {
                    long wait_time_for_next_screenshot = System.currentTimeMillis() - Utils.CURRENT_SCREENSHOT_TAKEN_TIME;
                    if ((SingleTestCase.getInstance().isRecording() || EmulatorController.this.isReplaying) && wait_time_for_next_screenshot > (long)Utils.SCREENSHOT_INTERVAL && !StatusMgt.isInsideApp()) {
                        EmulatorController.this.syncScreen();
                    }
                    Utils.sleep(Utils.SCREENSHOT_INTERVAL);
                }
            }
        };
        ThreadPool.execute(refreshScreenThread);
    }

    private void setAutoRefreshAsNotReady() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                UIController.updateNodeSytleClass((Node)EmulatorController.this.auto_refresh_indicator, "refresh_not_ready");
                EmulatorController.this.auto_refresh_indicator.setTooltip(new Tooltip(Main.getInternationalString("emulator.button.auto.refresh.indicator.not.ready")));
            }
        });
    }

    private void setAutoRefresh() {
        Utils.autoFetchWindowInfo = true;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                UIController.updateNodeSytleClass((Node)EmulatorController.this.auto_refresh_indicator, "refresh_auto");
                EmulatorController.this.auto_refresh_indicator.setTooltip(new Tooltip(Main.getInternationalString("emulator.button.auto.refresh.indicator")));
            }
        });
    }

    private void setManualRefresh() {
        Utils.autoFetchWindowInfo = false;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                UIController.updateNodeSytleClass((Node)EmulatorController.this.auto_refresh_indicator, "refresh_manual");
                EmulatorController.this.auto_refresh_indicator.setTooltip(new Tooltip(Main.getInternationalString("emulator.button.manual.refresh.indicator")));
            }
        });
    }

    private void manualFetchWindowInfoStart() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EmulatorController.this.auto_refresh_indicator.setVisible(false);
                EmulatorController.this.busyindicator.setVisible(true);
            }
        });
    }

    private void manualFetchWindowInfoEnd() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EmulatorController.this.auto_refresh_indicator.setVisible(true);
                EmulatorController.this.busyindicator.setVisible(false);
            }
        });
    }

    @FXML
    public void autoRefreshBtnClick(MouseEvent event) {
        if (!SingleTestCase.getInstance().isRecording()) {
            this.setAutoRefreshAsNotReady();
            return;
        }
        if (Utils.autoFetchWindowInfo) {
            this.setManualRefresh();
        } else {
            this.setAutoRefresh();
        }
    }
}

