/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.include;

import com.android.ddmlib.ViewClient;
import com.testin.itestin.business.CoordScriptRecord;
import com.testin.itestin.business.CoordScriptReplay;
import com.testin.itestin.business.ScriptListener;
import com.testin.itestin.business.ScriptReplay;
import com.testin.itestin.business.SingleTestCase;
import com.testin.itestin.business.TestFileUtils;
import com.testin.itestin.business.actions.ActionDrag;
import com.testin.itestin.business.actions.ActionRule;
import com.testin.itestin.business.actions.ActionTouch;
import com.testin.itestin.business.actions.ActionType;
import com.testin.itestin.business.actions.TestAction;
import com.testin.itestin.business.recorder.RecorderListener;
import com.testin.itestin.business.recorder.RecorderThread;
import com.testin.itestin.business.utils.StatusMgt;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.device.DevicesManager;
import com.testin.itestin.device.IDeviceShell;
import com.testin.itestin.device.event.Event;
import com.testin.itestin.device.event.EventDetector;
import com.testin.itestin.device.event.EventListener;
import com.testin.itestin.os.Handler;
import com.testin.itestin.os.Message;
import com.testin.itestin.threadpool.ThreadPool;
import com.testin.itestin.uiautomator.UiAutomatorModel;
import com.testin.itestin.uiautomator.tree.BasicTreeNode;
import com.testin.itestin.uiautomator.tree.RootWindowNode;
import com.testin.itestin.uiautomator.tree.UiNode;
import com.testin.itestin.util.Utils;
import com.testin.javafx.Main;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.control.AlertDialog;
import com.testin.javafx.ui.control.ChooseDialog;
import com.testin.javafx.ui.control.ConfirmDialog;
import com.testin.javafx.ui.control.DetailsDialog;
import com.testin.javafx.ui.control.DialogResponse;
import com.testin.javafx.ui.control.InputDialog;
import com.testin.javafx.ui.control.InputDialogWithOptions;
import com.testin.javafx.ui.control.InputReplayDialog;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RecordActionController
extends AnchorPane
implements Initializable,
EventListener,
RecorderListener {
    @FXML
    Label startButton;
    @FXML
    Label stopButton;
    @FXML
    Label replayTimesValue;
    @FXML
    Label scriptSave;
    @FXML
    Label scriptTimer;
    @FXML
    Label scriptName;
    @FXML
    Label nameandVersion;
    @FXML
    Label startReplay;
    @FXML
    Label separatorLine;
    static Logger log = Logger.getLogger(RecordActionController.class);
    private static ScriptReplay replayer;
    private static CoordScriptRecord coordRecorder;
    private static CoordScriptReplay coordReplayer;
    private int sec = 0;
    private Timer timer = null;
    private boolean isWindowChange = false;
    private static int replayTimes;
    private boolean isReplayingScript = false;
    EventDetector eventDetector = null;
    ViewClient mViewClient = null;
    private Handler handler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.getStatus()) {
                case 1537: {
                    String time = msg.getContent();
                    UIController.updateLabelText(RecordActionController.this.scriptTimer, time);
                    break;
                }
                case 1538: {
                    RecordActionController.this.timer.schedule(RecordActionController.this.createTimerTask(), 1000L, 1000L);
                    break;
                }
                case 1539: {
                    RecordActionController.this.handleStopWork();
                    if (!RecordActionController.this.isEnableReplay()) break;
                    UIController.updateNodeSytleClass((Node)RecordActionController.this.startReplay, "replayBtnNormal");
                    break;
                }
                case 1540: {
                    int total = msg.getArg1();
                    int index = msg.getArg2();
                    RecordActionController.this.handleShowReplayTimes(total, index);
                    break;
                }
                case 1545: {
                    RecordActionController.this.cancelRecording();
                    break;
                }
            }
        }
    };
    private ScriptListener scriptListener = new ScriptListener(){

        @Override
        public void onWindowChange(String windowInfo) {
            log.debug((Object)"Receive window change event.");
            Message msg = new Message();
            msg.setStatus(772);
            msg.setContent(windowInfo);
            UIController.getEmulatorHandler().sendMessage(msg);
        }

        @Override
        public void onTerminated(int errorCode, String message, String details) {
            Message msg = new Message();
            msg.setStatus(1539);
            RecordActionController.this.handler.sendMessage(msg);
            UIController.sendRecordStopMsg(SingleTestCase.getInstance().getRecordStyle());
            DialogResponse detRes = null;
            if (errorCode != 0) {
                if (RecordActionController.this.isWindowChange && errorCode == 1) {
                    if (!"".equals(details)) {
                        if (details.contains("signature matching")) {
                            detRes = DetailsDialog.show(String.format("%s", Main.getInternationalString("waitfinish.signature.not.match")), details);
                        }
                        if (details.contains("Process crashed")) {
                            detRes = DetailsDialog.show(String.format("%s", Main.getInternationalString("waitfinish.app.crash")), details);
                        }
                    } else {
                        detRes = DetailsDialog.show(message, details);
                    }
                } else {
                    detRes = DetailsDialog.show(message, details);
                }
                if (SingleTestCase.getInstance().getActions().size() > 0 && detRes != null) {
                    DialogResponse response = ConfirmDialog.show(Main.getInternationalString("recordactioncontroller.onterminated.saveornot"), null);
                    if (response.option == DialogResponse.Options.OK) {
                        RecordActionController.this.saveRecordScript();
                    }
                } else {
                    SingleTestCase.getInstance().setName(null);
                    UIController.updateNodeSytleClass((Node)RecordActionController.this.startReplay, "replayBtnDisable");
                }
                RecordActionController.this.handleStopWork();
            } else {
                RecordActionController.this.saveRecordScript();
            }
        }

        @Override
        public void onScreenshot(String imageName) {
        }

        @Override
        public void onAppStarted() {
            log.info((Object)"App started event triggered.");
            if (!RecordActionController.this.isWindowChange) {
                Message msg = new Message();
                msg.setStatus(1538);
                RecordActionController.this.handler.sendMessage(msg);
                RecordActionController.this.isWindowChange = true;
                msg = new Message();
                msg.setStatus(771);
                UIController.getEmulatorHandler().sendMessage(msg);
            }
        }

        @Override
        public void onTestAction(int index) {
        }

        @Override
        public void onTestTimes(int times) {
        }

        @Override
        public void onPackageChanged(boolean isAppUnderTest, String packageName) {
            log.info((Object)("App on top changed. isAppUnderTest: " + isAppUnderTest + ", packageName: " + packageName));
            Message msg = new Message();
            msg.setStatus(776);
            msg.setContent(packageName);
            msg.setArg1(isAppUnderTest ? 0 : 1);
            UIController.getEmulatorHandler().sendMessage(msg);
        }
    };
    private ScriptListener replayListener = new ScriptListener(){

        @Override
        public void onTerminated(int errorCode, String message, String details) {
            Message msg = new Message();
            msg.setStatus(1539);
            RecordActionController.this.handler.sendMessage(msg);
            UIController.sendReplayStopMsg(errorCode);
            UIController.sendReplayStopMsg();
            UIController.updateNodeSytleClass((Node)RecordActionController.this.startReplay, "replayBtnNormal");
            if (errorCode == 0) {
                AlertDialog.show(AlertDialog.DialogOptions.INFO, message);
            } else {
                DetailsDialog.show(message, details);
            }
        }

        @Override
        public void onWindowChange(String dumpWindow) {
            log.info((Object)"Receive window change event.");
            log.info((Object)("GetWindowInfo: " + dumpWindow));
            log.info((Object)("GetWindowInfo: " + Utils.getCalleeNames()));
            Message msg = new Message();
            msg.setStatus(772);
            msg.setContent(dumpWindow);
            UIController.getEmulatorHandler().sendMessage(msg);
        }

        @Override
        public void onTestAction(int index) {
            Message m = new Message();
            m.setStatus(1027);
            m.setContent(index);
            UIController.getScriptShowHandler().sendMessage(m);
        }

        @Override
        public void onScreenshot(String imageName) {
            Message m = new Message();
            m.setStatus(772);
            UIController.getEmulatorHandler().sendMessage(m);
        }

        @Override
        public void onAppStarted() {
            if (!RecordActionController.this.isWindowChange) {
                Message msg = new Message();
                msg.setStatus(1538);
                RecordActionController.this.handler.sendMessage(msg);
                RecordActionController.this.isWindowChange = true;
                msg = new Message();
                msg.setStatus(771);
                UIController.getEmulatorHandler().sendMessage(msg);
            }
        }

        @Override
        public void onTestTimes(int times) {
            Message msg = new Message();
            msg.setStatus(1540);
            msg.setArg1(replayTimes);
            msg.setArg2(times);
            RecordActionController.this.handler.sendMessage(msg);
        }

        @Override
        public void onPackageChanged(boolean main, String packageName) {
        }
    };
    private ScriptListener coordRecorderListener = new ScriptListener(){

        @Override
        public void onTerminated(int errorCode, String message, String details) {
            Message msg = new Message();
            msg.setStatus(1539);
            RecordActionController.this.handler.sendMessage(msg);
            UIController.sendRecordStopMsg(SingleTestCase.getInstance().getRecordStyle());
            if (errorCode != 0) {
                if (RecordActionController.this.isWindowChange) {
                    DialogResponse detRes = DetailsDialog.show(message, details);
                    if (detRes.option == DialogResponse.Options.OK || detRes.option == DialogResponse.Options.CANCEL) {
                        DialogResponse response = ConfirmDialog.show(Main.getInternationalString("recordactioncontroller.onterminated.saveornot"), null);
                        if (response.option == DialogResponse.Options.OK) {
                            RecordActionController.this.saveRecordCoordScript();
                        }
                    }
                } else {
                    DetailsDialog.show(message, details);
                }
            }
        }

        @Override
        public void onWindowChange(String dumpWindow) {
            log.info((Object)"Receive window change event.");
        }

        @Override
        public void onTestAction(int index) {
        }

        @Override
        public void onScreenshot(String imageName) {
        }

        @Override
        public void onAppStarted() {
            if (!RecordActionController.this.isWindowChange) {
                Message msg = new Message();
                msg.setStatus(1538);
                RecordActionController.this.handler.sendMessage(msg);
                RecordActionController.this.isWindowChange = true;
                msg = new Message();
                msg.setStatus(771);
                UIController.getCoordEmulatorHandler().sendMessage(msg);
            }
        }

        @Override
        public void onTestTimes(int times) {
        }

        @Override
        public void onPackageChanged(boolean main, String packageName) {
        }
    };
    private ScriptListener coordReplayListener = new ScriptListener(){

        @Override
        public void onTerminated(int errorCode, String message, String details) {
            Message msg = new Message();
            msg.setStatus(1539);
            RecordActionController.this.handler.sendMessage(msg);
            UIController.sendReplayStopMsg(errorCode);
            UIController.sendReplayStopMsg();
            if (errorCode == 0) {
                AlertDialog.show(AlertDialog.DialogOptions.INFO, message);
            } else {
                DetailsDialog.show(message, details);
            }
        }

        @Override
        public void onWindowChange(String dumpWindow) {
            log.info((Object)"Receive window change event.");
        }

        @Override
        public void onTestAction(int index) {
            Message m = new Message();
            m.setStatus(1027);
            m.setContent(index);
            UIController.getCoordscriptShowHandler().sendMessage(m);
        }

        @Override
        public void onScreenshot(String imageName) {
            Message m = new Message();
            m.setStatus(772);
            UIController.getCoordEmulatorHandler().sendMessage(m);
        }

        @Override
        public void onAppStarted() {
            if (!RecordActionController.this.isWindowChange) {
                Message msg = new Message();
                msg.setStatus(1538);
                RecordActionController.this.handler.sendMessage(msg);
                RecordActionController.this.isWindowChange = true;
                msg = new Message();
                msg.setStatus(771);
                UIController.getCoordEmulatorHandler().sendMessage(msg);
            }
        }

        @Override
        public void onTestTimes(int times) {
            Message msg = new Message();
            msg.setStatus(1540);
            msg.setArg1(replayTimes);
            msg.setArg2(times);
            RecordActionController.this.handler.sendMessage(msg);
        }

        @Override
        public void onPackageChanged(boolean main, String packageName) {
        }
    };

    static {
        replayTimes = 0;
    }

    private void cancelRecording() {
        SingleTestCase.getInstance().setRecording(false);
        if (!SingleTestCase.getInstance().isEditing()) {
            SingleTestCase.getInstance().setName(null);
            UIController.updateLabelText(this.scriptName, "");
            this.separatorLine.setVisible(false);
            this.disableButtons();
        } else {
            SingleTestCase.getInstance().setEditing(false);
            this.handleStopWork();
            if (this.isEnableReplay()) {
                UIController.updateNodeSytleClass((Node)this.startReplay, "replayBtnNormal");
            }
        }
    }

    private void handleShowReplayTimes(int total, int index) {
        String text = String.format("[%s/%s]", index, total);
        UIController.updateLabelText(this.replayTimesValue, text);
        this.replayTimesValue.setVisible(true);
    }

    public void setPromptMsg(String text) {
        UIController.getTopController().showPromptMsg(text);
    }

    private void stopRecord() {
        if (!SingleTestCase.getInstance().isEditing()) {
            UIController.addLastTakeScreen();
            UIController.addSleepAction(3000);
        }
        StatusMgt.setViewRecorderStop(true);
    }

    private void replayScript() {
        if (this.isReplayingScript) {
            log.info((Object)"Another thread is replaying script, cannot start a new one.");
            return;
        }
        ThreadPool.execute(new ReplayThread());
    }

    private void stopReplay() {
        UIController.sendReplayStopMsg();
        UIController.updateNodeSytleClass((Node)this.startReplay, "replayBtnNormal");
    }

    private boolean isSamePixel() {
        String strPixel;
        String currentPixel = TestFileUtils.getPixel();
        return currentPixel.equals(strPixel = SingleTestCase.getInstance().getCoordPixel());
    }

    private boolean isExistScript() {
        String path;
        String parent;
        File[] ff;
        boolean exist = false;
        String currentPixel = TestFileUtils.getPixel();
        if (SingleTestCase.getInstance().getCoordScriptPath() != null && (ff = new File(parent = new File(path = SingleTestCase.getInstance().getCoordScriptPath()).getParent()).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".script");
            }
        })).length > 0) {
            File[] fileArray = ff;
            int n = ff.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                String pixel = f.getName().substring(0, f.getName().indexOf("_"));
                if (currentPixel.equals(pixel)) {
                    exist = true;
                    break;
                }
                ++n2;
            }
        }
        return exist;
    }

    private void stopCoordRecord() {
        UIController.sendRecordStopMsg(SingleTestCase.getInstance().getRecordStyle());
        SingleTestCase.getInstance().setRecording(false);
        this.saveRecordCoordScript();
    }

    private void stopCoordReplay() {
        UIController.sendReplayStopMsg();
        UIController.updateNodeSytleClass((Node)this.startReplay, "replayBtnNormal");
    }

    private boolean handleStartWork() {
        log.info((Object)"Do some work before start recording.");
        if (DevicesManager.isDeviceOK()) {
            StatusMgt.setViewRecorderStop(false);
            DevicesManager.getDevice().startWork();
            UIController.updateNodeSytleClass((Node)this.stopButton, "stopBtnNormal");
            UIController.updateNodeSytleClass((Node)this.startButton, "startBtnDisable");
            this.sec = 0;
            this.isWindowChange = false;
            this.timer = new Timer();
            UIController.updateLabelText(this.scriptTimer, "00:00");
            return true;
        }
        return false;
    }

    private void handleStopWork() {
        StatusMgt.setViewRecorderStop(true);
        if (coordRecorder != null) {
            coordRecorder.stop();
            coordRecorder = null;
        }
        if (replayer != null) {
            replayer.stop();
            replayer = null;
        }
        if (coordReplayer != null) {
            coordReplayer.stop();
            coordReplayer = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (DevicesManager.isDeviceOK()) {
            DevicesManager.getDevice().stopWork();
        }
        UIController.updateNodeSytleClass((Node)this.stopButton, "stopBtnDisable");
        UIController.updateNodeSytleClass((Node)this.startButton, "startBtnNormal");
    }

    private void saveRecordCoordScript() {
        if (this.isWindowChange) {
            this.saveCoordScript();
        }
    }

    private String getNormalPixelScriptPath() {
        String pixel = SingleTestCase.getInstance().getCoordPixel();
        String scriptName = String.format("%s_%s_0.script", pixel, SingleTestCase.getInstance().getSafeAppName());
        String rootPath = TestFileUtils.getTestRootDir();
        String sriptDir = TestFileUtils.getScriptDir(rootPath, SingleTestCase.getInstance().getName());
        String path = String.valueOf(sriptDir) + scriptName;
        String scriptName1 = String.format("%s_%s_1.script", pixel, SingleTestCase.getInstance().getSafeAppName());
        String scriptName2 = String.format("%s_%s_2.script", pixel, SingleTestCase.getInstance().getSafeAppName());
        String path1 = String.valueOf(sriptDir) + File.separator + scriptName1;
        String path2 = String.valueOf(sriptDir) + File.separator + scriptName2;
        FileUtils.deleteQuietly((File)new File(path));
        FileUtils.deleteQuietly((File)new File(path1));
        FileUtils.deleteQuietly((File)new File(path2));
        return path;
    }

    private void saveCoordScript() {
        SingleTestCase.getInstance().setCoordScriptPath(this.getNormalPixelScriptPath());
        Message msg = new Message();
        msg.setStatus(774);
        msg.setContent(SingleTestCase.getInstance().getCoordScriptPath());
        UIController.getCoordscriptShowHandler().sendMessage(msg);
        this.enableReplayButton();
    }

    private void saveRecordScript() {
        if (this.isWindowChange) {
            this.saveScript();
        }
    }

    private void saveScript() {
        Message msg = new Message();
        msg.setStatus(774);
        UIController.getScriptShowHandler().sendMessage(msg);
        this.enableReplayButton();
    }

    private void showScriptName() {
        this.separatorLine.setVisible(true);
        this.scriptName.setVisible(true);
        String showname = "";
        showname = SingleTestCase.getInstance().getRecordStyle() == 1 ? String.valueOf(SingleTestCase.getInstance().getName()) + " (" + SingleTestCase.getInstance().getCoordPixel() + ")" : SingleTestCase.getInstance().getName();
        UIController.updateLabelText(this.scriptName, showname);
    }

    private TimerTask createTimerTask() {
        TimerTask mTask = new TimerTask(){

            @Override
            public void run() {
                RecordActionController recordActionController = RecordActionController.this;
                recordActionController.sec = recordActionController.sec + 1;
                int tmp = RecordActionController.this.sec;
                int m = (tmp %= 3600) / 60;
                int s = tmp %= 60;
                String t2 = String.format("%02d", m);
                String t3 = String.format("%02d", s);
                String t = String.format("%s:%s", t2, t3);
                Message msg = new Message();
                msg.setStatus(1537);
                msg.setContent(t);
                RecordActionController.this.handler.sendMessage(msg);
            }
        };
        return mTask;
    }

    private boolean isWorking() {
        boolean coordReplay;
        boolean record = !StatusMgt.isViewRecorderStop();
        boolean coordRecord = coordRecorder != null && !coordRecorder.isStopped();
        boolean replay = replayer != null && !replayer.isStopped();
        boolean bl = coordReplay = coordReplayer != null && !coordReplayer.isStopped();
        return record || coordRecord || replay || coordReplay;
    }

    public void initialize(URL location, ResourceBundle resources) {
        UIController.setRecordActionController(this);
        UIController.setRecordActionHandler(this.handler);
        this.scriptSave.setTooltip(new Tooltip(Main.getInternationalString("recordactioncontroller.lable.save")));
    }

    private void newOrContinueChoose() {
        DialogResponse response = new DialogResponse();
        boolean isSame = true;
        if (SingleTestCase.getInstance().getRecordStyle() == 1) {
            isSame = this.isSamePixel();
        }
        response = SingleTestCase.getInstance().getRecordStyle() == 1 && !isSame ? ChooseDialog.show(Main.getInternationalString("recordactioncontroller.ChooseDialog.diff"), Main.getInternationalString("recordactioncontroller.ChooseDialog.diff.new"), Main.getInternationalString("recordactioncontroller.ChooseDialog.diff.continue")) : ChooseDialog.show(Main.getInternationalString("recordactioncontroller.ChooseDialog.same"), Main.getInternationalString("recordactioncontroller.ChooseDialog.same.new"), Main.getInternationalString("recordactioncontroller.ChooseDialog.same.continue"));
        if (response.option == DialogResponse.Options.OK) {
            if (SingleTestCase.getInstance().getRecordStyle() == 0) {
                this.createNewTestCase();
            } else {
                this.createNewTestScript();
            }
        }
        if (response.option == DialogResponse.Options.CANCEL) {
            UIController.updateLabelText(this.replayTimesValue, "");
            SingleTestCase.getInstance().setEditing(true);
            SingleTestCase.getInstance().setRecording(true);
            SingleTestCase.getInstance().setRunType(0);
            if (SingleTestCase.getInstance().getRecordStyle() == 0) {
                UIController.updateNodeSytleClass((Node)this.startReplay, "replayBtnDisable");
                UIController.setScreenEventListener(this);
                ThreadPool.execute(new RecorderThread(this, this.scriptListener));
            } else {
                if (!isSame) {
                    if (this.isExistScript()) {
                        AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("recordactioncontroller.ChooseDialog.diff.continue.exist"));
                        SingleTestCase.getInstance().setEditing(false);
                        SingleTestCase.getInstance().setRecording(false);
                        this.handleStopWork();
                        return;
                    }
                    SingleTestCase.getInstance().setEditing(false);
                    SingleTestCase.getInstance().setCoordScriptPath(null);
                    SingleTestCase.getInstance().setCoordPixel(TestFileUtils.getPixel());
                    String showname = String.valueOf(SingleTestCase.getInstance().getName()) + " (" + SingleTestCase.getInstance().getCoordPixel() + ")";
                    UIController.updateLabelText(this.scriptName, showname);
                    UIController.cleenScreens();
                }
                UIController.updateNodeSytleClass((Node)this.startReplay, "replayBtnDisable");
                ThreadPool.execute(new CoordRecordThread());
            }
        }
        if (response.option == DialogResponse.Options.CLOSED) {
            this.handleStopWork();
        }
    }

    private boolean checkScriptDirNameExist() {
        String rootPath = TestFileUtils.getTestRootDir();
        List<String> scripts = TestFileUtils.getScriptsDir(rootPath);
        int num = this.getMaxNum(scripts);
        String defName = String.format("script_%03d", num + 1);
        DialogResponse response = InputDialog.show(Main.getInternationalString("recordactioncontroller.input.newScriptName"), defName);
        if (response.option == DialogResponse.Options.OK) {
            SingleTestCase.getInstance().setName(response.value);
            String scriptDir = TestFileUtils.getScriptDir(rootPath, response.value);
            if (new File(scriptDir).exists()) {
                String pixel;
                if (SingleTestCase.getInstance().getRecordStyle() == 0) {
                    DialogResponse response1 = ConfirmDialog.show(Main.getInternationalString("recordactioncontroller.savecoordscript.overrideornot"), null);
                    if (response1.option == DialogResponse.Options.OK) {
                        FileUtils.deleteQuietly((File)new File(scriptDir));
                        return true;
                    }
                    this.checkScriptDirNameExist();
                    return false;
                }
                if (SingleTestCase.getInstance().getRecordStyle() == 1 && this.isSamePixelScriptExist(scriptDir, pixel = TestFileUtils.getPixel())) {
                    DialogResponse response1 = ConfirmDialog.show(Main.getInternationalString("recordactioncontroller.savecoordscript.overrideornot"), null);
                    if (response1.option == DialogResponse.Options.OK) {
                        this.deleteCurrentPixelScript(scriptDir, pixel);
                        return true;
                    }
                    this.checkScriptDirNameExist();
                    return false;
                }
            }
            return true;
        }
        this.handleStopWork();
        return false;
    }

    private void deleteCurrentPixelScript(String scriptDir, String pixel) {
        File[] ff;
        File[] fileArray = ff = new File(scriptDir).listFiles();
        int n = ff.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().startsWith(pixel) && f.getName().endsWith(".script")) {
                FileUtils.deleteQuietly((File)f);
            }
            ++n2;
        }
    }

    private boolean isSamePixelScriptExist(String scriptDir, String pixel) {
        File[] ff;
        File[] fileArray = ff = new File(scriptDir).listFiles();
        int n = ff.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().startsWith(pixel) && f.getName().endsWith(".script")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void createNewTestScript() {
        if (this.checkScriptDirNameExist()) {
            UIController.cleenScreens();
            SingleTestCase.getInstance().setRecording(true);
            SingleTestCase.getInstance().setEditing(false);
            SingleTestCase.getInstance().setRunType(0);
            SingleTestCase.getInstance().setCoordPixel(TestFileUtils.getPixel());
            this.showScriptName();
            ThreadPool.execute(new CoordRecordThread());
        } else {
            if (TestinStage.getCoordRecordController() != null) {
                TestinStage.getCoordRecordController().setSaveScript(false);
            }
            this.disableButtons();
        }
    }

    @FXML
    public void clickStartBtn(MouseEvent event) {
        if (this.isWorking()) {
            return;
        }
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            boolean b = this.handleStartWork();
            if (b) {
                if (SingleTestCase.getInstance().getName() != null) {
                    this.newOrContinueChoose();
                } else if (SingleTestCase.getInstance().getRecordStyle() == 0) {
                    this.createNewTestCase();
                } else {
                    this.createNewTestScript();
                }
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            UIController.updateNodeSytleClass((Node)this.startButton, "startBtnEnter");
        } else if (eventType.equals("MOUSE_EXITED")) {
            UIController.updateNodeSytleClass((Node)this.startButton, "startBtnNormal");
        } else if (eventType.equals("MOUSE_PRESSED")) {
            UIController.updateNodeSytleClass((Node)this.startButton, "startBtnPressed");
        }
    }

    private void createNewTestCase() {
        if (this.checkScriptDirNameExist()) {
            UIController.cleenScreens();
            String relativeRoot = TestFileUtils.getTestRelativeDir();
            SingleTestCase.getInstance().setCasePath(TestFileUtils.getScriptDir(relativeRoot, SingleTestCase.getInstance().getName()));
            SingleTestCase.getInstance().setRecording(true);
            SingleTestCase.getInstance().setEditing(false);
            SingleTestCase.getInstance().setRunType(0);
            SingleTestCase.getInstance().removeAllAction();
            UIController.setAutoImgName(1);
            UIController.setScreenEventListener(this);
            ThreadPool.execute(new RecorderThread(this, this.scriptListener));
            this.showScriptName();
        } else {
            SingleTestCase.getInstance().setRecording(false);
            if (TestinStage.getRecordController() != null) {
                TestinStage.getRecordController().setSaveScript(false);
            }
            this.disableButtons();
        }
    }

    @FXML
    public void clickReplayBtn(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            if (this.isEnableReplay()) {
                if (SingleTestCase.getInstance().getRecordStyle() == 0) {
                    SingleTestCase.getInstance().setRunType(1);
                    this.replayScript();
                } else {
                    SingleTestCase.getInstance().setRunType(1);
                    ThreadPool.execute(new CoordReplayThread());
                }
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            if (this.isEnableReplay()) {
                UIController.updateNodeSytleClass((Node)this.startReplay, "replayBtnEnter");
            } else {
                UIController.updateNodeSytleClass((Node)this.startReplay, "replayBtnDisable");
            }
        } else if (eventType.equals("MOUSE_EXITED")) {
            if (this.isEnableReplay()) {
                UIController.updateNodeSytleClass((Node)this.startReplay, "replayBtnNormal");
            } else {
                UIController.updateNodeSytleClass((Node)this.startReplay, "replayBtnDisable");
            }
        } else if (eventType.equals("MOUSE_PRESSED")) {
            if (this.isEnableReplay()) {
                UIController.updateNodeSytleClass((Node)this.startReplay, "replayBtnPressed");
            } else {
                UIController.updateNodeSytleClass((Node)this.startReplay, "replayBtnDisable");
            }
        }
    }

    @FXML
    public void clickStopBtn(MouseEvent event) {
        if (!this.isWorking()) {
            return;
        }
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            if (SingleTestCase.getInstance().getRecordStyle() == 0) {
                if (SingleTestCase.getInstance().getRunType() == 0) {
                    this.stopRecord();
                } else {
                    this.stopReplay();
                }
            } else if (SingleTestCase.getInstance().getRunType() == 0) {
                this.stopCoordRecord();
            } else {
                this.stopCoordReplay();
            }
            this.handleStopWork();
        } else if (eventType.equals("MOUSE_ENTERED")) {
            if (!this.isWorking()) {
                UIController.updateNodeSytleClass((Node)this.stopButton, "stopBtnDisable");
            } else {
                UIController.updateNodeSytleClass((Node)this.stopButton, "stopBtnEnter");
            }
        } else if (eventType.equals("MOUSE_EXITED")) {
            if (!this.isWorking()) {
                UIController.updateNodeSytleClass((Node)this.stopButton, "stopBtnDisable");
            } else {
                UIController.updateNodeSytleClass((Node)this.stopButton, "stopBtnNormal");
            }
        } else if (eventType.equals("MOUSE_PRESSED")) {
            if (!this.isWorking()) {
                UIController.updateNodeSytleClass((Node)this.stopButton, "stopBtnDisable");
            } else {
                UIController.updateNodeSytleClass((Node)this.stopButton, "stopBtnPressed");
            }
        }
    }

    @FXML
    private void scriptSaveClick(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            this.saveScriptclicked();
        } else if (eventType.equals("MOUSE_ENTERED")) {
            if (this.isSaveAvailable()) {
                UIController.updateNodeSytleClass((Node)this.scriptSave, "saveBtnEnter");
            } else {
                UIController.updateNodeSytleClass((Node)this.scriptSave, "saveBtnDisable");
            }
        } else if (eventType.equals("MOUSE_EXITED")) {
            if (this.isSaveAvailable()) {
                UIController.updateNodeSytleClass((Node)this.scriptSave, "saveBtnNormal");
            } else {
                UIController.updateNodeSytleClass((Node)this.scriptSave, "saveBtnDisable");
            }
        } else if (eventType.equals("MOUSE_PRESSED")) {
            if (this.isSaveAvailable()) {
                UIController.updateNodeSytleClass((Node)this.scriptSave, "saveBtnPressed");
            } else {
                UIController.updateNodeSytleClass((Node)this.scriptSave, "saveBtnDisable");
            }
        }
    }

    private boolean isSaveAvailable() {
        return SingleTestCase.getInstance().getName() != null && !SingleTestCase.getInstance().isSaved();
    }

    public void saveScriptclicked() {
        if (!this.isSaveAvailable()) {
            return;
        }
        SingleTestCase.getInstance().setSaved(true);
        UIController.updateNodeSytleClass((Node)this.scriptSave, "saveBtnDisable");
        if (SingleTestCase.getInstance().getRecordStyle() == 0) {
            String invalidScriptLines = UIController.getScriptShowController().scanInvalidScriptLines();
            if (StringUtils.isNotEmpty((String)invalidScriptLines)) {
                DetailsDialog.show(Main.getInternationalString("editscriptshow.textscript.invalidscript"), invalidScriptLines);
                return;
            }
            if (UIController.getScriptShowController().isScriptTextChanged()) {
                log.info((Object)"Script has changed, need update while clicking save script button.");
                UIController.getScriptShowController().updateTestCaseByScriptText();
            }
            Message m = new Message();
            m.setStatus(774);
            UIController.getScriptShowHandler().sendMessage(m);
        } else {
            SingleTestCase.getInstance().setCoordScriptPath(this.getNormalPixelScriptPath());
            Message m = new Message();
            m.setStatus(774);
            m.setContent(SingleTestCase.getInstance().getCoordScriptPath());
            UIController.getCoordscriptShowHandler().sendMessage(m);
        }
    }

    private int getMaxNum(List<String> scripts) {
        int num = 0;
        if (scripts.size() > 0) {
            int i = 0;
            while (i < scripts.size()) {
                String name = new File(scripts.get(i)).getName();
                String[] l = name.split("_");
                if (l.length > 1) {
                    try {
                        if (Utils.isNumber(l[1])) {
                            int n = Integer.parseInt(l[1]);
                            num = num > n ? num : n;
                        }
                    }
                    catch (Exception ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                ++i;
            }
        }
        return num;
    }

    private int getRotation(UiAutomatorModel uimodel) {
        BasicTreeNode tmpNode;
        if (uimodel != null && (tmpNode = uimodel.getXmlRootNode()) instanceof RootWindowNode) {
            int rotation = ((RootWindowNode)tmpNode).rotation;
            return rotation;
        }
        return 0;
    }

    private float pointXInScreen(double x, int orientation) {
        if (!DevicesManager.isDeviceOK()) {
            return 0.0f;
        }
        int w = orientation == 0 || orientation == 2 ? DevicesManager.getDevice().getDisplayWidth() : DevicesManager.getDevice().getDisplayHeight();
        DecimalFormat df = new DecimalFormat("#.0000");
        return Float.parseFloat(df.format(x / (double)w));
    }

    private float pointYInScreen(double y, int orientation) {
        if (!DevicesManager.isDeviceOK()) {
            return 0.0f;
        }
        int h = orientation == 0 || orientation == 2 ? DevicesManager.getDevice().getDisplayHeight() : DevicesManager.getDevice().getDisplayWidth();
        DecimalFormat df = new DecimalFormat("#.0000");
        return Float.parseFloat(df.format(y / (double)h));
    }

    private UiAutomatorModel getUiModel(String windowInfo) {
        String myWindowInfo = windowInfo;
        if (!this.isWindowInfoValid(myWindowInfo)) {
            myWindowInfo = this.getWindowInfo();
        }
        if (!this.isWindowInfoValid(myWindowInfo)) {
            return null;
        }
        UiAutomatorModel mModel = null;
        try {
            mModel = new UiAutomatorModel(myWindowInfo);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return mModel;
    }

    private boolean isWindowInfoValid(String windowInfo) {
        return String.valueOf(windowInfo) != null && String.valueOf(windowInfo).startsWith("<?");
    }

    private TestAction generateRemoteAction(Event event) {
        TestAction action = null;
        int rotation = UIController.getRotation();
        try {
            if (event.getType() == 0 || event.getType() == 1) {
                action = this.recordActionTouch(ActionType.remote_touch, ActionRule.tap, rotation, this.pointXInScreen(event.getCenter().getX(), rotation), this.pointYInScreen(event.getCenter().getY(), rotation));
            } else if (event.getType() == 2) {
                action = this.recordActionDrag(ActionType.remote_drag, ActionRule.none, rotation, this.pointXInScreen(event.getStart().getX(), rotation), this.pointXInScreen(event.getEnd().getX(), rotation), this.pointYInScreen(event.getStart().getY(), rotation), this.pointYInScreen(event.getEnd().getY(), rotation));
            } else if (event.getType() == 3) {
                action = Utils.generateRemoteKeyAction("KEYCODE_" + event.getKeyName());
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return action;
    }

    public void onRemoteClick(int orientation, double x, double y) {
        if (SingleTestCase.getInstance().isRecording()) {
            log.info((Object)String.format("On remote click. orientation: %s, x: %s, y: %s.", orientation, x, y));
            TestAction action = null;
            action = this.recordActionTouch(ActionType.remote_touch, ActionRule.tap, orientation, (float)x, (float)y);
            this.sendTestAction(action);
        }
    }

    private TestAction recordActionTouch(ActionType actionOption, ActionRule rule, int rotation, float x, float y) {
        ActionTouch action = new ActionTouch();
        action.setAction(actionOption);
        action.setRule(rule);
        action.setRotation(rotation);
        action.setX(x);
        action.setY(y);
        return action;
    }

    public void onRemoteDrag(int orientation, float fromX, float toX, float fromY, float toY) {
        if (SingleTestCase.getInstance().isRecording()) {
            log.info((Object)String.format("On remote drag. orientation: %s, from(%s, %s), to (%s, %s).", orientation, Float.valueOf(fromX), Float.valueOf(fromY), Float.valueOf(toX), Float.valueOf(toY)));
            TestAction action = null;
            action = this.recordActionDrag(ActionType.remote_drag, ActionRule.none, orientation, fromX, toX, fromY, toY);
            this.sendTestAction(action);
        }
    }

    private TestAction recordActionDrag(ActionType actionOption, ActionRule rule, int rotation, float fromX, float toX, float fromY, float toY) {
        ActionDrag action = new ActionDrag();
        action.setAction(actionOption);
        action.setRule(rule);
        action.setRotation(rotation);
        action.setFromX(fromX);
        action.setToX(toX);
        action.setFromY(fromY);
        action.setToY(toY);
        return action;
    }

    private TestAction parseDragAction(Event event, UiAutomatorModel uiModel, int rotation) {
        if (event == null || uiModel == null) {
            log.error((Object)"invalue event object or ui model object, unable to parse action.");
            return null;
        }
        if (event.getType() != 2) {
            log.error((Object)"not drag event, not parsed in this method.");
            return null;
        }
        TestAction action = null;
        BasicTreeNode start = uiModel.getSelectedNodeByCoordinates(event.getStart().getX(), event.getStart().getY());
        BasicTreeNode end = uiModel.getSelectedNodeByCoordinates(event.getEnd().getX(), event.getEnd().getY());
        action = start != null && end != null && start.isSameNode(end) ? Utils.generateDragInNodeAction(event.getRule(), rotation, start) : Utils.generateDragOnScreenAction(rotation, this.pointXInScreen(event.getStart().getX(), rotation), this.pointXInScreen(event.getEnd().getX(), rotation), this.pointYInScreen(event.getStart().getY(), rotation), this.pointYInScreen(event.getEnd().getY(), rotation));
        return action;
    }

    public void sendTestAction(TestAction action) {
        Message tableMsg = new Message();
        tableMsg.setStatus(773);
        tableMsg.setContent(action);
        UIController.getScriptShowHandler().sendMessage(tableMsg);
    }

    public String getWindowInfo() {
        return ViewClient.getLastWindowInfo();
    }

    private boolean isCurrentPageHasEditable() {
        String windowinfo = ViewClient.getLastWindowInfo();
        return windowinfo.contains("editable=\"true\"");
    }

    @Override
    public void handleEvent(Event event) {
        log.info((Object)event);
        if (!SingleTestCase.getInstance().isRecording()) {
            log.info((Object)"It's not recording right now, ignore event.");
            return;
        }
        TestAction action = null;
        if (!StatusMgt.isInsideApp()) {
            action = this.generateRemoteAction(event);
        } else {
            UiAutomatorModel mModel = this.getUiModel(event.getWindowInfo());
            if (mModel == null) {
                log.info((Object)"UI Model is null.");
                return;
            }
            int rotation = this.getRotation(mModel);
            if (!(event.getType() != 0 && event.getType() != 1 && event.getType() != 4 || event.getCenter().isZero())) {
                BasicTreeNode node = mModel.getSelectedNodeByCoordinates(event.getCenter().getX(), event.getCenter().getY());
                if (node != null) {
                    if (this.isEditable(node)) {
                        log.info((Object)"It's a editable node, ignore click event.");
                        Utils.beep();
                        DialogResponse inputText = InputDialogWithOptions.show(Main.getInternationalString("inputdialog.prompt"), "");
                        if (inputText != null && inputText.value != null) {
                            action = Utils.generateInputTextAction(ActionRule.getRule(inputText.value2), inputText.value, node);
                            ViewClient.runCommand(action.expr());
                        }
                    } else if (this.isCurrentPageHasEditable()) {
                        if (node.getChildCount() == 0) {
                            action = Utils.generateClickAction(event.getRule(), rotation, node);
                        }
                    } else {
                        action = Utils.generateClickAction(event.getRule(), rotation, node);
                    }
                } else {
                    action = Utils.generateTouchOnScreenAction(rotation, this.pointXInScreen(event.getCenter().getX(), rotation), this.pointYInScreen(event.getCenter().getY(), rotation));
                }
            } else if (event.getType() == 2) {
                action = this.parseDragAction(event, mModel, rotation);
            } else if (event.getType() == 3) {
                if (event.getKeycode().equals((Object)IDeviceShell.KeyCode.HOME) || event.getKeycode().equals((Object)IDeviceShell.KeyCode.SEARCH)) {
                    log.info((Object)"Ignore key press for home and search.");
                } else {
                    action = Utils.generateInputkeyAction(event.getRule(), "KEYCODE_" + event.getKeyName());
                }
            }
        }
        if (action != null) {
            this.sendTestAction(Utils.generateSleepAction((int)UIController.getLastActionElapseTime()));
            UIController.setLastActionTimeToCurrentTime();
            if (SingleTestCase.getInstance().isAutoShot()) {
                TestAction autoScreenshotAction = Utils.generateAutoScreenshot(UIController.getNextAutoImgName(), SingleTestCase.getInstance().isAutoShot());
                this.sendTestAction(autoScreenshotAction);
            }
            this.sendTestAction(action);
        }
    }

    private boolean isEditable(BasicTreeNode node) {
        try {
            UiNode uinode = (UiNode)node;
            if (Boolean.parseBoolean(uinode.getAttribute("editable"))) {
                return true;
            }
        }
        catch (Exception e) {
            log.info((Object)"Parse ui tree node error.", (Throwable)e);
        }
        return false;
    }

    @Override
    public void showPromptMsg(String msg) {
        this.setPromptMsg(msg);
    }

    @Override
    public void recorderStart() {
        this.handleStartWork();
    }

    @Override
    public void recorderStop() {
        this.handleStopWork();
    }

    public boolean isEnableReplay() {
        boolean iswork = this.isWorking();
        return !iswork && !SingleTestCase.getInstance().isRecording() && SingleTestCase.getInstance().getName() != null && (SingleTestCase.getInstance().getCasePath() != null || SingleTestCase.getInstance().getCoordScriptPath() != null);
    }

    private void enableReplayButton() {
        UIController.updateNodeSytleClass((Node)this.startReplay, "replayBtnNormal");
    }

    private void disableButtons() {
        UIController.updateNodeSytleClass((Node)this.stopButton, "stopBtnDisable");
        if (SingleTestCase.getInstance().getName() != null) {
            UIController.updateNodeSytleClass((Node)this.startReplay, "replayBtnNormal");
        } else {
            UIController.updateNodeSytleClass((Node)this.startReplay, "replayBtnDisable");
        }
        UIController.updateNodeSytleClass((Node)this.startButton, "startBtnNormal");
    }

    public class CoordRecordThread
    extends Thread {
        public boolean stop = false;

        public CoordRecordThread() {
            this.setName("CoordRecord");
        }

        public boolean isStop() {
            return this.stop;
        }

        public void setStop(boolean stop) {
            this.stop = stop;
        }

        @Override
        public void run() {
            RecordActionController.this.handleStartWork();
            UIController.sendRecordStartMsg(769);
            coordRecorder = new CoordScriptRecord(DevicesManager.getDevice());
            coordRecorder.record(RecordActionController.this.coordRecorderListener, this);
        }
    }

    public class CoordReplayThread
    extends Thread {
        public boolean stop = false;

        public boolean isStop() {
            return this.stop;
        }

        public void setStop(boolean stop) {
            this.stop = stop;
        }

        public CoordReplayThread() {
            this.setName("CoordReplay");
        }

        @Override
        public void run() {
            DialogResponse response = InputReplayDialog.show(Main.getInternationalString("scriptmanagecontroller.replay.message"), "1");
            if (response.option == DialogResponse.Options.OK) {
                UIController.updateNodeSytleClass((Node)RecordActionController.this.startReplay, "replayBtnDisable");
                RecordActionController.this.handleStartWork();
                UIController.sendReplayStartMsg();
                coordReplayer = new CoordScriptReplay(DevicesManager.getDevice());
                replayTimes = Integer.valueOf(response.value);
                coordReplayer.replay(SingleTestCase.getInstance().getCoordScriptPath(), RecordActionController.this.coordReplayListener, replayTimes, this);
            } else if (response.option == DialogResponse.Options.CANCEL) {
                RecordActionController.this.handleStopWork();
            }
            Utils.gc();
        }
    }

    public class ReplayThread
    extends Thread {
        public boolean stop = false;

        public boolean isStop() {
            return this.stop;
        }

        public void setStop(boolean stop) {
            this.stop = stop;
        }

        public ReplayThread() {
            this.setName("Replay");
        }

        @Override
        public void run() {
            DialogResponse response = InputReplayDialog.show(Main.getInternationalString("scriptmanagecontroller.replay.message"), "1");
            try {
                try {
                    if (response.option == DialogResponse.Options.OK) {
                        UIController.updateNodeSytleClass((Node)RecordActionController.this.startReplay, "replayBtnDisable");
                        RecordActionController.this.isReplayingScript = true;
                        RecordActionController.this.handleStartWork();
                        UIController.sendReplayStartMsg();
                        replayer = new ScriptReplay(DevicesManager.getDevice());
                        replayTimes = Integer.valueOf(response.value);
                        replayer.replay(RecordActionController.this.replayListener, replayTimes, this);
                    } else if (response.option == DialogResponse.Options.CANCEL) {
                        RecordActionController.this.handleStopWork();
                    }
                }
                catch (Exception e) {
                    log.error((Object)String.format("Replay script encounters error. Error Msg: %s.", e.getMessage()), (Throwable)e);
                    Utils.gc();
                    RecordActionController.this.isReplayingScript = false;
                }
            }
            finally {
                Utils.gc();
                RecordActionController.this.isReplayingScript = false;
            }
        }
    }
}

