/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.include;

import com.testin.itestin.business.SingleTestCase;
import com.testin.itestin.business.actions.ActionRule;
import com.testin.itestin.business.actions.ActionType;
import com.testin.itestin.business.actions.TestAction;
import com.testin.itestin.business.actions.TestActionNote;
import com.testin.itestin.business.actions.TestActionScreenshot;
import com.testin.itestin.business.actions.TestActionSleep;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.os.Handler;
import com.testin.itestin.os.Message;
import com.testin.javafx.Main;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.control.AlertDialog;
import com.testin.javafx.ui.control.DetailsDialog;
import com.testin.javafx.ui.control.DialogResponse;
import com.testin.javafx.ui.control.InputDialog;
import com.testin.javafx.ui.control.ScriptAlterDialog;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ScriptShowController
extends AnchorPane
implements Initializable {
    static Logger log = Logger.getLogger(ScriptShowController.class);
    @FXML
    TableView<Script> tableview;
    @FXML
    TextArea textArea;
    @FXML
    TabPane TabPane;
    @FXML
    Label text;
    @FXML
    Label script;
    @FXML
    Label sleepbtn;
    @FXML
    Label shotbtn;
    @FXML
    Label editbtn;
    @FXML
    Label delbtn;
    @FXML
    Label descbtn;
    private int rowCount = 16;
    private String scriptCreateTime;
    private ContextMenu contextMenu = new ContextMenu();
    private static boolean scriptEditStatus = false;
    private static List<MenuItem> MenuItems = new ArrayList<MenuItem>();
    private Vector<String> scriptEdit = new Vector();
    private Handler handler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.getStatus()) {
                case 773: {
                    TestAction action = (TestAction)msg.getContent(TestAction.class);
                    ScriptShowController.this.appendAction(action);
                    if (SingleTestCase.getInstance().isEditing() || ScriptShowController.this.tableview.getItems().size() <= ScriptShowController.this.rowCount) break;
                    ScriptShowController.this.tableview.scrollTo(ScriptShowController.this.tableview.getItems().size());
                    break;
                }
                case 774: {
                    ScriptShowController.this.scriptCreateTime = String.valueOf(System.currentTimeMillis());
                    SingleTestCase.getInstance().setCreateTime(ScriptShowController.this.scriptCreateTime);
                    SingleTestCase.getInstance().saveScript();
                    break;
                }
                case 1282: {
                    ScriptShowController.this.show();
                    break;
                }
                case 1027: {
                    int index = (Integer)msg.getContent(Integer.class);
                    ScriptShowController.this.tableview.scrollTo(index - 1);
                    ScriptShowController.this.tableview.getSelectionModel().select(index - 1);
                    break;
                }
                case 769: {
                    if (!SingleTestCase.getInstance().isEditing()) {
                        ScriptShowController.this.clearScriptTable();
                        ScriptShowController.this.textArea.clear();
                    }
                    ScriptShowController.this.enableBottomButtonsStyle();
                    break;
                }
                case 770: {
                    SingleTestCase.getInstance().setRecording(false);
                    SingleTestCase.getInstance().setEditing(false);
                    break;
                }
                case 1025: {
                    break;
                }
                case 1026: {
                    if (msg.getContent() == null) {
                        return;
                    }
                    int state = (Integer)msg.getContent(Integer.class);
                    if (state == 0) {
                        SingleTestCase.getInstance().setRunResult(String.valueOf(1));
                    } else {
                        SingleTestCase.getInstance().setRunResult(String.valueOf(2));
                    }
                    SingleTestCase.getInstance().saveScript();
                    break;
                }
                case 768: {
                    ScriptShowController.this.clearScriptTable();
                    ScriptShowController.this.disableBottomButtonsSytle();
                    ScriptShowController.this.textArea.clear();
                    break;
                }
            }
        }
    };

    static {
        MenuItems.add(ScriptShowController.createMenuItem(Main.getInternationalString("coordscriptshowcontroller.menuitem1"), "sleep"));
        MenuItems.add(ScriptShowController.createMenuItem(Main.getInternationalString("coordscriptshowcontroller.menuitem2"), "screenshot"));
        MenuItems.add((MenuItem)ScriptShowController.createSeparatorMenuItem());
        MenuItems.add(ScriptShowController.createMenuItem(Main.getInternationalString("coordscriptshowcontroller.menuitem3"), "alter"));
        MenuItems.add(ScriptShowController.createMenuItem(Main.getInternationalString("coordscriptshowcontroller.menuitem4"), "delete"));
    }

    private static MenuItem createMenuItem(String text, String id) {
        Label lbl = new Label(text);
        lbl.setPrefWidth(130.0);
        lbl.setWrapText(true);
        MenuItem menuItem = new MenuItem();
        menuItem.setId(id);
        menuItem.setGraphic((Node)lbl);
        return menuItem;
    }

    private static SeparatorMenuItem createSeparatorMenuItem() {
        SeparatorMenuItem menuItem = new SeparatorMenuItem();
        return menuItem;
    }

    private TableColumn<String, String> createTableColumn(double width, String show, String data) {
        TableColumn col = new TableColumn(show);
        col.setResizable(false);
        col.setSortable(false);
        col.setPrefWidth(width);
        col.setCellValueFactory((Callback)new PropertyValueFactory(data));
        return col;
    }

    public void initialize(URL arg0, ResourceBundle arg1) {
        UIController.setScriptShowController(this);
        UIController.setScriptShowHandler(this.handler);
        this.initContextMenu();
        this.textArea.setEditable(true);
        this.sleepbtn.setTooltip(new Tooltip(Main.getInternationalString("coordscriptshowcontroller.menuitem1")));
        this.shotbtn.setTooltip(new Tooltip(Main.getInternationalString("coordscriptshowcontroller.menuitem2")));
        this.editbtn.setTooltip(new Tooltip(Main.getInternationalString("coordscriptshowcontroller.menuitem3")));
        this.delbtn.setTooltip(new Tooltip(Main.getInternationalString("coordscriptshowcontroller.menuitem4")));
        this.descbtn.setTooltip(new Tooltip(Main.getInternationalString("coordscriptshowcontroller.menuitem5")));
        this.textArea.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (TestinStage.getRecordController() != null) {
                    if (ScriptShowController.this.isScriptTextChanged()) {
                        TestinStage.getRecordController().setSaveScript(true);
                    } else {
                        TestinStage.getRecordController().setSaveScript(false);
                    }
                }
            }
        });
        Object[] columns = new TableColumn[]{this.createTableColumn(100.0, Main.getInternationalString("coordscriptshowcontroller.initialize.action"), "act"), this.createTableColumn(370.0, Main.getInternationalString("coordscriptshowcontroller.initialize.element"), "ele")};
        this.tableview.getColumns().setAll(columns);
        this.tableview.getColumns().addListener((ListChangeListener)new ListChangeListener<Object>((TableColumn[])columns){
            public boolean suspended = true;
            private final /* synthetic */ TableColumn[] val$columns;
            {
                this.val$columns = tableColumnArray;
            }

            public void onChanged(ListChangeListener.Change<?> change) {
                change.next();
                if (change.wasReplaced() && this.suspended) {
                    this.suspended = false;
                    ScriptShowController.this.tableview.getColumns().setAll((Object[])this.val$columns);
                    this.suspended = true;
                }
            }
        });
        this.tableview.visibleProperty().set(true);
        this.textArea.setVisible(false);
        UIController.updateNodeSytleClass((Node)this.script, "tab-click");
        UIController.updateNodeSytleClass((Node)this.text, "tab-unclick");
        this.tableview.getItems().add((Object)new Script("", ""));
    }

    private void initContextMenu() {
        this.contextMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MenuItem item = (MenuItem)event.getTarget();
                ScriptShowController.this.handleMenuItem(item.getId());
                ScriptShowController.this.hideContextMenu();
            }
        });
        this.contextMenu.getItems().addAll(MenuItems);
    }

    private void handleMenuItem(String id) {
        if (id == null) {
            return;
        }
        int index = this.tableview.getSelectionModel().getSelectedIndex();
        if (this.tableview.getItems().size() <= 0 && !id.equals("delete") && !id.equals("alter")) {
            Script empty = new Script("", "");
            this.tableview.getItems().add((Object)empty);
            index = 0;
        } else if (!(index >= 0 || id.equals("step") || id.equals("sleep") || id.equals("screenshot"))) {
            AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("coordscriptshowcontroller.handlemenuitem.selectedline"));
            return;
        }
        if (id.equals("sleep")) {
            DialogResponse sleep = InputDialog.show(Main.getInternationalString("coordscriptshowcontroller.handlemenuitem.inputdelaytime"), "2000");
            if (sleep.option == DialogResponse.Options.OK) {
                if (sleep.value.equals("")) {
                    AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("scriptshowcontroller.handlemenuitem.alterconnull"));
                    return;
                }
                String time = sleep.value;
                if (index < 0) {
                    this.tableview.getItems().add(this.tableview.getItems().size() - 1, (Object)new Script(Main.getInternationalString("coordscriptshowcontroller.handlemenuitem.delay"), time));
                } else {
                    this.tableview.getItems().add(index, (Object)new Script(Main.getInternationalString("coordscriptshowcontroller.handlemenuitem.delay"), time));
                }
                TestActionSleep action = new TestActionSleep();
                action.setAction(ActionType.sleep);
                action.setSleep(Integer.valueOf(time));
                action.setRule(ActionRule.none);
                SingleTestCase.getInstance().insertTestAction(action, index);
                this.updateTestArea();
                scriptEditStatus = true;
                if (TestinStage.getRecordController() != null) {
                    TestinStage.getRecordController().setSaveScript(scriptEditStatus);
                }
            }
        } else if (id.equals("screenshot")) {
            String nextImgName = this.getNextImageName();
            if (index < 0) {
                this.tableview.getItems().add(this.tableview.getItems().size() - 1, (Object)new Script(Main.getInternationalString("coordscriptshowcontroller.handlemenuitem.screenshot"), nextImgName));
            } else {
                this.tableview.getItems().add(index, (Object)new Script(Main.getInternationalString("coordscriptshowcontroller.handlemenuitem.screenshot"), nextImgName));
            }
            TestActionScreenshot screenShot = new TestActionScreenshot();
            screenShot.setAction(ActionType.screenshot);
            screenShot.setImageName(nextImgName);
            screenShot.setRule(ActionRule.none);
            SingleTestCase.getInstance().insertTestAction(screenShot, index);
            this.updateTestArea();
            scriptEditStatus = true;
            if (TestinStage.getRecordController() != null) {
                TestinStage.getRecordController().setSaveScript(scriptEditStatus);
            }
        } else if (id.equals("step")) {
            DialogResponse description = InputDialog.show(Main.getInternationalString("coordscriptshowcontroller.menuitem5"), "//");
            if (description.option == DialogResponse.Options.OK) {
                if (description.value.equals("")) {
                    AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("scriptshowcontroller.handlemenuitem.alterconnull"));
                    return;
                }
                String value = description.value;
                if (index < 0) {
                    this.tableview.getItems().add(this.tableview.getItems().size() - 1, (Object)new Script(Main.getInternationalString("coordscriptshowcontroller.menuitem5"), value));
                } else {
                    this.tableview.getItems().add(index, (Object)new Script(Main.getInternationalString("coordscriptshowcontroller.menuitem5"), value));
                }
                TestActionNote action = new TestActionNote();
                action.setAction(ActionType.note);
                action.setRule(ActionRule.none);
                action.setNote(value);
                SingleTestCase.getInstance().insertTestAction(action, index);
                this.updateTestArea();
                scriptEditStatus = true;
                if (TestinStage.getRecordController() != null) {
                    TestinStage.getRecordController().setSaveScript(scriptEditStatus);
                }
            }
        } else if (id.equals("delete")) {
            if (this.tableview.getItems().isEmpty()) {
                return;
            }
            this.tableview.getItems().remove(index);
            if (SingleTestCase.getInstance().getActions().isEmpty() || SingleTestCase.getInstance().getActions().size() <= index) {
                return;
            }
            SingleTestCase.getInstance().removeAction(index);
            this.updateTestArea();
            scriptEditStatus = true;
            if (TestinStage.getRecordController() != null) {
                TestinStage.getRecordController().setSaveScript(scriptEditStatus);
            }
        } else if (id.equals("alter")) {
            ArrayList<TestAction> acts = SingleTestCase.getInstance().getActions();
            if (index >= acts.size()) {
                return;
            }
            String oldScript = acts.get(index).expr();
            String newScript = "";
            HashMap<String, String> data = ScriptShowController.parseExpra(oldScript);
            if (!(data.get("time") != null && !data.get("time").equals("") || data.get("img") != null && !data.get("img").equals("") || data.get("data") != null && !data.get("data").equals("") || data.get("text") != null && !data.get("text").equals("") || data.get("keycode") != null && !data.get("keycode").equals(""))) {
                AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("scriptshowcontroller.handlemenuitem.editenable"));
                return;
            }
            String element = ((Script)this.tableview.getSelectionModel().getSelectedItem()).getEle();
            DialogResponse alter = ScriptAlterDialog.show(Main.getInternationalString("coordscriptshowcontroller.handlemenuitem.inputaltercontent"), acts.get(index).show());
            if (alter.option == DialogResponse.Options.OK) {
                String temp;
                if (alter.value.equals("")) {
                    return;
                }
                String con = ((Script)this.tableview.getSelectionModel().getSelectedItem()).getAct().replace(" ", "");
                if (con.equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.delay"))) {
                    this.tableview.getItems().set(index, (Object)new Script(con, alter.value));
                    newScript = oldScript.replace("[time/" + element, "[time/" + alter.value);
                } else if (con.equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.screen"))) {
                    TestActionScreenshot screenshot = (TestActionScreenshot)SingleTestCase.getInstance().getTestAction(index);
                    if (StringUtils.isEmpty((String)alter.value)) {
                        AlertDialog.show(AlertDialog.DialogOptions.ERROR, Main.getInternationalString("editscriptshow.img.isnotnull"));
                        return;
                    }
                    if (this.containsImageName(alter.value) && !alter.value.equals(screenshot.getImageName())) {
                        AlertDialog.show(AlertDialog.DialogOptions.ERROR, Main.getInternationalString("editscriptshow.img.isnotonly"));
                        return;
                    }
                    this.tableview.getItems().set(index, (Object)new Script(con, alter.value));
                    newScript = oldScript.replace("[img/" + element, "[img/" + alter.value);
                } else if (con.equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.press"))) {
                    this.tableview.getItems().set(index, (Object)new Script(con, alter.value));
                    newScript = oldScript.replace("[keycode/" + element, "[keycode/" + alter.value);
                } else if (con.equals(Main.getInternationalString("coordscriptshowcontroller.scriptshowinTable.touch"))) {
                    temp = alter.value.replace("][", ",").replace("[", "").replace("]", "");
                    String[] subValue9 = temp.split(",");
                    if (subValue9.length != 3) {
                        AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("scriptshowcontroller.handlemenuitem.altererror"));
                        return;
                    }
                    this.tableview.getItems().set(index, (Object)new Script(con, alter.value));
                    newScript = oldScript.replace("[data/" + element.replace("][", ",").replace("[", "").replace("]", ""), "[data/" + temp);
                } else if (con.equals(Main.getInternationalString("testaction.getactionname.drag"))) {
                    temp = alter.value.replace("][", ",").replace("[", "").replace("]", "");
                    String[] subValue9 = temp.split(",");
                    if (subValue9.length != 5) {
                        AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("scriptshowcontroller.handlemenuitem.altererror"));
                        return;
                    }
                    this.tableview.getItems().set(index, (Object)new Script(con, alter.value));
                    newScript = oldScript.replace("[data/" + element.replace("][", ",").replace("[", "").replace("]", ""), "[data/" + temp);
                } else if (data.get("text") != null && !data.get("text").isEmpty() && data.get("text").equals(element)) {
                    this.tableview.getItems().set(index, (Object)new Script(con, alter.value));
                    newScript = oldScript.replace("[text/" + element, "[text/" + alter.value);
                } else {
                    AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("scriptshowcontroller.handlemenuitem.altererror"));
                }
                TestAction action = TestAction.newInstance(newScript);
                if (action == null) {
                    AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("scriptshowcontroller.handlemenuitem.altererror"));
                    return;
                }
                SingleTestCase.getInstance().alterTestAction(action, index);
                this.updateTestArea();
                scriptEditStatus = true;
                if (TestinStage.getRecordController() != null) {
                    TestinStage.getRecordController().setSaveScript(scriptEditStatus);
                }
            }
        }
    }

    private static HashMap<String, String> parseExpra(String expr) {
        HashMap<String, String> data = new HashMap<String, String>();
        Pattern p = Pattern.compile("\\[(.*?)\\]");
        Matcher m = p.matcher(expr);
        ArrayList<String> kvs = new ArrayList<String>();
        while (m.find()) {
            kvs.add(m.group(1));
        }
        for (String str : kvs) {
            int index = str.indexOf("/");
            String key = str.substring(0, index);
            String value = str.substring(index + 1);
            data.put(key, value);
        }
        return data;
    }

    private void updateTestArea() {
        this.textArea.clear();
        ArrayList<TestAction> acts = SingleTestCase.getInstance().getActions();
        for (TestAction a : acts) {
            a.expr();
            this.textArea.appendText(String.valueOf(a.expr()) + "\r\n");
        }
    }

    private boolean containsImageName(String imgName) {
        ArrayList<TestAction> acts = SingleTestCase.getInstance().getActions();
        for (TestAction act : acts) {
            TestActionScreenshot screenshot;
            if (act.getActionType() != ActionType.screenshot || !imgName.equals((screenshot = (TestActionScreenshot)act).getImageName())) continue;
            return true;
        }
        return false;
    }

    private String getNextImageName() {
        if (SingleTestCase.getInstance().getActions().size() == 0) {
            return "pic_1";
        }
        int num = 0;
        ArrayList<TestAction> acts = SingleTestCase.getInstance().getActions();
        for (TestAction act : acts) {
            TestActionScreenshot screenshot;
            String imgName;
            int i;
            if (act.getActionType() != ActionType.screenshot || num >= (i = this.getImgNum(imgName = (screenshot = (TestActionScreenshot)act).getImageName()))) continue;
            num = i;
        }
        return "pic_" + (num + 1);
    }

    private int getImgNum(String imgName) {
        Pattern p = Pattern.compile("^pic_(\\d+)$");
        Matcher m = p.matcher(imgName);
        if (m.find()) {
            return Integer.parseInt(m.group(1));
        }
        return 1;
    }

    public void setPrefSize(double width, double height) {
        this.TabPane.setPrefSize(width, height);
        this.tableview.setPrefSize(width, height);
    }

    private void appendAction(TestAction act) {
        if (act.getActionType() == ActionType.screenshot) {
            TestActionScreenshot screenshot = (TestActionScreenshot)act;
            screenshot.setImageName(this.getNextImageName());
        }
        String actionName = act.getActionName();
        String show = act.show();
        String expr = act.expr();
        Script s = new Script(actionName, show);
        ObservableList items = this.tableview.getItems();
        if (SingleTestCase.getInstance().isEditing()) {
            if (items.size() == 0) {
                this.tableview.getItems().add((Object)s);
                this.textArea.appendText(String.valueOf(expr) + "\r\n");
                SingleTestCase.getInstance().addTestAction(act);
                Script empty = new Script("", "");
                this.tableview.getItems().add((Object)empty);
            } else {
                Script empty;
                int index = this.tableview.getSelectionModel().getSelectedIndex();
                if (index < 0) {
                    index = this.tableview.getItems().size() - 1;
                }
                if (StringUtils.isEmpty((String)(empty = (Script)items.get(items.size() - 1)).act) && StringUtils.isEmpty((String)empty.ele)) {
                    this.tableview.getItems().add(index, (Object)s);
                    SingleTestCase.getInstance().insertTestAction(act, index);
                    this.updateTestArea();
                } else {
                    this.tableview.getItems().add((Object)s);
                    SingleTestCase.getInstance().insertTestAction(act, index);
                    this.updateTestArea();
                }
            }
        } else if (items.size() == 0) {
            this.tableview.getItems().add((Object)s);
            this.textArea.appendText(String.valueOf(expr) + "\r\n");
            SingleTestCase.getInstance().addTestAction(act);
            Script empty = new Script("", "");
            this.tableview.getItems().add((Object)empty);
        } else {
            Script empty = (Script)items.get(items.size() - 1);
            if (StringUtils.isEmpty((String)empty.act) && StringUtils.isEmpty((String)empty.ele)) {
                this.tableview.getItems().add(items.size() - 1, (Object)s);
                this.textArea.appendText(String.valueOf(expr) + "\r\n");
                SingleTestCase.getInstance().addTestAction(act);
            } else {
                this.tableview.getItems().add((Object)s);
                this.textArea.appendText(String.valueOf(expr) + "\r\n");
                SingleTestCase.getInstance().addTestAction(act);
            }
        }
    }

    private void show() {
        this.clearScriptTable();
        if (SingleTestCase.getInstance() != null && SingleTestCase.getInstance().getRecordStyle() == 0) {
            Script empty;
            ArrayList<TestAction> acts = SingleTestCase.getInstance().getActions();
            String actstr = "";
            for (TestAction act : acts) {
                if (act == null || StringUtils.isEmpty((String)act.getActionName())) continue;
                this.tableview.getItems().add((Object)new Script(act.getActionName(), act.show()));
                actstr = String.valueOf(actstr) + act.expr() + "\r\n";
            }
            this.textArea.setText(actstr);
            ObservableList items = this.tableview.getItems();
            if (!(items.size() <= 0 || StringUtils.isEmpty((String)(empty = (Script)items.get(items.size() - 1)).act) && StringUtils.isEmpty((String)empty.ele))) {
                this.tableview.getItems().add((Object)new Script("", ""));
            }
            this.tableview.visibleProperty().set(true);
            SingleTestCase.getInstance().setSaved(true);
        }
    }

    public boolean isScriptTextChanged() {
        String[] savelines;
        String currentText = this.textArea.getText();
        String[] lines = currentText.split("\n");
        if (lines.length != (savelines = SingleTestCase.getInstance().actionsToString().split("\n")).length) {
            return true;
        }
        int i = 0;
        while (i < lines.length) {
            if (savelines.length <= i || !lines[i].trim().equals(savelines[i].trim())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void updateTestCaseByScriptText() {
        ArrayList<TestAction> testActions = new ArrayList<TestAction>();
        String currentScript = this.textArea.getText();
        if (StringUtils.isNotEmpty((String)currentScript)) {
            String[] actions = currentScript.split("\n");
            int i = 0;
            while (i < actions.length) {
                TestAction act = TestAction.newInstance(actions[i]);
                if (StringUtils.isNotEmpty((String)actions[i]) && (act == null || !TestAction.isScriptValid(actions[i]))) {
                    log.info((Object)("Invalid line: " + actions[i]));
                } else if (act != null) {
                    testActions.add(act);
                }
                ++i;
            }
        }
        SingleTestCase.getInstance().removeAllAction();
        int i = 0;
        while (i < testActions.size()) {
            SingleTestCase.getInstance().addTestAction((TestAction)testActions.get(i));
            ++i;
        }
    }

    public String scanInvalidScriptLines() {
        String invalidLines = "";
        String currentScript = this.textArea.getText();
        if (StringUtils.isNotEmpty((String)currentScript)) {
            String[] actions = currentScript.split("\n");
            int i = 0;
            while (i < actions.length) {
                if (SingleTestCase.getInstance().getRecordStyle() == 0) {
                    TestAction act = TestAction.newInstance(actions[i]);
                    if (StringUtils.isNotEmpty((String)actions[i]) && (act == null || !TestAction.isScriptValid(actions[i]))) {
                        invalidLines = String.valueOf(invalidLines) + actions[i] + "\n";
                    }
                }
                ++i;
            }
        }
        return invalidLines;
    }

    @FXML
    private void scriptClick(MouseEvent event) {
        String invalidScriptLines = this.scanInvalidScriptLines();
        if (StringUtils.isNotEmpty((String)invalidScriptLines)) {
            DetailsDialog.show(Main.getInternationalString("editscriptshow.textscript.invalidscript"), invalidScriptLines);
            return;
        }
        if (this.isScriptTextChanged()) {
            log.info((Object)"Script has changed, need update.");
            if (SingleTestCase.getInstance() != null && SingleTestCase.getInstance().getRecordStyle() == 0) {
                this.updateTestCaseByScriptText();
            }
        }
        this.show();
        this.tableview.setVisible(true);
        this.textArea.setVisible(false);
        UIController.updateNodeSytleClass((Node)this.script, "tab-click");
        UIController.updateNodeSytleClass((Node)this.text, "tab-unclick");
    }

    @FXML
    private void textClick(MouseEvent event) {
        String invalidScriptLines = this.scanInvalidScriptLines();
        if (StringUtils.isNotEmpty((String)invalidScriptLines)) {
            DetailsDialog.show("\u68c0\u67e5\u6709\u811a\u672c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\uff0c\u8bf7\u67e5\u770b\u8be6\u7ec6\u5185\u5bb9", invalidScriptLines);
            return;
        }
        this.tableview.setVisible(false);
        this.textArea.setVisible(true);
        UIController.updateNodeSytleClass((Node)this.text, "tab-click");
        UIController.updateNodeSytleClass((Node)this.script, "tab-unclick");
    }

    @FXML
    public void leftClick(MouseEvent event) {
        if (event.getClickCount() > 1) {
            this.handleMenuItem("alter");
        } else {
            MouseButton button = event.getButton();
            switch (button) {
                case PRIMARY: {
                    this.hideContextMenu();
                    break;
                }
                case SECONDARY: {
                    break;
                }
            }
        }
    }

    @FXML
    public void sleepClick(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            if (this.isSingleCaseHaveName()) {
                this.handleMenuItem("sleep");
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.sleepbtn, "sleepbtnBkgEnter");
            } else {
                UIController.updateNodeSytleClass((Node)this.sleepbtn, "sleepbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_EXITED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.sleepbtn, "sleepbtnBkg");
            } else {
                UIController.updateNodeSytleClass((Node)this.sleepbtn, "sleepbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_PRESSED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.sleepbtn, "sleepbtnBkgPress");
            } else {
                UIController.updateNodeSytleClass((Node)this.sleepbtn, "sleepbtnBkgDisable");
            }
        }
    }

    @FXML
    public void shotClick(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            if (this.isSingleCaseHaveName()) {
                this.handleMenuItem("screenshot");
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.shotbtn, "shotbtnBkgEnter");
            } else {
                UIController.updateNodeSytleClass((Node)this.shotbtn, "shotbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_EXITED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.shotbtn, "shotbtnBkg");
            } else {
                UIController.updateNodeSytleClass((Node)this.shotbtn, "shotbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_PRESSED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.shotbtn, "shotbtnBkgPress");
            } else {
                UIController.updateNodeSytleClass((Node)this.shotbtn, "shotbtnBkgDisable");
            }
        }
    }

    @FXML
    public void stepClick(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            if (this.isSingleCaseHaveName()) {
                this.handleMenuItem("step");
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.descbtn, "descbtnBkgEnter");
            } else {
                UIController.updateNodeSytleClass((Node)this.descbtn, "descbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_EXITED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.descbtn, "descbtnBkg");
            } else {
                UIController.updateNodeSytleClass((Node)this.descbtn, "descbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_PRESSED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.descbtn, "descbtnBkgPress");
            } else {
                UIController.updateNodeSytleClass((Node)this.descbtn, "descbtnBkgDisable");
            }
        }
    }

    @FXML
    public void alterClick(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            if (this.isSingleCaseHaveName()) {
                this.handleMenuItem("alter");
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.editbtn, "editbtnBkgEnter");
            } else {
                UIController.updateNodeSytleClass((Node)this.editbtn, "editbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_EXITED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.editbtn, "editbtnBkg");
            } else {
                UIController.updateNodeSytleClass((Node)this.editbtn, "editbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_PRESSED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.editbtn, "editbtnBkgPress");
            } else {
                UIController.updateNodeSytleClass((Node)this.editbtn, "editbtnBkgDisable");
            }
        }
    }

    @FXML
    public void deleteClick(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            if (this.isSingleCaseHaveName()) {
                this.handleMenuItem("delete");
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.delbtn, "delbtnBkgEnter");
            } else {
                UIController.updateNodeSytleClass((Node)this.delbtn, "delbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_EXITED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.delbtn, "delbtnBkg");
            } else {
                UIController.updateNodeSytleClass((Node)this.delbtn, "delbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_PRESSED")) {
            if (this.isSingleCaseHaveName()) {
                UIController.updateNodeSytleClass((Node)this.delbtn, "delbtnBkgPress");
            } else {
                UIController.updateNodeSytleClass((Node)this.delbtn, "delbtnBkgDisable");
            }
        }
    }

    private void enableBottomButtonsStyle() {
        UIController.updateNodeSytleClass((Node)this.delbtn, "delbtnBkg");
        UIController.updateNodeSytleClass((Node)this.editbtn, "editbtnBkg");
        UIController.updateNodeSytleClass((Node)this.descbtn, "descbtnBkg");
        UIController.updateNodeSytleClass((Node)this.shotbtn, "shotbtnBkg");
        UIController.updateNodeSytleClass((Node)this.sleepbtn, "sleepbtnBkg");
    }

    private void disableBottomButtonsSytle() {
        UIController.updateNodeSytleClass((Node)this.delbtn, "delbtnBkgDisable");
        UIController.updateNodeSytleClass((Node)this.editbtn, "editbtnBkgDisable");
        UIController.updateNodeSytleClass((Node)this.descbtn, "descbtnBkgDisable");
        UIController.updateNodeSytleClass((Node)this.shotbtn, "shotbtnBkgDisable");
        UIController.updateNodeSytleClass((Node)this.sleepbtn, "sleepbtnBkgDisable");
    }

    private boolean isSingleCaseHaveName() {
        return SingleTestCase.getInstance().getName() != null;
    }

    private void hideContextMenu() {
        if (this.contextMenu.isShowing()) {
            this.contextMenu.hide();
        }
    }

    public void clearScriptTable() {
        if (this.tableview != null) {
            this.tableview.getItems().clear();
            this.tableview.scrollTo(0);
        }
        this.textArea.clear();
        this.scriptEdit.clear();
    }

    public class Script {
        private String act;
        private String ele;

        public Script(String id, String ele) {
            if (!id.equals(Main.getInternationalString("coordscriptshowcontroller.menuitem5")) && !id.equals("")) {
                id = "        " + id;
            }
            this.act = id;
            this.ele = ele;
        }

        public String getAct() {
            return this.act;
        }

        public void setAct(String act) {
            this.act = act;
        }

        public String getEle() {
            return this.ele;
        }

        public void setEle(String ele) {
            this.ele = ele;
        }
    }
}

