/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.include;

import com.testin.itestin.business.SingleTestCase;
import com.testin.itestin.business.recorder.RecorderListener;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.common.Constants;
import com.testin.itestin.device.DeviceInfo;
import com.testin.itestin.device.DevicesManager;
import com.testin.itestin.entitys.UserInfo;
import com.testin.itestin.os.Handler;
import com.testin.itestin.os.Message;
import com.testin.itestin.service.LoginService;
import com.testin.javafx.Main;
import com.testin.javafx.TestinStage;
import com.testin.javafx.ui.control.AlertDialog;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Cursor;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import org.apache.log4j.Logger;

public class TopController
extends AnchorPane
implements Initializable,
RecorderListener {
    static Logger log = Logger.getLogger(TopController.class);
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    @FXML
    AnchorPane includeTop;
    @FXML
    Label winTitle;
    @FXML
    ImageView winClose;
    @FXML
    ImageView winMin;
    @FXML
    Label deviceInfo;
    @FXML
    ImageView scriptRecord;
    @FXML
    ImageView scriptManage;
    @FXML
    ImageView scriptTest;
    @FXML
    ImageView phoneState;
    @FXML
    AnchorPane userInfoPane;
    @FXML
    Label userEmail;
    @FXML
    ImageView logoutImg;
    @FXML
    Label logoutLabel;
    private boolean isUserLogin;
    private DeviceInfo devInfo;
    private Handler handler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.getStatus()) {
                case 769: {
                    SingleTestCase.getInstance().setRecording(true);
                    break;
                }
                case 770: {
                    SingleTestCase.getInstance().setRecording(false);
                    break;
                }
                case 257: {
                    TopController.this.devInfo = (DeviceInfo)msg.getContent(DeviceInfo.class);
                    TopController.this.handleDeviceOnline(TopController.this.devInfo);
                    break;
                }
                case 258: {
                    TopController.this.devInfo = (DeviceInfo)msg.getContent(DeviceInfo.class);
                    TopController.this.handleDeviceOffline(TopController.this.devInfo);
                    break;
                }
                case 513: {
                    TopController.this.handleUserLogin(msg.getContent());
                    break;
                }
                case 514: {
                    TopController.this.handleUserLogout(msg.getContent());
                    break;
                }
            }
        }
    };

    public void initialize(URL location, ResourceBundle resources) {
        UIController.setTopHandler(this.handler);
        UIController.setTopController(this);
        this.userInfoPane.setVisible(false);
        this.winTitle.setText(String.format("iTestin - %s", Main.getInternationalString("itestin.slogan")));
        this.showPromptMsg("");
    }

    private void handleDeviceOnline(DeviceInfo deviceinfo) {
        String mobile = String.format("%s %s", deviceinfo.getBrandName(), deviceinfo.getModelName());
        String otherinfo = String.format("%s: %s\n%s: %s\n%s: %s", Main.getInternationalString("topcontroller.handledeviceonline.sdkver"), deviceinfo.getReleaseVer(), Main.getInternationalString("topcontroller.handledeviceonline.resolution"), deviceinfo.getPixel(), Main.getInternationalString("topcontroller.handledeviceonline.screen.proportion"), deviceinfo.getScreenProportion());
        this.deviceInfo.setText(mobile);
        this.deviceInfo.setTooltip(new Tooltip(otherinfo));
        String url = this.getClass().getResource("/com/testin/javafx/resources/deviceOnline.png").toExternalForm();
        this.phoneState.setImage(new Image(url));
    }

    private void handleDeviceOffline(DeviceInfo deviceinfo) {
        this.deviceInfo.setText(Main.getInternationalString("topcontroller.handledeviceoffline.nodevice"));
        String url = this.getClass().getResource("/com/testin/javafx/resources/deviceOffline.png").toExternalForm();
        this.phoneState.setImage(new Image(url));
    }

    private void handleUserLogin(String email) {
        this.userInfoPane.setVisible(true);
        this.userEmail.setText(email);
        this.isUserLogin = true;
        TestinStage.gotoRecordSet();
        this.changeImage(0);
    }

    private void handleUserLogout(String email) {
        this.userInfoPane.setVisible(false);
        this.isUserLogin = false;
    }

    @FXML
    private void topOnMouseDragged(MouseEvent event) {
        if (TestinStage.getPrimaryStage() == null) {
            return;
        }
        TestinStage.getPrimaryStage().setX(event.getScreenX() - this.mouseDragOffsetX);
        TestinStage.getPrimaryStage().setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    private void topOnMousePressed(MouseEvent event) {
        if (TestinStage.getPrimaryStage() == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void closeWindow(MouseEvent event) {
        TestinStage.getPrimaryStage().close();
        System.exit(0);
    }

    @FXML
    public void miniWindow(MouseEvent event) {
        TestinStage.getPrimaryStage().setIconified(!TestinStage.getPrimaryStage().isIconified());
    }

    @FXML
    public void miniWindowEnter(MouseEvent event) {
        String url = this.getClass().getResource("/com/testin/javafx/resources/mini_enter.png").toExternalForm();
        this.winMin.setImage(new Image(url));
    }

    @FXML
    public void miniWindowPress(MouseEvent event) {
        String url = this.getClass().getResource("/com/testin/javafx/resources/mini_press.png").toExternalForm();
        this.winMin.setImage(new Image(url));
    }

    @FXML
    public void miniWindowExit(MouseEvent event) {
        String url = this.getClass().getResource("/com/testin/javafx/resources/mini.png").toExternalForm();
        this.winMin.setImage(new Image(url));
    }

    @FXML
    public void closeEnter(MouseEvent event) {
        String url = this.getClass().getResource("/com/testin/javafx/resources/close_enter.png").toExternalForm();
        this.winClose.setImage(new Image(url));
    }

    @FXML
    public void closePress(MouseEvent event) {
        String url = this.getClass().getResource("/com/testin/javafx/resources/close_press.png").toExternalForm();
        this.winClose.setImage(new Image(url));
    }

    @FXML
    public void closeExit(MouseEvent event) {
        String url = this.getClass().getResource("/com/testin/javafx/resources/close.png").toExternalForm();
        this.winClose.setImage(new Image(url));
    }

    private void changeImage(int index) {
        if (index == 0) {
            String img1 = this.getClass().getResource("/com/testin/javafx/resources/recordCheck.png").toExternalForm();
            this.scriptRecord.setImage(new Image(img1));
            this.scriptRecord.setY(1.0);
            String img2 = this.getClass().getResource("/com/testin/javafx/resources/scriptManage.png").toExternalForm();
            this.scriptManage.setImage(new Image(img2));
            this.scriptManage.setY(1.0);
            String img3 = this.getClass().getResource("/com/testin/javafx/resources/cloud.png").toExternalForm();
            this.scriptTest.setImage(new Image(img3));
            this.scriptTest.setY(1.0);
        } else if (index == 1) {
            String img1 = this.getClass().getResource("/com/testin/javafx/resources/record.png").toExternalForm();
            this.scriptRecord.setImage(new Image(img1));
            this.scriptRecord.setY(1.0);
            String img2 = this.getClass().getResource("/com/testin/javafx/resources/scriptManageCheck.png").toExternalForm();
            this.scriptManage.setImage(new Image(img2));
            this.scriptManage.setY(1.0);
            String img3 = this.getClass().getResource("/com/testin/javafx/resources/cloud.png").toExternalForm();
            this.scriptTest.setImage(new Image(img3));
            this.scriptTest.setY(1.0);
        } else if (index == 2) {
            String img1 = this.getClass().getResource("/com/testin/javafx/resources/record.png").toExternalForm();
            this.scriptRecord.setImage(new Image(img1));
            this.scriptRecord.setY(1.0);
            String img2 = this.getClass().getResource("/com/testin/javafx/resources/scriptManage.png").toExternalForm();
            this.scriptManage.setImage(new Image(img2));
            this.scriptManage.setY(1.0);
            String img3 = this.getClass().getResource("/com/testin/javafx/resources/cloudTest.png").toExternalForm();
            this.scriptTest.setImage(new Image(img3));
            this.scriptTest.setY(1.0);
        }
    }

    @FXML
    public void gotoRecord(MouseEvent event) {
        boolean noWorking;
        DeviceInfo di = DevicesManager.getDevice();
        boolean bl = noWorking = di == null || di.getState() != 1;
        if (this.isUserLogin && noWorking) {
            TestinStage.gotoRecordSet();
            this.changeImage(0);
        }
    }

    @FXML
    public void gotoScriptManege(MouseEvent event) {
        boolean noWorking;
        DeviceInfo di = DevicesManager.getDevice();
        boolean bl = noWorking = di == null || di.getState() != 1;
        if (this.isUserLogin && noWorking) {
            TestinStage.gotoScriptTilesManage();
            this.changeImage(1);
        }
    }

    @FXML
    public void gotoTestCloud(MouseEvent event) {
        boolean noWorking;
        LoginService loginService = LoginService.getInstance();
        UserInfo user = loginService.getDefaultUser();
        String email = user.getEmail();
        String pwd = user.getPassword();
        DeviceInfo di = DevicesManager.getDevice();
        boolean bl = noWorking = di == null || di.getState() != 1;
        if (this.isUserLogin && noWorking) {
            if (email.equals(Constants.TEST_USER_NAME) && pwd.equals(Constants.TEST_USER_PASSWORD)) {
                AlertDialog.show(AlertDialog.DialogOptions.WARN, Main.getInternationalString("scriptmanagecontroller.submit.testaccount"));
            } else {
                TestinStage.gotoCloudTest();
                this.changeImage(2);
            }
        }
    }

    @FXML
    public void clickLogout(MouseEvent event) {
        boolean noWorking;
        DeviceInfo di = DevicesManager.getDevice();
        boolean bl = noWorking = di == null || di.getState() != 1;
        if (noWorking) {
            this.handleUserLogout(null);
            TestinStage.gotoLogin();
        }
    }

    @FXML
    public void LogoutEnter(MouseEvent event) {
        this.logoutLabel.setCursor(Cursor.HAND);
    }

    @Override
    public void recorderStart() {
    }

    @Override
    public void recorderStop() {
    }

    @Override
    public void showPromptMsg(String msg) {
    }
}

