/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.update;

import com.testin.itestin.os.Handler;
import com.testin.itestin.os.Message;
import com.testin.itestin.threadpool.ThreadPool;
import com.testin.itestin.util.Utils;
import com.testin.javafx.Main;
import com.testin.javafx.TestinStage;
import com.testin.javafx.update.Updater;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import org.apache.log4j.Logger;

public class UpdateController
extends AnchorPane
implements Initializable,
Updater.UpdaterListener {
    static Logger log = Logger.getLogger(UpdateController.class);
    @FXML
    private ProgressBar progressBar;
    @FXML
    Label label;
    @FXML
    Label downLab;
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    Handler handler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.getStatus()) {
                case 1: {
                    UpdateController.this.fileInfo(msg.getContent(), msg.getArg1(), msg.getArg2());
                    break;
                }
                case 2: {
                    UpdateController.this.processInfo(msg.getArg1(), msg.getArg2());
                    break;
                }
                case 3: {
                    UpdateController.this.hidenWindow();
                    break;
                }
                case 4: {
                    UpdateController.this.closeWindow();
                    break;
                }
                case 5: {
                    UpdateController.this.setUpdateStatus();
                }
            }
        }
    };

    private void fileInfo(String fn, int fileCount, int fileIndex) {
        this.progressBar.setProgress(0.0);
        String info = String.format(" (%s/%s)", fileIndex, fileCount);
        this.downLab.setText(info);
    }

    private void setUpdateStatus() {
        this.label.setText(Main.getInternationalString("updatecontroller.setUpdateStatus.text"));
    }

    private void processInfo(long length, long transferred) {
        if (length > 0L) {
            double d = (double)transferred / (double)length;
            this.progressBar.setProgress(d);
        }
    }

    private void hidenWindow() {
        this.setVisible(false);
        this.label.setText(Main.getInternationalString("updatecontroller.processInfo.text"));
        this.downLab.setVisible(false);
    }

    private void closeWindow() {
        TestinStage.getPrimaryStage().close();
        System.exit(0);
    }

    @FXML
    public void updateOnMouseDragged(MouseEvent event) {
        if (TestinStage.getPrimaryStage() == null) {
            return;
        }
        TestinStage.getPrimaryStage().setX(event.getScreenX() - this.mouseDragOffsetX);
        TestinStage.getPrimaryStage().setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void updateOnMousePressed(MouseEvent event) {
        if (TestinStage.getPrimaryStage() == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.downLab.setVisible(true);
    }

    @FXML
    public void miniWindow(MouseEvent event) {
        TestinStage.getPrimaryStage().setIconified(!TestinStage.getPrimaryStage().isIconified());
    }

    @FXML
    public void updateCloseWindow(MouseEvent event) {
        this.exitWindow();
    }

    public void update() {
        Updater.getInstance().setUpdaterListener(this);
        Thread t = new Thread("Updater"){

            @Override
            public void run() {
                try {
                    try {
                        Utils.sleep(2000L);
                        boolean res = Updater.getInstance().update();
                        if (res) {
                            UpdateController.this.hidenUpdate();
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        UpdateController.this.exitWindow();
                        Utils.gc();
                    }
                }
                finally {
                    Utils.gc();
                }
            }
        };
        ThreadPool.execute(t);
    }

    private void hidenUpdate() {
        Message msg = new Message();
        msg.setStatus(3);
        this.handler.sendMessage(msg);
    }

    private void exitWindow() {
        Message msg = new Message();
        msg.setStatus(4);
        this.handler.sendMessage(msg);
    }

    @Override
    public void download(String fn, int fileCount, int fileIndex) {
        Message msg = new Message();
        msg.setStatus(1);
        msg.setContent(fn);
        msg.setArg1(fileCount);
        msg.setArg2(fileIndex);
        this.handler.sendMessage(msg);
    }

    @Override
    public void transferred(long length, long transferred) {
        Message msg = new Message();
        msg.setStatus(2);
        msg.setArg1((int)length);
        msg.setArg2((int)transferred);
        this.handler.sendMessage(msg);
    }

    @Override
    public void updateError() {
        Message msg = new Message();
        msg.setStatus(5);
        this.handler.sendMessage(msg);
    }
}

