/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.update;

import com.testin.itestin.common.Proxy;
import com.testin.javafx.update.DlFile;
import com.testin.javafx.update.OnDlStateChangeListener;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.log4j.Logger;

public class HttpDownloader {
    static Logger log = Logger.getLogger(HttpDownloader.class);
    static final int TIMEOUT = 300000;

    public static DlFile download(String url, String local, OnDlStateChangeListener onDlStateChangeListener) {
        DlFile dlFile;
        int state;
        int transferred;
        int contentLength;
        int statusCode;
        block29: {
            statusCode = 0;
            contentLength = 0;
            transferred = 0;
            state = 0;
            HttpDownloader.notifyAllListeners(onDlStateChangeListener, state, contentLength, transferred);
            dlFile = new DlFile();
            dlFile.setUrl(url);
            dlFile.setLocal(local);
            HttpURLConnection httpConn = null;
            FileOutputStream fos = null;
            BufferedInputStream in = null;
            try {
                try {
                    state = 1;
                    Proxy.setProxy();
                    URL uri = new URL(url);
                    httpConn = (HttpURLConnection)uri.openConnection();
                    httpConn.setConnectTimeout(300000);
                    httpConn.setReadTimeout(300000);
                    httpConn.setRequestMethod("GET");
                    httpConn.connect();
                    statusCode = httpConn.getResponseCode();
                    contentLength = httpConn.getContentLength();
                    HttpDownloader.notifyAllListeners(onDlStateChangeListener, state, contentLength, transferred);
                    transferred = 0;
                    if (statusCode == 200) {
                        in = new BufferedInputStream(httpConn.getInputStream());
                        fos = new FileOutputStream(local);
                        byte[] buff = new byte[4096];
                        int size = 0;
                        while ((size = in.read(buff)) != -1) {
                            fos.write(buff, 0, size);
                            HttpDownloader.notifyAllListeners(onDlStateChangeListener, state, contentLength, transferred += size);
                        }
                        in.close();
                        fos.close();
                        in = null;
                        fos = null;
                        state = 2;
                    } else {
                        state = -2;
                        dlFile.setErrorMsg("\u4e0b\u8f7d\u5931\u8d25,\u72b6\u6001\u7801\u9519\u8bef");
                    }
                    httpConn.disconnect();
                    httpConn = null;
                }
                catch (IOException ex) {
                    state = -1;
                    dlFile.setErrorMsg("\u4e0b\u8f7d\u5931\u8d25,\u670d\u52a1\u5668\u9519\u8bef");
                    dlFile.setStacktrace(HttpDownloader.getErrorInfo(ex));
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    if (httpConn != null) {
                        httpConn.disconnect();
                    }
                    break block29;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (httpConn != null) {
                    httpConn.disconnect();
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (httpConn != null) {
                httpConn.disconnect();
            }
        }
        HttpDownloader.notifyAllListeners(onDlStateChangeListener, state, contentLength, transferred);
        dlFile.setStatusCode(statusCode);
        dlFile.setState(state);
        dlFile.setMd5("");
        return dlFile;
    }

    private static String getErrorInfo(Throwable arg1) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        arg1.printStackTrace(pw);
        pw.close();
        String error = ((Object)writer).toString();
        return error;
    }

    private static void notifyAllListeners(OnDlStateChangeListener listener, int state, int contentLength, int transferred) {
        if (listener != null) {
            listener.onDlStateChange(state, contentLength, transferred);
        }
    }
}

