/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.update;

import com.testin.javafx.update.DlFile;
import com.testin.javafx.update.FileUtils;
import com.testin.javafx.update.HttpDownloader;
import com.testin.javafx.update.LocalFile;
import com.testin.javafx.update.LocalXml;
import com.testin.javafx.update.OnDlStateChangeListener;
import com.testin.javafx.update.RemoteFile;
import com.testin.javafx.update.RemoteXml;
import com.testin.javafx.update.UpdateConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UpdateChecker
implements OnDlStateChangeListener {
    static Logger log = Logger.getLogger(UpdateChecker.class);
    private String remoteXmlPath = String.valueOf(UpdateConfig.getTempDir()) + File.separator + "mClient.xml";
    private RemoteXml remoteXml;
    private String localXmlPath = UpdateConfig.getClientDat();
    private LocalXml localXml;
    private List<RemoteFile> updateFiles;
    private static List<RemoteFile> discardFiles;
    private static String localXmlPublish;

    public UpdateChecker() {
        this.remoteXml = new RemoteXml();
        this.localXml = new LocalXml();
        this.updateFiles = new ArrayList<RemoteFile>();
    }

    public String getPublishInfo() {
        return localXmlPublish;
    }

    public String getRemoteXmlPath() {
        return this.remoteXmlPath;
    }

    public static List<RemoteFile> getDiscardFiles() {
        return discardFiles;
    }

    public RemoteXml getRemoteXml() {
        return this.remoteXml;
    }

    public String getLocalXmlPath() {
        return this.localXmlPath;
    }

    public LocalXml getLocalXml() {
        return this.localXml;
    }

    public List<RemoteFile> getUpdateFiles() {
        return this.updateFiles;
    }

    public boolean isNeedUpdate() {
        try {
            log.info((Object)"Check if updates are available.");
            File tmpDir = new File(UpdateConfig.getTempDir());
            FileUtils.deleteDir(tmpDir);
            tmpDir.mkdirs();
            File logf = new File(UpdateConfig.getUpdateLog());
            logf.delete();
            DlFile dlFile = this.downloadRemoteXml();
            if (dlFile.getState() == 2) {
                this.parseRemoteXml();
                this.parseLocalXml();
                this.parseUpdateFile();
                this.parseDiscardFile();
            } else {
                log.error((Object)"\u68c0\u67e5\u66f4\u65b0\u5931\u8d25!");
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return this.updateFiles.size() > 0;
    }

    private DlFile downloadRemoteXml() {
        log.info((Object)String.format("Download remote xml %s", this.remoteXmlPath));
        DlFile dlFile = HttpDownloader.download(UpdateConfig.getServerUrl(), this.remoteXmlPath, this);
        log.info((Object)String.format("Download remote xml finished. Status %d", dlFile.getStatusCode()));
        return dlFile;
    }

    public void parseRemoteXml() throws ParserConfigurationException, SAXException, IOException {
        Node node;
        String value;
        File xmlPath = new File(this.remoteXmlPath);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document doc = builder.parse(xmlPath);
        Element root = doc.getDocumentElement();
        NodeList el = root.getElementsByTagName("version");
        if (el.getLength() > 0 && (value = (node = el.item(0)).getTextContent()) != null) {
            this.remoteXml.setVersion(value.trim());
        }
        if ((el = root.getElementsByTagName("publishInfo")).getLength() > 0 && (value = (node = el.item(0)).getTextContent()) != null) {
            this.remoteXml.setPublishInfo(value.trim());
        }
        if ((el = root.getElementsByTagName("publishTime")).getLength() > 0 && (value = (node = el.item(0)).getTextContent()) != null) {
            this.remoteXml.setPublishTime(value.trim());
        }
        ArrayList<RemoteFile> remoteFiles = new ArrayList<RemoteFile>();
        this.remoteXml.setRemoteFiles(remoteFiles);
        NodeList el_files = root.getElementsByTagName("file");
        int i = 0;
        while (i < el_files.getLength()) {
            RemoteFile remoteFile = new RemoteFile();
            remoteFiles.add(remoteFile);
            Node fileNode = el_files.item(i);
            NamedNodeMap attrs = fileNode.getAttributes();
            int j = 0;
            while (j < attrs.getLength()) {
                Node node2 = attrs.item(j);
                String key = node2.getNodeName();
                if (key != null) {
                    String value2;
                    if (key.equals("lastver")) {
                        value2 = node2.getNodeValue();
                        if (value2 != null) {
                            remoteFile.setLastver(value2.trim());
                        }
                    } else if (key.equals("path")) {
                        value2 = node2.getNodeValue();
                        if (value2 != null) {
                            remoteFile.setPath(value2.trim());
                        }
                    } else if (key.equals("url")) {
                        value2 = node2.getNodeValue();
                        if (value2 != null) {
                            remoteFile.setUrl(value2.trim());
                        }
                    } else if (key.equals("size")) {
                        try {
                            value2 = node2.getNodeValue();
                            if (value2 != null) {
                                int size = Integer.parseInt(value2.trim());
                                remoteFile.setSize(size);
                            }
                        }
                        catch (Exception ex) {
                            log.error((Object)ex.getMessage(), (Throwable)ex);
                        }
                    } else if (key.equals("needRestart")) {
                        try {
                            value2 = node2.getNodeValue();
                            if (value2 != null) {
                                boolean needRestart = Boolean.parseBoolean(value2.trim());
                                remoteFile.setNeedRestart(needRestart);
                            }
                        }
                        catch (Exception ex) {
                            log.error((Object)ex.getMessage(), (Throwable)ex);
                        }
                    } else if (key.equals("needDiscard")) {
                        try {
                            value2 = node2.getNodeValue();
                            if (value2 != null) {
                                boolean needDiscard = Boolean.parseBoolean(value2.trim());
                                remoteFile.setNeedDiscard(needDiscard);
                            }
                        }
                        catch (Exception ex) {
                            log.error((Object)ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public String getRemotePublishInfo() {
        try {
            return this.remoteXml.getPublishInfo();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public void parseLocalXml() {
        block22: {
            try {
                Node node;
                String value;
                File f = new File(this.localXmlPath);
                if (!f.exists()) break block22;
                File xmlPath = new File(this.localXmlPath);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = dbf.newDocumentBuilder();
                Document doc = builder.parse(xmlPath);
                Element root = doc.getDocumentElement();
                NodeList el = root.getElementsByTagName("Enabled");
                try {
                    if (el.getLength() > 0 && (value = (node = el.item(0)).getTextContent()) != null) {
                        this.localXml.setEnabled(Boolean.parseBoolean(value.trim()));
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                if ((el = root.getElementsByTagName("ServerUrl")).getLength() > 0 && (value = (node = el.item(0)).getTextContent()) != null) {
                    this.localXml.setServerUrl(value.trim());
                }
                if ((el = root.getElementsByTagName("version")).getLength() > 0 && (value = (node = el.item(0)).getTextContent()) != null) {
                    this.localXml.setVersion(value.trim());
                }
                if ((el = root.getElementsByTagName("PublishInfo")).getLength() > 0 && (value = (node = el.item(0)).getTextContent()) != null) {
                    this.localXml.setPublishInfo(value.trim());
                    localXmlPublish = value.trim();
                }
                if ((el = root.getElementsByTagName("publishTime")).getLength() > 0 && (value = (node = el.item(0)).getTextContent()) != null) {
                    this.localXml.setPublishTime(value.trim());
                }
                ArrayList<LocalFile> localFiles = new ArrayList<LocalFile>();
                this.localXml.setLocalFiles(localFiles);
                NodeList el_files = root.getElementsByTagName("LocalFile");
                int i = 0;
                while (i < el_files.getLength()) {
                    LocalFile localFile = new LocalFile();
                    localFiles.add(localFile);
                    Node fileNode = el_files.item(i);
                    NamedNodeMap attrs = fileNode.getAttributes();
                    int j = 0;
                    while (j < attrs.getLength()) {
                        Node node2 = attrs.item(j);
                        String key = node2.getNodeName();
                        if (key != null) {
                            String value2;
                            if (key.equals("lastver")) {
                                value2 = node2.getNodeValue();
                                if (value2 != null) {
                                    localFile.setLastver(value2.trim());
                                }
                            } else if (key.equals("path")) {
                                value2 = node2.getNodeValue();
                                if (value2 != null) {
                                    localFile.setPath(value2.trim());
                                }
                            } else if (key.equals("size")) {
                                try {
                                    value2 = node2.getNodeValue();
                                    if (value2 != null) {
                                        int size = Integer.parseInt(value2.trim());
                                        localFile.setSize(size);
                                    }
                                }
                                catch (Exception e) {
                                    log.error((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void parseUpdateFile() {
        List<RemoteFile> remoteFiles = this.remoteXml.getRemoteFiles();
        List<LocalFile> localFiles = this.localXml.getLocalFiles();
        if (remoteFiles != null) {
            for (RemoteFile rf : remoteFiles) {
                LocalFile lfcfg = null;
                if (localFiles != null) {
                    for (LocalFile lf : localFiles) {
                        if (!rf.getPath().equals(lf.getPath())) continue;
                        lfcfg = lf;
                        break;
                    }
                }
                if (lfcfg == null) {
                    this.updateFiles.add(rf);
                    continue;
                }
                if (this.compareVersion(rf.getLastver(), lfcfg.getLastver()) <= 0) continue;
                this.updateFiles.add(rf);
            }
        }
    }

    private List<RemoteFile> parseDiscardFile() {
        discardFiles = new ArrayList<RemoteFile>();
        List<RemoteFile> remoteFiles = this.remoteXml.getRemoteFiles();
        if (remoteFiles != null) {
            for (RemoteFile rf : remoteFiles) {
                if (!rf.isNeedDiscard()) continue;
                discardFiles.add(rf);
            }
        }
        return discardFiles;
    }

    private int compareVersion(String v1, String v2) {
        int len2;
        int len1;
        String[] var1 = v1.split("\\.");
        String[] var2 = v2.split("\\.");
        int i = len1 = var1.length;
        while (i < 10) {
            String[] dest = new String[var1.length + 1];
            System.arraycopy(var1, 0, dest, 0, var1.length);
            dest[var1.length] = "0";
            var1 = dest;
            ++i;
        }
        int i2 = len2 = var2.length;
        while (i2 < 10) {
            String[] dest = new String[var2.length + 1];
            System.arraycopy(var2, 0, dest, 0, var2.length);
            dest[var2.length] = "0";
            var2 = dest;
            ++i2;
        }
        i2 = 0;
        while (i2 < var1.length) {
            int num2;
            int num1 = Integer.parseInt(var1[i2]);
            if (num1 > (num2 = Integer.parseInt(var2[i2]))) {
                return 1;
            }
            if (num1 < num2) {
                return -1;
            }
            if (num1 == num2) {
                // empty if block
            }
            ++i2;
        }
        return 0;
    }

    @Override
    public void onDlStateChange(int state, int length, int transferred) {
    }
}

