/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.update;

import com.testin.javafx.update.DlFile;
import com.testin.javafx.update.FileUtils;
import com.testin.javafx.update.HttpDownloader;
import com.testin.javafx.update.OnDlStateChangeListener;
import com.testin.javafx.update.RemoteFile;
import com.testin.javafx.update.RemoteXml;
import com.testin.javafx.update.UpdateChecker;
import com.testin.javafx.update.UpdateConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class Updater
implements OnDlStateChangeListener {
    static Logger log = Logger.getLogger(Updater.class);
    private static Updater update = new Updater();
    private UpdaterListener updaterListener;
    private UpdateChecker updateChecker = new UpdateChecker();
    private List<DlFile> dlFiles = new ArrayList<DlFile>();
    private List<String> backupFiles = new ArrayList<String>();

    private Updater() {
    }

    public static Updater getInstance() {
        return update;
    }

    public void setUpdaterListener(UpdaterListener updaterListener) {
        this.updaterListener = updaterListener;
    }

    public boolean isUpdateNeeded() {
        return this.updateChecker.isNeedUpdate();
    }

    public boolean update() {
        boolean res = false;
        try {
            res = this.downloadFiles();
            if (res) {
                this.backupFiles();
                this.delDiscardFile();
                res = this.copyFiles();
                if (res) {
                    this.updateLocalXml();
                    res = true;
                } else {
                    this.rollbackFiles();
                }
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return res;
    }

    private void delDiscardFile() {
        try {
            List<RemoteFile> discardFiles = UpdateChecker.getDiscardFiles();
            for (RemoteFile rf : discardFiles) {
                String path = rf.getPath().replace(" ", "");
                String src = String.valueOf(UpdateConfig.getApplicationPath()) + File.separator + path;
                File srcF = new File(src);
                if (!srcF.exists()) continue;
                srcF.delete();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private boolean downloadFiles() {
        List<RemoteFile> updateFiles = this.updateChecker.getUpdateFiles();
        int fileCount = updateFiles.size();
        int i = 0;
        while (i < fileCount) {
            RemoteFile rf = updateFiles.get(i);
            String local = String.valueOf(UpdateConfig.getTempDir()) + File.separator + rf.getPath();
            File fn = new File(local);
            fn.getParentFile().mkdirs();
            if (this.updaterListener != null) {
                this.updaterListener.download(fn.getName(), fileCount, i + 1);
            }
            if (rf.isNeedDiscard()) {
                this.onDlStateChange(1, 1, 1);
            } else {
                DlFile dlFile = HttpDownloader.download(rf.getUrl(), local, this);
                if (dlFile.getState() == 2) {
                    this.dlFiles.add(dlFile);
                } else {
                    String msg = String.format("%s\u66f4\u65b0\u5931\u8d25!", fn.getName());
                    log.info((Object)msg);
                    if (this.updaterListener != null) {
                        this.updaterListener.updateError();
                    }
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private void backupFiles() throws IOException {
        File srcF;
        String dest;
        String src;
        String path;
        File bkDir = new File(UpdateConfig.getBackupDir());
        FileUtils.deleteDir(bkDir);
        bkDir.mkdirs();
        for (DlFile df : this.dlFiles) {
            String local = df.getLocal();
            path = local.replace(UpdateConfig.getTempDir(), "");
            src = String.valueOf(UpdateConfig.getApplicationPath()) + File.separator + path;
            dest = String.valueOf(UpdateConfig.getBackupDir()) + File.separator + path;
            srcF = new File(src);
            if (!srcF.exists()) continue;
            this.copyFile(srcF, new File(dest));
        }
        List<RemoteFile> discardFiles = UpdateChecker.getDiscardFiles();
        for (RemoteFile rf : discardFiles) {
            path = rf.getPath().replace(" ", "");
            src = String.valueOf(UpdateConfig.getApplicationPath()) + File.separator + path;
            dest = String.valueOf(UpdateConfig.getBackupDir()) + File.separator + path;
            srcF = new File(src);
            if (!srcF.exists()) continue;
            this.copyFile(srcF, new File(dest));
        }
    }

    private boolean copyFiles() {
        boolean res = false;
        try {
            File srcF;
            String path;
            for (DlFile df : this.dlFiles) {
                String local = df.getLocal();
                path = local.replace(UpdateConfig.getTempDir(), "");
                String dest = String.valueOf(UpdateConfig.getApplicationPath()) + File.separator + path;
                srcF = new File(local);
                this.backupFiles.add(local);
                this.copyFile(srcF, new File(dest));
            }
            List<RemoteFile> discardFiles = UpdateChecker.getDiscardFiles();
            for (RemoteFile rf : discardFiles) {
                path = rf.getPath().replace(" ", "");
                String src = String.valueOf(UpdateConfig.getApplicationPath()) + File.separator + path;
                srcF = new File(src);
                if (!srcF.exists()) continue;
                srcF.delete();
            }
            res = true;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return res;
    }

    private void rollbackFiles() throws IOException {
        Iterator<String> iterator = this.backupFiles.iterator();
        while (iterator.hasNext()) {
            String str;
            String src = str = iterator.next();
            String path = src.replace(UpdateConfig.getTempDir(), "");
            String dest = String.valueOf(UpdateConfig.getApplicationPath()) + File.separator + path;
            File srcF = new File(src);
            if (!srcF.exists()) continue;
            this.copyFile(srcF, new File(dest));
        }
    }

    private void updateLocalXml() throws IOException {
        RemoteXml remoteXml = this.updateChecker.getRemoteXml();
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        xml.append("<Config xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\r\n");
        xml.append("<Enabled>true</Enabled>\r\n");
        xml.append(String.format("<ServerUrl>%s</ServerUrl>\r\n", UpdateConfig.getServerUrl()));
        xml.append(String.format("<publishTime>%s</publishTime>\r\n", remoteXml.getPublishTime()));
        xml.append(String.format("<version>%s</version>\r\n", remoteXml.getVersion()));
        xml.append(String.format("<PublishInfo>%s</PublishInfo>\r\n", remoteXml.getPublishInfo()));
        xml.append("<UpdateFileList>\r\n");
        for (RemoteFile rf : remoteXml.getRemoteFiles()) {
            String str = "<LocalFile path=\"%s\" lastver=\"%s\" size=\"%s\" />\r\n";
            str = String.format(str, rf.getPath(), rf.getLastver(), rf.getSize());
            xml.append(str);
        }
        xml.append("</UpdateFileList>\r\n");
        xml.append("</Config>\r\n");
        this.saveLocalXml(xml.toString());
    }

    private void saveLocalXml(String xml) throws IOException {
        String localXmlPath = UpdateConfig.getClientDat();
        File f = new File(localXmlPath);
        f.delete();
        byte[] buff = xml.getBytes("utf-8");
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(f);
            fos.write(buff);
            fos.flush();
            fos.close();
            fos = null;
        }
    }

    public void copyFile(File tmp, File destFile) throws IOException {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            File dir = destFile.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            in = new FileInputStream(tmp);
            out = new FileOutputStream(destFile);
            int byteread = 0;
            byte[] buffer = new byte[2048];
            while ((byteread = in.read(buffer)) != -1) {
                out.write(buffer, 0, byteread);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void onDlStateChange(int state, int length, int transferred) {
        if (this.updaterListener != null) {
            this.updaterListener.transferred(length, transferred);
        }
    }

    public static interface UpdaterListener {
        public void download(String var1, int var2, int var3);

        public void transferred(long var1, long var3);

        public void updateError();
    }
}

