/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Device;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.log.LogReceiver;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;

final class AdbHelper {
    static final int WAIT_TIME = 5;
    static final String DEFAULT_ENCODING = "ISO-8859-1";

    private AdbHelper() {
    }

    public static SocketChannel open(InetSocketAddress adbSockAddr, Device device, int devicePort) throws IOException, TimeoutException, AdbCommandRejectedException {
        SocketChannel adbChan = SocketChannel.open(adbSockAddr);
        try {
            adbChan.socket().setTcpNoDelay(true);
            adbChan.configureBlocking(false);
            AdbHelper.setDevice(adbChan, device);
            byte[] req = AdbHelper.createAdbForwardRequest(null, devicePort);
            AdbHelper.write(adbChan, req);
            AdbResponse resp = AdbHelper.readAdbResponse(adbChan, false);
            if (!resp.okay) {
                throw new AdbCommandRejectedException(resp.message);
            }
            adbChan.configureBlocking(true);
        }
        catch (TimeoutException e) {
            adbChan.close();
            throw e;
        }
        catch (IOException e) {
            adbChan.close();
            throw e;
        }
        return adbChan;
    }

    public static SocketChannel createPassThroughConnection(InetSocketAddress adbSockAddr, Device device, int pid) throws TimeoutException, AdbCommandRejectedException, IOException {
        SocketChannel adbChan = SocketChannel.open(adbSockAddr);
        try {
            adbChan.socket().setTcpNoDelay(true);
            adbChan.configureBlocking(false);
            AdbHelper.setDevice(adbChan, device);
            byte[] req = AdbHelper.createJdwpForwardRequest(pid);
            AdbHelper.write(adbChan, req);
            AdbResponse resp = AdbHelper.readAdbResponse(adbChan, false);
            if (!resp.okay) {
                throw new AdbCommandRejectedException(resp.message);
            }
            adbChan.configureBlocking(true);
        }
        catch (TimeoutException e) {
            adbChan.close();
            throw e;
        }
        catch (IOException e) {
            adbChan.close();
            throw e;
        }
        return adbChan;
    }

    private static byte[] createAdbForwardRequest(String addrStr, int port) {
        String reqStr = addrStr == null ? "tcp:" + port : "tcp:" + port + ":" + addrStr;
        return AdbHelper.formAdbRequest(reqStr);
    }

    private static byte[] createJdwpForwardRequest(int pid) {
        String reqStr = String.format("jdwp:%1$d", pid);
        return AdbHelper.formAdbRequest(reqStr);
    }

    static byte[] formAdbRequest(String req) {
        byte[] result;
        String resultStr = String.format("%04X%s", req.length(), req);
        try {
            result = resultStr.getBytes(DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            return null;
        }
        assert (result.length == req.length() + 4);
        return result;
    }

    static AdbResponse readAdbResponse(SocketChannel chan, boolean readDiagString) throws TimeoutException, IOException {
        AdbResponse resp;
        block6: {
            resp = new AdbResponse();
            byte[] reply = new byte[4];
            AdbHelper.read(chan, reply);
            if (AdbHelper.isOkay(reply)) {
                resp.okay = true;
            } else {
                readDiagString = true;
                resp.okay = false;
            }
            try {
                int len;
                if (!readDiagString) break block6;
                byte[] lenBuf = new byte[4];
                AdbHelper.read(chan, lenBuf);
                String lenStr = AdbHelper.replyToString(lenBuf);
                try {
                    len = Integer.parseInt(lenStr, 16);
                }
                catch (NumberFormatException nfe) {
                    Log.w("ddms", "Expected digits, got '" + lenStr + "': " + lenBuf[0] + " " + lenBuf[1] + " " + lenBuf[2] + " " + lenBuf[3]);
                    Log.w("ddms", "reply was " + AdbHelper.replyToString(reply));
                    break block6;
                }
                byte[] msg = new byte[len];
                AdbHelper.read(chan, msg);
                resp.message = AdbHelper.replyToString(msg);
                Log.v("ddms", "Got reply '" + AdbHelper.replyToString(reply) + "', diag='" + resp.message + "'");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resp;
    }

    static RawImage getFrameBuffer(InetSocketAddress adbSockAddr, Device device) throws TimeoutException, AdbCommandRejectedException, IOException {
        RawImage imageParams = new RawImage();
        byte[] request = AdbHelper.formAdbRequest("framebuffer:");
        byte[] nudge = new byte[1];
        SocketChannel adbChan = null;
        try {
            adbChan = SocketChannel.open(adbSockAddr);
            adbChan.configureBlocking(false);
            AdbHelper.setDevice(adbChan, device);
            AdbHelper.write(adbChan, request);
            AdbResponse resp = AdbHelper.readAdbResponse(adbChan, false);
            if (!resp.okay) {
                throw new AdbCommandRejectedException(resp.message);
            }
            byte[] reply = new byte[4];
            AdbHelper.read(adbChan, reply);
            ByteBuffer buf = ByteBuffer.wrap(reply);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            int version = buf.getInt();
            int headerSize = RawImage.getHeaderSize(version);
            reply = new byte[headerSize * 4];
            AdbHelper.read(adbChan, reply);
            buf = ByteBuffer.wrap(reply);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            if (!imageParams.readHeader(version, buf)) {
                Log.e("Screenshot", "Unsupported protocol: " + version);
                return null;
            }
            Log.d("ddms", "image params: bpp=" + imageParams.bpp + ", size=" + imageParams.size + ", width=" + imageParams.width + ", height=" + imageParams.height);
            AdbHelper.write(adbChan, nudge);
            reply = new byte[imageParams.size];
            AdbHelper.read(adbChan, reply);
            imageParams.data = reply;
        }
        finally {
            if (adbChan != null) {
                adbChan.close();
            }
        }
        return imageParams;
    }

    static void executeRemoteCommand(InetSocketAddress adbSockAddr, String command, IDevice device, IShellOutputReceiver rcvr, int maxTimeToOutputResponse) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        Log.v("ddms", "execute: running " + command);
        SocketChannel adbChan = null;
        try {
            adbChan = SocketChannel.open(adbSockAddr);
            adbChan.configureBlocking(false);
            AdbHelper.setDevice(adbChan, device);
            byte[] request = AdbHelper.formAdbRequest("shell:" + command);
            AdbHelper.write(adbChan, request);
            AdbResponse resp = AdbHelper.readAdbResponse(adbChan, false);
            if (!resp.okay) {
                Log.e("ddms", "ADB rejected shell command (" + command + "): " + resp.message);
                throw new AdbCommandRejectedException(resp.message);
            }
            byte[] data = new byte[16384];
            ByteBuffer buf = ByteBuffer.wrap(data);
            int timeToResponseCount = 0;
            while (true) {
                if (rcvr != null && rcvr.isCancelled()) {
                    Log.v("ddms", "execute: cancelled");
                    break;
                }
                int count = adbChan.read(buf);
                if (count < 0) {
                    rcvr.flush();
                    Log.v("ddms", "execute '" + command + "' on '" + device + "' : EOF hit. Read: " + count);
                    break;
                }
                if (count == 0) {
                    try {
                        int wait = 25;
                        if (maxTimeToOutputResponse > 0 && (timeToResponseCount += wait) > maxTimeToOutputResponse) {
                            throw new ShellCommandUnresponsiveException();
                        }
                        Thread.sleep(wait);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                timeToResponseCount = 0;
                if (rcvr != null) {
                    rcvr.addOutput(buf.array(), buf.arrayOffset(), buf.position());
                }
                buf.rewind();
            }
        }
        finally {
            if (adbChan != null) {
                adbChan.close();
            }
            Log.v("ddms", "execute: returning");
        }
    }

    static void executeRemoteCommand(InetSocketAddress adbSockAddr, String command, IDevice device, IShellOutputReceiver rcvr, int maxTimeToOutputResponse, boolean su) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        Log.v("ddms", "execute: running " + command);
        SocketChannel adbChan = null;
        try {
            byte[] request;
            adbChan = SocketChannel.open(adbSockAddr);
            adbChan.configureBlocking(false);
            AdbHelper.setDevice(adbChan, device);
            if (su) {
                request = AdbHelper.formAdbRequest("shell:su");
                AdbHelper.write(adbChan, request);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                request = command.getBytes();
                AdbHelper.write(adbChan, request);
            } else {
                request = AdbHelper.formAdbRequest("shell:" + command);
                AdbHelper.write(adbChan, request);
            }
            AdbResponse resp = AdbHelper.readAdbResponse(adbChan, false);
            if (!resp.okay) {
                Log.e("ddms", "ADB rejected shell command (" + command + "): " + resp.message);
                throw new AdbCommandRejectedException(resp.message);
            }
            byte[] data = new byte[16384];
            ByteBuffer buf = ByteBuffer.wrap(data);
            int timeToResponseCount = 0;
            while (true) {
                if (rcvr != null && rcvr.isCancelled()) {
                    Log.v("ddms", "execute: cancelled");
                    break;
                }
                int count = adbChan.read(buf);
                if (count < 0) {
                    rcvr.flush();
                    Log.v("ddms", "execute '" + command + "' on '" + device + "' : EOF hit. Read: " + count);
                    break;
                }
                if (count == 0) {
                    try {
                        int wait = 25;
                        if (maxTimeToOutputResponse > 0 && (timeToResponseCount += wait) > maxTimeToOutputResponse) {
                            throw new ShellCommandUnresponsiveException();
                        }
                        Thread.sleep(wait);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                timeToResponseCount = 0;
                if (rcvr != null) {
                    rcvr.addOutput(buf.array(), buf.arrayOffset(), buf.position());
                }
                buf.rewind();
            }
        }
        finally {
            if (adbChan != null) {
                adbChan.close();
            }
            Log.v("ddms", "execute: returning");
        }
    }

    public static void runEventLogService(InetSocketAddress adbSockAddr, Device device, LogReceiver rcvr) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.runLogService(adbSockAddr, device, "events", rcvr);
    }

    public static void runLogService(InetSocketAddress adbSockAddr, Device device, String logName, LogReceiver rcvr) throws TimeoutException, AdbCommandRejectedException, IOException {
        SocketChannel adbChan = null;
        try {
            adbChan = SocketChannel.open(adbSockAddr);
            adbChan.configureBlocking(false);
            AdbHelper.setDevice(adbChan, device);
            byte[] request = AdbHelper.formAdbRequest("log:" + logName);
            AdbHelper.write(adbChan, request);
            AdbResponse resp = AdbHelper.readAdbResponse(adbChan, false);
            if (!resp.okay) {
                throw new AdbCommandRejectedException(resp.message);
            }
            byte[] data = new byte[16384];
            ByteBuffer buf = ByteBuffer.wrap(data);
            while (rcvr == null || !rcvr.isCancelled()) {
                int count = adbChan.read(buf);
                if (count < 0) {
                    break;
                }
                if (count == 0) {
                    try {
                        Thread.sleep(25L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (rcvr != null) {
                    rcvr.parseNewData(buf.array(), buf.arrayOffset(), buf.position());
                }
                buf.rewind();
            }
        }
        finally {
            if (adbChan != null) {
                adbChan.close();
            }
        }
    }

    public static void createForward(InetSocketAddress adbSockAddr, Device device, int localPort, int remotePort) throws TimeoutException, AdbCommandRejectedException, IOException {
        SocketChannel adbChan = null;
        try {
            adbChan = SocketChannel.open(adbSockAddr);
            adbChan.configureBlocking(false);
            byte[] request = AdbHelper.formAdbRequest(String.format("host-serial:%1$s:forward:tcp:%2$d;tcp:%3$d", device.getSerialNumber(), localPort, remotePort));
            if (AndroidDebugBridge.getBridgeType() == AndroidDebugBridge.BridgeType.ACB) {
                request = AdbHelper.formAdbRequest(String.format("host-portid:%1$s:forward:tcp:%2$d;tcp:%3$d", device.getSerialNumber(), localPort, remotePort));
            }
            AdbHelper.write(adbChan, request);
            AdbResponse resp = AdbHelper.readAdbResponse(adbChan, false);
            if (!resp.okay) {
                Log.w("create-forward", "Error creating forward: " + resp.message);
                throw new AdbCommandRejectedException(resp.message);
            }
        }
        finally {
            if (adbChan != null) {
                adbChan.close();
            }
        }
    }

    public static void removeForward(InetSocketAddress adbSockAddr, Device device, int localPort, int remotePort) throws TimeoutException, AdbCommandRejectedException, IOException {
        SocketChannel adbChan = null;
        try {
            adbChan = SocketChannel.open(adbSockAddr);
            adbChan.configureBlocking(false);
            byte[] request = AdbHelper.formAdbRequest(String.format("host-serial:%1$s:killforward:tcp:%2$d;tcp:%3$d", device.getSerialNumber(), localPort, remotePort));
            if (AndroidDebugBridge.getBridgeType() == AndroidDebugBridge.BridgeType.ACB) {
                request = AdbHelper.formAdbRequest(String.format("host-portid:%1$s:killforward:tcp:%2$d;tcp:%3$d", device.getSerialNumber(), localPort, remotePort));
            }
            AdbHelper.write(adbChan, request);
            AdbResponse resp = AdbHelper.readAdbResponse(adbChan, false);
            if (!resp.okay) {
                Log.w("remove-forward", "Error creating forward: " + resp.message);
                throw new AdbCommandRejectedException(resp.message);
            }
        }
        finally {
            if (adbChan != null) {
                adbChan.close();
            }
        }
    }

    static boolean isOkay(byte[] reply) {
        return reply[0] == 79 && reply[1] == 75 && reply[2] == 65 && reply[3] == 89;
    }

    static String replyToString(byte[] reply) {
        String result;
        try {
            result = new String(reply, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            result = "";
        }
        return result;
    }

    static void read(SocketChannel chan, byte[] data) throws TimeoutException, IOException {
        AdbHelper.read(chan, data, -1, DdmPreferences.getTimeOut());
    }

    static void read(SocketChannel chan, byte[] data, int length, int timeout) throws TimeoutException, IOException {
        ByteBuffer buf = ByteBuffer.wrap(data, 0, length != -1 ? length : data.length);
        int numWaits = 0;
        while (buf.position() != buf.limit()) {
            int count = chan.read(buf);
            if (count < 0) {
                Log.d("ddms", "read: channel EOF");
                throw new IOException("EOF");
            }
            if (count == 0) {
                if (timeout != 0 && numWaits * 5 > timeout) {
                    Log.d("ddms", "read: timeout");
                    throw new TimeoutException();
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++numWaits;
                continue;
            }
            numWaits = 0;
        }
    }

    static void write(SocketChannel chan, byte[] data) throws TimeoutException, IOException {
        AdbHelper.write(chan, data, -1, DdmPreferences.getTimeOut());
    }

    static void write(SocketChannel chan, byte[] data, int length, int timeout) throws TimeoutException, IOException {
        ByteBuffer buf = ByteBuffer.wrap(data, 0, length != -1 ? length : data.length);
        int numWaits = 0;
        while (buf.position() != buf.limit()) {
            int count = chan.write(buf);
            if (count < 0) {
                Log.d("ddms", "write: channel EOF");
                throw new IOException("channel EOF");
            }
            if (count == 0) {
                if (timeout != 0 && numWaits * 5 > timeout) {
                    Log.d("ddms", "write: timeout");
                    throw new TimeoutException();
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++numWaits;
                continue;
            }
            numWaits = 0;
        }
    }

    static void setDevice(SocketChannel adbChan, IDevice device) throws TimeoutException, AdbCommandRejectedException, IOException {
        if (device != null) {
            String msg = "host:transport:" + device.getSerialNumber();
            if (AndroidDebugBridge.getBridgeType() == AndroidDebugBridge.BridgeType.ACB) {
                msg = "host:transport-portid:" + device.getSerialNumber();
            }
            byte[] device_query = AdbHelper.formAdbRequest(msg);
            AdbHelper.write(adbChan, device_query);
            AdbResponse resp = AdbHelper.readAdbResponse(adbChan, false);
            if (!resp.okay) {
                throw new AdbCommandRejectedException(resp.message, true);
            }
        }
    }

    public static void reboot(String into, InetSocketAddress adbSockAddr, Device device) throws TimeoutException, AdbCommandRejectedException, IOException {
        byte[] request = into == null ? AdbHelper.formAdbRequest("reboot:") : AdbHelper.formAdbRequest("reboot:" + into);
        SocketChannel adbChan = null;
        try {
            adbChan = SocketChannel.open(adbSockAddr);
            adbChan.configureBlocking(false);
            AdbHelper.setDevice(adbChan, device);
            AdbHelper.write(adbChan, request);
        }
        finally {
            if (adbChan != null) {
                adbChan.close();
            }
        }
    }

    static class AdbResponse {
        public boolean okay;
        public String message = "";
    }
}

