/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.DeviceMonitor;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.log.LogReceiver;
import java.io.File;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Device
implements IDevice {
    private static final int INSTALL_TIMEOUT = 120000;
    static final String RE_EMULATOR_SN = "emulator-(\\d+)";
    private String mSerialNumber = null;
    private String mAvdName = null;
    private IDevice.DeviceState mState = null;
    private final Map<String, String> mProperties = new HashMap<String, String>();
    private final Map<String, String> mMountPoints = new HashMap<String, String>();
    private final ArrayList<Client> mClients = new ArrayList();
    private DeviceMonitor mMonitor;
    private static final String LOG_TAG = "Device";
    private SocketChannel mSocketChannel;
    private boolean mArePropertiesSet = false;
    private Integer mLastBatteryLevel = null;
    private long mLastBatteryCheckTime = 0L;

    @Override
    public String getSerialNumber() {
        return this.mSerialNumber;
    }

    @Override
    public String getAvdName() {
        return this.mAvdName;
    }

    void setAvdName(String avdName) {
        if (!this.isEmulator()) {
            throw new IllegalArgumentException("Cannot set the AVD name of the device is not an emulator");
        }
        this.mAvdName = avdName;
    }

    @Override
    public IDevice.DeviceState getState() {
        return this.mState;
    }

    void setState(IDevice.DeviceState state) {
        this.mState = state;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.mProperties);
    }

    @Override
    public int getPropertyCount() {
        return this.mProperties.size();
    }

    @Override
    public String getProperty(String name) {
        return this.mProperties.get(name);
    }

    @Override
    public boolean arePropertiesSet() {
        return this.mArePropertiesSet;
    }

    @Override
    public String getPropertyCacheOrSync(String name) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (this.mArePropertiesSet) {
            return this.getProperty(name);
        }
        return this.getPropertySync(name);
    }

    @Override
    public String getPropertySync(String name) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        this.executeShellCommand(String.format("getprop '%s'", name), receiver);
        String value = receiver.getOutput().trim();
        if (value.isEmpty()) {
            return null;
        }
        return value;
    }

    @Override
    public String getMountPoint(String name) {
        return this.mMountPoints.get(name);
    }

    public String toString() {
        return this.mSerialNumber;
    }

    @Override
    public boolean isOnline() {
        return this.mState == IDevice.DeviceState.ONLINE;
    }

    @Override
    public boolean isEmulator() {
        return this.mSerialNumber.matches(RE_EMULATOR_SN);
    }

    @Override
    public boolean isOffline() {
        return this.mState == IDevice.DeviceState.OFFLINE;
    }

    @Override
    public boolean isBootLoader() {
        return this.mState == IDevice.DeviceState.BOOTLOADER;
    }

    @Override
    public boolean hasClients() {
        return this.mClients.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Client[] getClients() {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            return this.mClients.toArray(new Client[this.mClients.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Client getClient(String applicationName) {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            for (Client c : this.mClients) {
                if (!applicationName.equals(c.getClientData().getClientDescription())) continue;
                return c;
            }
        }
        return null;
    }

    @Override
    public SyncService getSyncService() throws TimeoutException, AdbCommandRejectedException, IOException {
        SyncService syncService = new SyncService(AndroidDebugBridge.getSocketAddress(), this);
        if (syncService.openSync()) {
            return syncService;
        }
        return null;
    }

    @Override
    public FileListingService getFileListingService() {
        return new FileListingService(this);
    }

    @Override
    public RawImage getScreenshot() throws TimeoutException, AdbCommandRejectedException, IOException {
        return AdbHelper.getFrameBuffer(AndroidDebugBridge.getSocketAddress(), this);
    }

    @Override
    public void executeShellCommand(String command, IShellOutputReceiver receiver) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        AdbHelper.executeRemoteCommand(AndroidDebugBridge.getSocketAddress(), command, this, receiver, DdmPreferences.getTimeOut());
    }

    @Override
    public void executeShellCommand(String command, IShellOutputReceiver receiver, int maxTimeToOutputResponse) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        AdbHelper.executeRemoteCommand(AndroidDebugBridge.getSocketAddress(), command, this, receiver, maxTimeToOutputResponse);
    }

    @Override
    public void executeShellCommand(String command, IShellOutputReceiver receiver, int maxTimeToOutputResponse, boolean su) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        AdbHelper.executeRemoteCommand(AndroidDebugBridge.getSocketAddress(), command, this, receiver, maxTimeToOutputResponse, su);
    }

    @Override
    public void runEventLogService(LogReceiver receiver) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.runEventLogService(AndroidDebugBridge.getSocketAddress(), this, receiver);
    }

    @Override
    public void runLogService(String logname, LogReceiver receiver) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.runLogService(AndroidDebugBridge.getSocketAddress(), this, logname, receiver);
    }

    @Override
    public void createForward(int localPort, int remotePort) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.createForward(AndroidDebugBridge.getSocketAddress(), this, localPort, remotePort);
    }

    @Override
    public void removeForward(int localPort, int remotePort) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.removeForward(AndroidDebugBridge.getSocketAddress(), this, localPort, remotePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClientName(int pid) {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            for (Client c : this.mClients) {
                if (c.getClientData().getPid() != pid) continue;
                return c.getClientData().getClientDescription();
            }
        }
        return null;
    }

    Device(DeviceMonitor monitor, String serialNumber, IDevice.DeviceState deviceState) {
        this.mMonitor = monitor;
        this.mSerialNumber = serialNumber;
        this.mState = deviceState;
    }

    DeviceMonitor getMonitor() {
        return this.mMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClient(Client client) {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            this.mClients.add(client);
        }
    }

    List<Client> getClientList() {
        return this.mClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasClient(int pid) {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            Client client;
            Iterator<Client> iterator = this.mClients.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((client = iterator.next()).getClientData().getPid() != pid);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearClientList() {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            this.mClients.clear();
        }
    }

    void setClientMonitoringSocket(SocketChannel socketChannel) {
        this.mSocketChannel = socketChannel;
    }

    SocketChannel getClientMonitoringSocket() {
        return this.mSocketChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClient(Client client, boolean notify) {
        this.mMonitor.addPortToAvailableList(client.getDebuggerListenPort());
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            this.mClients.remove(client);
        }
        if (notify) {
            this.mMonitor.getServer().deviceChanged(this, 2);
        }
    }

    void update(int changeMask) {
        if ((changeMask & 4) != 0) {
            this.mArePropertiesSet = true;
        }
        this.mMonitor.getServer().deviceChanged(this, changeMask);
    }

    void update(Client client, int changeMask) {
        this.mMonitor.getServer().clientChanged(client, changeMask);
    }

    void addProperty(String label, String value) {
        this.mProperties.put(label, value);
    }

    void setMountingPoint(String name, String value) {
        this.mMountPoints.put(name, value);
    }

    @Override
    public void pushFile(String local, String remote) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException {
        block9: {
            SyncService sync = null;
            try {
                try {
                    String targetFileName = this.getFileName(local);
                    Log.d(targetFileName, String.format("Uploading %1$s onto device '%2$s'", targetFileName, this.getSerialNumber()));
                    sync = this.getSyncService();
                    if (sync != null) {
                        String message = String.format("Uploading file onto device '%1$s'", this.getSerialNumber());
                        Log.d(LOG_TAG, message);
                        sync.pushFile(local, remote, SyncService.getNullProgressMonitor());
                        break block9;
                    }
                    throw new IOException("Unable to open sync connection!");
                }
                catch (TimeoutException e) {
                    Log.e(LOG_TAG, "Error during Sync: timeout.");
                    throw e;
                }
                catch (SyncException e) {
                    Log.e(LOG_TAG, String.format("Error during Sync: %1$s", e.getMessage()));
                    throw e;
                }
                catch (IOException e) {
                    Log.e(LOG_TAG, String.format("Error during Sync: %1$s", e.getMessage()));
                    throw e;
                }
            }
            finally {
                if (sync != null) {
                    sync.close();
                }
            }
        }
    }

    @Override
    public void pullFile(String remote, String local) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException {
        block9: {
            SyncService sync = null;
            try {
                try {
                    String targetFileName = this.getFileName(remote);
                    Log.d(targetFileName, String.format("Downloading %1$s from device '%2$s'", targetFileName, this.getSerialNumber()));
                    sync = this.getSyncService();
                    if (sync != null) {
                        String message = String.format("Downloding file from device '%1$s'", this.getSerialNumber());
                        Log.d(LOG_TAG, message);
                        sync.pullFile(remote, local, SyncService.getNullProgressMonitor());
                        break block9;
                    }
                    throw new IOException("Unable to open sync connection!");
                }
                catch (TimeoutException e) {
                    Log.e(LOG_TAG, "Error during Sync: timeout.");
                    throw e;
                }
                catch (SyncException e) {
                    Log.e(LOG_TAG, String.format("Error during Sync: %1$s", e.getMessage()));
                    throw e;
                }
                catch (IOException e) {
                    Log.e(LOG_TAG, String.format("Error during Sync: %1$s", e.getMessage()));
                    throw e;
                }
            }
            finally {
                if (sync != null) {
                    sync.close();
                }
            }
        }
    }

    @Override
    public String installPackage(String packageFilePath, boolean reinstall, String ... extraArgs) throws InstallException {
        try {
            String remoteFilePath = this.syncPackageToDevice(packageFilePath);
            String result = this.installRemotePackage(remoteFilePath, reinstall, extraArgs);
            this.removeRemotePackage(remoteFilePath);
            return result;
        }
        catch (IOException e) {
            throw new InstallException(e);
        }
        catch (AdbCommandRejectedException e) {
            throw new InstallException(e);
        }
        catch (TimeoutException e) {
            throw new InstallException(e);
        }
        catch (SyncException e) {
            throw new InstallException(e);
        }
    }

    @Override
    public String syncPackageToDevice(String localFilePath) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException {
        SyncService sync = null;
        try {
            String packageFileName = this.getFileName(localFilePath);
            String remoteFilePath = String.format("/data/local/tmp/%1$s", packageFileName);
            Log.d(packageFileName, String.format("Uploading %1$s onto device '%2$s'", packageFileName, this.getSerialNumber()));
            sync = this.getSyncService();
            if (sync == null) {
                throw new IOException("Unable to open sync connection!");
            }
            String message = String.format("Uploading file onto device '%1$s'", this.getSerialNumber());
            Log.d(LOG_TAG, message);
            sync.pushFile(localFilePath, remoteFilePath, SyncService.getNullProgressMonitor());
            String string = remoteFilePath;
            return string;
        }
        catch (TimeoutException e) {
            Log.e(LOG_TAG, "Error during Sync: timeout.");
            throw e;
        }
        catch (SyncException e) {
            Log.e(LOG_TAG, String.format("Error during Sync: %1$s", e.getMessage()));
            throw e;
        }
        catch (IOException e) {
            Log.e(LOG_TAG, String.format("Error during Sync: %1$s", e.getMessage()));
            throw e;
        }
        finally {
            if (sync != null) {
                sync.close();
            }
        }
    }

    private String getFileName(String filePath) {
        return new File(filePath).getName();
    }

    @Override
    public String installRemotePackage(String remoteFilePath, boolean reinstall, String ... extraArgs) throws InstallException {
        try {
            InstallReceiver receiver = new InstallReceiver();
            StringBuilder optionString = new StringBuilder();
            if (reinstall) {
                optionString.append("-r ");
            }
            String[] stringArray = extraArgs;
            int n = extraArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                optionString.append(arg);
                optionString.append(' ');
                ++n2;
            }
            String cmd = String.format("pm install %1$s \"%2$s\"", optionString.toString(), remoteFilePath);
            this.executeShellCommand(cmd, receiver, 120000);
            return receiver.getErrorMessage();
        }
        catch (TimeoutException e) {
            throw new InstallException(e);
        }
        catch (AdbCommandRejectedException e) {
            throw new InstallException(e);
        }
        catch (ShellCommandUnresponsiveException e) {
            throw new InstallException(e);
        }
        catch (IOException e) {
            throw new InstallException(e);
        }
    }

    @Override
    public void removeRemotePackage(String remoteFilePath) throws InstallException {
        try {
            this.executeShellCommand("rm " + remoteFilePath, new NullOutputReceiver(), 120000);
        }
        catch (IOException e) {
            throw new InstallException(e);
        }
        catch (TimeoutException e) {
            throw new InstallException(e);
        }
        catch (AdbCommandRejectedException e) {
            throw new InstallException(e);
        }
        catch (ShellCommandUnresponsiveException e) {
            throw new InstallException(e);
        }
    }

    @Override
    public String uninstallPackage(String packageName) throws InstallException {
        try {
            InstallReceiver receiver = new InstallReceiver();
            this.executeShellCommand("pm uninstall " + packageName, receiver, 120000);
            return receiver.getErrorMessage();
        }
        catch (TimeoutException e) {
            throw new InstallException(e);
        }
        catch (AdbCommandRejectedException e) {
            throw new InstallException(e);
        }
        catch (ShellCommandUnresponsiveException e) {
            throw new InstallException(e);
        }
        catch (IOException e) {
            throw new InstallException(e);
        }
    }

    @Override
    public void reboot(String into) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.reboot(into, AndroidDebugBridge.getSocketAddress(), this);
    }

    @Override
    public Integer getBatteryLevel() throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException {
        return this.getBatteryLevel(300000L);
    }

    @Override
    public Integer getBatteryLevel(long freshnessMs) throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException {
        if (this.mLastBatteryLevel != null && this.mLastBatteryCheckTime > System.currentTimeMillis() - freshnessMs) {
            return this.mLastBatteryLevel;
        }
        BatteryReceiver receiver = new BatteryReceiver();
        this.executeShellCommand("dumpsys battery", receiver);
        this.mLastBatteryLevel = receiver.getBatteryLevel();
        this.mLastBatteryCheckTime = System.currentTimeMillis();
        return this.mLastBatteryLevel;
    }

    private static final class BatteryReceiver
    extends MultiLineReceiver {
        private static final Pattern BATTERY_LEVEL = Pattern.compile("\\s*level: (\\d+)");
        private static final Pattern SCALE = Pattern.compile("\\s*scale: (\\d+)");
        private Integer mBatteryLevel = null;
        private Integer mBatteryScale = null;

        private BatteryReceiver() {
        }

        public Integer getBatteryLevel() {
            if (this.mBatteryLevel != null && this.mBatteryScale != null) {
                return this.mBatteryLevel * 100 / this.mBatteryScale;
            }
            return null;
        }

        @Override
        public void processNewLines(String[] lines) {
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                Matcher scaleMatch;
                String line = stringArray[n2];
                Matcher batteryMatch = BATTERY_LEVEL.matcher(line);
                if (batteryMatch.matches()) {
                    try {
                        this.mBatteryLevel = Integer.parseInt(batteryMatch.group(1));
                    }
                    catch (NumberFormatException e) {
                        Log.w(Device.LOG_TAG, String.format("Failed to parse %s as an integer", batteryMatch.group(1)));
                    }
                }
                if ((scaleMatch = SCALE.matcher(line)).matches()) {
                    try {
                        this.mBatteryScale = Integer.parseInt(scaleMatch.group(1));
                    }
                    catch (NumberFormatException e) {
                        Log.w(Device.LOG_TAG, String.format("Failed to parse %s as an integer", batteryMatch.group(1)));
                    }
                }
                ++n2;
            }
        }

        @Override
        public boolean isCancelled() {
            return false;
        }
    }

    private static final class InstallReceiver
    extends MultiLineReceiver {
        private static final String SUCCESS_OUTPUT = "Success";
        private static final Pattern FAILURE_PATTERN = Pattern.compile("Failure\\s+\\[(.*)\\]");
        private String mErrorMessage = null;

        @Override
        public void processNewLines(String[] lines) {
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.length() > 0) {
                    if (line.startsWith(SUCCESS_OUTPUT)) {
                        this.mErrorMessage = null;
                    } else {
                        Matcher m = FAILURE_PATTERN.matcher(line);
                        if (m.matches()) {
                            this.mErrorMessage = m.group(1);
                        }
                    }
                }
                ++n2;
            }
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        public String getErrorMessage() {
            return this.mErrorMessage;
        }
    }
}

