/*
 * Decompiled with CFR 0.152.
 */
package my.test;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import java.util.HashMap;
import java.util.Map;

public class DeviceSwitcher {
    private static String adbPath = "E:\\devicesmanager\\client\\yc-devices-controller\\tools\\acb.exe";
    private static DeviceSwitcher mDeviceSwitcher;
    private Map<String, IDevice> mDevicesMap = new HashMap<String, IDevice>();

    public static DeviceSwitcher getDeviceSwitcher() {
        if (mDeviceSwitcher == null) {
            mDeviceSwitcher = new DeviceSwitcher();
        }
        return mDeviceSwitcher;
    }

    public void finish() {
        AndroidDebugBridge.terminate();
    }

    private DeviceSwitcher() {
        this.init();
    }

    private void init() {
        AndroidDebugBridge.init(true);
        try {
            this.usingWaitLoop();
            this.usingDeviceChangeListener();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void usingWaitLoop() throws Exception {
        AndroidDebugBridge adb = AndroidDebugBridge.createBridge(adbPath, false);
        try {
            int trials = 10;
            while (trials > 0) {
                Thread.sleep(50L);
                if (adb.isConnected()) break;
                --trials;
            }
            if (!adb.isConnected()) {
                System.out.println("Couldn't connect to ADB server");
                return;
            }
            trials = 10;
            while (trials > 0) {
                Thread.sleep(50L);
                if (adb.hasInitialDeviceList()) break;
                --trials;
            }
            if (!adb.hasInitialDeviceList()) {
                System.out.println("Couldn't list connected devices");
                return;
            }
            IDevice[] iDeviceArray = adb.getDevices();
            int n = iDeviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDevice device = iDeviceArray[n2];
                System.out.println("* " + device.getSerialNumber());
                ++n2;
            }
            return;
        }
        finally {
            AndroidDebugBridge.disconnectBridge();
        }
    }

    private void usingDeviceChangeListener() throws Exception {
        AndroidDebugBridge.addDeviceChangeListener(new AndroidDebugBridge.IDeviceChangeListener(){

            @Override
            public void deviceConnected(IDevice device) {
                System.out.println("+ " + device.getSerialNumber());
            }

            @Override
            public void deviceDisconnected(IDevice device) {
                System.out.println("- " + device.getSerialNumber());
            }

            @Override
            public void deviceChanged(IDevice device, int changeMask) {
                System.out.println("& " + device.getSerialNumber());
            }
        });
    }

    public static void main(String[] args) {
        DeviceSwitcher switcher = DeviceSwitcher.getDeviceSwitcher();
    }
}

