/**
 * Used by the web methods.
 *
 * @author Renas Reda, renas.reda@robotium.com
 *
 * Rewritten by Xie Chunhong, xiechunhong@testin.cn, 2014/7/15
 * check each method's definition, not to redefine a method twice on the same page.
 * Add event listeners injectors, in order to support action recording.
 * Add a custom method for generating xpath.
 *
 */

if ((typeof Testin) == "undefined"){
    // TODO 将这些函数，放在itestin的NameSpace下，这样的好像是只需要检查NS是否存在即可，不需要对每个函数都做检查。
    Testin = {};
    var version = "1.0";
    Testin.prototype = {
        ver: version
    };
}

// // Test on browser.
// var TEST_ON_BROWSER = false;
// 
// enable/disable info logging.
var DEBUG_ENABLE = false;

// storing element number checker id.
if((typeof ELEMENT_NUMBER_CHECKER_ID) == "undefined"){
    ELEMENT_NUMBER_CHECKER_ID = null;
}

// Visible element number on current document.
if ((typeof ELEMENT_NUMBER) == "undefined"){
    ELEMENT_NUMBER = 0;
}

// Visible text for current view document body.
if ((typeof DOCUMENT_TEXT) == "undefined"){
    DOCUMENT_TEXT = "";
}

// A flag to indicate if current has visible changes.
if ((typeof VIEW_CHANGED) == "undefined"){
    VIEW_CHANGED = false;
}

// Previous element
if ((typeof PREVIOUS_ELEMENT) == "undefined"){
    PREVIOUS_ELEMENT = document.body;
}

/*
 * Set previous element, save original text to the element.
 */
if ((typeof setPreviousElement) == "undefined"){
    setPreviousElement = function(element){
        if (isElementValid(element)){
            if (isTextInput(element)){
                element["originalValue"] = element.value;
            }
            PREVIOUS_ELEMENT = element;
        }
    };
}

/*
 * Check if previous element is a text input, and its text has been changed.
 */
if ((typeof needInputAction) == "undefined"){
    needInputAction = function(){
        if (isElementValid(PREVIOUS_ELEMENT)){
            if (isTextInput(PREVIOUS_ELEMENT)){
                if (PREVIOUS_ELEMENT.value != PREVIOUS_ELEMENT.originalValue){
                    return true;
                }
            }
        }
        return false;
    };
}

if (( typeof allWebElements) == "undefined") {
    allWebElements = function() {
        for (var key in document.all) {            
            try {
                promptElement(document.all[key]);
            } catch(ignored) {
            }
        }
        finished();
    };
};

/**
 * Send back the info of hooked elements to Java. 
 */
if (( typeof allHookedWebElements) == "undefined") {	
    allHookedWebElements = function() {
        //if (!VIEW_CHANGED){
        //    finished();
        //    return;
        //}
        info("BODY: " + document.body.innerHTML);
        var visible_elements = getVisibleElements();
        for (var ve in visible_elements) {
            try {
                var element = visible_elements[ve];
                try{
                	info("WEBELEMENTTEST: " + getElementInfo(element));
                }catch(fortest){
                	// Ignore.
                }
                info("isRecorderListenerNeeded(element): " + isRecorderListenerNeeded(element));
                if (!isRecorderListenerNeeded(element)){
                	continue;
                }
                var elementinfo = getElementInfo(element);
                if (elementinfo != ""){
                    //if (element.tagName == "IFRAME"){
                    //    prompt("IFRAMECONTENT: " + element.contentDocument.body.innerHTML);
                    //}
                //if (element["hooked"]) {
                	info("createXPathFromElement(element): " + createXPathFromElement(element));
                	info("isTextInput(element): " + isTextInput(element));
                	info("isTextUnique(element.innerText): " + isTextUnique(element.innerText));                	
                    sendMsg(getElementInfo(element) + ";," + createXPathFromElement(element) + ";," + isTextInput(element) + ";," + isTextUnique(element.innerText));
                //}
                }
            } catch(ignored) {
                sendErrMsg(ignored + "");
            }
        }
        VIEW_CHANGED = false;
        //prompt(document.body.innerHTML);
        finished();
    };
};

if (( typeof allTexts) == "undefined") {
    allTexts = function() {
        var range = document.createRange();
        var walk = document.createTreeWalker(document.body, NodeFilter.SHOW_TEXT, null, false);
        while ( n = walk.nextNode()) {
            try {
                promptText(n, range);
            } catch(ignored) {
            }
        }
        finished();
    };
};

if (( typeof clickElement) == "undefined") {
    clickElement = function(element) {
        var e = document.createEvent('MouseEvents');

        // Explaining every parameter for initMouseEvent.
        // event.initMouseEvent(type, canBubble, cancelable, view,
        //                           detail, screenX, screenY, clientX, clientY,
        //                           ctrlKey, altKey, shiftKey, metaKey,
        //                           button, relatedTarget);
        e.initMouseEvent('click', true, true, window, 1, 0, 0, 0, 0, false, false, false, false, 0, null);
        element.dispatchEvent(e);
    };
}

if (( typeof id) == "undefined") {
    id = function(id, click) {
        var element = document.getElementById(id);
        if (element != null) {

            if (click == 'true') {
                clickElement(element);
            } else {
                promptElement(element);
            }
        } else {
            for (var key in document.all) {
                try {
                    element = document.all[key];
                    if (element.id == id) {
                        if (click == 'true') {
                            clickElement(element);
                            return;
                        } else {
                            promptElement(element);
                        }
                    }
                } catch(ignored) {
                }
            }
        }
        finished();
    };
};

if (( typeof xpath) == "undefined") {
    xpath = function(xpath, click) {
        var elements = document.evaluate(xpath, document, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE, null);

        if (elements) {
            var element = elements.iterateNext();
            while (element) {
                if (click == 'true') {
                    clickElement(element);
                    return;
                } else {
                    promptElement(element);
                    element = result.iterateNext();
                }
            }
            finished();
        }
    };
};

if (( typeof cssSelector) == "undefined") {
    cssSelector = function(cssSelector, click) {
        var elements = document.querySelectorAll(cssSelector);
        for (var key in elements) {
            if (elements != null) {
                try {
                    if (click == 'true') {
                        clickElement(elements[key]);
                        return;
                    } else {
                        promptElement(elements[key]);
                    }
                } catch(ignored) {
                }
            }
        }
        finished();
    };
};

if (( typeof name) == "undefined") {
    name = function(cssSelector, click) {

        var walk = document.createTreeWalker(document.body, NodeFilter.SHOW_ELEMENT, null, false);
        while ( n = walk.nextNode()) {
            try {
                var attributeName = n.getAttribute('name');
                if (attributeName != null && trim(attributeName).length > 0 && attributeName == name) {
                    if (click == 'true') {
                        clickElement(n);
                        return;
                    } else {
                        promptElement(n);
                    }
                }
            } catch(ignored) {
            }
        }
        finished();
    };
}

if (( typeof className) == "undefined") {
    className = function(nameOfClass, click) {
        var walk = document.createTreeWalker(document.body, NodeFilter.SHOW_ELEMENT, null, false);
        while ( n = walk.nextNode()) {
            try {
                var className = n.className;
                if (className != null && trim(className).length > 0 && className == nameOfClass) {
                    if (click == 'true') {
                        clickElement(n);
                        return;
                    } else {
                        promptElement(n);
                    }
                }
            } catch(ignored) {
            }
        }
        finished();
    };
}

if (( typeof textContent) == "undefined") {
    textContent = function(text, click) {
        var range = document.createRange();
        var walk = document.createTreeWalker(document.body, NodeFilter.SHOW_TEXT, null, false);
        while ( n = walk.nextNode()) {
            try {
                var textContent = n.textContent;
                if (trim(textContent) == trim(text)) {
                    if (click == 'true') {
                        clickElement(n);
                        return;
                    } else {
                        promptText(n, range);
                    }
                }
            } catch(ignored) {
            }
        }
        finished();
    };
}

if (( typeof tagName) == "undefined") {
    tagName = function(tagName, click) {
        var elements = document.getElementsByTagName(tagName);
        for (var key in elements) {
            if (elements != null) {
                try {
                    if (click == 'true') {
                        clickElement(elements[key]);
                        return;
                    } else {
                        promptElement(elements[key]);
                    }
                } catch(ignored) {
                }
            }
        }
        finished();
    };
}

/**
 * Click on web element by id, text, or xpath.
 * If element can be found by id, then click on the found element.
 * Otherwise, try to find the element by xpath.
 * If xpath also cannot locate the element, try to use text as the identifier
 * to find the element and click on it. 
 */
if((typeof clickOnWebElement) == "undefined"){
	clickOnWebElement = function(mId, mText, mXpath) {
		info("ID: " + mId + " mText: " + mText + " mXpath: " + mXpath);
		var elementById = document.getElementById(mId);
		if (elementById != null){
			info("ELEMENT FOUND BY ID: " + elementById);
			clickElement(elementById);
			finished();
			return;
		}
		
		var range = document.createRange();
		var walk = document.createTreeWalker(document.body, NodeFilter.SHOW_TEXT, null, false);    	
    	while ( n = walk.nextNode()) {
            try {
                var textContent = n.textContent;	                
                if (trim(textContent) == mText) {
                	info("Element FOUND BY Text: " + textContent);                	
                	clickElement(n);
                	finished();	
                	return; 
                }
            } catch(ignored) {
            }
        }
		       		
		var elementByXpath = document.evaluate(mXpath, document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue;
        if (elementByXpath != null){
        	info("ELEMENT FOUND BY XPATH: " + elementByXpath);
        	clickElement(elementByXpath);
        	finished();
			return;
        }       	
	};
}


/**
 * Send back the info of hooked elements to Java. 
 */
if (( typeof getElementByText) == "undefined") {
    getElementByText = function(textToFind) { 
        var visible_elements = getVisibleElements();
        for (var ve in visible_elements) {
            try {
                var element = visible_elements[ve];
                var text = element.innerText;
	            if (trim(text).length == 0) {
	                text = element.value;
	            }
	            text = trim(text);
	            
	            if (textToFind == text){
	            	return element;
	            }
            } catch(ignored) {
                sendErrMsg(ignored + "");
            }
        }
        return null;      
    };
};

/**
 * Find element by id, text, or xpath. 
 */
if((typeof getWebElement) == "undefined"){
	getWebElement = function(mId, mText, mXpath){
		if(mId != ""){
			var elementById = document.getElementById(mId);
			if (elementById != null){
				info("ELEMENT FOUND BY ID: " + elementById);
				promptExtElement(elementById);
				finished();
				return;
			}
		}
		
		// Click the first element that match the text.
		if(mText != ""){
			var range = document.createRange();
			var walk = document.createTreeWalker(document.body, NodeFilter.SHOW_TEXT, null, false);    	
	    	while ( n = walk.nextNode()) {
	            try {
	                var textContent = n.textContent;	                
	                if (trim(textContent) == mText) {
	                	info("Element FOUND BY Text: " + textContent);                	
	                	promptExtTextElement(n, range);
	                	finished();	
	                	return; 
	                }
	            } catch(ignored) {
	            }
	        }
		}
		
		var elementByXpath = document.evaluate(mXpath, document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue;
        if (elementByXpath != null){
        	info("ELEMENT FOUND BY XPATH: " + elementByXpath);
        	promptExtElement(elementByXpath);
        	finished();
			return;
        }
	};
}

if (( typeof enterTextById) == "undefined") {
    enterTextById = function(id, text) {
        var element = document.getElementById(id);
        if (element != null)
            element.value = text;

        finished();
    };
}

if (( typeof enterTextByXpath) == "undefined") {
    enterTextByXpath = function(xpath, text) {
        var element = document.evaluate(xpath, document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue;
        if (element != null)
            element.value = text;

        finished();
    };
}

if ((typeof enterText) == "undefined") {
	enterText = function(mId, mXpath, textToInput){
		if (mId != null && mId != "" && mId != "null"){
			var element = document.getElementById(mId);
			if (element != null){
	            element.value = textToInput;
	       	}
		}else if (mXpath != null && mXpath != "" && mXpath != "null"){
			var element = document.evaluate(mXpath, document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue;
	        if (element != null){
	            element.value = textToInput;
	        }
        }
        finished();
	};
}

if (( typeof enterTextByCssSelector) == "undefined") {
    enterTextByCssSelector = function(cssSelector, text) {
        var element = document.querySelector(cssSelector);
        if (element != null)
            element.value = text;

        finished();
    };
}

if (( typeof enterTextByName) == "undefined") {
    enterTextByName = function(name, text) {
        var walk = document.createTreeWalker(document.body, NodeFilter.SHOW_ELEMENT, null, false);
        while ( n = walk.nextNode()) {
            var attributeName = n.getAttribute('name');
            if (attributeName != null && trim(attributeName).length > 0 && attributeName == name)
                n.value = text;
        }
        finished();
    };
}

if (( typeof enterTextByClassName) == "undefined") {
    enterTextByClassName = function(name, text) {

        var walk = document.createTreeWalker(document.body, NodeFilter.SHOW_ELEMENT, null, false);
        while ( n = walk.nextNode()) {
            var className = n.className;
            if (className != null && trim(className).length > 0 && className == name)
                n.value = text;
        }
        finished();
    };
}

if (( typeof enterTextByTextContent) == "undefined") {
    enterTextByTextContent = function(textContent, text) {
        var walk = document.createTreeWalker(document.body, NodeFilter.SHOW_TEXT, null, false);
        while ( n = walk.nextNode()) {
            var textValue = n.textContent;
            if (textValue == textContent)
                n.parentNode.value = text;
        }
        finished();
    };
}

if (( typeof enterTextByTagName) == "undefined") {
    enterTextByTagName = function(tagName, text) {
        var elements = document.getElementsByTagName(tagName);
        if (elements != null) {
            elements[0].value = text;
        }
        finished();
    };
}

/**
 * Communicate with Java, send web-element info back to java.
 */
if (( typeof promptElement) == "undefined") {
    promptElement = function(element) {
        sendMsg(getElementInfo(element));
    };
}

if (( typeof promptExtElement) == "undefined") {
    promptExtElement = function(element) {
        sendMsg(getElementInfo(element) + ";," + createXPathFromElement(element) + ";," + isTextInput(element) + ";," + isTextUnique(element.innerText));
    };
}

if ((typeof promptExtTextElement) == "undefined"){
	promptExtTextElement = function(element, range){
		var textElement = getElementTextInfo(element, range) + ";,;," + createXPathFromElement(element) + ";," + isTextInput(element) + ";," + isTextUnique(element.innerText);
		info("TextElement: " + textElement);
		sendMsg(textElement);
	};
}

/**
 * Communicate with Java, send web-element text info back to java.
 */
if (( typeof promptText) == "undefined") {
    promptText = function(element, range) {
        sendMsg(getElementTextInfo(element, range));
    };
}

/**
 * Signal of execution done.
 */
if (( typeof finished) == "undefined") {
    finished = function() {
        sendMsg('robotium-finished');
    };
};

/**
 * Get element text info
 */
if (( typeof getElementTextInfo) == "undefined") {
    getElementTextInfo = function(element, range) {
        var text = element.textContent;
        if (trim(text).length > 0) {
            range.selectNodeContents(element);
            var rect = range.getBoundingClientRect();
            if (rect.width > 0 && rect.height > 0 && rect.left >= 0 && rect.top >= 0) {
                var id = element.parentNode.id;
                var name = element.parentNode.getAttribute('name');
                var className = element.parentNode.className;
                var tagName = element.parentNode.tagName;
                return id + ';,' + text + ';,' + name + ";," + className + ";," + tagName + ";," + rect.left + ';,' + rect.top + ';,' + rect.width + ';,' + rect.height;
            }
        }
    };
}



/**
 * Get element info
 */
if (( typeof getElementInfo) == "undefined") {
    getElementInfo = function(element) {
        try {
            //console.info(element);
            var id = "";
            try{id = element.id;}catch(ignore){};            
            info("ID: " + id);
            
            var text = "";
  
			try {
				text = element.innerText;
				if (trim(text).length == 0) {
					text = element.value;
				}
				text = trim(text);
			} catch(ignore) {
			};            
            info("TEXT: " + text);
            
            
            var name = "";
            try{
            	name = element.getAttribute('name');
            }catch(ex){
            	// Ignore;
            }
            info("NAME: " + name);
            
            var className = "";
            try{
            	className = element.className;
            }catch(ignore){
            	
            }            
            info("className: " + className);
            
            
            var tagName = "";
            try{
            	tagName = element.tagName;
            }catch(ignore){
            	
            }
            info("TAGNAME: " + tagName);
            
            var attributes = "";
            try{
	            var htmlAttributes = element.attributes;
	            for (var i = 0, htmlAttribute; htmlAttribute = htmlAttributes[i]; i++) {
	                attributes += htmlAttribute.name + "::" + htmlAttribute.value;
	                if (i + 1 < htmlAttributes.length) {
	                    attributes += "#$";
	                }
	            }
            }catch(ignore){
            	
            }
            info("ATTR: " + attributes);
            
            var rect = null;
            try{
            	rect = element.getBoundingClientRect();
            }catch(ignore){
            }
            info("RECT: " + rect);
            
            if(rect == null){
            	return id + ';,' + text + ';,' + 
                       name + ";," + className + ";," + 
                       tagName + ";," + 0 + ';,' + 
                       0 + ';,' + 0 + ';,' + 
                       0 + ';,' + attributes;
            }
            info("WIDTH: " + rect.width + " HEIGHT: " + rect.height + " LEFT: " + rect.left + " TOP: " + rect.top);
            if (rect.width > 0 && rect.height > 0 && rect.left >= 0 && rect.top >= 0) {
                return id + ';,' + text + ';,' + 
                       name + ";," + className + ";," + 
                       tagName + ";," + rect.left + ';,' + 
                       rect.top + ';,' + rect.width + ';,' + 
                       rect.height + ';,' + attributes;
            }
        } catch(e) {
            //console.info("getElementInfo Error: ", e);
            sendErrMsg("Get Element Info encounters error: " + e + " TYPEOF: " + (typeof element));
        }
        return "";
    };
}

/**
 * Base on the element object provided,
 * decide if inject event listener is needed.
 */
if (( typeof isRecorderListenerNeeded) == "undefined") {
    isRecorderListenerNeeded = function(element) {
        
        // First of all, the element should be valid.
        info("isElementValid(element): " + isElementValid(element) + " isHooked(element): " + isHooked(element) + 
        " isElementVisible(element)" + isElementVisible(element) + " isLeaf(element): " + isLeaf(element) + " isUnderAnchor(element)" + isUnderAnchor(element) + " element.tagName: " + element.tagName
        );
        if (!isElementValid(element)){
            return false;
        }
        
        if (isHooked(element)){
            //info("EVENT LISTENER ALREADY INJECTED, NO NEED TO INJECT AGAIN.");
            return false;            
        }
        
        // Element should be visible.
        return isElementVisible(element) && 
        // And it has to be a leaf element and it's not under an anchor element.
        (isLeaf(element) && !isUnderAnchor(element)) || 
        // or it is an anchor(all anchors should inject with recorder listeners).
        element.tagName == "A" || element.tagName == "LI";        
    };
}

/*
 * Check if the provided element is valid (not null, not undefined, is an object)
 */
if ((typeof isElementValid) == "undefined"){
    isElementValid = function(element){
        return element != null && (typeof element) == "object";
    };
}

/**
 * Check if the provided element is visible for user.
 */
if (( typeof isElementVisible) == "undefined") {
    isElementVisible = function(element) {
        try {
            if (!isElementValid(element)){
                return false;
            }
            
            var displayed = false;
           
            // Check if the element is displayed.
            try {        
                if (element.hasOwnProperty("style")) {
                    if (element.style.display != "none") {
                        displayed = true;
                    }
                }
            } catch(ignored) {
                // ignored
                // prompt("SOMETHINGWRONG: " + ignored);
            }
           
            var rect = element.getBoundingClientRect();
            
            return (rect.width > 0 && rect.height > 0 && rect.left >= 0 && rect.top >= 0 && displayed);
        } catch(e) {            
            // ignore
            // prompt("SOMETHING WRONG HERE: " + e);
        }
        return false;
    };
}

/**
 * Check if element's direct parent has event listener.
 */
if (( typeof parentHasAnyJqueryEventListeners) == "undefined") {
    parentHasAnyJqueryEventListeners = function(element) {
        if (( typeof element) == "undefined") {
            return false;
        }
        if (( typeof element.parentNode) == "undefined") {
            return false;
        }
        return hasAnyJqueryEventListeners(element.parentNode);
    };
}

/**
 * Check if an element has registered any event listeners(for jQuery event only).
 */
if (( typeof hasAnyJqueryEventListeners) == "undefined") {
    hasAnyJqueryEventListeners = function(domElement) {
        return __getEventListeners(domElement) != null;
    };
}

/*
 * Check if element has event listener of appointed event type.
 * For example fastClick, click, tap.
 */
if ((typeof hasEventListener) == "undefined"){
    hasEventListener = function(element, eventType){
        
        var listenerList = __getEventListeners(element);
        
        if (element.id == "sel_vsltax_taxState"){
            info("sel_vsltax_taxState: " + getListenerList(element));
        }
        
        if (listenerList == null) {
            return false;
        }

        for (var el in listenerList) {
            if (el == eventType) {
                return true;
            }
        }
        return false;
    };
}

/**
 * Does element has id?
 * If an element has been set with id that maybe mean this element is important to user.
 */
if (( typeof hasId) == "undefined") {
    hasId = function(element) {
        if (( typeof element.id) == "undefined") {
            return false;
        }
        if (trim(element.id).length > 0) {
            return true;
        }
        return false;
    };
}


/**
 * Hook recorder event for element that provided.
 */
if (( typeof hookRecorderListener_JQM) == "undefined") {
    hookRecorderListener_JQM = function(element) {
        try {
            if (isRecorderListenerNeeded_JQM(element)) {
                addClickListener(element);
                unhookRecorderEventListenersForParentElements(element);
            }
        } catch (a) {
            sendErrMsg("WEBTEST: " + a);
        }
    };
}


/**
 * Define page show listener.
 */
if (( typeof pageChangeListener) == "undefined") {
    pageChangeListener = function() {
        hookRecorderListener_JQM();
    };
}

/*
 * Check if any of the element's children has been hooked with recorder listener.
 */
if((typeof isChildHookedRecorderListeners) == "undefined"){
    isChildHookedRecorderListeners = function(element){
        try{
            if (element == null || (typeof element) == "undefined"){
                return false;
            }
            if ((typeof element.children) == "undefined"){
                return false;
            }
            if (element.children.length == 0){
                return false;
            }
        for (var ele in element.children){
            if (hasRecorderListener(element.children[ele])){
                return true;
            }else{
                if (isChildHookedRecorderListeners(element.children[ele])){
                    return true;
                }
            }
        }
        }catch(e){
            console.info(e);
        }
        return false;       
    };
}

/*
 * Check if the provided element need recorder listener hooking.
 */
if (( typeof isRecorderListenerNeeded_JQM) == "undefined") {
    isRecorderListenerNeeded_JQM = function(element) {
        
         info(element.id + " " + isHooked(element) + " " + 
         isChildHookedRecorderListeners(element) + " " + 
         isElementVisible(element) + " " + 
         isRecorderListenerNeeded(element) + " " +
         parentHasAnyJqueryEventListeners(element) + " " + 
         hasId(element) + " " + 
         isLeaf(element) + " " + 
         hasEventListener(element, "fastClick") + " " + 
         hasEventListener(element, "click")
         );
  
        if (isHooked(element) || isChildHookedRecorderListeners(element)) {
            info("EVENT LISTENER ALREADY INJECTED, NO NEED TO INJECT AGAIN.");
            return false;
        }
        return (isElementVisible(element) && ((hasEventListener(element, "fastClick") || hasEventListener(element, "click") || hasEventListener(element, "touchstart")) || (isRecorderListenerNeeded(element) && !parentHasAnyJqueryEventListeners(element)
        ) || ((hasId(element)/* || hasVisibleText(element)*/) && isLeaf(element))));
    };
}


/*
 * Check if element has visible text 
 */
if ((typeof hasVisibleText) == "undefined"){
    hasVisibleText = function(element){
        if (element == null || (typeof element) != "object"){
            return false;
        }
        return isElementVisible(element) && trim(element.innerText) != "";
    };
}

/*
 * If an element has already injected with hooker.
 */
if ((typeof isHooked) == "undefined"){
    isHooked = function(element){
        
        if (!isElementValid(element)){
            return false;
        }
        
        if (element.hooked){           
            return true;
        }
        /*
        try{
            var eventList = __getEventListeners(element);
            
            if (eventList == null){
                return false;
            }
            
            for (var ee in eventList){
                for (var eee in eventList[ee]){
                    if (eventList[ee][eee].handler == clickListener){
                        return true;
                    }
                }
            }
        }catch(e){
            sendErrMsg(e);
        }
        */
        return false;
    };
}

/**
 * Check if the current shown page has been injected with tap or fastclick event listener.
 * If yes, then no need to call inject event method twice.
 */
if (( typeof hasEventListenerInjected) == "undefined") {
    hasEventListenerInjected = function() {
        if (__isJQMImported()) {
            for (var ele in document.all) {
                var element = document.all[ele];
                if (isRecorderListenerNeeded_JQM(element)) {
                    
                    if ((typeof element) == "undefined"){
                        if (element.hooked){
                            return true;
                        }
                    }
                    /*
                    var eventList = __getEventListeners(element);
                    if (eventList == null) {
                        continue;
                    }

                    // Check fastClick event listeners.
                    var fastClickEvents = eventList.fastClick;
                    if ( typeof (fastClickEvents) != "undefined") {
                        for (var fe in fastClickEvents) {
                            if (fastClickEvents[fe].handler == clickListener) {
                                return true;
                            }
                        }
                    }

                    // Check tap event listeners.
                    var tapEvents = eventList.tap;
                    if ( typeof (tapEvents) != "undefined") {
                        for (var te in tapEvents) {
                            if (tapEvents[te].handler == clickListener) {
                                return true;
                            }
                        }
                    }
                    */
                }
            }
        }
        return false;
    };
}

/*
 * If the current element has fast click or tap event listener that injected by recorder.
 */
if (( typeof hasRecorderListener) == "undefined") {
    hasRecorderListener = function(element) {
        if (element.hooked){
            return true;
        }
        return false;
        /*
        var eventList = __getEventListeners(element);
        if (eventList == null) {
            return false;
        }

        // Check fastClick event listeners.
        var fastClickEvents = eventList.fastClick;
        if ( typeof (fastClickEvents) != "undefined") {
            for (var fe in fastClickEvents) {
                if (fastClickEvents[fe].handler == clickListener) {
                    return true;
                }
            }
        }

        // Check tap event listeners.
        var tapEvents = eventList.tap;
        if ( typeof (tapEvents) != "undefined") {
            for (var te in tapEvents) {
                if (tapEvents[te].handler == clickListener) {
                    return true;
                }
            }
        }
        return false;
        */
    };
}

/**
 * Get jQuery event listener objects.
 */
if (( typeof __getEventListeners) == "undefined") {
    __getEventListeners = function(element, eventType) {
        if (__isJQMImported()) {
            try {                
                // Filter out non-html element.
                if ((typeof element) != "object"){
                    return null;
                }
                
                // jQuery version greater or equals 1.8
                var events_1_8 = jQuery._data(element, "events");
               
                // jQuery version less than 1.8
                var events_1_x = jQuery(element).data("events");
                
                var event_list = null;

                if (( typeof events_1_8) != "undefined") {
                    event_list = events_1_8;                    
                }
                if (( typeof events_1_x) != "undefined") {
                    event_list = events_1_x;
                }
                
                if (eventType){
                    return event_list[eventType];
                }else{
                    return event_list;
                }

            } catch(e) {
                // ignored
            }
            return null;
        }
    };
}

/**
 * Add fastClick or tap event listener for element.
 */
if (( typeof addClickListener) == "undefined") {
    addClickListener = function(element) {
                
        // To avoid duplicate event listener attached,
        // so remove the event before attaching it.
        // If inject fastClick event listener to input element, 
        // keyboard won't show when clicking on the input element.
        // TODO 对于插入哪些事件监听器，有比较大的问题，需要考虑设备的兼容性。
        // 只有当被插入监听事件的控件有click事件时，对其插入click事件，
        // 如果有fastClick则插入fastClick，其他则插入tap事上。
        // *****新的思路是改写控件原有的Handler方法，在原Handler前面加上输出控件和动作信息的代码*****
        // 这种方式需要考虑如何解决重复注入的问题，初步的解决方法是有一个List保留原来的Handler.
        if (hasEventListener(element, "fastClick") && !isHandlerChanged(element, "fastClick")){
            appendRecorderListener(element, "fastClick");
        }/* else if(hasEventListener(element, "click")&& !isHandlerChanged(element, "click")){
            appendRecorderListener(element, "click");
        }*/ else if(hasEventListener(element, "touchstart") && !isHandlerChanged(element, "touchstart")){
            appendRecorderListener(element, "touchstart");
        } else if (hasEventListenerIncludingParents(element, "fastClick") && element.tagName!="INPUT"){
            info("EVENT TYPE: fastClick - vmousedown");
            jQuery(element).off("touchstart", clickListener);
            jQuery(element).on("touchstart", clickListener);
            element["hooked"] = "touchstart";
        } else if (hasEventListenerIncludingParents(element, "click") && element.tagName != "INPUT"){
            info("EVENT TYPE: touchstart");
            jQuery(element).off("touchstart", clickListener);
            jQuery(element).on("touchstart", clickListener);
            element["hooked"] = "touchstart";
        } else {
            info("EVENT TYPE: tap - vmousedown");
            jQuery(element).off("vmousedown", clickListener);
            jQuery(element).on("vmousedown", clickListener);
            element["hooked"] = "vmousedown";
        }
        
        info("Add Listener for: " + " ID: " + element.id + " Txt: " + element.textContent + " HOOKED: " + element.hooked + " Listeners: " + getListenerList(element));
    };
}

/*
 * Get listener list
 */
if ((typeof getListenerList) == "undefined"){
    getListenerList = function(element){
        if (!isElementValid(element)){
            return "";
        }
        var listenerList = __getEventListeners(element); 
        var listenerListStr = "";
        for (var listener in listenerList){
            listenerListStr += listener + ",";
        }
        return listenerListStr;
    };
}

/*
 * Append codes before the original event handler 
 * for sending element info back to Java.
 */
if ((typeof appendRecorderListener) == "undefined"){
    appendRecorderListener = function(element, eventType){
        //console.info(element, eventType);
        var original_handler = getHandler(element, eventType);
        element[eventType + "_original_handler"] = original_handler;
        var new_handler = function(event){
            var hooked = jQuery(this)[0].hooked;
            if (hooked){                
                if (needInputAction()){
                    action(getInputInfo(PREVIOUS_ELEMENT));                    
                }
                action(getElementInfo(element));
                setPreviousElement(element);
            }
            original_handler.call(this, event);            
        };        
        
        // Replace original handler.
        var event_list = __getEventListeners(element, eventType);            
        event_list[0].handler = new_handler;
        
        element["hooked"] = eventType + "_inline";
        startViewChangeMonitor();
    };
}

/*
 * is handler changed.
 */
if ((typeof isHandlerChanged) == "undefined"){
    isHandlerChanged = function(element, eventType){
        if (!isElementValid(element)){
            return false;
        }
        if (element[eventType + "_original_handler"]){
            var current_handler = getHandler(element, eventType);
            if (current_handler == element[eventType + "_original_handler"]){
                return false;
            }
            return true;
        }
        return false;
    };
}

/*
 * getHandler
 */
if (( typeof getHandler) == "undefined") {
    getHandler = function(element, eventType) {

        var event_list = __getEventListeners(element, eventType);
        if (event_list != null) {
            var my_handler = event_list[0].handler;
            return my_handler;
        }
        return null;
    };
}

/*
 * hasEventListenerIncludingParents
 * Check the given element itself and its 5 levels upper parents
 * if find any appointed type of event listener, return true, 
 * otherwise return false.
 */
if((typeof hasEventListenerIncludingParents) == "undefined"){
    hasEventListenerIncludingParents = function(element, eventType){
        var levelLimit = 3;
        while(levelLimit > 0 && element != null && (typeof element) != "undefined"){
            if (hasEventListener(element, eventType)){
                return true;
            }
            levelLimit--;
            element = element.parentNode;
        }
        return false;
    };
}

/*
 * Un-hook parent recording event listeners.
 * 
 */
if ((typeof unhookRecorderEventListenersForParentElements)){
    unhookRecorderEventListenersForParentElements = function(element){
        try{
            if (element == null || (typeof element) == "undefined"){
                return;
            }
            element = element.parentNode;
            while(element != null && (typeof element) != "undefined"){
                jQuery(element).off("fastClick", clickListener);
                jQuery(element).off("click", clickListener);
                jQuery(element).off("tap", clickListener);
                jQuery(element).off("touchstart", clickListener);
                jQuery(element).off("vmousedown", clickListener);
                element["hooked"] = false;
                //jQuery(element).off("tap", clickListener);
                element = element.parentNode;
            }
        }catch(e){
            sendErrMsg("unhookRecorderEventListenersForParentElements " + e);
        }
    };
}


/**
 * FastClick/Tap event listener,
 * mainly for sending action info and element info back to Java.
 */
if (( typeof clickListener) == "undefined") {
    clickListener = function(event) {
        //console.info(event);
        info("IN FAST CLICK LISTENER... " + event.type);
        if (__isJQMImported()) {
            var element = jQuery(this)[0];
            if (element.id == "baseInfo_bzStartTime"){
                element.value="baseInfo_bzStartTime";
            }
            // prompt the DOM element. 
            if (needInputAction()){
                action(getInputInfo(PREVIOUS_ELEMENT));
                // TODO: 检查输入是否有变化，如果没有可以不输出。(DONE)
                // 让sendInputInfoBack方法接收element对象，当然需要保留原有方法。 (DONE)
                // 如果这个方法成功，则可以去掉onblur事件。但同样需要sendInfoBack的方法，但类似于这里修改。
            }
            action(getElementInfo(element));
            setPreviousElement(element);
            try {
                if (parentHasAnyJqueryEventListeners(element) && event.type == "fastClick") {
                    var eventList = __getEventListeners(element.parentNode);
                    //console.info("EVENTLIST", eventList);
                    if (eventList.fastClick) {
                        for (var fc in eventList.fastClick) {
                            eventList.fastClick[fc].handler.call(this, event);
                        }
                    }
                    if (eventList.click) {
                        for (var c in eventList.click) {
                            eventList.click[c].handler.call(this, event);
                        }
                    }
                }
            } catch(e) {
                console.info("CallParentEventListener Error!", e);
            }
        }
        startViewChangeMonitor();
        // return true;
        // System will return true in default.
        // If return false implicitly the event will not be propagated to upper elements.
    };
}


/**
 * Support: Android<4.1
 * These codes are originally taken from jQuery 2.1.1 library.
 */
if (( typeof trim) == "undefined") {
    trim = function(text) {        
        return text == null ? "" : (text + "").trim();
    };
}

/**
 * Check if the current page has import jQuery mobile library.
 */
if (( typeof __isJQMImported) == "undefined") {
    __isJQMImported = function() {
        if (( typeof jQuery) == "undefined") {
            return false;
        } else {
            if (( typeof jQuery.mobile) == "undefined") {
                return false;
            } else {
                // info("JQuery Version: " + jQuery.fn.jquery);
                // info("Browser is grade A ? " + jQuery.mobile.gradeA());
                return true;
            }
        }
        return false;
    };
};

/**
 * Check if the provided element hidden.
 */
if (( typeof isHidden) == "undefined") {
    isHidden = function(element) {
        try {
            while (element.parentElement) {
                if (element.parentElement.style.display == "none") {
                    return true;
                }
                element = element.parentElement;
            }
        } catch (err) {
        }
        return false;
    };
};

/**
 * Check if the provided element is a leaf element.
 */
if (( typeof isLeaf) == "undefined") {
    isLeaf = function(element) {
        try {
            return element.children.length == 0;
        } catch (err) {
            return true;
        }
        return false;
    };
};

/**
 * Check if the provided element is a text input.
 */
if (( typeof isTextInput) == "undefined") {
    isTextInput = function(element) {
        try {
            if (element.tagName == "TEXTAREA" || 
            (element.tagName == "INPUT" && 
            (element.type == "text" || 
            element.type == "search" || 
            element.type == "password" || 
            element.type == "tel"))) {
                return true;
            }
        } catch (err) {
            // Ignore
        }
        return false;
    };
};

/**
 * Check if the provided element is a sub-element of an anchor (tag: <a>)
 */
if (( typeof isUnderAnchor) == "undefined") {
    isUnderAnchor = function(element) {
        try {
            while (element.parentElement) {
                if (element.parentElement.tagName == "A") {
                    return true;
                }
                element = element.parentElement;
            }
        } catch (err) {
            sendErrMsg(err);
        }
        return false;
    };
};

/**
 * Generate xpath for element that provided.
 */
if (( typeof createXPathFromElement) == "undefined") {
    createXPathFromElement = function(h) {
    	try{
	        var b = document.getElementsByTagName("*");
	        for ( segs = []; h && h.nodeType == 1; h = h.parentNode) {
	            if (h.hasAttribute("id")) {
	                var a = 0;
	                for (var g = 0; g < b.length; g++) {
	                    if (b[g].hasAttribute("id") && b[g].id == h.id) {
	                        a++;
	                    }
	                    if (a > 1) {
	                        break;
	                    }
	                }
	                if (a == 1) {
	                    segs.unshift("id('" + h.getAttribute("id") + "')");
	                    return segs.join("/");
	                } else {
	                    segs.unshift(h.localName.toLowerCase() + "[@id='" + h.getAttribute("id") + "']");
	                }
	            } else {
	                var hasClass = h.hasAttribute("class");
	                var classNotEmpty = false;
	                if (hasClass) {
	                    classNotEmpty = trim(h.getAttribute("class")).length > 0;
	                }
	
	                if (hasClass && classNotEmpty) {
	                    var f = 1;
	                    for ( sibC = h.previousSibling; sibC; sibC = sibC.previousSibling) {
	                        try {
	                            if (sibC.hasAttribute("class")) {
	                                if (sibC.getAttribute("class") == h.getAttribute("class")) {
	                                    f++;
	                                }
	                            }
	                        } catch (d) {
	                        }
	                    }
	                    if (f != 1) {
	                        segs.unshift(h.localName.toLowerCase() + "[@class='" + h.getAttribute("class") + "'][" + f + "]");
	                    } else {
	                        segs.unshift(h.localName.toLowerCase() + "[@class='" + h.getAttribute("class") + "']");
	                    }
	                } else {
	                    for ( i = 1, sib = h.previousSibling; sib; sib = sib.previousSibling) {
	                        if (sib.localName == h.localName) {
	                            i++;
	                        }
	                    }
	                    segs.unshift(h.localName.toLowerCase() + "[" + i + "]");
	                }
	            }
	        }
	        return segs.length ? "/" + segs.join("/") : null;
        }catch(except){
        	info("ERROR: " + except);
        }
        return null;
    };
};

/**
 * Add click event listener for generic web element that provided.
 */
if (( typeof addEvent) == "undefined") {
    addEvent = function(element) {
        if (window.addEventListener) {
            try {
                element.removeEventListener("click", sendInfoBack);
            } catch (err) {
                // ignore
            }
            element.addEventListener("click", sendInfoBack, false);
        } else {
            try {
                element.detachEvent("onclick", sendInfoBack);
            } catch (err) {
                // ignore
            }
            element.attachEvent("onclick", sendInfoBack);
        }
        element["hooked"] = "onclick";
    };
};

/**
 * Add blur event listener for generic web element that provided.
 */
if (( typeof addBlurEvent) == "undefined") {
    addBlurEvent = function(element) {
        if (window.addEventListener) {
            try {
                element.removeEventListener("blur", sendInputInfoBack);
            } catch (err) {
                // ignore
            }
            element.addEventListener("blur", sendInputInfoBack, false);
        } else {
            try {
                element.detachEvent("onblur", sendInputInfoBack);
            } catch (err) {
                // ignore
            }
            element.attachEvent("onblur", sendInputInfoBack);
        }
    };
};

/**
 * Search on the current view to check if the text provided is unique on the view.
 */
if (( typeof isTextUnique) == "undefined") {
    isTextUnique = function(mytext) {
        if (mytext == null || (typeof mytext) == "undefined" || mytext == ""){
            return false;
        }
        mytext = trim(mytext);
        var tree = document.createTreeWalker(document.body, NodeFilter.SHOW_TEXT, null, false);
        var count = 0;
        while ( node = tree.nextNode()) {
            try {
                var text = trim(node.textContent);
                if (text.length > 0) {
                    if (text == mytext && !isHidden(node.parentNode)) {
                        count++;
                        if (count > 1) {
                            return false;
                        }
                    }
                }
            } catch (err) {
                sendErrMsg("WEBERROR: " + err);
            }
        }
        return true;
    };
};

/**
 * Send element info back to Java
 * after the text input lose focus (blur)
 */
if (( typeof sendInputInfoBack) == "undefined") {
    sendInputInfoBack = function(event) {
        var element = null;
        if (event.originalTarget) {
            element = event.originalTarget;
        } else {
            element = event.target;
        }
       
        var inputinfo = getInputInfo(element);
        if (inputinfo != ""){
            sendMsg("WEBVIEWINPUT__" + createXPathFromElement(element) + "__" + id + "__" + text + "__" + name + "__" + classname + "__" + tagname + "__" + value + "__" + textunique);
        }
        
        finished();
    };
};

if ((typeof getInputInfo) == "undefined"){
    getInputInfo = function(element){
        try {
            var eleBound = element.getBoundingClientRect();
            if (eleBound.width > 0 && eleBound.height > 0 && eleBound.left >= 0 && eleBound.top >= 0) {
                var id = element.id;
                var text = element.innerText;
                var textunique = isTextUnique(text);
                var name = element.getAttribute("name");
                var classname = element.className;
                var tagname = element.tagName;
                var value = element.value;
                return ("WEBVIEWINPUT__" + createXPathFromElement(element) + "__" + id + "__" + text + "__" + name + "__" + classname + "__" + tagname + "__" + value + "__" + textunique);
            }
        } catch (err) {
            sendErrMsg(err);
        }
        return "";
    };
}

/*
 *  Send info back to Java for the element that clicked by user.
 */
if (( typeof sendInfoBack) == "undefined") {
    sendInfoBack = function(a) {
        try {
            var f = null;
            if (a.originalTarget) {
                f = a.originalTarget;
            } else {
                f = a.target;
            }

            var xpath = createXPathFromElement(f);
            var c = f.id;
            var j = f.innerText;
            var textunique = isTextUnique(j);
            var b = f.getAttribute("name");
            var g = f.className;
            var d = f.tagName;
            sendMsg("WEBVIEWCLICK__" + xpath + "__" + c + "__" + j + "__" + b + "__" + g + "__" + d + "__" + textunique);
        } catch (e) {
            sendErrMsg(e);
        }
        startViewChangeMonitor();
        finished();
    };
};

/*
 * Send message to JAVA.
 */
if (( typeof sendMsg) == "undefined") {
    sendMsg = function(msg) {
        prompt(msg + "");
    };
}

/*
 * Send error message to JAVA.
 */
if (( typeof sendErrMsg) == "undefined") {
    sendErrMsg = function(errMsg) {
        prompt("ERR: " + errMsg);
    };
}

/*
 * Debug method.
 */
if (( typeof info) == "undefined") {
    info = function(info) {
        if (DEBUG_ENABLE) {
            prompt("DEBUG: " + info);
        }
    };
}

/*
 * Debug method.
 */
if (( typeof action) == "undefined") {
    action = function(actionInfo) {
       
        prompt("WEBACTION: " + actionInfo);
       
    };
}

/*
 * When web element number on current page is changed, trigger hookRecorderListener_JQM implicitly.
 */
if ((typeof startViewChangeMonitor) == "undefined"){
    startViewChangeMonitor = function(){
        info("startViewChangeMonitor called.");
        if (ELEMENT_NUMBER_CHECKER_ID != null){
            window.clearInterval(ELEMENT_NUMBER_CHECKER_ID);
        }
        
        ELEMENT_NUMBER_CHECKER_ID = window.setInterval(function(){                      
            var textChanged = isDocumentTextChanged();
            var elementNumChanged = isElementNumChanged();
            info("View Change Monitor Running... TextChanged: " + textChanged + " elementNumChanged: " + elementNumChanged);
            if (textChanged || elementNumChanged){
                // Don't hook event listener for the first time element number check.
                if(ELEMENT_NUMBER != 0 /* && !hasEventListenerInjected()*/){                    
                    injectEvents();
                }                
            }
        }, 1000);
    };
}

/*
 * Check if the text content on current body is changed.
 */ 
if ((typeof isDocumentTextChanged) == "undefined"){
    isDocumentTextChanged = function(){
        var current_text = document.body.innerText;        
        if (current_text != DOCUMENT_TEXT){
            DOCUMENT_TEXT = current_text;
            return true;
        }
        return false;
    };
}

/*
 * Check if the number of visible element is changed.
 */
if ((typeof isElementNumChanged) == "undefined"){
    isElementNumChanged = function(){
        var current_num = getVisibleElements().length;        
        if (current_num != ELEMENT_NUMBER){
            ELEMENT_NUMBER = current_num;
            return true;
        }
        return false;
    };
}

/*
 * Filter visible web element.
 */
if((typeof getVisibleElements) == "undefined"){
    getVisibleElements = function(){
        var elementArray = [];        
        for(var ele in document.all){
            var element = document.all[ele];            
            if (isElementVisible(element)){
                elementArray.push(element);
            }
        }
        return elementArray;
    };
}

/**
 * Inject click event listener for clickable leaf elements.
 * Inject blur event listener for text inputs.
 */
if (( typeof injectEvents) == "undefined") {
    injectEvents = function() {
        VIEW_CHANGED = true;
        var jqm_imported = __isJQMImported();
        var visible_elements = getVisibleElements();
        
        for (var ve in visible_elements) {
            var element = visible_elements[ve];
            if (element.id == "sel_vsltax_taxState"){
                info(element.id + " JQML: " + isRecorderListenerNeeded_JQM(element) + " NL: " + isRecorderListenerNeeded(element));                
            }
            if (jqm_imported) {
                // WAIT FOR 1 SECOND, IF NO EVENT INJECTED THEN INJECT EVENT IMPLICITLY.
                // Normally pageshow event will be triggered after page is shown.
                // However for the first page, injectEvent won't be called before pageshow,
                // so it is necessary to check event listener injection status after injectEvent
                // is called, is no event listener injected, then call hookRecorderListener_JQM
                // implicitly.
                //setTimeout(function() {
                //    if (!hasEventListenerInjected()) {
                //hookRecorderListener_JQM();
                //   }
                //}, 1000);
                hookRecorderListener_JQM(element);
                jQuery(document).off("pageshow", pageChangeListener);
                jQuery(document).on("pageshow", pageChangeListener);                
            } else if (isRecorderListenerNeeded(element)) {
                addEvent(element);                                
            }
            
            //if (isTextInput(element)) {
                // To listen text input action.
            //    addBlurEvent(element);
            //}
        }        
        finished();

    };
};
// 
// if(TEST_ON_BROWSER){
    // window.prompt = function(msg){
        // console.info("WEBVIEW", msg);
    // };
    // injectEvents();
// }
// 
// if (( typeof jQuery) != "undefined") {
    // info("~~~~~~~~~~~~~~~~PAGE BEFORE CREATE CALLED~~~~~~~~~~~~~~~~");
    // jQuery(document).ready(function() {
        // jQuery(document).off("pagebeforecreate", injectEvents);
        // jQuery(document).on("pagebeforecreate", injectEvents);
    // });    
// }

