(function() {
	
	"use strict";
	
	angular.module('app.text')
		.controller('TextController', TextController);

	TextController.$inject = ['csInterface', 
							  'ps', 
							  'textLayerFactory', 
							  '$scope'];

    function TextController (csInterface, ps, textLayerFactory, $scope) {
   
    	$scope.$emit('module:loaded', "USEFUL", "text");

    	var vm = this;
    	var textObj = textLayerFactory.getTextObj();
    	vm.textArea = (textObj == undefined) ? "Select a Text Layer first" : textObj.Text;

    	vm.setText = function () {
    		ps.script("setTextById('" + vm.textArea + "', '" + textObj.ID + "')");
    	}
    }

}())