(function() {

	"use strict";

	angular.module('app.layers')

		.factory ('UIGrid', function() {
			return {
				enableRowSelection: true,
				enableRowHeaderSelection: false,
				multiSelect: false,
				selectionRowHeaderWidth: 35,
				rowHeight: 24,
				columnDefs: [{
						field: "ID",
						visible: false
					}, {
						field: "Layer Name",
						enableColumnMenu: false,
						width: "**"
					}, {
						field: "Text",
						enableColumnMenu: false
					}

				]
			}
		})

		.controller('LayersController', LayersController);

	LayersController.$inject = ['csInterface', 
								'ps', 
								'$state', 
								'UIGrid', 
								'textLayerFactory', 
								'$scope'];

	function LayersController(csInterface, ps, $state, UIGrid, textLayerFactory, $scope) {

		$scope.$emit('module:loaded', "SUPPORT", "layers");

		var vm = this;
		vm.UIGrid = UIGrid;

		vm.UIGrid.onRegisterApi = function(gridApi) {
			vm.gridApi = gridApi;
			gridApi.selection.on.rowSelectionChanged($scope, function(row) {
				console.log(row.entity);
				textLayerFactory.setTextObj(row.entity);
				// $scope.$emit('module:layerSelected', row.entity);
				$state.go('text');
			});
		}

		vm.getTextLayersInfo = function() {
			ps.script("getTextLayersInfoAM()").then(function(res) {
				// the way to proper check for error coming from csInterface.evalScript
				// EvalScript_ErrMessage is a global from CSInterface.js
				if (EvalScript_ErrMessage == res) {
					console.log("No Text Layers in the Document");
				} else {
					vm.UIGrid.data = JSON.parse(res);
				}
			})
		}

    	vm.getTextLayersInfo();

	}

}())

console.log("");