package 
{
	import com.alibaba.image.JPGEncoderIMP;
	import com.senocular.display.TransformTool;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.DisplayObjectContainer;
	import flash.display.SimpleButton;
	import flash.display.Sprite;
	import flash.events.Event;
	import com.greensock.TweenMax;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.FileReference;
	import flash023.display.DisPlayLoader;
	import flash023.events.SliderEvent;
	import flash023.filters.*;
	import flash.filters.*;
	import fl.motion.ColorMatrix;
	/**
	 * @author FLASH023
	 * @date 2011-10-12 8:55
	**/
	public class ImageDiy extends Sprite  
	{
		private var loader:DisPlayLoader;
		private var btnArray:Array ;
		private var centerPoint:Point;
		private var filterArray:Array;
		private var scaleMax:Number;
		private var scaleMin:Number;
		private var scaleStep:Number;
		private var handlerArray:Array;
		private var tool:TransformTool;
		public function ImageDiy():void {
			stage?init(null):addEventListener (Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event):void 
		{	
			handlerArray = [];
			handlerArray["index"] = 0;			
			scaleStep = .1;
			scaleMax = 3;
			scaleMin = .3;
			filterArray = [new ColorMatrixFilter, new ColorMatrixFilter, new ColorMatrixFilter];
			centerPoint = new Point (mask_mc.x + mask_mc.width * .5, mask_mc.y + mask_mc.height * .5);
			btnArray  = [r_btn, d_btn, l_btn, left_btn, right_btn, cut_btn,big_btn, small_btn, save_btn, repeal_btn, restore_btn, original_btn, close_btn];
			uiInit();
			loader = new DisPlayLoader("image.jpg");			
			loader.addEventListener (Event.COMPLETE , onImageLoaded );
			loader.startLoad();		
			/*
			tool = new TransformTool;
			tool.skewEnabled = false;
			tool.rotationEnabled = false;
			tool.doubleClickEnabled = true;			
			addChild (tool);
			*/
			//
			removeEventListener(Event.ADDED_TO_STAGE, init);			
		}
		private function uiInit():void {
			r_mc.value = 0;
			d_mc.value = .5;
			l_mc.value = .5;
			r_mc.hide(true);
			d_mc.hide(true);
			l_mc.hide(true);			
			r_mc.addEventListener (SliderEvent.CHANGE_END, onSilderChange);
			d_mc.addEventListener (SliderEvent.CHANGE_END, onSilderChange);
			l_mc.addEventListener (SliderEvent.CHANGE_END, onSilderChange);
			TweenMax.to(alert_mc, 0, { autoAlpha:0 } );
			//
			image_mc.mask = mask_mc;
			image_mc.x = centerPoint.x;
			image_mc.y = centerPoint.y;
			for each(var _btn:SimpleButton in btnArray ) {
				_btn.mouseEnabled =false;
				_btn.addEventListener (MouseEvent.CLICK , onClick);
			}
			cut_mc.visible = false;
			cut_mc.dot_mc.visible = false;
			cut_mc.dot_mc.addEventListener("PASS_CUT", passCut);
			cut_mc.rec_mc.doubleClickEnabled = true;		
			scroll_mc.setHeight(mask_mc.height + 12.8);
			vscroll_mc.setHeight(mask_mc.width);
			stage.focus = stage;
			stage.addEventListener (KeyboardEvent.KEY_DOWN, keyDown);
		}
		
		private function keyDown(e:KeyboardEvent):void 
		{
			if (e.keyCode == 27) passCut(null);
		}
		private function handlerMem(_obj:Object ):void {
			handlerArray.length = handlerArray["index"]+1;
			handlerArray.push (_obj);
			trace(handlerArray);
			if (handlerArray.length > 2) handlerArray.shift ();
			handlerArray["index"] = handlerArray.length - 1;
		}
		private function onSilderChange(e:SliderEvent):void 
		{
			if (e.target == r_mc) {
				var _v:Number = e.value*10;
				var _matrix:Array=[0,-_v,0,-_v,1+_v*4,-_v,0,-_v,0];
				filterArray[0] = new ConvolutionFilter(3, 3, _matrix);				
				image_mc.filters = filterArray;
				if (!e.auto )srsComplete();
				return;
			}
			if (e.target == d_mc) {
				var _dcm:ColorMatrix=new ColorMatrix();
				_dcm.SetContrastMatrix(e.value*255); 
				filterArray[1] = new ColorMatrixFilter(_dcm.GetFlatArray());
				image_mc.filters = filterArray;
				if (!e.auto )srsComplete();
				return;
			}
			if (e.target == l_mc) {
				var _lcm:ColorMatrix=new ColorMatrix();				
				_lcm.SetBrightnessMatrix(e.value*510-255); 
				filterArray[2] = new ColorMatrixFilter(_lcm.GetFlatArray());
				image_mc.filters = filterArray;
				if (!e.auto )srsComplete();
				return;
			}
		}
		private function autoHandler(_obj:Object ):void {
			if (!_obj) {
				handlerArray["index"] = 0;
				resetImage();
				return;
			}
			trace(_obj.type, handlerArray["index"]);
			if (_obj.type == "srs") {
				r_mc.value = _obj.r;
				d_mc.value = _obj.d;
				l_mc.visible = _obj.l;
				image_mc.x = _obj.x;
				image_mc.y = _obj.y;
				image_mc.rotation = _obj.rotation;
				image_mc.scaleX = image_mc.scaleY = _obj.scale;
				r_mc.dispatchEvent(new SliderEvent (SliderEvent.CHANGE_END, _obj.r, true));
				d_mc.dispatchEvent(new SliderEvent (SliderEvent.CHANGE_END, _obj.d, true));
				l_mc.dispatchEvent(new SliderEvent (SliderEvent.CHANGE_END, _obj.l, true));
				return;
			}
		}
		private function resetImage():void {
			image_mc.x = centerPoint.x;
			image_mc.y = centerPoint.y;
			image_mc.scaleX = image_mc.scaleY = 1;
			image_mc.rotation = 0;
			image_mc.filters = null;
			//
			r_mc.value = 0;
			d_mc.value = .5;
			l_mc.value = .5;
			filterArray = [new ColorMatrixFilter, new ColorMatrixFilter, new ColorMatrixFilter];
			scroll_mc.target = 	vscroll_mc.target = image_mc;
		}
		private function onClick(e:MouseEvent ):void {
			//trace(e.target.name);
			if (e.target == r_btn) {
				r_mc.show();
				return;
			}
			if (e.target == d_btn) {
				d_mc.show();
				return;
			}
			if (e.target == l_btn) {
				l_mc.show();
				return;
			}
			if (e.target == repeal_btn) {
				if (handlerArray.length ) {		
					if (handlerArray["index"] > 0) {
						handlerArray["index"]--;
						trace("prev", handlerArray["index"]);
						autoHandler( handlerArray[handlerArray["index"]]);
					}				
				}
				return;
			}
			if (e.target == restore_btn) {
				if (handlerArray.length ) {					
					if (handlerArray["index"] < handlerArray.length-1) {		
						handlerArray["index"]++;	
						trace("next", handlerArray["index"]);			
						autoHandler( handlerArray[handlerArray["index"]]);
						
					}			
				}
				return;
			}
			if (e.target == left_btn) {
				TweenMax.to(image_mc,0,{rotation:"-90"});
				srsComplete();
				return;
			}
			if (e.target == right_btn) {
				TweenMax.to(image_mc,0,{rotation:"-90"});
				srsComplete();
				return;
			}
			if (e.target == big_btn) {
				var _bs:Number = image_mc.scaleX + scaleStep;
				if (_bs > scaleMax )_bs = scaleMax;
				TweenMax.to(image_mc, .3, {x:centerPoint.x,y:centerPoint.y,scaleX: _bs ,scaleY:_bs,onComplete:srsComplete});
				return;
			}
			if (e.target == small_btn) {
				var _ss:Number = image_mc.scaleX - scaleStep;
				if (_ss < scaleMin )_ss = scaleMin;				
				TweenMax.to(image_mc, .3, {x:centerPoint.x,y:centerPoint.y,scaleX:_ss,scaleY:_ss,onComplete:srsComplete});				
				return;
			}
			if (e.target == cut_btn) {
				cut_mc.visible = true;
				cut_mc.rec_mc.width = cut_mc.rec_mc.height = 0;
				cut_mc.addEventListener (MouseEvent.MOUSE_DOWN, mouseDown);
				return;
			}
			if (e.target == original_btn) {
				handlerArray["index"] = 0;
				resetImage();
				while (image_mc.numChildren ) image_mc.removeChildAt(0);
				image_mc.addChild (loader);
				return;
			}
			if (e.target == save_btn) {
				var _jpg:JPGEncoderIMP = new JPGEncoderIMP;				
				new FileReference().save(_jpg.encode(getBitmapData()), "save.jpg");
				return;
			}
		}
		private function getBitmapData():BitmapData  {
			var _d:int = getChildIndex(image_mc);
			var _x:int = image_mc.x;
			var _y:int = image_mc.y;
			var _s:Sprite = new Sprite;
			image_mc.x = image_mc.width * .5;
			image_mc.y = image_mc.height * .5;
			image_mc.mask = null;
			_s.addChild (image_mc);
			var _rect:Rectangle = image_mc.getBounds (_s);
			var _bmd:BitmapData = new BitmapData(_rect.x+_rect.width,_rect.y+_rect.height  , true, 0x00);			
			_bmd.draw (_s);
			image_mc.x = _x;
			image_mc.y = _y;
			image_mc.mask = mask_mc;
			addChildAt(image_mc, _d);
			
			var _tempBmd:BitmapData = new BitmapData(_rect.width, _rect.height, true, 0x00);
			_tempBmd.copyPixels(_bmd, _rect, new Point(0, 0));
			return _tempBmd;
		}
		private function mouseDown(e:MouseEvent):void 
		{
			if (e.target == cut_mc.rec_mc) {
				cut_mc.rec_mc.startDrag ();
				cut_mc.rec_mc.drag = true;				
			}else{
				cut_mc.rec_mc.x = cut_mc.dot_mc.x=cut_mc.mouseX;
				cut_mc.rec_mc.y = cut_mc.dot_mc.y = cut_mc.mouseY;
				cut_mc.dot_mc.visible = true;
			}
			stage.addEventListener (MouseEvent.MOUSE_MOVE , mouseMove);
			stage.addEventListener (MouseEvent.MOUSE_UP, mouseUp);
			
		}
		
		private function mouseUp(e:MouseEvent):void 
		{
			if (cut_mc.rec_mc.width > 20 && cut_mc.rec_mc.height > 20) {
				//tool.target = cut_mc.rec_mc;
				cut_mc.dot_mc.target = cut_mc.rec_mc;
				cut_mc.removeEventListener (MouseEvent.MOUSE_DOWN, mouseDown);
				cut_mc.rec_mc.addEventListener (MouseEvent.MOUSE_DOWN, mouseDown);
				cut_mc.rec_mc.addEventListener (MouseEvent.DOUBLE_CLICK , onDoubleClick);
			}
			cut_mc.rec_mc.drag = false;
			stopDrag ();
			stage.removeEventListener (MouseEvent.MOUSE_MOVE , mouseMove);
			stage.removeEventListener (MouseEvent.MOUSE_UP, mouseUp);
		}
		
		private function onDoubleClick(e:MouseEvent):void 
		{
			trace("cut");
			var _d:int = getChildIndex(image_mc);
			var _s:Sprite = new Sprite;
			_s.addChild (image_mc);
			var _bmd:BitmapData = new BitmapData(1000 , 800 , true, 0x00);			
			_bmd.draw (_s);
			addChildAt(image_mc, _d);
			var _rect:Rectangle = cut_mc.rec_mc.getBounds (this);
			var _tempBmd:BitmapData = new BitmapData(_rect.width, _rect.height, true, 0x00);
			_tempBmd.copyPixels(_bmd, _rect, new Point(0, 0));
			while (image_mc.numChildren ) image_mc.removeChildAt(0);
			var _bitmap:Bitmap = new Bitmap (_tempBmd );
			_bitmap.x = _bitmap.width * -.5;
			_bitmap.y = _bitmap.height * -.5;
			image_mc.addChild (_bitmap);
			trace(_rect);
			resetImage ();
			scroll_mc.target = 	vscroll_mc.target = image_mc;
			//			
			passCut(null);
		}
		private function passCut(e:Event ):void {
			cut_mc.visible = false;
			cut_mc.dot_mc.visible = false;
			cut_mc.rec_mc.removeEventListener (MouseEvent.DOUBLE_CLICK , onDoubleClick);
		}
		private function mouseMove(e:MouseEvent):void 
		{
			if (cut_mc.rec_mc.drag) {
				cut_mc.dot_mc.x = cut_mc.rec_mc.x + cut_mc.rec_mc.width;
				cut_mc.dot_mc.y = cut_mc.rec_mc.y + cut_mc.rec_mc.height;
			}else {
				cut_mc.dot_mc.x = cut_mc.mouseX;
				cut_mc.dot_mc.y = cut_mc.mouseY;
				cut_mc.rec_mc.width = cut_mc.mouseX-cut_mc.rec_mc.x;
				cut_mc.rec_mc.height = cut_mc.mouseY-cut_mc.rec_mc.y;		
			}
				
		}
		private function srsComplete():void {
			handlerMem({ type:"srs",x:image_mc.x,y:image_mc.y, rotation:image_mc.rotation,scale:image_mc.scaleX, r:r_mc.value,d:d_mc.value,l:l_mc.value });
			scroll_mc.target = 	vscroll_mc.target = image_mc;
		}
		private function onImageLoaded(e:Event ):void {
			for each(var _btn:SimpleButton in btnArray ) {
				_btn.mouseEnabled = true;		
			}
			loader.x = loader.width *-.5;
			loader.y = loader.height * -.5;
			image_mc.addChild (loader);
			scroll_mc.target = 	vscroll_mc.target = image_mc;
			//trace("loaded");
		}
	}
	
}