﻿package flash023.display
{
	import flash.display.Loader;
	import flash.events.Event;
	import flash.net.URLRequest;
	import flash.errors.IOError;
	import flash.events.IOErrorEvent;
	import flash.utils.setTimeout;
	import flash.utils.clearTimeout ;
	/**
	 * ...
	 * @author FLASH023
	 */
	public class DisPlayLoader extends Loader 
	{
		private var path:String;	
		private var loadnum:int;
		private var T:int;
		private var loading:Boolean;
		private var w:int;
		private var h:int;
		private var size:Boolean;
		public function DisPlayLoader(_url:String, _size:Boolean = false, _w:int = 0, _h:int = 0 ):void {	
			size = _size;
			w = _w;
			h = _h;
			path = _url;
			contentLoaderInfo.addEventListener (Event.COMPLETE, loadCompleteHandler);
			contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);				
			addEventListener (Event.REMOVED_FROM_STAGE, removeFormStage);			
		}
		public function startLoad(_b:Boolean = false ):void {
			loadnum++;
			loading = true;
			load(new URLRequest (path));
		}
		private function ioErrorHandler(_evt:IOErrorEvent):void {
			if (loadnum < 3) {
				loading = false;
				T=setTimeout(startLoad,loadnum*20,true);
			}else {
				dispatchEvent (new Event("ERROR"));
			}
		}
		public function loadCompleteHandler(_evt:Event = null):void {
			if (size) {
				width = w;
				height = h;
			}
			loading = false;
			dispatchEvent (new Event(Event.COMPLETE));
			contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
			contentLoaderInfo.removeEventListener (Event.COMPLETE, loadCompleteHandler);
			//trace("加载成功");
		}
		private function removeFormStage(_evt:Event):void {
			clearTimeout(T);			
			if (loading) unloadAndStop ();
			contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
			contentLoaderInfo.removeEventListener (Event.COMPLETE, loadCompleteHandler);
			removeEventListener (Event.REMOVED_FROM_STAGE, removeFormStage);
		}
	}
	
}