﻿package flash023.display
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.net.URLRequest;
	import flash.errors.IOError;
	import flash.events.IOErrorEvent;
	import flash.utils.setTimeout;
	import flash.utils.clearTimeout ;
	/**
	 * ...
	 * @author FLASH023
	 */
	public class ImageLoader extends Sprite   
	{
		private var w:uint;
		private var h:uint;
		private var loader:Loader;
		private var autoSize:Boolean;
		public var lock:Boolean;	
		private var path:String;
		private var T:uint = 0;
		private var loadnum:uint = 0;
		public var _data:Object;
		public var _bitmap:Bitmap;
		private var scale:Boolean;
		public var link:String;
		public function ImageLoader(_url:String, _b:Boolean = false, _w:uint = 0, _h:uint = 0,_s:Boolean =false):void {
			mouseChildren=mouseEnabled =false;
			autoSize = _b;
			w = _w;
			h = _h;
			scale = _s;
			path = _url;
			loader = new Loader;
			loader.contentLoaderInfo.addEventListener (Event.COMPLETE, loadCompleteHandler);
			loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);	
			
			addEventListener (Event.REMOVED_FROM_STAGE, removeFormStage);			
			//load();
		}
		public function load(_b:Boolean = false ):void {
			if (lock) return;
			_b?loadnum++:loadnum = 0;
			try{
				loader.load(new URLRequest ( path));
				//trace(path);
				lock = true;
			}catch (_e:Error) {
				lock = false;
				dispatchEvent (new Event("ERROR"));
				loadnum<3&&(T=setTimeout(load,loadnum*2000,true));
				//trace( path+"加载失败");
			}
		}
		private function ioErrorHandler(_evt:IOErrorEvent):void {
			lock = false;		
			if(loadnum<3){
				T=setTimeout(load,loadnum*20,true);
			}else {
				dispatchEvent (new Event("ERROR"));
			}
			trace( path+"_加载失败");
		}
		public function loadCompleteHandler(_evt:Event = null):void {
			if (_evt)	{
				_bitmap = _evt.target.content as Bitmap;
			}
			if (scale&&w&&h) {
				_bitmap.width = w;
				_bitmap.scaleY = _bitmap.scaleX;
				if (_bitmap.height > h) {
					_bitmap.height = h;
					_bitmap.scaleX = _bitmap.scaleY;
				}
			}else{
				w&&(_bitmap.width = w);
				h && (_bitmap.height = h);
			}
			addChild (_bitmap );
			if(autoSize){
				_bitmap.x-=_bitmap.width*.5;
				_bitmap.y-=_bitmap.height*.5;
			}
			_evt&&dispatchEvent (new Event(Event.COMPLETE));
			loader.contentLoaderInfo.removeEventListener (Event.COMPLETE, loadCompleteHandler);
			loader = null;
			//trace("加载成功");
		}
		private function removeFormStage(_evt:Event):void {
			clearTimeout(T);
			if (_bitmap) {
				_bitmap.bitmapData.dispose();
				_bitmap = null;
			}
			if (loader) loader.unloadAndStop ();
			removeEventListener (Event.REMOVED_FROM_STAGE, removeFormStage);
		}
		public function get bitmapData():BitmapData {
			if (_bitmap ) return _bitmap.bitmapData.clone ();
			return null;
		}
	}
	
}