﻿package flash023.display
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.net.URLRequest;
	import flash.errors.IOError;
	import flash.events.IOErrorEvent;
	import flash.utils.setTimeout;
	import flash.utils.clearTimeout ;
	/**
	 * ...
	 * @author FLASH023
	 */
	public class MediaLoader extends Loader 
	{
		private var path:String;	
		private var loadnum:int;
		private var T:int;
		private var loading:Boolean;
		public function MediaLoader(_url:String):void {	
			path = _url;
			contentLoaderInfo.addEventListener (Event.COMPLETE, loadCompleteHandler);
			contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);				
			addEventListener (Event.REMOVED_FROM_STAGE, removeFormStage);				
		}
		public function load(_b:Boolean = false ):void {
			loadnum++;
			loading = true;
			load(new URLRequest (path);
		}
		private function ioErrorHandler(_evt:IOErrorEvent):void {
			if (loadnum < 3) {
				loading = false;
				T=setTimeout(load,loadnum*20,true);
			}else {
				dispatchEvent (new Event("ERROR"));
			}
		}
		public function loadCompleteHandler(_evt:Event = null):void {
			loading = false;
			dispatchEvent (new Event(Event.COMPLETE));
			contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
			contentLoaderInfo.removeEventListener (Event.COMPLETE, loadCompleteHandler);
			//trace("加载成功");
		}
		private function removeFormStage(_evt:Event):void {
			clearTimeout(T);			
			if (loading) loader.unloadAndStop ();
			contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
			contentLoaderInfo.removeEventListener (Event.COMPLETE, loadCompleteHandler);
			removeEventListener (Event.REMOVED_FROM_STAGE, removeFormStage);
		}
	}
	
}