package flash023.ui
{
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import flash023.events.SliderEvent;
	import com.greensock.TweenMax;
	/**
	 * @author FLASH023
	 * @date 2011-10-12 17:06
	**/
	public class ScrollBar extends Sprite  
	{
		private var _v:Number;
		private var h:int;
		private var _target:MovieClip;
		public function ScrollBar():void {
			h = 100;
			bar_mc.buttonMode = true;
			bar_mc.mouseChildren = false;
			bar_mc.addEventListener (MouseEvent.MOUSE_DOWN, mouseDown);
		}
		private function mouseDown(e:MouseEvent):void 
		{
			bar_mc.startDrag(false, new Rectangle(0, 12.8, 0, h-bar_mc.height));
			stage.addEventListener (MouseEvent.MOUSE_MOVE, mouseMove);
			stage.addEventListener (MouseEvent.MOUSE_UP, mouseUp);
		}
		
		private function mouseUp(e:MouseEvent):void 
		{
			stopDrag ();
			stage.removeEventListener (MouseEvent.MOUSE_MOVE, mouseMove);
			stage.removeEventListener (MouseEvent.MOUSE_UP, mouseUp);
		}
		
		private function mouseMove(e:MouseEvent):void 
		{
			_v = (bar_mc.y - 12.8) / (h - bar_mc.height);
			trace(_v);
			if (name.charAt (0) == "v") {
				TweenMax.to(_target, .3, { x:_target.mask.x+_target.mask.width *.5-(_v-.5)*(_target.width -_target.mask.width) } );
			}else {
				TweenMax.to(_target, .3, { y:_target.mask.y+_target.mask.height *.5-(_v-.5)*(_target.height -_target.mask.height)} );
			}
			
		}
		public function set value(_n:Number ):void {
			if (_n > 1)_n = 1;
			if (_n < 0)_n = 0;
			_v = _n;
			bar_mc.y = 12.8 + _v * (h - bar_mc.height);
		}
		public function get value():Number {
			return _v;
		}
		public function setHeight(_h:int):void {
			line_mc.height = _h;
			h = _h - 25.6;
			down_btn.y = _h - 12.8;
		}
		public function setScale(_s:Number ):void {
			bar_mc.height = _s * h;
			if (bar_mc.height < 16) bar_mc.height = 16;
			visible = _s < 1;
			bar_mc.y = (h - bar_mc.height ) * .5;
		}
		public function set target(_mc:MovieClip ):void {
			_target = _mc;
			if (name.charAt (0) == "v") {
				setScale(_mc.mask.width / _mc.width);
			}else {
				setScale(_mc.mask.height / _mc.height);
			}
			
		}
	}
	
}