package flash023.ui
{
	import flash.display.Sprite;
	import com.greensock.TweenMax;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash023.events.SliderEvent;
	import flash.geom.Rectangle;
	/**
	 * @author FLASH023
	 * @date 2011-10-12 9:03
	**/
	public class SliderClip extends Sprite 
	{
		private var _v:Number;
		public function SliderClip():void {
			value = .5;
			_btn.addEventListener (MouseEvent.MOUSE_DOWN, mouseDown);
		}
		
		private function mouseDown(e:MouseEvent):void 
		{
			_btn.startDrag(false, new Rectangle(5, 16.25, 75, 0));
			dispatchEvent (new SliderEvent(SliderEvent.CHANGE_START,_v));
			stage.addEventListener (MouseEvent.MOUSE_MOVE, mouseMove);
			stage.addEventListener (MouseEvent.MOUSE_UP, mouseUp);
		}
		
		private function mouseUp(e:MouseEvent):void 
		{
			stopDrag ();
			dispatchEvent (new SliderEvent(SliderEvent.CHANGE_END,_v));
			stage.removeEventListener (MouseEvent.MOUSE_MOVE, mouseMove);
			stage.removeEventListener (MouseEvent.MOUSE_UP, mouseUp);
		}
		
		private function mouseMove(e:MouseEvent):void 
		{
			_v = (_btn.x - 5) / 70;
			dispatchEvent (new SliderEvent(SliderEvent.CHANGE_ING, _v,true));
		}
		private function tweenComplete():void {
			stage.addEventListener (MouseEvent.MOUSE_MOVE, checkHit);
		}
		
		private function checkHit(e:MouseEvent):void 
		{
			var _p:Point = new Point (mouseX, mouseY);
			_p = localToGlobal(_p);
			if (!this.hitTestPoint(_p.x, _p.y,true)) {
				hide();
			}
		}
		public function set value(_n:Number ):void {
			if(name!="r_mc")if (_n > 1)_n = 1;
			if (_n < 0)_n = 0;
			_v = _n;
			_btn.x = 5 + _v * 70;
		}
		public function get value():Number {
			return _v;
		}
		public function reset():void {
			value = .5;
			hide();
		}
		public function hide(_b:Boolean = false ):void {
			TweenMax.to(this, _b?0:.3, { autoAlpha:0 } );
			stage.removeEventListener (MouseEvent.MOUSE_MOVE, checkHit);
		}
		public function show():void {
			TweenMax.to(this, .3, { autoAlpha:1,onComplete:tweenComplete } );
		}
	}
	
	
}