/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.lib.manual.IManualPage;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualPages;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonStreamParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.EnumRarity;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.client.manual.pages.IIManualPageContributorSkin;

public class CustomSkinHandler {
    public static final LinkedHashMap<String, SpecialSkin> specialSkins = new LinkedHashMap();
    public static final LinkedHashMap<String, ArrayList<SpecialSkin>> specialSkinsByUUID = new LinkedHashMap();

    public static void getManualPages() {
        ManualHelper.getManual().manualContents.removeAll((Object)"contributor_skins");
        ArrayList<Object> skin_pages = new ArrayList<Object>();
        skin_pages.add(new ManualPages.Text(ManualHelper.getManual(), "contributor_skins"));
        for (SpecialSkin skin : specialSkins.values()) {
            skin_pages.add((Object)new IIManualPageContributorSkin(ManualHelper.getManual(), skin));
        }
        ManualInstance.ManualEntry contributor_skins = ManualHelper.getManual().getEntry("contributor_skins");
        if (contributor_skins == null) {
            contributor_skins = new ManualInstance.ManualEntry("contributor_skins", "ii_warfare", new IManualPage[0]);
            ManualHelper.getManual().manualContents.put((Object)"ii_warfare", (Object)contributor_skins);
        }
        contributor_skins.setPages((IManualPage[])skin_pages.toArray(new ManualPages[0]));
    }

    public static class ThreadContributorSpecialsDownloader
    extends Thread {
        public static ThreadContributorSpecialsDownloader activeThread;

        public ThreadContributorSpecialsDownloader() {
            this.setName("Immersive Intelligence Contributors Thread");
            this.setDaemon(true);
            this.start();
            activeThread = this;
        }

        @Override
        public void run() {
            Gson gson = new Gson();
            try {
                ImmersiveIntelligence.logger.info("Attempting to download II special skin list from GitHub");
                URL url = new URL("https://raw.githubusercontent.com/Pabilo8/ImmersiveIntelligence/master/contributor_skins.json");
                specialSkins.clear();
                specialSkinsByUUID.clear();
                JsonStreamParser parser = new JsonStreamParser((Reader)new InputStreamReader(url.openStream()));
                JsonArray array = parser.next().getAsJsonArray();
                for (JsonElement jsonElement : array) {
                    try {
                        JsonObject jsonObject = jsonElement.getAsJsonObject();
                        String name = jsonObject.get("name").getAsString();
                        ArrayList uuid = new ArrayList();
                        ArrayList appliesTo = new ArrayList();
                        ArrayList<String> mods = new ArrayList<String>();
                        jsonObject.get("uuid").getAsJsonArray().iterator().forEachRemaining(jsonElement1 -> uuid.add(jsonElement1.getAsString()));
                        jsonObject.get("appliesTo").getAsJsonArray().iterator().forEachRemaining(jsonElement1 -> appliesTo.add(jsonElement1.getAsString()));
                        jsonObject.get("mods").getAsJsonArray().iterator().forEachRemaining(jsonElement1 -> mods.add(jsonElement1.getAsString()));
                        SpecialSkin skin = new SpecialSkin(name, uuid.toArray(new String[0]), appliesTo.toArray(new String[0]), mods);
                        specialSkins.put(skin.name, skin);
                        if (skin.uuid == null) continue;
                        for (String id : skin.uuid) {
                            if (specialSkinsByUUID.containsKey(id)) {
                                specialSkinsByUUID.get(id).add(skin);
                                continue;
                            }
                            specialSkinsByUUID.put(id, new ArrayList<SpecialSkin>(Collections.singleton(skin)));
                        }
                    }
                    catch (Exception excepParse) {
                        ImmersiveIntelligence.logger.warn((Object)excepParse);
                    }
                }
                specialSkins.values().forEach(SpecialSkin::parseAdditionals);
                StringBuilder builder = new StringBuilder("Loaded skins: ");
                specialSkins.values().forEach(specialSkin -> builder.append(specialSkin.name).append(", "));
                ImmersiveIntelligence.logger.info(builder.delete(builder.lastIndexOf(", "), builder.length()).toString());
            }
            catch (Exception e) {
                ImmersiveIntelligence.logger.info("Could not load contributor special skin list.");
                e.printStackTrace();
            }
        }
    }

    public static class SpecialSkin {
        public final String name;
        public final String[] uuid;
        public final String[] appliesTo;
        public final List<String> mods;
        public int textColor = 0xFFFFFF;
        public EnumRarity rarity = EnumRarity.UNCOMMON;

        public SpecialSkin(String name, String[] uuid, String[] appliesTo, List<String> mods) {
            this.name = name;
            this.uuid = uuid;
            this.appliesTo = appliesTo;
            this.mods = mods;
        }

        void parseAdditionals() {
            Optional<String> optional = this.mods.stream().filter(s -> s.contains("text_color=")).findFirst();
            optional.ifPresent(s -> {
                this.textColor = Integer.parseInt(s.substring(11), 16);
            });
            this.mods.removeIf(s -> s.contains("text_color="));
            optional = this.mods.stream().filter(s -> s.contains("rarity=")).findFirst();
            optional.map(s -> s.substring(7).replace('/', ':')).ifPresent(substring -> Arrays.stream(EnumRarity.values()).filter(rarity -> rarity.field_77934_f.equals(substring)).forEach(rarity -> {
                this.rarity = rarity;
            }));
            this.mods.removeIf(s -> s.contains("rarity="));
        }
    }
}

