/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import pl.pabilo8.immersiveintelligence.Config;

public class CoagulatorRecipe
extends MultiblockRecipe {
    public static float energyModifier = 1.0f;
    public static float timeModifier = 1.0f;
    public final FluidStack fluidInput;
    public final FluidStack coagulantInput;
    public final ItemStack itemOutput;
    public static LinkedList<CoagulatorRecipe> recipeList = new LinkedList();
    public static HashMap<ItemStack, Integer> dryingMap = new HashMap();
    int totalProcessTime;
    int totalProcessEnergy;

    public CoagulatorRecipe(ItemStack itemOutput, FluidStack fluidInput, FluidStack coagulantInput, int energy, int mixingTime) {
        this.itemOutput = itemOutput;
        this.fluidInput = fluidInput;
        this.coagulantInput = coagulantInput;
        this.totalProcessEnergy = (int)Math.floor((float)energy * energyModifier);
        this.totalProcessTime = (int)Math.floor((float)mixingTime * timeModifier);
        this.fluidInputList = new ArrayList();
        this.fluidInputList.add(this.fluidInput);
        this.fluidInputList.add(this.coagulantInput);
        this.outputList = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{itemOutput});
    }

    public static CoagulatorRecipe addRecipe(ItemStack itemOutput, FluidStack fluidInput, FluidStack coagulantInput, int energy, int mixingTime, int dryingTime) {
        CoagulatorRecipe r = new CoagulatorRecipe(itemOutput, fluidInput, coagulantInput, energy, mixingTime);
        recipeList.add(r);
        dryingMap.put(itemOutput, dryingTime);
        return r;
    }

    public static List<CoagulatorRecipe> removeRecipesForOutput(ItemStack stack) {
        ArrayList<CoagulatorRecipe> list = new ArrayList<CoagulatorRecipe>();
        Iterator it = recipeList.iterator();
        while (it.hasNext()) {
            CoagulatorRecipe ir = (CoagulatorRecipe)((Object)it.next());
            if (!OreDictionary.itemMatches((ItemStack)ir.itemOutput, (ItemStack)stack, (boolean)true)) continue;
            list.add(ir);
            it.remove();
        }
        return list;
    }

    public static CoagulatorRecipe findRecipe(FluidStack fluidInput, FluidStack coagulantInput) {
        for (CoagulatorRecipe recipe : recipeList) {
            if (!fluidInput.isFluidEqual(recipe.fluidInput) || fluidInput.amount < recipe.fluidInput.amount || !coagulantInput.isFluidEqual(recipe.coagulantInput) || coagulantInput.amount < recipe.coagulantInput.amount) continue;
            return recipe;
        }
        return null;
    }

    @Nonnull
    public static FluidStack getFluidForOutputStack(ItemStack effect) {
        for (CoagulatorRecipe recipe : recipeList) {
            if (!OreDictionary.itemMatches((ItemStack)effect, (ItemStack)recipe.itemOutput, (boolean)false)) continue;
            return recipe.fluidInput;
        }
        return new FluidStack(FluidRegistry.WATER, 1000);
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("fluid_input", (NBTBase)this.fluidInput.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("coagulant_input", (NBTBase)this.coagulantInput.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public static CoagulatorRecipe loadFromNBT(NBTTagCompound nbt) {
        IngredientStack item_input = IngredientStack.readFromNBT((NBTTagCompound)nbt.func_74775_l("item_input"));
        FluidStack fluidInput = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("fluid_input"));
        FluidStack coagulantInput = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("coagulant_input"));
        return CoagulatorRecipe.findRecipe(fluidInput, coagulantInput);
    }

    public static int getBucketProgressForStack(ItemStack stack) {
        return dryingMap.entrySet().stream().filter(e -> OreDictionary.itemMatches((ItemStack)((ItemStack)e.getKey()), (ItemStack)stack, (boolean)false)).map(Map.Entry::getValue).findFirst().orElse(Config.IIConfig.Machines.Coagulator.bucketTime);
    }

    public int getTotalProcessTime() {
        return this.totalProcessTime;
    }

    public int getTotalProcessEnergy() {
        return this.totalProcessEnergy;
    }
}

