/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.crafting;

import net.minecraft.nbt.NBTTagCompound;

public class DustStack {
    public final String name;
    public int amount;

    public DustStack(String name, int amount) {
        this.name = name;
        this.amount = amount;
    }

    public DustStack(NBTTagCompound nbt) {
        this(nbt.func_74779_i("name"), nbt.func_74762_e("amount"));
    }

    public DustStack getSubtracted(DustStack dust) {
        if (this.amount > dust.amount) {
            return new DustStack(this.name, this.amount - dust.amount);
        }
        return DustStack.getEmptyStack();
    }

    public boolean isEmpty() {
        return "".equals(this.name) || this.amount == 0;
    }

    public static DustStack getEmptyStack() {
        return new DustStack("", 0);
    }

    public DustStack copy() {
        return new DustStack(this.name, this.amount);
    }

    public boolean canMergeWith(DustStack other) {
        return this.isEmpty() || other.isEmpty() || other.name.equals(this.name);
    }

    public DustStack mergeWith(DustStack other) {
        return new DustStack(this.isEmpty() ? other.name : this.name, this.amount + other.amount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DustStack)) {
            return false;
        }
        DustStack dustStack = (DustStack)o;
        return this.amount == dustStack.amount && this.name.equals(dustStack.name);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("name", this.name);
        nbt.func_74768_a("amount", this.amount);
        return nbt;
    }
}

