/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.first.TileEntityChemicalPainter;

public class PaintingRecipe
extends MultiblockRecipe {
    public static float energyModifier = 1.0f;
    public static float timeModifier = 1.0f;
    public static float paintModifier = 1.0f;
    public final BiFunction<Integer, ItemStack, ItemStack> process;
    public final IngredientStack itemInput;
    public static LinkedList<PaintingRecipe> recipeList = new LinkedList();
    int paintAmount;
    int totalProcessTime;
    int totalProcessEnergy;

    public PaintingRecipe(BiFunction<Integer, ItemStack, ItemStack> process, Object itemInput, int energy, int time, int paintAmount) {
        this.process = process;
        this.itemInput = ApiUtils.createIngredientStack((Object)itemInput);
        this.totalProcessEnergy = (int)Math.floor((float)energy * energyModifier);
        this.totalProcessTime = (int)Math.floor((float)time * timeModifier);
        this.paintAmount = (int)Math.floor((float)time * paintModifier);
        this.inputList = Lists.newArrayList((Object[])new IngredientStack[]{this.itemInput});
        this.outputList = this.getExampleColoredItems();
    }

    private NonNullList<ItemStack> getExampleColoredItems() {
        NonNullList list = NonNullList.func_191196_a();
        Set collect = Arrays.stream(EnumDyeColor.values()).map(enumDyeColor -> {
            float[] values = enumDyeColor.func_193349_f();
            return Utils.rgb(values[0], values[1], values[2]);
        }).map(integer -> this.process.apply((Integer)integer, this.itemInput.getExampleStack().func_77946_l())).collect(Collectors.toSet());
        list.addAll(collect);
        return list;
    }

    public static PaintingRecipe addRecipe(BiFunction<Integer, ItemStack, ItemStack> process, IngredientStack itemInput, int energy, int time, int paintAmount) {
        PaintingRecipe r = new PaintingRecipe(process, itemInput, energy, time, paintAmount);
        recipeList.add(r);
        return r;
    }

    public static List<PaintingRecipe> removeRecipesForInput(ItemStack stack) {
        ArrayList<PaintingRecipe> list = new ArrayList<PaintingRecipe>();
        Iterator it = recipeList.iterator();
        while (it.hasNext()) {
            PaintingRecipe ir = (PaintingRecipe)((Object)it.next());
            if (!ir.itemInput.matchesItemStack(stack)) continue;
            list.add(ir);
            it.remove();
        }
        return list;
    }

    public static PaintingRecipe findRecipe(ItemStack input) {
        return recipeList.stream().filter(recipe -> recipe.itemInput.matchesItemStack(input)).findFirst().orElse(null);
    }

    public NonNullList<ItemStack> getActualItemOutputs(TileEntity te) {
        if (te instanceof TileEntityChemicalPainter) {
            return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{this.process.apply(((TileEntityChemicalPainter)te).color, ((ItemStack)((TileEntityChemicalPainter)te).inventory.get(0)).func_77946_l())});
        }
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[0]);
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("item_input", (NBTBase)this.itemInput.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public static PaintingRecipe loadFromNBT(NBTTagCompound nbt) {
        IngredientStack item_input = IngredientStack.readFromNBT((NBTTagCompound)nbt.func_74775_l("item_input"));
        FluidStack fluid_input = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("fluid_input"));
        return PaintingRecipe.findRecipe(item_input.stack);
    }

    public int getTotalProcessTime() {
        return this.totalProcessTime;
    }

    public int getTotalProcessEnergy() {
        return this.totalProcessEnergy;
    }

    public int getPaintAmount() {
        return this.paintAmount;
    }
}

