/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.common.util.ListUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class VulcanizerRecipe
extends MultiblockRecipe {
    public static float energyModifier = 1.0f;
    public static float timeModifier = 1.0f;
    public final IngredientStack input;
    public final IngredientStack compoundInput;
    public final IngredientStack sulfurInput;
    public final ComparableItemStack mold;
    public final ItemStack output;
    int totalProcessTime;
    int totalProcessEnergy;
    public final ResourceLocation resIn;
    public final ResourceLocation resOut;
    public static final ResourceLocation TEXTURE_LATEX = new ResourceLocation("immersiveintelligence", "textures/blocks/multiblock/vulcanizer/latex_strip.png");
    public static final ResourceLocation TEXTURE_RUBBER = new ResourceLocation("immersiveintelligence", "textures/blocks/multiblock/vulcanizer/rubber_strip.png");
    public static ArrayListMultimap<ComparableItemStack, VulcanizerRecipe> recipeList = ArrayListMultimap.create();
    public static HashMap<String, Function<NBTTagCompound, VulcanizerRecipe>> deserializers = new HashMap();

    public VulcanizerRecipe(ItemStack output, ComparableItemStack mold, IngredientStack mainInput, IngredientStack compoundInput, IngredientStack sulfurInput, int energy, ResourceLocation resIn, ResourceLocation resOut) {
        this.output = output;
        this.mold = mold;
        this.input = ApiUtils.createIngredientStack((Object)mainInput);
        this.compoundInput = ApiUtils.createIngredientStack((Object)compoundInput);
        this.sulfurInput = ApiUtils.createIngredientStack((Object)sulfurInput);
        this.totalProcessEnergy = (int)Math.floor((float)energy * energyModifier);
        this.totalProcessTime = (int)Math.floor(1000.0f * timeModifier);
        this.inputList = Lists.newArrayList((Object[])new IngredientStack[]{this.input, this.compoundInput, this.sulfurInput, new IngredientStack(this.mold.stack)});
        this.outputList = ListUtils.fromItem((ItemStack)this.output);
        this.resIn = resIn;
        this.resOut = resOut;
    }

    public VulcanizerRecipe setInputSize(int size) {
        this.input.inputSize = size;
        return this;
    }

    public boolean matches(ItemStack mold, ItemStack input) {
        return this.input.matches((Object)input);
    }

    public VulcanizerRecipe getActualRecipe(ItemStack mold, ItemStack input) {
        return this;
    }

    public static VulcanizerRecipe addRecipe(ItemStack output, ComparableItemStack mold, IngredientStack input, IngredientStack compound, IngredientStack sulfur, int energy) {
        return VulcanizerRecipe.addRecipe(output, mold, input, compound, sulfur, energy, TEXTURE_LATEX, TEXTURE_RUBBER);
    }

    public static VulcanizerRecipe addRecipe(ItemStack output, ComparableItemStack mold, IngredientStack input, IngredientStack compound, IngredientStack sulfur, int energy, ResourceLocation resIn, ResourceLocation resOut) {
        VulcanizerRecipe r = new VulcanizerRecipe(output, mold, input, compound, sulfur, energy, resIn, resOut);
        recipeList.put((Object)mold, (Object)r);
        return r;
    }

    public static VulcanizerRecipe findRecipe(ItemStack mold, ItemStack input) {
        if (mold.func_190926_b() || input.func_190926_b()) {
            return null;
        }
        ComparableItemStack comp = ApiUtils.createComparableItemStack((ItemStack)mold, (boolean)false);
        List list = recipeList.get((Object)comp);
        for (VulcanizerRecipe recipe : list) {
            if (!recipe.matches(mold, input)) continue;
            return recipe.getActualRecipe(mold, input);
        }
        return null;
    }

    public static List<VulcanizerRecipe> removeRecipes(ItemStack output) {
        ArrayList<VulcanizerRecipe> list = new ArrayList<VulcanizerRecipe>();
        HashSet keySet = new HashSet(recipeList.keySet());
        for (ComparableItemStack mold : keySet) {
            Iterator it = recipeList.get((Object)mold).iterator();
            while (it.hasNext()) {
                VulcanizerRecipe ir = (VulcanizerRecipe)((Object)it.next());
                if (!OreDictionary.itemMatches((ItemStack)ir.output, (ItemStack)output, (boolean)true)) continue;
                list.add(ir);
                it.remove();
            }
        }
        return list;
    }

    public static boolean isValidMold(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        return recipeList.containsKey((Object)ApiUtils.createComparableItemStack((ItemStack)itemStack, (boolean)false));
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("mold", (NBTBase)this.mold.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("input", (NBTBase)this.input.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public int getTotalProcessTime() {
        return this.totalProcessTime;
    }

    public int getTotalProcessEnergy() {
        return this.totalProcessEnergy;
    }

    public static VulcanizerRecipe loadFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("type") && deserializers.containsKey(nbt.func_74779_i("type"))) {
            return deserializers.get(nbt.func_74779_i("type")).apply(nbt);
        }
        IngredientStack input = IngredientStack.readFromNBT((NBTTagCompound)nbt.func_74775_l("input"));
        ComparableItemStack mold = ComparableItemStack.readFromNBT((NBTTagCompound)nbt.func_74775_l("mold"));
        List list = recipeList.get((Object)mold);
        for (VulcanizerRecipe recipe : list) {
            if (!recipe.input.equals((Object)input)) continue;
            return recipe;
        }
        return null;
    }
}

