/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import pl.pabilo8.immersiveintelligence.api.data.operators.DataOperator;
import pl.pabilo8.immersiveintelligence.api.data.operators.advanced_arithmetic.DataOperationMax;
import pl.pabilo8.immersiveintelligence.api.data.operators.advanced_arithmetic.DataOperationMin;
import pl.pabilo8.immersiveintelligence.api.data.operators.advanced_arithmetic.DataOperationPower;
import pl.pabilo8.immersiveintelligence.api.data.operators.advanced_arithmetic.DataOperationRoot;
import pl.pabilo8.immersiveintelligence.api.data.operators.advanced_logic.DataOperationNAND;
import pl.pabilo8.immersiveintelligence.api.data.operators.advanced_logic.DataOperationNOR;
import pl.pabilo8.immersiveintelligence.api.data.operators.advanced_logic.DataOperationXNOR;
import pl.pabilo8.immersiveintelligence.api.data.operators.advanced_logic.DataOperationXOR;
import pl.pabilo8.immersiveintelligence.api.data.operators.arithmetic.DataOperationAdd;
import pl.pabilo8.immersiveintelligence.api.data.operators.arithmetic.DataOperationDivide;
import pl.pabilo8.immersiveintelligence.api.data.operators.arithmetic.DataOperationModulo;
import pl.pabilo8.immersiveintelligence.api.data.operators.arithmetic.DataOperationMultiply;
import pl.pabilo8.immersiveintelligence.api.data.operators.arithmetic.DataOperationSubtract;
import pl.pabilo8.immersiveintelligence.api.data.operators.array.DataOperationGet;
import pl.pabilo8.immersiveintelligence.api.data.operators.array.DataOperationPop;
import pl.pabilo8.immersiveintelligence.api.data.operators.array.DataOperationPush;
import pl.pabilo8.immersiveintelligence.api.data.operators.comparators.DataOperationEqual;
import pl.pabilo8.immersiveintelligence.api.data.operators.comparators.DataOperationGreater;
import pl.pabilo8.immersiveintelligence.api.data.operators.comparators.DataOperationGreaterOrEqual;
import pl.pabilo8.immersiveintelligence.api.data.operators.comparators.DataOperationLess;
import pl.pabilo8.immersiveintelligence.api.data.operators.comparators.DataOperationLessOrEqual;
import pl.pabilo8.immersiveintelligence.api.data.operators.document.DataOperationDocumentGetAuthor;
import pl.pabilo8.immersiveintelligence.api.data.operators.document.DataOperationDocumentGetTitle;
import pl.pabilo8.immersiveintelligence.api.data.operators.document.DataOperationDocumentReadAllPagesArray;
import pl.pabilo8.immersiveintelligence.api.data.operators.document.DataOperationDocumentReadAllPagesString;
import pl.pabilo8.immersiveintelligence.api.data.operators.document.DataOperationDocumentReadPage;
import pl.pabilo8.immersiveintelligence.api.data.operators.entity.DataOperationGetEntityDimensionID;
import pl.pabilo8.immersiveintelligence.api.data.operators.entity.DataOperationGetEntityID;
import pl.pabilo8.immersiveintelligence.api.data.operators.entity.DataOperationGetEntityName;
import pl.pabilo8.immersiveintelligence.api.data.operators.entity.DataOperationGetEntityPosX;
import pl.pabilo8.immersiveintelligence.api.data.operators.entity.DataOperationGetEntityPosY;
import pl.pabilo8.immersiveintelligence.api.data.operators.entity.DataOperationGetEntityPosZ;
import pl.pabilo8.immersiveintelligence.api.data.operators.entity.DataOperationGetEntityType;
import pl.pabilo8.immersiveintelligence.api.data.operators.itemstack.DataOperationCanStackWith;
import pl.pabilo8.immersiveintelligence.api.data.operators.itemstack.DataOperationGetDurability;
import pl.pabilo8.immersiveintelligence.api.data.operators.itemstack.DataOperationGetItemID;
import pl.pabilo8.immersiveintelligence.api.data.operators.itemstack.DataOperationGetItemStack;
import pl.pabilo8.immersiveintelligence.api.data.operators.itemstack.DataOperationGetNBT;
import pl.pabilo8.immersiveintelligence.api.data.operators.itemstack.DataOperationGetQuantity;
import pl.pabilo8.immersiveintelligence.api.data.operators.itemstack.DataOperationIsStackEmpty;
import pl.pabilo8.immersiveintelligence.api.data.operators.itemstack.DataOperationMatchesOreDictionary;
import pl.pabilo8.immersiveintelligence.api.data.operators.itemstack.DataOperationSetDurability;
import pl.pabilo8.immersiveintelligence.api.data.operators.itemstack.DataOperationSetNBT;
import pl.pabilo8.immersiveintelligence.api.data.operators.itemstack.DataOperationSetQuantity;
import pl.pabilo8.immersiveintelligence.api.data.operators.logic.DataOperationAND;
import pl.pabilo8.immersiveintelligence.api.data.operators.logic.DataOperationNOT;
import pl.pabilo8.immersiveintelligence.api.data.operators.logic.DataOperationOR;
import pl.pabilo8.immersiveintelligence.api.data.operators.text.DataOperationStringCamelCase;
import pl.pabilo8.immersiveintelligence.api.data.operators.text.DataOperationStringCharAt;
import pl.pabilo8.immersiveintelligence.api.data.operators.text.DataOperationStringContains;
import pl.pabilo8.immersiveintelligence.api.data.operators.text.DataOperationStringContainsCount;
import pl.pabilo8.immersiveintelligence.api.data.operators.text.DataOperationStringEqual;
import pl.pabilo8.immersiveintelligence.api.data.operators.text.DataOperationStringFormat;
import pl.pabilo8.immersiveintelligence.api.data.operators.text.DataOperationStringHexcol;
import pl.pabilo8.immersiveintelligence.api.data.operators.text.DataOperationStringJoin;
import pl.pabilo8.immersiveintelligence.api.data.operators.text.DataOperationStringLength;
import pl.pabilo8.immersiveintelligence.api.data.operators.text.DataOperationStringLowerCase;
import pl.pabilo8.immersiveintelligence.api.data.operators.text.DataOperationStringReverse;
import pl.pabilo8.immersiveintelligence.api.data.operators.text.DataOperationStringSnakeCase;
import pl.pabilo8.immersiveintelligence.api.data.operators.text.DataOperationStringSplit;
import pl.pabilo8.immersiveintelligence.api.data.operators.text.DataOperationStringSubstring;
import pl.pabilo8.immersiveintelligence.api.data.operators.text.DataOperationStringTrim;
import pl.pabilo8.immersiveintelligence.api.data.operators.text.DataOperationStringUpperCase;
import pl.pabilo8.immersiveintelligence.api.data.operators.type_conversion.DataOperationIsNull;
import pl.pabilo8.immersiveintelligence.api.data.operators.type_conversion.DataOperationToBoolean;
import pl.pabilo8.immersiveintelligence.api.data.operators.type_conversion.DataOperationToInteger;
import pl.pabilo8.immersiveintelligence.api.data.operators.type_conversion.DataOperationToNull;
import pl.pabilo8.immersiveintelligence.api.data.operators.type_conversion.DataOperationToString;

public class DataOperations {
    public static final Map<String, Class<? extends DataOperator>> operations = new HashMap<String, Class<? extends DataOperator>>();

    @Nonnull
    public static DataOperator getOperatorInstance(String name) {
        Class<? extends DataOperator> c = operations.get(name);
        if (c != null) {
            try {
                return c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return new DataOperationAdd();
    }

    static {
        operations.put("add", DataOperationAdd.class);
        operations.put("subtract", DataOperationSubtract.class);
        operations.put("multiply", DataOperationMultiply.class);
        operations.put("divide", DataOperationDivide.class);
        operations.put("modulo", DataOperationModulo.class);
        operations.put("power", DataOperationPower.class);
        operations.put("root", DataOperationRoot.class);
        operations.put("max", DataOperationMax.class);
        operations.put("min", DataOperationMin.class);
        operations.put("greater", DataOperationGreater.class);
        operations.put("less", DataOperationLess.class);
        operations.put("greater_or_equal", DataOperationGreaterOrEqual.class);
        operations.put("less_or_equal", DataOperationLessOrEqual.class);
        operations.put("equal", DataOperationEqual.class);
        operations.put("and", DataOperationAND.class);
        operations.put("or", DataOperationOR.class);
        operations.put("not", DataOperationNOT.class);
        operations.put("nand", DataOperationNAND.class);
        operations.put("nor", DataOperationNOR.class);
        operations.put("xor", DataOperationXOR.class);
        operations.put("xnor", DataOperationXNOR.class);
        operations.put("string_join", DataOperationStringJoin.class);
        operations.put("string_equal", DataOperationStringEqual.class);
        operations.put("string_split", DataOperationStringSplit.class);
        operations.put("string_length", DataOperationStringLength.class);
        operations.put("string_char_at", DataOperationStringCharAt.class);
        operations.put("string_substring", DataOperationStringSubstring.class);
        operations.put("string_trim", DataOperationStringTrim.class);
        operations.put("string_hexcol", DataOperationStringHexcol.class);
        operations.put("string_format", DataOperationStringFormat.class);
        operations.put("string_contains", DataOperationStringContains.class);
        operations.put("string_contains_count", DataOperationStringContainsCount.class);
        operations.put("string_lowercase", DataOperationStringLowerCase.class);
        operations.put("string_uppercase", DataOperationStringUpperCase.class);
        operations.put("string_snake_case", DataOperationStringSnakeCase.class);
        operations.put("string_camel_case", DataOperationStringCamelCase.class);
        operations.put("string_reverse", DataOperationStringReverse.class);
        operations.put("get_quantity", DataOperationGetQuantity.class);
        operations.put("set_quantity", DataOperationSetQuantity.class);
        operations.put("get_durability", DataOperationGetDurability.class);
        operations.put("set_durability", DataOperationSetDurability.class);
        operations.put("get_nbt", DataOperationGetNBT.class);
        operations.put("set_nbt", DataOperationSetNBT.class);
        operations.put("get_item_id", DataOperationGetItemID.class);
        operations.put("get_itemstack", DataOperationGetItemStack.class);
        operations.put("is_stack_empty", DataOperationIsStackEmpty.class);
        operations.put("can_stack_with", DataOperationCanStackWith.class);
        operations.put("matches_oredict", DataOperationMatchesOreDictionary.class);
        operations.put("entity_get_id", DataOperationGetEntityID.class);
        operations.put("entity_get_type", DataOperationGetEntityType.class);
        operations.put("entity_get_name", DataOperationGetEntityName.class);
        operations.put("entity_get_dimension_id", DataOperationGetEntityDimensionID.class);
        operations.put("entity_get_x", DataOperationGetEntityPosX.class);
        operations.put("entity_get_y", DataOperationGetEntityPosY.class);
        operations.put("entity_get_z", DataOperationGetEntityPosZ.class);
        operations.put("array_get", DataOperationGet.class);
        operations.put("array_pop", DataOperationPop.class);
        operations.put("array_push", DataOperationPush.class);
        operations.put("document_read_page", DataOperationDocumentReadPage.class);
        operations.put("document_read_all_pages_array", DataOperationDocumentReadAllPagesArray.class);
        operations.put("document_read_all_pages_string", DataOperationDocumentReadAllPagesString.class);
        operations.put("document_get_author", DataOperationDocumentGetAuthor.class);
        operations.put("document_get_title", DataOperationDocumentGetTitle.class);
        operations.put("is_null", DataOperationIsNull.class);
        operations.put("to_integer", DataOperationToInteger.class);
        operations.put("to_string", DataOperationToString.class);
        operations.put("to_boolean", DataOperationToBoolean.class);
        operations.put("to_null", DataOperationToNull.class);
    }
}

