/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.operators.array;

import java.util.ArrayList;
import java.util.Arrays;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.operators.DataOperator;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeAccessor;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeArray;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeExpression;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeNull;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;

public class DataOperationPush
extends DataOperator {
    public DataOperationPush() {
        this.name = "array_push";
        this.sign = "[]<<";
        this.allowedType1 = DataPacketTypeArray.class;
        this.allowedType2 = DataPacketTypeAccessor.class;
        this.expectedResult = DataPacketTypeNull.class;
    }

    @Override
    public IDataType execute(DataPacket packet, DataPacketTypeExpression data) {
        DataPacketTypeArray t1 = DataOperationPush.getVarInType(DataPacketTypeArray.class, data.getType1(), packet);
        IDataType t2 = data.getType2();
        for (int tries = 0; t2 instanceof DataPacketTypeAccessor && tries < 32; ++tries) {
            t2 = ((DataPacketTypeAccessor)t2).getRealValue(packet);
        }
        IDataType[] arr = t1.value;
        ArrayList<IDataType> iDataTypes = new ArrayList<IDataType>(Arrays.asList(arr));
        iDataTypes.add(t2);
        t1.value = iDataTypes.toArray(new IDataType[0]);
        return new DataPacketTypeNull();
    }
}

