/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.types;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeNull;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;

public class DataPacketTypeArray
implements IDataType {
    public IDataType[] value;

    public DataPacketTypeArray(IDataType ... i) {
        this.value = i;
    }

    public DataPacketTypeArray() {
    }

    @Override
    public String getName() {
        return "array";
    }

    @Override
    public String valueToString() {
        return Arrays.toString(this.value);
    }

    @Override
    public void setDefaultValue() {
        this.value = new IDataType[]{new DataPacketTypeNull()};
    }

    @Override
    public void valueFromNBT(NBTTagCompound n) {
        NBTTagList l = n.func_150295_c("Values", 10);
        ArrayList<IDataType> dataTypes = new ArrayList<IDataType>();
        for (NBTBase b : l) {
            NBTTagCompound c;
            if (!(b instanceof NBTTagCompound) || !(c = (NBTTagCompound)b).func_74764_b("Type")) continue;
            String type = c.func_74779_i("Type");
            IDataType data = null;
            try {
                data = (IDataType)DataPacket.varTypes.get(type).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
            if (data == null) continue;
            data.valueFromNBT(c);
            dataTypes.add(data);
        }
        this.value = dataTypes.toArray(new IDataType[0]);
    }

    @Override
    public NBTTagCompound valueToNBT() {
        NBTTagCompound nbt = this.getHeaderTag();
        NBTTagList list = new NBTTagList();
        for (IDataType type : this.value) {
            list.func_74742_a((NBTBase)type.valueToNBT());
        }
        nbt.func_74782_a("Values", (NBTBase)list);
        return nbt;
    }

    @Override
    public int getTypeColour() {
        return 5377067;
    }

    @Override
    public String textureLocation() {
        return "immersiveintelligence:textures/gui/data_types.png";
    }

    @Override
    public int getFrameOffset() {
        return 7;
    }
}

