/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.fx;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleCloud;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleBlockFragment;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleExplosion;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleFlame;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleFlareTrace;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleGasCloud;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleGunfire;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleRenderer;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleTMTModel;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleTracer;
import pl.pabilo8.immersiveintelligence.client.fx.nuke.ParticleAtomFog;
import pl.pabilo8.immersiveintelligence.client.fx.nuke.ParticleAtomicBoomCore;
import pl.pabilo8.immersiveintelligence.client.fx.nuke.ParticleAtomicBoomRing;
import pl.pabilo8.immersiveintelligence.client.fx.nuke.ParticleShockwave;
import pl.pabilo8.immersiveintelligence.client.tmt.ModelRendererTurbo;
import pl.pabilo8.immersiveintelligence.common.entity.EntityAtomicBoom;
import pl.pabilo8.immersiveintelligence.common.util.IIExplosion;

@SideOnly(value=Side.CLIENT)
public class ParticleUtils {
    @SideOnly(value=Side.CLIENT)
    public static ParticleRenderer particleRenderer = new ParticleRenderer();

    public static void spawnExplosionBoomFX(World world, double x, double y, double z, float radius, float strength, boolean flaming, boolean damagesTerrain) {
        ParticleUtils.spawnShockwave(x, y, z, radius, 0.75f * strength);
        if (radius < 6.0f) {
            ParticleUtils.spawnExplosionFX(x, y, z, 0.0, 0.0, 0.0, radius * 1.85f);
        }
        HashSet<BlockPos> positions = new HashSet<BlockPos>(new IIExplosion(world, null, x, y, z, radius, strength, flaming, true).generateAffectedBlockPositions());
        world.func_184148_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, x, y, z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        for (BlockPos position : positions) {
            int i;
            IBlockState state = world.func_180495_p(position);
            double d0 = (float)position.func_177958_n() + world.field_73012_v.nextFloat();
            double d1 = (float)position.func_177956_o() + world.field_73012_v.nextFloat();
            double d2 = (float)position.func_177952_p() + world.field_73012_v.nextFloat();
            double d3 = d0 - x;
            double d4 = d1 - y;
            double d5 = d2 - z;
            double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
            d3 /= d6;
            d4 /= d6;
            d5 /= d6;
            double d7 = 0.5 / (d6 / (double)radius + 0.1);
            ParticleUtils.spawnBlockFragmentFX(d0, d1, d2, d3 *= (d7 *= (double)(world.field_73012_v.nextFloat() * world.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7, 1.0f, state);
            world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (d0 + x) / 2.0, (d1 + y) / 2.0, (d2 + z) / 2.0, d3, d4, d5, new int[0]);
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, d3, d4, d5, new int[0]);
            Vec3d vv = new Vec3d((Vec3i)position).func_72441_c((double)Utils.RAND.nextFloat(), 0.0, (double)Utils.RAND.nextFloat());
            ParticleUtils.spawnExplosionFX(vv.field_72450_a, vv.field_72448_b, vv.field_72449_c, 0.0, 0.0, 0.0, 2.0f);
            if (flaming) {
                for (i = 0; i < 7; ++i) {
                    vv = new Vec3d((Vec3i)position).func_72441_c((double)Utils.RAND.nextFloat(), 0.0, (double)Utils.RAND.nextFloat());
                    ParticleUtils.spawnFlameFX(vv.field_72450_a, vv.field_72448_b, vv.field_72449_c, (Utils.RAND.nextFloat() - 0.5f) * 2.0f * strength, Utils.RAND.nextFloat() * 0.01f, (Utils.RAND.nextFloat() - 0.5f) * 2.0f * strength, 4.0f, 40 + 10 * i);
                    world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, vv.field_72450_a, vv.field_72448_b, vv.field_72449_c, (double)((Utils.RAND.nextFloat() - 0.5f) * 0.25f * strength), (double)(Utils.RAND.nextFloat() * 0.01f), (double)((Utils.RAND.nextFloat() - 0.5f) * 0.25f * strength), new int[0]);
                }
            }
            for (i = 0; i < 16; ++i) {
                vv = new Vec3d((Vec3i)position).func_72441_c((double)Utils.RAND.nextFloat(), 0.0, (double)Utils.RAND.nextFloat());
                ParticleUtils.spawnBlockFragmentFX(vv.field_72450_a, vv.field_72448_b, vv.field_72449_c, (Utils.RAND.nextFloat() - 0.5f) * 2.0f * strength, Utils.RAND.nextFloat() * strength * 1.5f, (Utils.RAND.nextFloat() - 0.5f) * 2.0f * strength, 1.0f, state);
            }
        }
    }

    public static void spawnBlockFragmentFX(double x, double y, double z, double mx, double my, double mz, float size, IBlockState state) {
        ParticleBlockFragment particle = new ParticleBlockFragment((World)ClientUtils.mc().field_71441_e, x, y, z, mx, my, mz, size, state);
        particle.init();
        particleRenderer.addEffect(particle);
    }

    public static void spawnTracerFX(double x, double y, double z, double mx, double my, double mz, float size, int color) {
        ParticleTracer particle = new ParticleTracer((World)ClientUtils.mc().field_71441_e, x, y, z, mx, my, mz, size, color);
        particleRenderer.addEffect(particle);
    }

    public static void spawnGunfireFX(double x, double y, double z, double mx, double my, double mz, float size) {
        ParticleGunfire particle = new ParticleGunfire((World)ClientUtils.mc().field_71441_e, x, y, z, mx, my, mz, size);
        particleRenderer.addEffect(particle);
    }

    public static void spawnTMTModelFX(double x, double y, double z, double mx, double my, double mz, float size, ModelRendererTurbo model, ResourceLocation texture) {
        ParticleTMTModel particle = new ParticleTMTModel((World)ClientUtils.mc().field_71441_e, x, y, z, mx, my, mz, size, model, texture);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
    }

    public static void spawnFlameFX(double x, double y, double z, double mx, double my, double mz, float size, int lifeTime) {
        ParticleFlame particle = new ParticleFlame((World)ClientUtils.mc().field_71441_e, x, y, z, mx, my, mz, size, lifeTime);
        particleRenderer.addEffect(particle);
    }

    public static void spawnExplosionFX(double x, double y, double z, double mx, double my, double mz, float size) {
        ParticleExplosion particle = new ParticleExplosion((World)ClientUtils.mc().field_71441_e, x, y, z, mx, my, mz, size);
        particleRenderer.addEffect(particle);
    }

    public static void spawnExplosionPhosphorusFX(double x, double y, double z) {
        for (int i = 0; i < 40; ++i) {
            Vec3d v = new Vec3d(1.0, 0.0, 0.0).func_178785_b((float)i / 10.0f * 360.0f);
            float level = (float)Math.floor((float)i / 10.0f);
            ParticleExplosion particle = new ParticleExplosion((World)ClientUtils.mc().field_71441_e, x, y + 0.025 + (double)(level * 0.65f), z, v.field_72450_a * 0.25 * ((double)(4.0f / level) * 0.175), 0.0125, v.field_72449_c * 0.25 * ((double)(4.0f / level) * 0.175), 4.0f);
            particleRenderer.addEffect(particle);
        }
    }

    public static void spawnFlameExplosion(double x, double y, double z, float size) {
        ParticleUtils.spawnFlameExplosion(x, y, z, size, Utils.RAND);
    }

    public static void spawnFlameExplosion(double x, double y, double z, float size, Random rand) {
        Vec3d v;
        int i = 0;
        while ((float)i < 20.0f * size) {
            v = new Vec3d(1.0, 0.0, 0.0).func_178785_b((float)i / 20.0f * 360.0f);
            ParticleCloud particle = (ParticleCloud)ClientUtils.mc().field_71452_i.func_178927_a(EnumParticleTypes.CLOUD.func_179348_c(), x, y + 0.25, z, v.field_72450_a * 0.25, 0.125, v.field_72449_c * 0.25, new int[]{4});
            if (particle != null) {
                particle.func_70538_b(rand.nextFloat() * 0.125f, rand.nextFloat() * 0.125f, 0.0f);
                particle.func_70541_f(2.5f);
                particle.func_187114_a(10);
            }
            ++i;
        }
        i = 0;
        while ((float)i < 100.0f * size) {
            v = new Vec3d(1.0, 0.0, 0.0).func_178785_b((float)i / 25.0f * 360.0f);
            float level = (float)Math.floor((float)i / 25.0f);
            ParticleUtils.spawnExplosionFX(x, y + 0.025 + (double)(level * 0.65f), z, v.field_72450_a * 0.25 * ((double)(4.0f / level) * 0.175), 0.0125, v.field_72449_c * 0.25 * ((double)(4.0f / level) * 0.175), 8.0f * size);
            ++i;
        }
    }

    public static void spawnShockwave(double x, double y, double z, float size, float speed) {
        int i = 0;
        while ((float)i < 50.0f * (size / 20.0f)) {
            Vec3d v = new Vec3d(1.0, 0.0, 0.0).func_178785_b((float)i / 50.0f * 360.0f);
            ParticleShockwave particle = new ParticleShockwave((World)ClientUtils.mc().field_71441_e, x, y, z, v.field_72450_a * (double)speed, -speed * 0.02f, v.field_72449_c * (double)speed, size);
            particle.func_187114_a((int)(40.0f * (speed / 2.5f)));
            particleRenderer.addEffect(particle);
            ++i;
        }
    }

    public static void spawnGasCloud(double x, double y, double z, float size, Fluid fluid) {
        Vec3d v = new Vec3d((double)Utils.RAND.nextFloat() - 0.5, 0.0, (double)Utils.RAND.nextFloat() - 0.5).func_186678_a((double)size);
        ParticleGasCloud particle = new ParticleGasCloud((World)ClientUtils.mc().field_71441_e, x + v.field_72450_a, y, z + v.field_72449_c, size * 16.0f, fluid);
        particle.func_187114_a((int)(80.0f * size));
        particleRenderer.addEffect(particle);
    }

    public static void spawnFog(double x, double y, double z, float size, float speed, float yspeed) {
        int i = 0;
        while ((float)i < 36.0f * (size / 20.0f)) {
            Vec3d v = new Vec3d(1.0, 0.0, 0.0).func_178785_b((float)i / 36.0f * 360.0f);
            ParticleAtomFog particle = new ParticleAtomFog((World)ClientUtils.mc().field_71441_e, x, y, z, v.field_72450_a * (double)speed, yspeed, v.field_72449_c * (double)speed, size);
            particle.func_187114_a((int)(40.0f * (size / 20.0f)));
            particleRenderer.addEffect(particle);
            ++i;
        }
    }

    public static void spawnAtomicBoomCore(EntityAtomicBoom atomicBoom, double x, double y, double z, float size, float speed, float yspeed) {
        int i = 0;
        while ((float)i < 36.0f * (size / 20.0f)) {
            Vec3d v = new Vec3d(1.5, 0.0, 0.0).func_178785_b((float)i / 36.0f * 360.0f);
            ParticleAtomicBoomCore particle = new ParticleAtomicBoomCore((World)ClientUtils.mc().field_71441_e, x + v.field_72450_a, y, z + v.field_72449_c, v.field_72450_a * (double)speed, yspeed, v.field_72449_c * (double)speed, size);
            particle.func_187114_a((int)(120.0f * (size / 20.0f)));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
            ++i;
        }
    }

    public static void spawnAtomicBoomRing(EntityAtomicBoom atomicBoom, double x, double y, double z, float size, float speed, float yspeed) {
        int i = 0;
        while ((float)i < 36.0f * (size / 20.0f)) {
            Vec3d v = new Vec3d(1.0, 0.0, 0.0).func_178785_b((float)i / 36.0f * 360.0f);
            ParticleAtomicBoomRing particle = new ParticleAtomicBoomRing((World)ClientUtils.mc().field_71441_e, x, y, z, v.field_72450_a * (double)speed, yspeed, v.field_72449_c * (double)speed, size);
            particle.func_187114_a((int)(40.0f * (size / 20.0f)));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
            ++i;
        }
    }

    public static void spawnFlareFX(double x, double y, double z, int colour, float size) {
        ParticleGasCloud.ParticleFlareFlash particle = new ParticleGasCloud.ParticleFlareFlash((World)ClientUtils.mc().field_71441_e, x, y, z, colour, size * 6.0f);
        particle.func_187114_a(20);
        particleRenderer.addEffect(particle);
    }

    public static void spawnFlareTraceFX(double x, double y, double z, int colour, float size) {
        ParticleFlareTrace particle = new ParticleFlareTrace((World)ClientUtils.mc().field_71441_e, x, y, z, size, colour, 125);
        particleRenderer.addEffect(particle);
    }
}

