/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.GuiIEContainerBase;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.client.gui.elements.buttons.GuiSliderII;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.first.TileEntityChemicalPainter;
import pl.pabilo8.immersiveintelligence.common.gui.ContainerChemicalPainter;

public class GuiChemicalPainter
extends GuiIEContainerBase
implements GuiSlider.ISlider {
    public static final ResourceLocation TEXTURE = new ResourceLocation("immersiveintelligence:textures/gui/chemical_painter.png");
    public static final ResourceLocation TEXTURE_ICONS = new ResourceLocation("immersiveintelligence:textures/gui/emplacement_icons.png");
    TileEntityChemicalPainter tile;
    private GuiSliderII sliderRed;
    private GuiSliderII sliderGreen;
    private GuiSliderII sliderBlue;
    private GuiSliderII sliderCyan;
    private GuiSliderII sliderMagenta;
    private GuiSliderII sliderYellow;
    private GuiSliderII sliderBlack;
    private GuiSliderII sliderHue;
    private GuiSliderII sliderSaturation;
    private GuiSliderII sliderValue;
    private ColorMode colorMode = ColorMode.RGB;
    private int color;
    GuiButtonIE buttonModeRGB;
    GuiButtonIE buttonModeCMYK;
    GuiButtonIE buttonModeHSV;
    GuiButtonIE buttonActiveColor;
    int colorDelay = 0;

    public GuiChemicalPainter(InventoryPlayer inventoryPlayer, TileEntityChemicalPainter tile) {
        super((Container)new ContainerChemicalPainter(inventoryPlayer, tile));
        this.field_147000_g = 203;
        this.tile = tile;
        this.color = tile.color;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        super.func_73866_w_();
        switch (this.colorMode) {
            case RGB: {
                float[] rgb = Utils.rgbIntToRGB(this.color);
                this.sliderRed = this.getSlider(0, "Red", rgb[0]);
                this.sliderGreen = this.getSlider(1, "Green", rgb[1]);
                this.sliderBlue = this.getSlider(2, "Blue", rgb[2]);
                break;
            }
            case CMYK: {
                float[] rgb = Utils.rgbIntToRGB(this.color);
                float[] cmyk = Utils.rgbToCmyk(rgb[0], rgb[1], rgb[2]);
                this.sliderCyan = this.getSlider(0, "Cyan", cmyk[0]);
                this.sliderMagenta = this.getSlider(1, "Magenta", cmyk[1]);
                this.sliderYellow = this.getSlider(2, "Yellow", cmyk[2]);
                this.sliderBlack = this.getSlider(3, "Black", cmyk[3]);
                break;
            }
            case HSV: {
                float[] rgb = Utils.rgbIntToRGB(this.color);
                float[] hsv = Utils.rgbToHsv(rgb[0], rgb[1], rgb[2]);
                this.sliderHue = this.getSlider(0, "Hue", hsv[0]);
                this.sliderSaturation = this.getSlider(1, "Saturation", hsv[1]);
                this.sliderValue = this.getSlider(2, "Value", hsv[2]);
            }
        }
        this.buttonActiveColor = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(this.field_146292_n.size(), this.field_147003_i + 4, this.field_147009_r + 88, 18, 18, "", TEXTURE_ICONS.toString(), 163, 142));
        this.buttonModeRGB = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(1, this.field_147003_i + 176, this.field_147009_r + 79, 12, 12, "R", TEXTURE_ICONS.toString(), 144, 89).setHoverOffset(12, 0));
        this.buttonModeCMYK = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(1, this.field_147003_i + 176, this.field_147009_r + 79 + 12, 12, 12, "C", TEXTURE_ICONS.toString(), 144, 89).setHoverOffset(12, 0));
        this.buttonModeHSV = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(1, this.field_147003_i + 176, this.field_147009_r + 79 + 24, 12, 12, "H", TEXTURE_ICONS.toString(), 144, 89).setHoverOffset(12, 0));
        this.saveBasicData();
    }

    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        if (button == this.buttonModeRGB) {
            this.colorMode = ColorMode.RGB;
            this.func_73866_w_();
        } else if (button == this.buttonModeCMYK) {
            this.colorMode = ColorMode.CMYK;
            this.func_73866_w_();
        } else if (button == this.buttonModeHSV) {
            this.colorMode = ColorMode.HSV;
            this.func_73866_w_();
        } else if (button == this.buttonActiveColor) {
            this.colorDelay = 20;
            GuiChemicalPainter.func_146275_d((String)Integer.toHexString(this.tile.color));
        }
        super.func_146284_a(button);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        Utils.drawStringCentered(this.field_146289_q, I18n.func_135052_a((String)"tile.immersiveintelligence.metal_multiblock1.chemical_painter.name", (Object[])new Object[0]), 8, 6, this.field_146999_f - 12, 0, 657930);
        float[] rgb = Utils.rgbIntToRGB(this.color);
        GlStateManager.func_179124_c((float)rgb[0], (float)rgb[1], (float)rgb[2]);
        Utils.bindTexture(TEXTURE_ICONS);
        this.func_73729_b(7, 91, 163, 160, 12, 12);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void func_146976_a(float f, int mx, int my) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.bindTexture(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        Utils.drawPowerBar(this.field_147003_i + 159, this.field_147009_r + 23, 7, 47, (float)this.tile.getEnergyStored(null) / (float)this.tile.getMaxEnergyStored(null));
        for (int i = 0; i < 4; ++i) {
            ClientUtils.handleGuiTank((IFluidTank)this.tile.tanks[i], (int)(this.field_147003_i + 49 + 22 * i), (int)(this.field_147009_r + 23), (int)17, (int)47, (int)177, (int)0, (int)20, (int)51, (int)mx, (int)my, (String)TEXTURE.toString(), null);
        }
        if (this.tile.active) {
            this.func_73729_b(this.field_147003_i + 20, this.field_147009_r + 20, 176, 51, 24, Math.round(51.0f * ((float)this.tile.processTime / (float)this.tile.processTimeMax)));
        }
    }

    public void func_73863_a(int mx, int my, float partial) {
        super.func_73863_a(mx, my, partial);
        this.func_191948_b(mx, my);
        this.colorDelay = Math.max(--this.colorDelay, 0);
        ArrayList<String> tooltip = new ArrayList<String>();
        if (mx > this.field_147003_i + 159 && mx < this.field_147003_i + 166 && my > this.field_147009_r + 23 && my < this.field_147009_r + 70) {
            tooltip.add(Utils.getPowerLevelString(this.tile));
        } else if (this.buttonModeRGB.func_146115_a()) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.chemical_painter.color.rgb", (Object[])new Object[0]));
        } else if (this.buttonModeCMYK.func_146115_a()) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.chemical_painter.color.cmyk", (Object[])new Object[0]));
        } else if (this.buttonModeHSV.func_146115_a()) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.chemical_painter.color.hsv", (Object[])new Object[0]));
        } else if (this.buttonActiveColor.func_146115_a()) {
            tooltip.add(this.colorDelay > 0 ? TextFormatting.GREEN + TextFormatting.ITALIC.toString() + I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.chemical_painter.color_copied", (Object[])new Object[0]) + TextFormatting.RESET : String.format("<hexcol=%1$s:#%1$s (%2$s)>", String.format("%06x", this.color), I18n.func_135052_a((String)("item.fireworksCharge." + Utils.getRGBTextFormatting(this.color).func_176610_l()), (Object[])new Object[0])));
        } else {
            for (int i = 0; i < 4; ++i) {
                ClientUtils.handleGuiTank((IFluidTank)this.tile.tanks[i], (int)(this.field_147003_i + 49 + 22 * i), (int)(this.field_147009_r + 23), (int)17, (int)47, (int)177, (int)0, (int)20, (int)51, (int)mx, (int)my, (String)TEXTURE.toString(), tooltip);
            }
        }
        if (!tooltip.isEmpty()) {
            ClientUtils.drawHoveringText(tooltip, (int)mx, (int)my, (FontRenderer)ClientProxy.itemFont, (int)(this.field_147003_i + this.field_146999_f), (int)-1);
            RenderHelper.func_74520_c();
        }
    }

    public GuiSliderII getSlider(int id, String name, float value) {
        GuiSliderII slider = (GuiSliderII)this.func_189646_b((GuiButton)new GuiSliderII(this.field_146292_n.size(), this.field_147003_i + 25 + id % 2 * 75, this.field_147009_r + 80 + 8 + 17 * (int)Math.floor((float)id / 2.0f), 70, name, value, 657930));
        slider.parent = this;
        return slider;
    }

    public void func_146281_b() {
        this.saveBasicData();
        super.func_146281_b();
    }

    public void saveBasicData() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("color", this.color);
        ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageTileSync((TileEntityIEBase)this.tile, nbt));
    }

    public void onChangeSliderValue(GuiSlider slider) {
        switch (this.colorMode) {
            case RGB: {
                this.color = Utils.rgb((float)this.sliderRed.sliderValue, (float)this.sliderGreen.sliderValue, (float)this.sliderBlue.sliderValue);
                break;
            }
            case CMYK: {
                float[] rgb = Utils.cmykToRgb((float)this.sliderCyan.sliderValue, (float)this.sliderMagenta.sliderValue, (float)this.sliderYellow.sliderValue, (float)this.sliderBlack.sliderValue);
                this.color = Utils.rgb(rgb[0], rgb[1], rgb[2]);
                break;
            }
            case HSV: {
                float[] rgb = Utils.hsvToRgb((float)this.sliderHue.sliderValue, (float)this.sliderSaturation.sliderValue, (float)this.sliderValue.sliderValue);
                this.color = Utils.rgb(rgb[0], rgb[1], rgb[2]);
            }
        }
    }

    static enum ColorMode {
        RGB,
        CMYK,
        HSV;

    }
}

