/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.GuiIEContainerBase;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.client.gui.elements.GuiLabelNoShadow;
import pl.pabilo8.immersiveintelligence.client.gui.elements.GuiPackerTaskList;
import pl.pabilo8.immersiveintelligence.client.gui.elements.buttons.GuiButtonDropdownList;
import pl.pabilo8.immersiveintelligence.client.gui.elements.buttons.GuiButtonSwitch;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.first.TileEntityPacker;
import pl.pabilo8.immersiveintelligence.common.gui.ContainerPacker;

public class GuiPacker
extends GuiIEContainerBase {
    private static final ResourceLocation TEXTURE_ICONS = new ResourceLocation("immersiveintelligence:textures/gui/emplacement_icons.png");
    private static final ResourceLocation TEXTURE_PACKER = new ResourceLocation("immersiveintelligence:textures/gui/packer.png");
    TileEntityPacker tile;
    private GuiButtonIE buttonAdd;
    private GuiButtonIE buttonRemove;
    private GuiButtonIE buttonDuplicate;
    private GuiButtonIE buttonClear;
    private GuiButtonState buttonRepeat;
    GuiPackerTaskList taskList;
    private int scroll;
    private final int maxScroll;
    private final ContainerPacker container;
    private GuiButtonDropdownList putModeList;
    private GuiButtonSwitch switchOreDict;
    private GuiButtonSwitch switchNBT;
    private GuiTextField textFieldAmount;

    public GuiPacker(InventoryPlayer inventoryPlayer, TileEntityPacker tile) {
        super((Container)new ContainerPacker(inventoryPlayer, tile));
        this.field_146999_f = 256;
        this.field_147000_g = 211;
        this.tile = tile;
        this.container = (ContainerPacker)this.field_147002_h;
        this.container.ghostUpdateFunction = this::saveBasicData;
        this.maxScroll = 18 * (int)(Math.floor((float)this.container.slots.length / 3.0f) - 6.0);
        this.scroll = 0;
    }

    public void func_73866_w_() {
        TileEntityPacker.PackerTask task;
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146293_o.clear();
        this.addLabel(5, 6, 78, 11, 657930, "Tasks");
        this.buttonAdd = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(this.field_146292_n.size(), this.field_147003_i + 6, this.field_147009_r + 96 + 4 + 8, 12, 12, "", TEXTURE_PACKER.toString(), 0, 223));
        this.buttonRemove = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(this.field_146292_n.size(), this.field_147003_i + 6 + 12, this.field_147009_r + 96 + 4 + 8, 12, 12, "", TEXTURE_PACKER.toString(), 24, 223));
        this.buttonDuplicate = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(this.field_146292_n.size(), this.field_147003_i + 6 + 24, this.field_147009_r + 96 + 4 + 8, 12, 12, "", TEXTURE_PACKER.toString(), 48, 223));
        this.buttonClear = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(this.field_146292_n.size(), this.field_147003_i + 6 + 36, this.field_147009_r + 96 + 4 + 8, 12, 12, "", TEXTURE_PACKER.toString(), 72, 223));
        this.buttonRepeat = (GuiButtonState)this.func_189646_b((GuiButton)new GuiButtonState(this.field_146292_n.size(), this.field_147003_i + 72, this.field_147009_r + 5, 12, 12, "", this.tile.repeatActions, TEXTURE_PACKER.toString(), 0, 235, 0));
        this.taskList = (GuiPackerTaskList)this.func_189646_b(this.taskList == null ? new GuiPackerTaskList(this.field_146292_n.size(), this.field_147003_i + 6, this.field_147009_r + 19, 78, 84, this.tile.hasUpgrade(IIContent.UPGRADE_UNPACKER_CONVERSION), this.tile.tasks, this::saveGuiToTask) : this.taskList);
        this.taskList.recalculateEntries();
        this.container.ghostSlot.field_75223_e = -2147483647;
        this.container.ghostSlot.field_75221_f = -2147483647;
        this.container.ghostSlot.field_75224_c.func_70299_a(0, ItemStack.field_190927_a);
        if (this.taskList.selectedOption != -1 && (task = this.tile.tasks.get(this.taskList.selectedOption)) != null) {
            this.addLabel(84, 10, 89, 0, 657930, "Task: " + I18n.func_135052_a((String)("desc.immersiveintelligence.metal_multiblock1.packer.task." + task.actionType.getActionName(this.tile.hasUpgrade(IIContent.UPGRADE_UNPACKER_CONVERSION))), (Object[])new Object[0])).func_175203_a();
            this.addLabel(88, 26, 657930, "Item:");
            this.addLabel(88, 42, 657930, "Mode:");
            this.putModeList = (GuiButtonDropdownList)this.func_189646_b(new GuiButtonDropdownList(this.field_146292_n.size(), this.field_147003_i + 84 + 32, this.field_147009_r + 10 + 6 + 20, 52, 20, TileEntityPacker.PackerPutMode.values().length, (String[])Arrays.stream(TileEntityPacker.PackerPutMode.values()).map(TileEntityPacker.PackerPutMode::func_176610_l).toArray(String[]::new)));
            this.putModeList.setTranslationFunc(s -> I18n.func_135052_a((String)("desc.immersiveintelligence.metal_multiblock1.packer.mode." + s), (Object[])new Object[0]));
            this.putModeList.selectedEntry = task.mode.ordinal();
            this.addLabel(88, 54, 657930, "Amount:");
            this.switchOreDict = this.switchOreDict == null ? this.addSwitch(88, 78, 85, 0x1A1A1A, 11867392, 9825536, task.stack.oreName != null, "Uses OreDict", false) : (GuiButtonSwitch)this.func_189646_b((GuiButton)this.switchOreDict);
            this.switchNBT = this.switchNBT == null ? this.addSwitch(88, 90, 85, 0x1A1A1A, 11867392, 9825536, task.stack.useNBT, "NBT Sensitive:", false) : (GuiButtonSwitch)this.func_189646_b((GuiButton)this.switchNBT);
            this.textFieldAmount = new GuiTextField(this.field_146292_n.size(), this.field_146297_k.field_71466_p, this.field_147003_i + 84 + 4, this.field_147009_r + 10 + 6 + 10 + 32 + 1, 80, 14);
            this.textFieldAmount.func_146180_a(task.mode == TileEntityPacker.PackerPutMode.ALL_POSSIBLE ? "*" : String.valueOf(task.stack.inputSize));
            this.textFieldAmount.func_146184_c(task.mode != TileEntityPacker.PackerPutMode.ALL_POSSIBLE);
            this.container.ghostSlot.field_75223_e = 150;
            this.container.ghostSlot.field_75221_f = 16;
            this.container.ghostSlot.field_75224_c.func_70299_a(0, task.stack.getExampleStack());
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.taskList.selectedOption != -1) {
            this.textFieldAmount.func_146192_a(mouseX, mouseY, 0);
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.taskList.selectedOption != -1) {
            this.textFieldAmount.func_146201_a(typedChar, keyCode);
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        if (button == this.buttonRepeat) {
            this.tile.repeatActions = this.buttonRepeat.state;
            this.saveBasicData();
        } else if (button == this.taskList) {
            this.switchOreDict = null;
            this.switchNBT = null;
            this.func_73866_w_();
        } else if (button == this.buttonAdd) {
            this.tile.tasks.add(new TileEntityPacker.PackerTask(TileEntityPacker.PackerPutMode.ALL_POSSIBLE, TileEntityPacker.PackerActionType.ITEM, new IngredientStack("*")));
            this.saveBasicData();
            this.func_73866_w_();
        } else if (button == this.buttonRemove) {
            if (this.taskList.selectedOption != -1) {
                this.tile.tasks.remove(this.taskList.selectedOption);
                this.taskList.selectedOption = -1;
                this.saveBasicData();
                this.func_73866_w_();
            }
        } else if (button == this.buttonDuplicate) {
            if (this.taskList.selectedOption != -1) {
                this.tile.tasks.add(new TileEntityPacker.PackerTask(this.tile.tasks.get(this.taskList.selectedOption).toNBT()));
                this.saveBasicData();
                this.func_73866_w_();
            }
        } else if (button == this.buttonClear) {
            this.tile.tasks.clear();
            this.taskList.selectedOption = -1;
            this.saveBasicData();
            this.func_73866_w_();
        } else if (this.taskList.selectedOption != -1) {
            this.saveGuiToTask(this.taskList.selectedOption);
            if (!this.putModeList.dropped) {
                this.func_73866_w_();
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.saveBasicData();
    }

    protected void func_146976_a(float f, int mx, int my) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int mouseChange = Mouse.getDWheel();
        if (Mouse.isButtonDown((int)0) && this.func_146978_c(238, 7, 11, 108, mx, my)) {
            this.scroll = (int)((float)this.maxScroll * MathHelper.func_76131_a((float)((float)(my - this.field_147009_r - 7) / 94.0f), (float)0.0f, (float)1.0f)) / 18 * 18;
        } else if (this.func_146978_c(181, 5, 60, 112, mx, my)) {
            this.scroll -= Integer.signum(mouseChange) * 18;
        }
        this.scroll = MathHelper.func_76125_a((int)this.scroll, (int)0, (int)this.maxScroll);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.bindTexture(TEXTURE_PACKER);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, 122);
        this.func_73729_b(this.field_147003_i + 40, this.field_147009_r + 122, 0, 122, 176, 89);
        this.func_175174_a(this.field_147003_i + 239, (float)(this.field_147009_r + 8) + 92.0f * ((float)this.scroll / (float)this.maxScroll), 161, 211, 9, 14);
        if (this.taskList.selectedOption != -1) {
            this.func_73729_b(this.field_147003_i + 85, this.field_147009_r + 3, 176, 122, 64, 119);
            this.func_73729_b(this.field_147003_i + 85 + 64, this.field_147009_r + 3, 232, 122, 24, 119);
            if (this.textFieldAmount != null) {
                this.textFieldAmount.func_146194_f();
            }
            ClientUtils.drawSlot((int)(this.field_147003_i + 150), (int)(this.field_147009_r + 16), (int)16, (int)16, (int)128);
        }
        for (Slot slot : this.container.slots) {
            if (slot == null) continue;
            int j = slot.getSlotIndex() - 1;
            int x = j % 3 * 18;
            int y = j / 3 * 18 - this.scroll;
            if (y < 0 || y > 90) {
                slot.field_75223_e = -2147483647;
                slot.field_75221_f = -2147483647;
                continue;
            }
            slot.field_75223_e = 184 + x;
            slot.field_75221_f = 8 + y;
        }
    }

    public void func_73863_a(int mx, int my, float partial) {
        super.func_73863_a(mx, my, partial);
        this.func_191948_b(mx, my);
        ArrayList<String> tooltip = new ArrayList<String>();
        if (this.buttonAdd.func_146115_a()) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.emplacement.add", (Object[])new Object[0]));
        } else if (this.buttonRemove.func_146115_a()) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.emplacement.remove", (Object[])new Object[0]));
        } else if (this.buttonDuplicate.func_146115_a()) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.emplacement.duplicate", (Object[])new Object[0]));
        } else if (this.buttonClear.func_146115_a()) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.emplacement.clear", (Object[])new Object[0]));
        }
        if (!tooltip.isEmpty()) {
            ClientUtils.drawHoveringText(tooltip, (int)mx, (int)my, (FontRenderer)this.field_146289_q, (int)(this.field_147003_i + this.field_146999_f), (int)-1);
            RenderHelper.func_74520_c();
        }
    }

    protected GuiButtonSwitch addSwitch(int x, int y, int textWidth, int textColor, int color1, int color2, boolean state, String name, boolean firstTime) {
        return (GuiButtonSwitch)this.func_189646_b((GuiButton)new GuiButtonSwitch(this.field_146292_n.size(), this.field_147003_i + x, this.field_147009_r + y, textWidth, 8, 18, 9, 18, 52, state, TEXTURE_ICONS, textColor, color1, color2, name, firstTime));
    }

    protected GuiLabelNoShadow addLabel(int x, int y, int textColor, String ... text) {
        return this.addLabel(x, y, 0, 0, textColor, text);
    }

    protected GuiLabelNoShadow addLabel(int x, int y, int w, int h, int textColor, String ... text) {
        GuiLabelNoShadow guiLabel = new GuiLabelNoShadow(this.field_146289_q, this.field_146293_o.size(), this.field_147003_i + x, this.field_147009_r + y, w, h, textColor);
        Arrays.stream(text).forEachOrdered(arg_0 -> ((GuiLabelNoShadow)guiLabel).func_175202_a(arg_0));
        this.field_146293_o.add(guiLabel);
        return guiLabel;
    }

    private void saveGuiToTask(int task) {
        int[] oids;
        if (task == -1) {
            return;
        }
        TileEntityPacker.PackerTask t = this.tile.tasks.get(task);
        t.mode = TileEntityPacker.PackerPutMode.values()[this.putModeList.selectedEntry];
        IngredientStack is = null;
        ItemStack stack = this.container.ghostSlot.func_75211_c();
        if (this.switchOreDict.state && !stack.func_190926_b() && (oids = OreDictionary.getOreIDs((ItemStack)stack)).length > 0) {
            is = new IngredientStack(OreDictionary.getOreName((int)oids[0]));
        }
        t.stack = is == null ? (stack.func_190926_b() ? new IngredientStack("*") : new IngredientStack(stack)) : is;
        try {
            t.stack.inputSize = Integer.parseInt(this.textFieldAmount.func_146179_b());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        t.stack.useNBT = this.switchNBT.state;
    }

    private void saveBasicData() {
        if (this.taskList.selectedOption != -1) {
            this.saveGuiToTask(this.taskList.selectedOption);
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("tasks", (NBTBase)this.tile.writeTasks());
        tag.func_74757_a("repeatActions", this.buttonRepeat.state);
        ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageTileSync((TileEntityIEBase)this.tile, tag));
    }
}

