/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.gui.elements.data_editor;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeBoolean;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeItemStack;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeNull;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.client.gui.elements.data_editor.GuiDataEditorBoolean;
import pl.pabilo8.immersiveintelligence.client.gui.elements.data_editor.GuiDataEditorInteger;
import pl.pabilo8.immersiveintelligence.client.gui.elements.data_editor.GuiDataEditorItemStack;
import pl.pabilo8.immersiveintelligence.client.gui.elements.data_editor.GuiDataEditorNull;
import pl.pabilo8.immersiveintelligence.client.gui.elements.data_editor.GuiDataEditorString;

public abstract class GuiDataEditor<T extends IDataType>
extends GuiButton {
    public static LinkedHashMap<Class<? extends IDataType>, BiFunction<Integer, IDataType, GuiDataEditor<? extends IDataType>>> editors = new LinkedHashMap();
    protected T dataType;
    protected List<GuiButton> buttonList = Lists.newArrayList();

    public GuiDataEditor(int buttonId, T dataType) {
        super(buttonId, 0, 0, "");
        this.dataType = dataType;
    }

    public void setBounds(int x, int y, int w, int h) {
        this.field_146128_h = x;
        this.field_146129_i = y;
        this.field_146120_f = w;
        this.field_146121_g = h;
        this.init();
    }

    public void init() {
        this.buttonList.clear();
    }

    public abstract T createType();

    public void update() {
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
        this.buttonList.forEach(guiButton -> guiButton.func_191745_a(mc, mouseX, mouseY, partialTicks));
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        return false;
    }

    public void keyTyped(char typedChar, int keyCode) throws IOException {
    }

    public abstract T outputType();

    protected <B extends GuiButton> B addButton(B buttonIn) {
        this.buttonList.add(buttonIn);
        return buttonIn;
    }

    public boolean isFocused() {
        return false;
    }

    static {
        editors.put(DataPacketTypeBoolean.class, (id, data) -> new GuiDataEditorBoolean((int)id, (DataPacketTypeBoolean)data));
        editors.put(DataPacketTypeString.class, (id, data) -> new GuiDataEditorString((int)id, (DataPacketTypeString)data));
        editors.put(DataPacketTypeInteger.class, (id, data) -> new GuiDataEditorInteger((int)id, (DataPacketTypeInteger)data));
        editors.put(DataPacketTypeNull.class, (id, data) -> new GuiDataEditorNull((int)id, (DataPacketTypeNull)data));
        editors.put(DataPacketTypeItemStack.class, (id, data) -> new GuiDataEditorItemStack((int)id, (DataPacketTypeItemStack)data));
    }
}

