/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.gui.emplacement;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.INpc;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.registries.GameData;
import org.apache.commons.lang3.ArrayUtils;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.client.gui.elements.GuiEmplacementTaskList;
import pl.pabilo8.immersiveintelligence.client.gui.elements.buttons.GuiButtonCheckboxII;
import pl.pabilo8.immersiveintelligence.client.gui.elements.buttons.GuiButtonDropdownList;
import pl.pabilo8.immersiveintelligence.client.gui.elements.buttons.GuiButtonSwitch;
import pl.pabilo8.immersiveintelligence.client.gui.emplacement.GuiEmplacement;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.second.TileEntityEmplacement;

public class GuiEmplacementPageTasks
extends GuiEmplacement {
    int currentTab = 0;
    private GuiButtonIE[] taskTabButtons = new GuiButtonIE[0];
    @Nullable
    private GuiTextField valueEdit;
    @Nullable
    private GuiButtonDropdownList valueList;
    private GuiButtonSwitch buttonEnabled;
    private GuiButtonCheckboxII buttonInverted;
    private GuiButtonIE buttonAdd;
    private GuiButtonIE buttonRemove;
    private GuiButtonIE buttonDuplicate;
    private GuiButtonIE buttonClear;
    private GuiButtonIE buttonTypePrev;
    private GuiButtonIE buttonTypeNext;
    private GuiEmplacementTaskList buttonTaskList;
    private TaskFilter selected = null;
    private boolean tasksModified = false;
    private final ArrayList<TaskFilter> taskFilters = new ArrayList();

    public GuiEmplacementPageTasks(InventoryPlayer inventoryPlayer, TileEntityEmplacement tile) {
        super(inventoryPlayer, tile, IIGuiList.GUI_EMPLACEMENT_TASKS);
        this.title = I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.emplacement.tasks", (Object[])new Object[0]);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.taskTabButtons = new GuiButtonIE[]{this.addTaskTabButton(0), this.addTaskTabButton(1), this.addTaskTabButton(2), this.addTaskTabButton(3)};
        this.buttonEnabled = this.addSwitch(133, 17, 60, 657930, 11867392, 9825536, this.currentTab == this.tile.defaultTargetMode, I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.emplacement.task_enabled", (Object[])new Object[0]), this.tasksModified);
        this.addLabel(122, 36, 83, 0, 657930, I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.emplacement.selector_preset", (Object[])new Object[0])).func_175203_a();
        this.buttonInverted = (GuiButtonCheckboxII)this.func_189646_b((GuiButton)new GuiButtonCheckboxII(this.field_146292_n.size(), this.field_147003_i + 122, this.field_147009_r + 32 + 33 - 6 + 44, I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.emplacement.task_negation", (Object[])new Object[0]), !this.tile.redstoneControl));
        if (this.selected != null) {
            this.buttonInverted.state = this.selected.negation;
        }
        this.addLabel(122, 81, 83, 0, 657930, I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.emplacement.filter", (Object[])new Object[0])).func_175203_a();
        this.buttonAdd = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(this.field_146292_n.size(), this.field_147003_i + 4, this.field_147009_r + 32 + 2 + 96, 48, 12, I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.emplacement.add", (Object[])new Object[0]), this.TEXTURE_ICONS.toString(), 0, 89));
        this.buttonRemove = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(this.field_146292_n.size(), this.field_147003_i + 4 + 48, this.field_147009_r + 32 + 2 + 96, 48, 12, I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.emplacement.remove", (Object[])new Object[0]), this.TEXTURE_ICONS.toString(), 0, 89));
        this.buttonRemove.field_146124_l = this.selected != null;
        this.buttonDuplicate = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(this.field_146292_n.size(), this.field_147003_i + 4 + 48 + 48, this.field_147009_r + 32 + 2 + 96, 48, 12, I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.emplacement.duplicate", (Object[])new Object[0]), this.TEXTURE_ICONS.toString(), 0, 89));
        this.buttonDuplicate.field_146124_l = this.selected != null;
        this.buttonClear = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(this.field_146292_n.size(), this.field_147003_i + 4 + 48 + 48 + 48, this.field_147009_r + 32 + 2 + 96, 48, 12, I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.emplacement.clear", (Object[])new Object[0]), this.TEXTURE_ICONS.toString(), 0, 89));
        this.buttonTypePrev = ((GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(this.field_146292_n.size(), this.field_147003_i + 120, this.field_147009_r + 32 + 8, 12, 12, "", this.TEXTURE_ICONS.toString(), 96, 89))).setHoverOffset(12, 0);
        this.buttonTypeNext = ((GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(this.field_146292_n.size(), this.field_147003_i + 192, this.field_147009_r + 32 + 8, 12, 12, "", this.TEXTURE_ICONS.toString(), 120, 89))).setHoverOffset(12, 0);
        Object[] entries = this.selected != null ? this.selected.type.getDropdownEntries() : new String[]{};
        this.valueEdit = null;
        if (entries.length > 0) {
            this.valueList = (GuiButtonDropdownList)this.func_189646_b(new GuiButtonDropdownList(this.field_146292_n.size(), this.field_147003_i + 120, this.field_147009_r + 87, 84, 13, 4, (String[])entries));
            if (!this.selected.filter.isEmpty()) {
                this.valueList.selectedEntry = ArrayUtils.indexOf((Object[])entries, (Object)this.selected.filter);
            }
        } else {
            this.valueEdit = new GuiTextField(this.field_146292_n.size(), this.field_146289_q, this.field_147003_i + 120, this.field_147009_r + 86, 84, 13);
            this.valueEdit.func_146184_c(this.selected != null);
            if (this.selected != null) {
                this.valueEdit.func_146180_a(this.selected.filter);
            }
        }
        if (this.selected != null) {
            this.addLabel(132, 47, 60, 0, 657930, "desc.immersiveintelligence.metal_multiblock1.emplacement.target." + this.selected.type.func_176610_l()).func_175203_a();
        }
        this.buttonInverted.field_146124_l = this.selected != null;
        this.buttonTypePrev.field_146124_l = this.selected != null;
        boolean bl = this.buttonTypeNext.field_146124_l = this.selected != null;
        if (!this.tasksModified) {
            this.loadTaskIntoList();
        }
        this.buttonTaskList = (GuiEmplacementTaskList)this.func_189646_b(new GuiEmplacementTaskList(this.field_146292_n.size(), this.field_147003_i + 6, this.field_147009_r + 34, 93, 94, this.taskFilters.toArray(new TaskFilter[0])));
        if (this.selected != null) {
            this.buttonTaskList.selectedOption = this.taskFilters.indexOf(this.selected);
        }
    }

    private void loadTaskIntoList() {
        this.tasksModified = true;
        this.taskFilters.clear();
        NBTTagCompound nbt = this.tile.defaultTaskNBT[this.currentTab];
        NBTTagList tagList = nbt.func_150295_c("filters", 10);
        for (NBTBase nbtBase : tagList) {
            if (!(nbtBase instanceof NBTTagCompound)) continue;
            this.taskFilters.add(new TaskFilter((NBTTagCompound)nbtBase));
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button instanceof GuiButtonIE && Arrays.stream(this.taskTabButtons).anyMatch(guiButtonIE -> guiButtonIE == button)) {
            this.syncDataToServer();
            this.currentTab = Integer.parseInt(button.field_146126_j) - 1;
            this.tasksModified = false;
            this.selected = null;
            this.func_73866_w_();
        } else if (this.valueList != null && button == this.valueList) {
            if (this.selected != null) {
                this.selected.filter = this.valueList.getEntry(this.valueList.selectedEntry);
            }
        } else if (button == this.buttonAdd) {
            this.taskFilters.add(new TaskFilter(EnumTaskType.MOBS, false, ""));
            this.func_73866_w_();
        } else if (button == this.buttonRemove) {
            this.taskFilters.remove(this.selected);
            this.func_73866_w_();
        } else if (button == this.buttonDuplicate) {
            this.taskFilters.add(new TaskFilter(this.selected.type, this.selected.negation, this.selected.filter));
            this.func_73866_w_();
        } else if (button == this.buttonClear) {
            this.taskFilters.clear();
            this.func_73866_w_();
        } else if (button == this.buttonTaskList) {
            if (this.buttonTaskList.selectedOption == -1) {
                this.selected = null;
            } else if (GuiEmplacementPageTasks.func_146272_n()) {
                if (this.taskFilters.get(this.buttonTaskList.selectedOption) == this.selected) {
                    this.selected = null;
                }
                this.taskFilters.remove(this.buttonTaskList.selectedOption);
            } else {
                this.selected = this.taskFilters.get(this.buttonTaskList.selectedOption);
            }
            this.func_73866_w_();
        } else if (button == this.buttonInverted) {
            this.selected.negation = this.buttonInverted.state;
        } else if (button == this.buttonTypeNext) {
            this.selected.type = EnumTaskType.values()[Utils.cycleInt(true, this.selected.type.ordinal(), 0, EnumTaskType.values().length - 1)];
            this.func_73866_w_();
        } else if (button == this.buttonTypePrev) {
            this.selected.type = EnumTaskType.values()[Utils.cycleInt(false, this.selected.type.ordinal(), 0, EnumTaskType.values().length - 1)];
            this.func_73866_w_();
        }
    }

    @Override
    protected void syncDataToServer() {
        super.syncDataToServer();
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.buttonEnabled.state) {
            this.tile.defaultTargetMode = this.currentTab;
            nbt.func_74768_a("defaultTargetMode", this.currentTab);
        } else if (this.tile.defaultTargetMode == this.currentTab) {
            this.tile.defaultTargetMode = -1;
            nbt.func_74768_a("defaultTargetMode", -1);
        }
        NBTTagCompound filterTag = new NBTTagCompound();
        NBTTagList tagList = new NBTTagList();
        for (TaskFilter filter : this.taskFilters) {
            NBTTagCompound cc = new NBTTagCompound();
            cc.func_74778_a("type", filter.type.func_176610_l().toLowerCase());
            cc.func_74757_a("negation", filter.negation);
            cc.func_74778_a("filter", filter.filter);
            tagList.func_74742_a((NBTBase)cc);
        }
        filterTag.func_74782_a("filters", (NBTBase)tagList);
        nbt.func_74782_a("defaultTaskNBT" + (this.currentTab + 1), (NBTBase)filterTag);
        ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageTileSync((TileEntityIEBase)this.tile, nbt));
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.syncDataToServer();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.valueEdit != null) {
            this.valueEdit.func_146178_a();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.valueEdit != null) {
            this.valueEdit.func_146192_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        if (this.valueEdit != null) {
            this.valueEdit.func_146201_a(par1, par2);
            if (this.selected != null) {
                this.selected.filter = this.valueEdit.func_146179_b();
            }
            if (par2 != 18 || !this.valueEdit.func_146206_l()) {
                super.func_73869_a(par1, par2);
            }
        } else {
            super.func_73869_a(par1, par2);
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mx, int my) {
        super.func_146976_a(partialTicks, mx, my);
        this.bindIcons();
        this.func_73729_b(this.field_147003_i + 128, this.field_147009_r + 26, 56, 113, 77, 2);
        this.func_73729_b(this.field_147003_i + 4, this.field_147009_r + 32, 56, 115, 107, 96);
        this.bindTexture();
        this.func_73729_b(this.field_147003_i + 113, this.field_147009_r + 122 - 96, 205, 44, 6, 96);
        this.func_73729_b(this.field_147003_i + 113, this.field_147009_r + 122, 205, 140, 6, 6);
        ClientUtils.drawRepeatedSprite((float)(this.field_147003_i + 113 + 6), (float)(this.field_147009_r + 122), (float)86.0f, (float)6.0f, (int)20, (int)6, (float)0.82421875f, (float)0.90234375f, (float)0.546875f, (float)0.5703125f);
        this.bindIcons();
        if (this.valueEdit != null) {
            this.valueEdit.func_146194_f();
        }
    }

    private GuiButtonIE addTaskTabButton(int id) {
        return (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(this.field_146292_n.size(), this.field_147003_i + id * 32, this.field_147009_r + 16, 32, 12, String.valueOf(id + 1), this.TEXTURE_ICONS.toString(), id == this.currentTab ? 56 : 87, 101));
    }

    public static enum EnumTaskType implements IStringSerializable
    {
        MOBS(() -> (String[])ArrayUtils.add((Object[])GameData.getEntityClassMap().values().stream().filter(entityEntry -> IMob.class.isAssignableFrom(entityEntry.getEntityClass())).map(entityEntry -> entityEntry.delegate.name()).map(ResourceLocation::toString).toArray(String[]::new), (int)0, (Object)"")),
        ANIMALS(() -> (String[])ArrayUtils.add((Object[])GameData.getEntityClassMap().values().stream().filter(entityEntry -> EntityAnimal.class.isAssignableFrom(entityEntry.getEntityClass())).map(entityEntry -> entityEntry.delegate.name()).map(ResourceLocation::toString).toArray(String[]::new), (int)0, (Object)"")),
        PLAYERS,
        NPCS(() -> (String[])ArrayUtils.add((Object[])GameData.getEntityClassMap().values().stream().filter(entityEntry -> INpc.class.isAssignableFrom(entityEntry.getEntityClass())).map(entityEntry -> entityEntry.delegate.name()).map(ResourceLocation::toString).toArray(String[]::new), (int)0, (Object)"")),
        VEHICLES,
        SHELLS,
        TEAM,
        NAME;

        private final Supplier<String[]> entries;

        private EnumTaskType() {
            this(() -> new String[0]);
        }

        private EnumTaskType(Supplier<String[]> entries) {
            this.entries = entries;
        }

        @Nonnull
        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }

        public String[] getDropdownEntries() {
            return this.entries.get();
        }
    }

    public static class TaskFilter {
        public EnumTaskType type;
        protected boolean negation;
        protected String filter;

        public TaskFilter(EnumTaskType type, boolean negation, String filter) {
            this.type = type;
            this.negation = negation;
            this.filter = filter;
        }

        public TaskFilter(NBTTagCompound tag) {
            this(EnumTaskType.valueOf(tag.func_74779_i("type").toUpperCase()), tag.func_74767_n("negation"), tag.func_74779_i("filter"));
        }
    }
}

