/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.manual.pages;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualPages;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.gui.GuiManual;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.client.IDataMachineGui;
import pl.pabilo8.immersiveintelligence.client.gui.elements.GuiWidgetManualWrapper;

public class IIManualPageDataVariablesCallback
extends ManualPages {
    List<CallbackEntry> entries = new ArrayList<CallbackEntry>();
    String title;
    int titleShift;

    public IIManualPageDataVariablesCallback(ManualInstance manual, String name) {
        super(manual, name + ".vars_callback");
    }

    public IIManualPageDataVariablesCallback addEntry(IDataType type, String ... c) {
        if (c.length > 0) {
            this.entries.add(new CallbackEntry(type, c, this.text + "." + c[0]));
        }
        return this;
    }

    public void initPage(GuiManual gui, int x, int y, List<GuiButton> pageButtons) {
        this.highlighted = ItemStack.field_190927_a;
        boolean uni = this.manual.fontRenderer.func_82883_a();
        this.manual.fontRenderer.func_78264_a(true);
        this.title = I18n.func_135052_a((String)"ie.manual.entry.variables_callback", (Object[])new Object[0]);
        this.titleShift = 55 - this.manual.fontRenderer.func_78256_a(this.title) / 2;
        int spacing = 15;
        for (CallbackEntry entry : this.entries) {
            entry.init(this.manual, gui, x, y + spacing, pageButtons);
            pageButtons.add((GuiButton)new GuiButtonDataCallback(pageButtons.size(), x - 4, y + spacing - 3, entry));
            spacing += entry.getSpacing();
        }
        this.manual.fontRenderer.func_78264_a(uni);
    }

    public void buttonPressed(GuiManual gui, GuiButton button) {
        super.buttonPressed(gui, button);
        if (button instanceof GuiButtonDataCallback) {
            CallbackEntry entry = ((GuiButtonDataCallback)button).entry;
            if (Minecraft.func_71410_x().field_71462_r instanceof IDataMachineGui) {
                ((IDataMachineGui)Minecraft.func_71410_x().field_71462_r).editVariable('c', new DataPacketTypeString(entry.n[0]));
            }
        }
    }

    public void renderPage(GuiManual gui, int x, int y, int mx, int my) {
        ManualUtils.drawSplitString((FontRenderer)this.manual.fontRenderer, (String)(String.valueOf(TextFormatting.BOLD) + TextFormatting.UNDERLINE + this.title), (int)(x + this.titleShift), (int)y, (int)120, (int)this.manual.getTextColour());
        CallbackEntry tooltip = null;
        int down = 15;
        for (CallbackEntry entry : this.entries) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)0.9f, (float)0.9f, (float)0.85f, (float)0.85f);
            ClientUtils.bindTexture((String)entry.dataType.textureLocation());
            gui.func_73729_b(x - 4, y + down - 3, 40, entry.dataType.getFrameOffset() * 20, 16, 16);
            if (Utils.isPointInRectangle(x - 4, y + down - 3, x + 12, y + down + 13, mx, my)) {
                tooltip = entry;
            }
            String toDraw = entry.n[(int)Math.ceil(gui.field_146297_k.field_71441_e.func_82737_E() % (long)entry.prezTimeTotal / 20L)];
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)1.25, (double)1.25, (double)1.25);
            ManualUtils.drawSplitString((FontRenderer)this.manual.fontRenderer, (String)(TextFormatting.BOLD + toDraw), (int)((int)((float)(x + 15) / 1.25f)), (int)((int)((float)(y + down - 1) / 1.25f)), (int)100, (int)entry.dataType.getTypeColour());
            GlStateManager.func_179121_F();
            GlStateManager.func_179084_k();
            ManualUtils.drawSplitString((FontRenderer)this.manual.fontRenderer, (String)entry.localizedText, (int)(x + 24), (int)(y + (down += this.manual.fontRenderer.field_78288_b)), (int)100, (int)this.manual.getTextColour());
            down += entry.spacingMain;
        }
        this.manual.fontRenderer.func_78264_a(false);
        if (tooltip != null) {
            ArrayList<String> toDraw = new ArrayList<String>();
            toDraw.add(I18n.func_135052_a((String)("datasystem.immersiveintelligence.datatype." + tooltip.dataType.getName()), (Object[])new Object[0]));
            ClientUtils.drawHoveringText(toDraw, (int)mx, (int)my, (FontRenderer)this.manual.fontRenderer, (int)-1, (int)-1);
        }
        this.manual.fontRenderer.func_78264_a(true);
    }

    public boolean listForSearch(String searchTag) {
        return false;
    }

    public static class GuiButtonDataCallback
    extends GuiButtonIE {
        @Nonnull
        public final CallbackEntry entry;

        public GuiButtonDataCallback(int buttonId, int x, int y, CallbackEntry entry) {
            super(100 + buttonId, x, y, 16, 16, "", String.format("immersiveintelligence:textures/gui/data_types/%s.png", entry.dataType.getName()), 0, 0);
            this.entry = entry;
            this.field_146124_l = ManualHelper.getManual().getGui() instanceof GuiWidgetManualWrapper;
        }
    }

    public static class CallbackEntry {
        IDataType dataType;
        String[] n;
        int prezTimeTotal;
        String text;
        String localizedText;
        int spacingMain;

        public CallbackEntry(IDataType dataType, String[] n, String text) {
            this.dataType = dataType;
            this.n = n;
            this.text = text;
        }

        public void init(ManualInstance manual, GuiManual gui, int x, int y, List<GuiButton> pageButtons) {
            this.prezTimeTotal = this.n.length * 20;
            this.localizedText = manual.formatText(this.text);
            this.localizedText = ManualPages.addLinks((ManualInstance)manual, (GuiManual)gui, (String)this.localizedText, (int)(x + 24), (int)y, (int)80, pageButtons);
            this.spacingMain = manual.fontRenderer.func_78267_b(this.localizedText, 120) + 4;
        }

        public int getSpacing() {
            return this.spacingMain;
        }
    }
}

