/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration0;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDevice0;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDevice1;
import blusunrize.immersiveengineering.common.blocks.stone.BlockTypes_StoneDecoration;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistry;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.IBullet;
import pl.pabilo8.immersiveintelligence.api.crafting.AmmunitionWorkshopRecipe;
import pl.pabilo8.immersiveintelligence.api.crafting.BathingRecipe;
import pl.pabilo8.immersiveintelligence.api.crafting.CoagulatorRecipe;
import pl.pabilo8.immersiveintelligence.api.crafting.FillerRecipe;
import pl.pabilo8.immersiveintelligence.api.crafting.PaintingRecipe;
import pl.pabilo8.immersiveintelligence.api.crafting.PrecissionAssemblerRecipe;
import pl.pabilo8.immersiveintelligence.api.crafting.SawmillRecipe;
import pl.pabilo8.immersiveintelligence.api.crafting.VulcanizerRecipe;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.blocks.types.IIBlockTypes_MetalDevice;
import pl.pabilo8.immersiveintelligence.common.blocks.types.IIBlockTypes_Mine;
import pl.pabilo8.immersiveintelligence.common.blocks.types.IIBlockTypes_Ore;
import pl.pabilo8.immersiveintelligence.common.blocks.types.IIBlockTypes_SmallCrate;
import pl.pabilo8.immersiveintelligence.common.crafting.RecipeCrateConversion;
import pl.pabilo8.immersiveintelligence.common.crafting.RecipeMinecart;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIFunctionalCircuit;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIMinecart;

public class IIRecipes {
    public static void addCircuitRecipes() {
        if (Config.IIConfig.changeCircuitProduction) {
            ItemStack circuitboard = new ItemStack((Item)IEContent.itemMaterial, 1, 27);
            BlueprintCraftingRecipe.recipeList.get((Object)"components").removeIf(blueprintCraftingRecipe -> blueprintCraftingRecipe.output.func_77969_a(circuitboard));
            BlueprintCraftingRecipe.addRecipe((String)"basic_circuits", (ItemStack)new ItemStack((Item)IIContent.itemMaterial, 1, IIContent.itemMaterial.getMetaBySubname("basic_circuit_board_raw")), (Object[])new Object[]{new ItemStack((Block)IEContent.blockStoneDecoration, 2, BlockTypes_StoneDecoration.INSULATING_GLASS.getMeta()), "plateCopper"});
            BlueprintCraftingRecipe.addRecipe((String)"basic_circuits", (ItemStack)new ItemStack((Item)IEContent.itemMaterial, 1, 27), (Object[])new Object[]{"circuitBasicEtched", new IngredientStack("chipBasic", 2)});
            BlueprintCraftingRecipe.addRecipe((String)"advanced_circuits", (ItemStack)new ItemStack((Item)IIContent.itemMaterial, 1, IIContent.itemMaterial.getMetaBySubname("advanced_circuit_board_raw")), (Object[])new Object[]{new IngredientStack("circuitBasicRaw", 2), "plateAdvancedElectronicAlloy"});
            BlueprintCraftingRecipe.addRecipe((String)"advanced_circuits", (ItemStack)new ItemStack((Item)IIContent.itemMaterial, 1, IIContent.itemMaterial.getMetaBySubname("advanced_circuit_board")), (Object[])new Object[]{"circuitAdvancedEtched", new IngredientStack("chipAdvanced", 2)});
            BlueprintCraftingRecipe.addRecipe((String)"processors", (ItemStack)new ItemStack((Item)IIContent.itemMaterial, 1, IIContent.itemMaterial.getMetaBySubname("processor_circuit_board_raw")), (Object[])new Object[]{new IngredientStack("circuitAdvancedRaw", 4), new IngredientStack("plateAdvancedElectronicAlloy", 2)});
            BlueprintCraftingRecipe.addRecipe((String)"processors", (ItemStack)new ItemStack((Item)IIContent.itemMaterial, 1, IIContent.itemMaterial.getMetaBySubname("processor_circuit_board")), (Object[])new Object[]{"circuitProcessorEtched", new IngredientStack("chipProcessor", 2)});
        }
        BathingRecipe.addRecipe(new ItemStack((Item)IIContent.itemMaterial, 1, IIContent.itemMaterial.getMetaBySubname("basic_circuit_board_etched")), new IngredientStack("circuitBasicRaw"), FluidRegistry.getFluidStack((String)"etching_acid", (int)1000), 15000, 360);
        BathingRecipe.addRecipe(new ItemStack((Item)IIContent.itemMaterial, 1, IIContent.itemMaterial.getMetaBySubname("advanced_circuit_board_etched")), new IngredientStack("circuitAdvancedRaw"), FluidRegistry.getFluidStack((String)"etching_acid", (int)2000), 150000, 560);
        BathingRecipe.addRecipe(new ItemStack((Item)IIContent.itemMaterial, 1, IIContent.itemMaterial.getMetaBySubname("processor_circuit_board_etched")), new IngredientStack("circuitProcessorRaw"), FluidRegistry.getFluidStack((String)"etching_acid", (int)4000), 1500000, 720);
        PrecissionAssemblerRecipe.addRecipe(new ItemStack((Item)IEContent.itemMaterial, 4, 26), new ItemStack((Item)IEContent.itemMetal, 1, 20), new IngredientStack[]{new IngredientStack("plateIron"), new IngredientStack("wireCopper", 2), new IngredientStack("blockGlass")}, new String[]{"inserter", "solderer", "drill"}, new String[]{"drill work main", "solderer work first", "inserter pick first", "inserter drop main", "solderer work main", "drill work second", "inserter pick second", "inserter drop main"}, 12000, 1.0f);
        PrecissionAssemblerRecipe.addRecipe(new ItemStack((Item)IIContent.itemMaterial, 1, IIContent.itemMaterial.getMetaBySubname("basic_electronic_element")), ItemStack.field_190927_a, new IngredientStack[]{new IngredientStack("electronTube"), new IngredientStack("plateNickel"), new IngredientStack("dustRedstone", 4)}, new String[]{"inserter", "solderer", "drill"}, new String[]{"inserter pick second", "drill work main", "inserter drop main", "solderer work main", "inserter pick first", "inserter drop main"}, 18000, 1.0f);
        PrecissionAssemblerRecipe.addRecipe(new ItemStack((Item)IIContent.itemMaterial, 2, IIContent.itemMaterial.getMetaBySubname("advanced_electron_tube")), ItemStack.field_190927_a, new IngredientStack[]{new IngredientStack("plateSteel"), new IngredientStack("wireTungsten", 2), new IngredientStack("electronTube", 2)}, new String[]{"inserter", "solderer", "drill"}, new String[]{"drill work main", "inserter pick second", "inserter drop main", "inserter pick first", "inserter drop main", "solderer work main"}, 24000, 1.25f);
        PrecissionAssemblerRecipe.addRecipe(new ItemStack((Item)IIContent.itemMaterial, 1, IIContent.itemMaterial.getMetaBySubname("advanced_electronic_element")), ItemStack.field_190927_a, new IngredientStack[]{new IngredientStack("electronTubeAdvanced"), new IngredientStack("chipBasic")}, new String[]{"inserter", "solderer", "drill"}, new String[]{"inserter pick second", "drill work main", "inserter drop main", "solderer work main", "inserter pick first", "inserter drop main"}, 32000, 1.25f);
        PrecissionAssemblerRecipe.addRecipe(Utils.getStackWithMetaName(IIContent.itemMaterial, "transistor", 4), ItemStack.field_190927_a, new IngredientStack[]{new IngredientStack("plateSilicon", 2), new IngredientStack("plateAdvancedElectronicAlloy"), new IngredientStack("plateAluminum"), new IngredientStack("dyeBlack")}, new String[]{"inserter", "solderer", "drill"}, new String[]{"drill work main", "solderer work first", "inserter pick first", "drill work main", "inserter drop main", "inserter pick second", "solderer work main", "inserter drop main", "inserter pick third", "inserter drop third", "solderer work main"}, 50000, 0.9f);
        PrecissionAssemblerRecipe.addRecipe(new ItemStack((Item)IIContent.itemMaterial, 1, IIContent.itemMaterial.getMetaBySubname("processor_electronic_element")), Utils.getStackWithMetaName(IIContent.itemMaterialNugget, "silicon"), new IngredientStack[]{new IngredientStack("transistor", 32), new IngredientStack("electronTubeAdvanced", 2)}, new String[]{"inserter", "solderer", "buzzsaw"}, new String[]{"solderer work first", "inserter pick first", "buzzsaw work main", "solderer work main", "inserter drop main", "buzzsaw work main", "solderer work main"}, 500000, 1.5f);
    }

    public static void addSiliconProcessingRecipes() {
        PrecissionAssemblerRecipe.addRecipe(Utils.getStackWithMetaName(IIContent.itemMaterialPlate, "silicon"), ItemStack.field_190927_a, new IngredientStack[]{new IngredientStack("bouleSilicon", 1)}, new String[]{"buzzsaw"}, new String[]{"buzzsaw work main"}, 24000, 3.0f);
        PrecissionAssemblerRecipe.addRecipe(Utils.getStackWithMetaName(IIContent.itemMaterialIngot, "silicon"), ItemStack.field_190927_a, new IngredientStack[]{new IngredientStack("bouleSilicon", 1)}, new String[]{"hammer", "buzzsaw"}, new String[]{"hammer work main", "hammer work main", "buzzsaw work main", "hammer work main"}, 24000, 1.0f);
        CrusherRecipe.removeRecipesForInput((ItemStack)new ItemStack(Items.field_151128_bU));
        CrusherRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemMaterialDust, "quartz_dirty"), (Object)new IngredientStack("gemQuartz", 1), (int)3200);
        BathingRecipe.addRecipe(Utils.getStackWithMetaName(IIContent.itemMaterialDust, "quartz"), new IngredientStack("dustQuartzDirty"), new FluidStack(IIContent.fluidHydrofluoricAcid, 1000), 4200, 240);
        ArcFurnaceRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemMaterialBoule, "silicon"), (Object)new IngredientStack("dustQuartz", 6), (ItemStack)ItemStack.field_190927_a, (int)400, (int)512, (Object[])new Object[0]);
        CrusherRecipe.removeRecipesForInput((ItemStack)new ItemStack(Items.field_151128_bU));
    }

    public static void addInkRecipes() {
        MixerRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidInkCyan, 1000), (FluidStack)new FluidStack(FluidRegistry.WATER, 500), (Object[])new Object[]{"dyeCyan"}, (int)3200);
        MixerRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidInkYellow, 1000), (FluidStack)new FluidStack(FluidRegistry.WATER, 500), (Object[])new Object[]{"dyeYellow"}, (int)3200);
        MixerRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidInkMagenta, 1000), (FluidStack)new FluidStack(FluidRegistry.WATER, 500), (Object[])new Object[]{"dyeMagenta"}, (int)3200);
        MixerRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidInkBlack, 1000), (FluidStack)new FluidStack(FluidRegistry.WATER, 500), (Object[])new Object[]{"dyeBlack"}, (int)3200);
    }

    public static void addBulletPressRecipes() {
        MetalPressRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemAmmoCasing, "artillery_8bcal", 1), (Object)new IngredientStack("plateSteel", 4), (ItemStack)Utils.getStackWithMetaName(IIContent.itemPressMold, "howitzer"), (int)2800);
        MetalPressRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemAmmoCasing, "mortar_6bCal", 1), (Object)new IngredientStack("plateSteel", 3), (ItemStack)Utils.getStackWithMetaName(IIContent.itemPressMold, "mortar"), (int)2500);
        MetalPressRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemAmmoCasing, "light_artillery_6bcal", 1), (Object)new IngredientStack("plateSteel", 3), (ItemStack)Utils.getStackWithMetaName(IIContent.itemPressMold, "light_howitzer"), (int)2200);
        MetalPressRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemAmmoCasing, "mg_2bcal", 1), (Object)new IngredientStack("ingotBrass"), (ItemStack)Utils.getStackWithMetaName(IIContent.itemPressMold, "machinegun"), (int)1600);
        MetalPressRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemAmmoCasing, "stg_1bcal", 1), (Object)new IngredientStack("ingotBrass"), (ItemStack)Utils.getStackWithMetaName(IIContent.itemPressMold, "assault_rifle"), (int)1400);
        MetalPressRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemAmmoCasing, "submachinegun_1bcal", 1), (Object)new IngredientStack("ingotBrass"), (ItemStack)Utils.getStackWithMetaName(IIContent.itemPressMold, "submachinegun"), (int)1200);
        MetalPressRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemAmmoCasing, "naval_mine", 1), (Object)new IngredientStack("plateSteel", 4), (ItemStack)Utils.getStackWithMetaName(IIContent.itemPressMold, "naval_mine"), (int)4800);
        MetalPressRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemAmmoCasing, "tripmine", 1), (Object)new IngredientStack("plateBrass", 2), (ItemStack)Utils.getStackWithMetaName(IIContent.itemPressMold, "tripmine"), (int)3600);
        MetalPressRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemAmmoCasing, "tellermine", 1), (Object)new IngredientStack("plateBrass", 2), (ItemStack)Utils.getStackWithMetaName(IIContent.itemPressMold, "tellermine"), (int)3600);
        MetalPressRecipe.removeRecipes((ItemStack)new ItemStack((Item)IEContent.itemBullet, 2, 0));
        MetalPressRecipe.addRecipe((ItemStack)new ItemStack((Item)IEContent.itemBullet, 2, 0), (Object)"ingotBrass", (ItemStack)new ItemStack((Item)IEContent.itemMold, 1, 3), (int)2800);
        BlueprintCraftingRecipe.addRecipe((String)"bullet_magazines", (ItemStack)Utils.getStackWithMetaName(IIContent.itemBulletMagazine, "machinegun"), (Object[])new Object[]{new IngredientStack("plateSteel", 2), new IngredientStack("springSteel", 1)});
        BlueprintCraftingRecipe.addRecipe((String)"bullet_magazines", (ItemStack)Utils.getStackWithMetaName(IIContent.itemBulletMagazine, "submachinegun"), (Object[])new Object[]{new IngredientStack("plateSteel", 2), new IngredientStack("springSteel", 1)});
        BlueprintCraftingRecipe.addRecipe((String)"bullet_magazines", (ItemStack)Utils.getStackWithMetaName(IIContent.itemBulletMagazine, "assault_rifle"), (Object[])new Object[]{new IngredientStack("plateSteel", 2), new IngredientStack("springSteel", 1)});
        BlueprintCraftingRecipe.addRecipe((String)"bullet_magazines", (ItemStack)Utils.getStackWithMetaName(IIContent.itemBulletMagazine, "submachinegun_drum"), (Object[])new Object[]{new IngredientStack("plateSteel", 5), new IngredientStack("springSteel", 1)});
        BlueprintCraftingRecipe.addRecipe((String)"bullet_magazines", (ItemStack)Utils.getStackWithMetaName(IIContent.itemBulletMagazine, "autocannon"), (Object[])new Object[]{new IngredientStack("plateSteel", 3), new IngredientStack("springSteel", 2)});
        BlueprintCraftingRecipe.addRecipe((String)"bullet_magazines", (ItemStack)Utils.getStackWithMetaName(IIContent.itemBulletMagazine, "cpds_drum"), (Object[])new Object[]{new IngredientStack("plateSteel", 8), new IngredientStack(new ItemStack((Item)IEContent.itemMaterial, 1, 8)), new IngredientStack("springSteel", 2), new IngredientStack("dyeGreen", 2)});
    }

    public static void addFunctionalCircuits() {
        for (ItemIIFunctionalCircuit.Circuit value : ItemIIFunctionalCircuit.Circuit.values()) {
            BlueprintCraftingRecipe.addRecipe((String)IIRecipes.getNameForCircuitTier(value.tier), (ItemStack)Utils.getStackWithMetaName(IIContent.itemCircuit, value.func_176610_l()), (Object[])new Object[]{new IngredientStack("circuitBasic", 2), new ItemStack((Item)IEContent.itemTool, 1, 1)});
        }
    }

    @Nonnull
    private static String getNameForCircuitTier(int tier) {
        switch (tier) {
            default: {
                return "basic_functional_circuits";
            }
            case 1: {
                return "advanced_functional_circuits";
            }
            case 2: 
        }
        return "processor_functional_circuits";
    }

    public static void addSpringRecipes() {
        BlueprintCraftingRecipe.addRecipe((String)"metal_springs", (ItemStack)Utils.getStackWithMetaName(IIContent.itemMaterialSpring, "iron", 2), (Object[])new Object[]{new IngredientStack("plateIron", 1), new ItemStack((Item)IEContent.itemTool, 1)});
        BlueprintCraftingRecipe.addRecipe((String)"metal_springs", (ItemStack)Utils.getStackWithMetaName(IIContent.itemMaterialSpring, "steel", 2), (Object[])new Object[]{new IngredientStack("plateSteel", 1), new ItemStack((Item)IEContent.itemTool, 1)});
        BlueprintCraftingRecipe.addRecipe((String)"metal_springs", (ItemStack)Utils.getStackWithMetaName(IIContent.itemMaterialSpring, "brass", 2), (Object[])new Object[]{new IngredientStack("plateBrass", 1), new ItemStack((Item)IEContent.itemTool, 1)});
    }

    public static void addMiscIERecipes() {
        BathingRecipe.addRecipe(new ItemStack((Block)IEContent.blockTreatedWood, 12), new IngredientStack("plankWood", 8), new FluidStack(IEContent.fluidCreosote, 1000), 3200, 120);
        MetalPressRecipe.addRecipe((ItemStack)new ItemStack((Item)IIContent.itemPrintedPage, 1, 0), (Object)new IngredientStack("paper"), (ItemStack)new ItemStack((Item)IEContent.itemMold, 1, 0), (int)600);
        ArcFurnaceRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemMaterial, "white_phosphorus", 4), (Object)new IngredientStack("dustPhosphorus", 4), (ItemStack)ItemStack.field_190927_a, (int)400, (int)512, (Object[])new Object[]{"dustCoke"});
    }

    public static void addWoodTableSawRecipes() {
        CraftingManager.field_193380_a.forEach(iRecipe -> {
            if (blusunrize.immersiveengineering.common.util.Utils.compareToOreName((ItemStack)iRecipe.func_77571_b(), (String)"plankWood")) {
                ItemStack out = iRecipe.func_77571_b().func_77946_l();
                out.func_190920_e(Math.round((float)out.func_190916_E() * 1.5f));
                ArrayList stacks = new ArrayList();
                for (Ingredient ingredient : iRecipe.func_192400_c()) {
                    Arrays.stream(ingredient.func_193365_a()).filter(stack -> blusunrize.immersiveengineering.common.util.Utils.compareToOreName((ItemStack)stack, (String)"logWood")).forEachOrdered(stacks::add);
                }
                if (!stacks.isEmpty()) {
                    SawmillRecipe.addRecipe(out, new IngredientStack(stacks).setUseNBT(false), Utils.getStackWithMetaName(IIContent.itemMaterial, "dust_wood"), Config.IIConfig.Machines.Sawmill.torqueMin + 2, 200, 1);
                }
            }
        });
        CrusherRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemMaterial, "dust_wood", 2), (Object)new IngredientStack("logWood"), (int)4096);
        CrusherRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemMaterial, "dust_wood", 1), (Object)new IngredientStack("plankWood", 2), (int)3192);
        SawmillRecipe.addRecipe(new ItemStack(Items.field_151055_y, 3), new IngredientStack("plankWood"), Utils.getStackWithMetaName(IIContent.itemMaterial, "dust_wood"), Config.IIConfig.Machines.Sawmill.torqueMin, 100, 1);
        SawmillRecipe.addRecipe(new ItemStack((Item)IEContent.itemMaterial, 3, 0), new IngredientStack("plankTreatedWood"), Utils.getStackWithMetaName(IIContent.itemMaterial, "dust_wood"), Config.IIConfig.Machines.Sawmill.torqueMin, 100, 1);
        BottlingMachineRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemMaterial, "pulp_wood"), (Object)new IngredientStack("dustWood"), (FluidStack)new FluidStack(FluidRegistry.WATER, 250));
        BottlingMachineRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemMaterial, "pulp_wood_treated", 1), (Object)new IngredientStack("pulpWood"), (FluidStack)new FluidStack(IEContent.fluidCreosote, 1000));
        MetalPressRecipe.addRecipe((ItemStack)new ItemStack(Items.field_151121_aF, 2, 0), (Object)new IngredientStack("pulpWood"), (ItemStack)new ItemStack((Item)IEContent.itemMold, 1, 0), (int)100);
        MetalPressRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemMaterial, "artificial_leather"), (Object)new IngredientStack("pulpWoodTreated"), (ItemStack)new ItemStack((Item)IEContent.itemMold, 1, 0), (int)600);
        CrusherRecipe.addRecipe((ItemStack)new ItemStack((Item)IIContent.itemMaterial, 1, 17), (Object)new IngredientStack(new ItemStack((Block)IIContent.blockCharredLog)), (int)2024).addToSecondaryOutput(new Object[]{Utils.getStackWithMetaName(IIContent.itemMaterial, "dust_wood", 1), Float.valueOf(1.0f)});
    }

    public static void addRotaryPowerRecipes() {
    }

    public static void addMinecartRecipes(IForgeRegistry<IRecipe> registry) {
        for (ItemIIMinecart.Minecarts value : ItemIIMinecart.Minecarts.values()) {
            registry.register(new RecipeMinecart(new ItemStack((Item)IIContent.itemMinecart, 1, value.ordinal()), value.stack.get()).setRegistryName("immersiveintelligence", "minecart_" + value.func_176610_l()));
        }
    }

    public static void addSmallCrateRecipes(IForgeRegistry<IRecipe> registry) {
        registry.register(new RecipeCrateConversion(new ItemStack((Block)IEContent.blockWoodenDevice0, 1, 0), IIRecipes.getSmallCrate(IIBlockTypes_SmallCrate.WOODEN_CRATE_BOX), IIRecipes.getSmallCrate(IIBlockTypes_SmallCrate.WOODEN_CRATE_CUBE), IIRecipes.getSmallCrate(IIBlockTypes_SmallCrate.WOODEN_CRATE_WIDE)).setRegistryName("immersiveintelligence", "small_crate_wooden"));
        registry.register(new RecipeCrateConversion(new ItemStack((Block)IIContent.blockMetalDevice, 1, 0), IIRecipes.getSmallCrate(IIBlockTypes_SmallCrate.METAL_CRATE_BOX), IIRecipes.getSmallCrate(IIBlockTypes_SmallCrate.METAL_CRATE_CUBE), IIRecipes.getSmallCrate(IIBlockTypes_SmallCrate.METAL_CRATE_WIDE)).setRegistryName("immersiveintelligence", "small_crate_metal"));
    }

    public static ItemStack getSmallCrate(IIBlockTypes_SmallCrate e) {
        return new ItemStack((Block)IIContent.blockSmallCrate, 1, e.getMeta());
    }

    public static void addRDXProductionRecipes() {
        MixerRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidMethanol, 500), (FluidStack)new FluidStack(IIContent.gasHydrogen, 1000), (Object[])new IngredientStack[]{new IngredientStack("dustNickel")}, (int)3200);
        MixerRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidMethanol, 2000), (FluidStack)new FluidStack(IIContent.gasHydrogen, 3000), (Object[])new IngredientStack[]{new IngredientStack("dustPlatinum")}, (int)4800);
        FermenterRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidAmmonia, 120), (ItemStack)ItemStack.field_190927_a, (Object)new IngredientStack("listAllMeatRaw"), (int)1600);
        FermenterRecipe.addRecipe((FluidStack)new FluidStack(IIContent.fluidAmmonia, 160), (ItemStack)ItemStack.field_190927_a, (Object)new ItemStack(Items.field_151078_bh), (int)1000);
        BottlingMachineRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemMaterial, "dust_formaldehyde", 2), (Object)new IngredientStack("nuggetSilver"), (FluidStack)new FluidStack(IIContent.fluidMethanol, 1000));
        BottlingMachineRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemMaterial, "dust_hexamine", 1), (Object)new IngredientStack("dustFormaldehyde"), (FluidStack)new FluidStack(IIContent.fluidAmmonia, 320));
    }

    public static void addHMXProductionRecipes() {
        BottlingMachineRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemMaterial, "dust_hmx", 1), (Object)new IngredientStack("materialHexogen"), (FluidStack)new FluidStack(IIContent.fluidNitricAcid, 500));
    }

    public static void addConcreteRecipes() {
        BathingRecipe.addRecipe(Utils.getStackWithMetaName(IIContent.blockConcreteDecoration, "concrete_bricks"), new IngredientStack(new ItemStack(Blocks.field_150336_V)), new FluidStack(FluidRegistry.getFluid((String)"concrete"), 500), 1600, 120);
        ArcFurnaceRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.blockConcreteDecoration, "sturdy_concrete_bricks"), (Object)Utils.getStackWithMetaName(IIContent.blockConcreteDecoration, "concrete_bricks"), (ItemStack)ItemStack.field_190927_a, (int)200, (int)2400, (Object[])new Object[]{new IngredientStack("stickSteel", 2)});
        ArcFurnaceRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.blockConcreteDecoration, "uberconcrete", 2), (Object)Utils.getStackWithMetaName(IIContent.blockConcreteDecoration, "sturdy_concrete_bricks"), (ItemStack)ItemStack.field_190927_a, (int)200, (int)3600, (Object[])new Object[]{new ItemStack((Block)IEContent.blockStoneDecoration, 1, BlockTypes_StoneDecoration.CONCRETE_LEADED.getMeta())});
    }

    public static void addChemicalBathCleaningRecipes() {
        Block[] shulker_boxes;
        String[] dyes;
        for (String dye : dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"}) {
            IIRecipes.addBathingCleaningRecipe(new ItemStack(Blocks.field_150325_L, 1), new IngredientStack("wool" + dye), 1000, 1024, 200, true, false, false);
            IIRecipes.addBathingCleaningRecipe(new ItemStack(Blocks.field_150359_w, 1), new IngredientStack("blockGlass" + dye), 1000, 1024, 200, true);
            IIRecipes.addBathingCleaningRecipe(new ItemStack(Blocks.field_150410_aZ, 1), new IngredientStack("paneGlass" + dye), 1000, 1024, 200, true);
        }
        for (int i = 0; i < 16; ++i) {
            if (i != 0) {
                IIRecipes.addBathingCleaningRecipe(new ItemStack(Blocks.field_150324_C, 1), new IngredientStack(new ItemStack(Blocks.field_150324_C, 1, i)), 2000, 3096, 240, true, false, false);
                IIRecipes.addBathingCleaningRecipe(new ItemStack(Blocks.field_150404_cg, 1), new IngredientStack(new ItemStack(Blocks.field_150404_cg, 1, i)), 2000, 3096, 240, true, false, false);
            }
            IIRecipes.addBathingCleaningRecipe(new ItemStack(Blocks.field_150405_ch, 1), new IngredientStack(new ItemStack(Blocks.field_150406_ce, 1, i)), 2000, 1440, 280, false, true, true);
        }
        for (Block shulker_box : shulker_boxes = new Block[]{Blocks.field_190978_dm, Blocks.field_190979_dn, Blocks.field_190980_do, Blocks.field_190981_dp, Blocks.field_190982_dq, Blocks.field_190983_dr, Blocks.field_190984_ds, Blocks.field_190985_dt, Blocks.field_190986_du, Blocks.field_190988_dw, Blocks.field_190989_dx, Blocks.field_190990_dy, Blocks.field_190991_dz}) {
            IIRecipes.addBathingCleaningRecipe(new ItemStack(Blocks.field_190977_dl, 1), new IngredientStack(new ItemStack(shulker_box, 1)), 2000, 4096, 120, false, true, true);
        }
        IIRecipes.addBathingCleaningRecipe(new ItemStack(Items.field_179564_cE, 1), new IngredientStack(new ItemStack(Items.field_179564_cE, 1)), 2000, 1024, 160, true, false, false);
    }

    public static void addChemicalPainterRecipes() {
        PaintingRecipe.addRecipe((rgb, stack) -> {
            EnumDyeColor dye = Utils.getRGBTextFormatting(rgb);
            return new ItemStack(Blocks.field_150325_L, 1, dye.func_176765_a());
        }, new IngredientStack(new ItemStack(Blocks.field_150325_L)), 512, 240, 125);
        PaintingRecipe.addRecipe((rgb, stack) -> {
            EnumDyeColor dye = Utils.getRGBTextFormatting(rgb);
            return new ItemStack(Blocks.field_150404_cg, 1, dye.func_176765_a());
        }, new IngredientStack(new ItemStack(Blocks.field_150404_cg)), 512, 240, 50);
        PaintingRecipe.addRecipe((rgb, stack) -> {
            EnumDyeColor dye = Utils.getRGBTextFormatting(rgb);
            return new ItemStack((Block)Blocks.field_150399_cn, 1, dye.func_176765_a());
        }, new IngredientStack(new ItemStack(Blocks.field_150359_w)), 512, 240, 125);
        PaintingRecipe.addRecipe((rgb, stack) -> {
            EnumDyeColor dye = Utils.getRGBTextFormatting(rgb);
            return new ItemStack((Block)Blocks.field_150397_co, 1, dye.func_176765_a());
        }, new IngredientStack(new ItemStack(Blocks.field_150410_aZ)), 512, 240, 125);
        PaintingRecipe.addRecipe((rgb, stack) -> {
            EnumDyeColor dye = Utils.getRGBTextFormatting(rgb);
            return new ItemStack(Blocks.field_150406_ce, 1, dye.func_176765_a());
        }, new IngredientStack(new ItemStack(Blocks.field_150405_ch)), 512, 240, 125);
        PaintingRecipe.addRecipe((rgb, stack) -> {
            EnumDyeColor dye = Utils.getRGBTextFormatting(rgb);
            return new ItemStack(Items.field_151104_aV, 1, dye.func_176765_a());
        }, new IngredientStack(new ItemStack(Items.field_151104_aV)), 512, 240, 200);
        PaintingRecipe.addRecipe((rgb, stack) -> {
            IIContent.itemAdvancedPowerPack.func_82813_b((ItemStack)stack, (int)rgb);
            return stack;
        }, new IngredientStack(new ItemStack((Item)IIContent.itemAdvancedPowerPack)), 8192, 340, 2000);
        PaintingRecipe.addRecipe((rgb, stack) -> {
            Items.field_151024_Q.func_82813_b(stack, rgb.intValue());
            return stack;
        }, new IngredientStack((List)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((Item)Items.field_151024_Q), new ItemStack((Item)Items.field_151027_R), new ItemStack((Item)Items.field_151026_S), new ItemStack((Item)Items.field_151021_T)})), 8192, 340, 2000);
        PaintingRecipe.addRecipe((rgb, stack) -> stack, new IngredientStack((List)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((Item)IIContent.itemLightEngineerHelmet), new ItemStack((Item)IIContent.itemLightEngineerChestplate), new ItemStack((Item)IIContent.itemLightEngineerLeggings), new ItemStack((Item)IIContent.itemLightEngineerBoots)})), 8192, 340, 2000);
        for (IBullet bullet : BulletRegistry.INSTANCE.registeredBulletItems.values()) {
            ItemStack bulletStack = bullet.getBulletWithParams("", "", "");
            bulletStack.func_77982_d(new NBTTagCompound());
            PaintingRecipe.addRecipe((rgb, stack) -> {
                ItemStack ret = bullet.setPaintColour((ItemStack)stack, (int)rgb);
                ret.func_190920_e(1);
                return ret;
            }, new IngredientStack(bulletStack).setUseNBT(false), (int)(bullet.getCaliber() * 1024.0f), 100 + (int)(bullet.getCaliber() * 40.0f), 50 + (int)(bullet.getCaliber() * 25.0f));
        }
    }

    private static void addBathingCleaningRecipe(ItemStack out, IngredientStack in, int amount, int energy, int time, boolean allowHFl) {
        IIRecipes.addBathingCleaningRecipe(out, in, amount, energy, time, true, true, allowHFl);
    }

    private static void addBathingCleaningRecipe(ItemStack out, IngredientStack in, int amount, int energy, int time, boolean allowWater, boolean allowSulfuric, boolean allowHFl) {
        if (allowWater) {
            BathingRecipe.addWashingRecipe(out, in, new FluidStack(FluidRegistry.WATER, amount), energy, time);
        }
        if (allowSulfuric) {
            BathingRecipe.addWashingRecipe(out, in, new FluidStack(IIContent.fluidSulfuricAcid, allowWater ? amount / 2 : amount), allowWater ? energy / 2 : energy, allowWater ? time / 2 : time);
        }
        if (allowHFl) {
            BathingRecipe.addWashingRecipe(out, in, new FluidStack(IIContent.fluidHydrofluoricAcid, amount / 2), allowWater ? energy / 4 : energy / 2, allowWater ? time / 4 : time / 2);
        }
    }

    public static void addUpgradeRecipes() {
        IIContent.UPGRADE_INSERTER.addStack(new IngredientStack(Utils.getStackWithMetaName(IIContent.itemPrecissionTool, "precission_inserter"))).addStack(new IngredientStack("scaffoldingSteel")).setRequiredProgress(20000).setRequiredSteps(12);
        IIContent.UPGRADE_SAW_UNREGULATOR.addStack(new IngredientStack(Utils.getStackWithMetaName(IIContent.itemMotorGear, "steel"))).addStack(new IngredientStack(new ItemStack((Item)IEContent.itemMaterial, 1, 8))).addStack(new IngredientStack("stickSteel", 2)).setRequiredProgress(32000);
        IIContent.UPGRADE_IMPROVED_GEARBOX.addStack(new IngredientStack(Utils.getStackWithMetaName(IIContent.itemMotorGear, "tungsten", 2))).addStack(new IngredientStack(new ItemStack((Item)IEContent.itemMaterial, 1, 9))).addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDecoration0, 2, BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta()))).setRequiredProgress(32000);
        IIContent.UPGRADE_MG_LOADER.addStack(new IngredientStack("plateSteel", 8)).setRequiredProgress(20000).setRequiredSteps(10);
        IIContent.UPGRADE_UNPACKER_CONVERSION.setRequiredProgress(20000).setRequiredSteps(25);
        IIContent.UPGRADE_PACKER_FLUID.addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDevice0, 1, BlockTypes_MetalDevice0.FLUID_PUMP.getMeta()))).addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDevice0, 2, BlockTypes_MetalDevice0.BARREL.getMeta()))).setRequiredProgress(20000).setRequiredSteps(25);
        IIContent.UPGRADE_PACKER_ENERGY.addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDevice1, 1, BlockTypes_MetalDevice1.TESLA_COIL.getMeta()))).addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDevice0, 2, BlockTypes_MetalDevice0.CAPACITOR_MV.getMeta()))).setRequiredProgress(20000).setRequiredSteps(25);
        IIContent.UPGRADE_RADIO_LOCATORS.addStack(new IngredientStack("plateSteel", 4)).addStack(new IngredientStack(new ItemStack((Item)IIContent.itemRadioConfigurator, 2, 1))).addStack(new IngredientStack(new ItemStack((Item)IIContent.itemDataWireCoil, 10, 0))).setRequiredProgress(250000).setRequiredSteps(1);
        IIContent.UPGRADE_EMPLACEMENT_WEAPON_MACHINEGUN.addStack(new IngredientStack(new ItemStack((Block)IIContent.blockSandbags, 4))).addStack(new IngredientStack(new ItemStack((Item)IIContent.itemMachinegun, 2))).addStack(new IngredientStack(new ItemStack((Block)IIContent.blockMetalDevice, 2, IIBlockTypes_MetalDevice.AMMUNITION_CRATE.getMeta()))).addStack(new IngredientStack("circuitBasic", 4)).setRequiredProgress(40000);
        IIContent.UPGRADE_EMPLACEMENT_WEAPON_IROBSERVER.addStack(new IngredientStack("blockGlassRed", 1)).addStack(new IngredientStack("blockGlass", 1)).addStack(new IngredientStack("blockSteel", 2)).addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDecoration0, 2, BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta()))).addStack(new IngredientStack("circuitBasic", 6)).setRequiredProgress(40000);
        IIContent.UPGRADE_EMPLACEMENT_WEAPON_AUTOCANNON.addStack(new IngredientStack(new ItemStack((Item)IEContent.itemMaterial, 4, 14))).addStack(new IngredientStack("blockSteel", 2)).addStack(new IngredientStack(new ItemStack((Item)IEContent.itemMaterial, 3, 9))).addStack(new IngredientStack(new ItemStack((Block)IIContent.blockMetalDevice, 1, IIBlockTypes_MetalDevice.AMMUNITION_CRATE.getMeta()))).addStack(new IngredientStack("circuitAdvanced", 6)).setRequiredProgress(80000);
        IIContent.UPGRADE_EMPLACEMENT_WEAPON_HEAVY_CHEMTHROWER.addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDevice0, 2, BlockTypes_MetalDevice0.FLUID_PLACER.getMeta()))).addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDevice1, 4, BlockTypes_MetalDevice1.FLUID_PIPE.getMeta()))).addStack(new IngredientStack(new ItemStack((Item)IEContent.itemMaterial, 2, 14))).addStack(new IngredientStack("blockSteel", 1)).addStack(new IngredientStack("circuitAdvanced", 6)).setRequiredProgress(80000);
        IIContent.UPGRADE_EMPLACEMENT_WEAPON_HEAVY_RAILGUN.addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDevice0, 2, BlockTypes_MetalDevice0.CAPACITOR_HV.getMeta()))).addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.COIL_HV.getMeta()))).addStack(new IngredientStack("blockSteel", 1)).addStack(new IngredientStack(new ItemStack((Item)IEContent.itemMaterial, 2, 9))).addStack(new IngredientStack(new ItemStack((Block)IIContent.blockMetalDevice, 1, IIBlockTypes_MetalDevice.AMMUNITION_CRATE.getMeta()))).addStack(new IngredientStack("circuitAdvanced", 6)).setRequiredProgress(80000);
        IIContent.UPGRADE_EMPLACEMENT_WEAPON_TESLA.addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDevice0, 8, BlockTypes_MetalDevice0.CAPACITOR_HV.getMeta()))).addStack(new IngredientStack(new ItemStack((Block)IEContent.blockMetalDecoration0, 8, BlockTypes_MetalDecoration0.COIL_HV.getMeta()))).addStack(new IngredientStack("circuitAdvanced", 6)).setRequiredProgress(120000);
        IIContent.UPGRADE_EMPLACEMENT_WEAPON_CPDS.addStack(new IngredientStack(new ItemStack((Item)IEContent.itemMaterial, 8, 14))).addStack(new IngredientStack(new ItemStack((Item)IEContent.itemMaterial, 2, 9))).addStack(new IngredientStack("blockSteel", 3)).addStack(new IngredientStack("circuitProcessor", 6)).setRequiredProgress(300000);
    }

    public static void addSmeltingRecipes() {
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Block)IIContent.blockOre, IIBlockTypes_Ore.ZINC.getMeta()), Utils.getStackWithMetaName(IIContent.itemMaterialIngot, "zinc"), 0.5f);
        FurnaceRecipes.func_77602_a().func_151394_a(Utils.getStackWithMetaName(IIContent.itemMaterialDust, "zinc"), Utils.getStackWithMetaName(IIContent.itemMaterialIngot, "zinc"), 0.5f);
        FurnaceRecipes.func_77602_a().func_151394_a(Utils.getStackWithMetaName(IIContent.itemMaterialDust, "brass"), Utils.getStackWithMetaName(IIContent.itemMaterialIngot, "brass"), 0.5f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Block)IIContent.blockOre, IIBlockTypes_Ore.PLATINUM.getMeta()), Utils.getStackWithMetaName(IIContent.itemMaterialIngot, "platinum"), 0.5f);
        FurnaceRecipes.func_77602_a().func_151394_a(Utils.getStackWithMetaName(IIContent.itemMaterialDust, "platinum"), Utils.getStackWithMetaName(IIContent.itemMaterialIngot, "platinum"), 0.5f);
        if (Config.IIConfig.smeltableTungsten) {
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Block)IIContent.blockOre, IIBlockTypes_Ore.TUNGSTEN.getMeta()), Utils.getStackWithMetaName(IIContent.itemMaterialIngot, "tungsten"), 0.5f);
            FurnaceRecipes.func_77602_a().func_151394_a(Utils.getStackWithMetaName(IIContent.itemMaterialDust, "tungsten"), Utils.getStackWithMetaName(IIContent.itemMaterialIngot, "tungsten"), 0.5f);
        }
        if (Config.IIConfig.smeltableAEA) {
            FurnaceRecipes.func_77602_a().func_151394_a(Utils.getStackWithMetaName(IIContent.itemMaterialDust, "advanced_electronic_alloy"), Utils.getStackWithMetaName(IIContent.itemMaterialIngot, "advanced_electronic_alloy"), 0.5f);
        }
    }

    public static void addArcFurnaceRecyclingRecipes() {
        ArcFurnaceRecipe.allowItemForRecycling((Object)new ItemStack((Item)IIContent.itemDrillhead, 1, Short.MAX_VALUE));
        ArcFurnaceRecipe.allowItemForRecycling((Object)new ItemStack((Item)IIContent.itemSawblade, 1, Short.MAX_VALUE));
        ArcFurnaceRecipe.allowItemForRecycling((Object)new ItemStack((Block)IIContent.blockMetalDecoration, 1, Short.MAX_VALUE));
        ArcFurnaceRecipe.allowItemForRecycling((Object)new ItemStack((Block)IIContent.blockMetalDevice, 1, Short.MAX_VALUE));
        ArcFurnaceRecipe.allowItemForRecycling((Object)new ItemStack((Block)IIContent.blockMetalFortification, 1, Short.MAX_VALUE));
        ArcFurnaceRecipe.allowItemForRecycling((Object)new ItemStack((Block)IIContent.blockMetalFortification1, 1, Short.MAX_VALUE));
    }

    public static void addAmmunitionCasingRecipes() {
        IBullet bullet;
        FillerRecipe.recipeList.clear();
        FillerRecipe.addRecipe(IIContent.itemAmmoArtillery, 160, 8000);
        FillerRecipe.addRecipe(IIContent.itemAmmoLightArtillery, 140, 6000);
        FillerRecipe.addRecipe(IIContent.itemAmmoAutocannon, 80, 1000);
        FillerRecipe.addRecipe(IIContent.itemAmmoMachinegun, 60, 800);
        FillerRecipe.addRecipe(IIContent.itemAmmoAssaultRifle, 55, 700);
        FillerRecipe.addRecipe(IIContent.itemAmmoSubmachinegun, 50, 600);
        FillerRecipe.addRecipe(IIContent.itemAmmoRevolver, 40, 400);
        for (Item item : new Item[]{IIContent.itemAmmoArtillery, IIContent.itemAmmoLightArtillery, IIContent.itemAmmoAutocannon, IIContent.itemAmmoMachinegun, IIContent.itemAmmoAssaultRifle, IIContent.itemAmmoSubmachinegun, IIContent.itemAmmoRevolver}) {
            assert (item != null);
            bullet = (IBullet)item;
            ItemStack casingStack = bullet.getCasingStack(1);
            ItemNBTHelper.setBoolean((ItemStack)casingStack, (String)"ii_FilledCasing", (boolean)true);
            AmmunitionWorkshopRecipe.addRecipe((core, casing) -> {
                ItemStack stack = new ItemStack(item, 1, 0);
                stack.deserializeNBT(core.serializeNBT());
                return stack;
            }, new IngredientStack(bullet.getBulletCore("coreBrass", IIContent.itemAmmoArtillery.getAllowedCoreTypes()[0].func_176610_l())), new IngredientStack(casingStack).setUseNBT(true), (int)(128.0f * bullet.getCaliber()), (int)(240.0f + 20.0f * bullet.getCaliber()));
        }
        for (Item item : new Item[]{IIContent.blockTripmine.bullet, IIContent.blockTellermine.bullet, IIContent.itemNavalMine, IIContent.itemGrenade, IIContent.itemRailgunGrenade}) {
            assert (item != null);
            bullet = (IBullet)item;
            AmmunitionWorkshopRecipe.addRecipe((core, casing) -> {
                ItemStack stack = new ItemStack(item, 1, IIBlockTypes_Mine.MAIN.getMeta());
                stack.deserializeNBT(core.serializeNBT());
                return stack;
            }, new IngredientStack(bullet.getBulletCore("coreBrass", IIContent.itemAmmoArtillery.getAllowedCoreTypes()[0].func_176610_l())), new IngredientStack(bullet.getCasingStack(1)).setUseNBT(true), (int)(128.0f * bullet.getCaliber()), 480);
        }
    }

    public static void addRubberRecipes() {
        for (int i = 0; i < IIContent.itemVulcanizerMold.getSubNames().length; ++i) {
            BlueprintCraftingRecipe.addRecipe((String)"vulcanizer_molds", (ItemStack)new ItemStack((Item)IIContent.itemVulcanizerMold, 1, i), (Object[])new Object[]{new IngredientStack("plateSteel", 8), new ItemStack((Item)IEContent.itemTool, 1, 1)});
        }
        MetalPressRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemMaterialPlate, "rubber_raw"), (Object)new IngredientStack("rubberRaw"), (ComparableItemStack)ApiUtils.createComparableItemStack((ItemStack)new ItemStack((Item)IEContent.itemMold, 1, 0), (boolean)false), (int)2400);
        VulcanizerRecipe.addRecipe(Utils.getStackWithMetaName(IIContent.itemMaterial, "rubber_belt", 4), new ComparableItemStack(Utils.getStackWithMetaName(IIContent.itemVulcanizerMold, "belt")), new IngredientStack("plateRubberRaw", 10), new IngredientStack("dustVulcanizationCompound", 3), new IngredientStack("dustSulfur", 2), 24000);
        VulcanizerRecipe.addRecipe(Utils.getStackWithMetaName(IIContent.itemMaterial, "rubber_tire", 3), new ComparableItemStack(Utils.getStackWithMetaName(IIContent.itemVulcanizerMold, "tire")), new IngredientStack("plateRubberRaw", 10), new IngredientStack("dustVulcanizationCompound", 8), new IngredientStack("dustSulfur", 3), 32000);
        CoagulatorRecipe.addRecipe(Utils.getStackWithMetaName(IIContent.itemMaterial, "natural_rubber", 8), new FluidStack(IIContent.fluidLatex, 5500), new FluidStack(IIContent.fluidFormicAcid, 500), 24000, 400, 2400);
    }

    public static void addMetalPressRecipes() {
        for (int i = 0; i < IIContent.itemPressMold.getSubNames().length; ++i) {
            BlueprintCraftingRecipe.addRecipe((String)"ammo_molds", (ItemStack)new ItemStack((Item)IIContent.itemPressMold, 1, i), (Object[])new Object[]{new IngredientStack("plateSteel", 5), new ItemStack((Item)IEContent.itemTool, 1, 1)});
        }
    }

    public static void addDuraluminiumRecipes() {
        ArcFurnaceRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemMaterialIngot, "duraluminium", 6), (Object)new IngredientStack("ingotAluminum", 6), (ItemStack)new ItemStack(Items.field_191525_da), (int)600, (int)640, (Object[])new Object[]{"ingotCopper", "ingotZinc", "ingotIron", "ingotSilicon"});
        ArcFurnaceRecipe.addRecipe((ItemStack)Utils.getStackWithMetaName(IIContent.itemMaterialIngot, "duraluminium", 6), (Object)new IngredientStack("dustAluminum", 6), (ItemStack)new ItemStack(Items.field_191525_da), (int)600, (int)640, (Object[])new Object[]{"dustCopper", "dustZinc", "dustIron", "dustSilicon"});
    }
}

