/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.ammunition_system.emplacement_weapons;

import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.entities.EntityRailgunShot;
import blusunrize.immersiveengineering.common.util.IESounds;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletHelper;
import pl.pabilo8.immersiveintelligence.client.ShaderUtil;
import pl.pabilo8.immersiveintelligence.client.gui.emplacement.GuiEmplacementPageStorage;
import pl.pabilo8.immersiveintelligence.client.render.multiblock.metal.EmplacementRenderer;
import pl.pabilo8.immersiveintelligence.client.tmt.ModelRendererTurbo;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.ammunition_system.emplacement_weapons.EmplacementWeaponCPDS;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.second.TileEntityEmplacement;
import pl.pabilo8.immersiveintelligence.common.entity.EntityEmplacementWeapon;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.items.weapons.ItemIIRailgunOverride;

public class EmplacementWeaponHeavyRailgun
extends TileEntityEmplacement.EmplacementWeapon {
    private AxisAlignedBB vision;
    float shootDelay = Config.IIConfig.Weapons.EmplacementWeapons.HeavyRailgun.shotFireTime;
    int reloadDelay = 0;
    private Vec3d vv;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private NonNullList<ItemStack> inventoryPlatform = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    private boolean requiresPlatformRefill = false;
    private ArrayDeque<ItemStack> magazine = new ArrayDeque();
    private ItemStack s2 = ItemStack.field_190927_a;
    private final IItemHandler inventoryHandler = new ItemStackHandler(this.inventory){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (!ItemIIRailgunOverride.isAmmo(stack)) {
                return false;
            }
            return super.isItemValid(slot, stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            ItemStack itemStack = super.insertItem(slot, stack, simulate);
            EmplacementWeaponHeavyRailgun.this.inventory.set(slot, this.stacks.get(slot));
            return itemStack;
        }
    };

    @Override
    public String getName() {
        return "heavy_railgun";
    }

    @Override
    public float getYawTurnSpeed() {
        return Config.IIConfig.Weapons.EmplacementWeapons.HeavyRailgun.yawRotateSpeed;
    }

    @Override
    public float getPitchTurnSpeed() {
        return Config.IIConfig.Weapons.EmplacementWeapons.HeavyRailgun.pitchRotateSpeed;
    }

    @Override
    public void shoot(TileEntityEmplacement te) {
        super.shoot(te);
        if (!te.func_145831_w().field_72995_K) {
            ItemStack itemStack = this.s2 = this.magazine.size() > 0 ? this.magazine.removeFirst() : ItemStack.field_190927_a;
            if (!this.s2.func_190926_b()) {
                te.func_145831_w().func_184148_a(null, (double)te.func_174877_v().func_177958_n(), (double)te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p(), IESounds.railgunFire, SoundCategory.PLAYERS, 1.5f, 0.0f);
                if (this.s2.func_77973_b() == IIContent.itemRailgunGrenade) {
                    EntityBullet a = BulletHelper.createBullet(te.func_145831_w(), this.s2, te.getWeaponCenter(), this.vv.func_186678_a(-1.0), 3.0f);
                    a.setShootPos(te.getAllBlocks());
                    if (this.entity != null) {
                        a.setShooters((Entity)this.entity, (Entity[])this.entity.partArray);
                    }
                    te.func_145831_w().func_72838_d((Entity)a);
                } else {
                    Vec3d weaponCenter = te.getWeaponCenter();
                    Vec3d scale = this.vv.func_186678_a(-1.0).func_72432_b();
                    float speed = 20.0f;
                    EntityRailgunShot shot = new EntityRailgunShot(te.func_145831_w(), (EntityLivingBase)this.entity, scale.field_72450_a * (double)speed, scale.field_72448_b * (double)speed, scale.field_72449_c * (double)speed, this.s2.func_77946_l());
                    shot.func_70107_b(weaponCenter.field_72450_a, weaponCenter.field_72448_b, weaponCenter.field_72449_c);
                    te.func_145831_w().func_72838_d((Entity)shot);
                }
            }
        } else if (this.magazine.size() > 0) {
            this.magazine.removeFirst();
        }
        this.shootDelay = Config.IIConfig.Weapons.EmplacementWeapons.HeavyRailgun.shotFireTime;
    }

    @Override
    public boolean isSetUp(boolean door) {
        return true;
    }

    @Override
    public boolean requiresPlatformRefill() {
        return this.requiresPlatformRefill;
    }

    @Override
    public float[] getAnglePrediction(Vec3d posTurret, Vec3d posTarget, Vec3d motion) {
        ItemStack itemStack = this.s2 = this.magazine.size() > 0 ? this.magazine.peekFirst() : ItemStack.field_190927_a;
        if (this.s2.func_77973_b() == IIContent.itemRailgunGrenade) {
            double baseMotionY;
            float force = IIContent.itemRailgunGrenade.getDefaultVelocity() * 3.0f;
            float mass = this.s2.func_190926_b() ? 0.0f : IIContent.itemRailgunGrenade.getMass(this.s2);
            this.vv = posTurret.func_178788_d(posTarget.func_178787_e(motion.func_186678_a(EmplacementWeaponCPDS.getInterceptTime(force, posTurret.func_178788_d(posTarget), motion))));
            double gravityMotionY = 0.0;
            double motionY = 0.0;
            double baseMotionYC = baseMotionY = this.vv.func_72432_b().field_72448_b;
            for (double dist = this.vv.func_72438_d(new Vec3d(0.0, this.vv.field_72448_b, 0.0)); dist > 0.0; dist -= (double)(EntityBullet.DEV_SLOMO * force)) {
                force -= 0.0f * force * EntityBullet.DEV_SLOMO;
                baseMotionYC = baseMotionY * (double)(force / (IIContent.itemRailgunGrenade.getDefaultVelocity() * 3.0f));
                motionY += (baseMotionYC + (gravityMotionY -= (double)(0.15f * mass * EntityBullet.DEV_SLOMO))) * (double)EntityBullet.DEV_SLOMO;
            }
            this.vv = this.vv.func_72441_c(0.0, motionY - baseMotionY, 0.0).func_72432_b();
        } else {
            this.vv = posTurret.func_178788_d(posTarget.func_178787_e(motion));
            double dist = this.vv.func_72438_d(new Vec3d(0.0, this.vv.field_72448_b, 0.0));
            RailgunHandler.RailgunProjectileProperties p = RailgunHandler.getProjectileProperties((ItemStack)this.s2);
            if (p != null) {
                double baseMotionY;
                float force = 20.0f;
                float gravity = (float)p.gravity;
                double gravityMotionY = 0.0;
                double motionY = 0.0;
                double baseMotionYC = baseMotionY = this.vv.func_72432_b().field_72448_b;
                while (dist > 0.0) {
                    dist -= (double)force;
                    force = (float)((double)force * 0.99);
                    motionY += (baseMotionYC *= (double)0.99f) + (gravityMotionY -= (double)gravity);
                }
                this.vv = this.vv.func_72441_c(0.0, motionY - baseMotionY, 0.0).func_72432_b();
            }
        }
        float yy = (float)(Math.atan2(this.vv.field_72450_a, this.vv.field_72449_c) * 180.0 / 3.1415927410125732);
        float pp = (float)Math.toDegrees(Math.atan2(this.vv.field_72448_b, this.vv.func_72438_d(new Vec3d(0.0, this.vv.field_72448_b, 0.0))));
        return new float[]{yy, pp};
    }

    @Override
    public void aimAt(float yaw, float pitch) {
        if (this.reloadDelay == 0) {
            super.aimAt(yaw, pitch);
        } else {
            super.aimAt(yaw, 0.0f);
        }
    }

    @Override
    public void init(TileEntityEmplacement te, boolean firstTime) {
        super.init(te, firstTime);
        this.vision = new AxisAlignedBB(te.func_174877_v()).func_72317_d(-0.5, 0.0, -0.5).func_186662_g((double)Config.IIConfig.Weapons.EmplacementWeapons.HeavyRailgun.detectionRadius);
    }

    @Override
    public void tick(TileEntityEmplacement te, boolean active) {
        if (active && this.magazine.isEmpty()) {
            if (this.reloadDelay == 0) {
                if (this.inventoryPlatform.stream().anyMatch(ItemIIRailgunOverride::isAmmo)) {
                    this.reloadDelay = 1;
                } else {
                    this.requiresPlatformRefill = true;
                }
            } else if (this.pitch == 0.0f) {
                ++this.reloadDelay;
            }
            if (this.reloadDelay >= Config.IIConfig.Weapons.EmplacementWeapons.HeavyRailgun.reloadAmmoBoxTime) {
                for (ItemStack stack : this.inventoryPlatform) {
                    if (this.magazine.size() >= 8) break;
                    while (!stack.func_190926_b() && this.magazine.size() < 8) {
                        ItemStack copy = stack.func_77946_l();
                        copy.func_190920_e(1);
                        this.magazine.addLast(copy);
                        stack.func_190918_g(1);
                    }
                }
                this.reloadDelay = 0;
                this.syncWithClient(te);
            }
        }
        if (this.shootDelay > 0.0f) {
            this.shootDelay -= 1.0f;
        }
    }

    @Override
    public NBTTagCompound saveToNBT(boolean forClient) {
        NBTTagCompound nbt = super.saveToNBT(forClient);
        nbt.func_74776_a("shootDelay", this.shootDelay);
        nbt.func_74768_a("reloadDelay", this.reloadDelay);
        nbt.func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventory));
        nbt.func_74782_a("inventoryPlatform", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventoryPlatform));
        if (!forClient) {
            nbt.func_74782_a("magazine", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.magazine));
        }
        nbt.func_74768_a("magazine_amount", this.magazine.size());
        nbt.func_74757_a("requiresPlatformRefill", this.requiresPlatformRefill);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.shootDelay = tagCompound.func_74760_g("shootDelay");
        this.reloadDelay = tagCompound.func_74762_e("reloadDelay");
        this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)tagCompound.func_150295_c("inventory", 10), (int)this.inventory.size());
        this.inventoryPlatform = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)tagCompound.func_150295_c("inventoryPlatform", 10), (int)this.inventoryPlatform.size());
        this.magazine = new ArrayDeque(blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)tagCompound.func_150295_c("magazine", 10), (int)tagCompound.func_74762_e("magazine_amount")));
        this.requiresPlatformRefill = tagCompound.func_74767_n("requiresPlatformRefill");
    }

    @Override
    public boolean canShoot(TileEntityEmplacement te) {
        if (this.shootDelay > 0.0f) {
            if (this.shootDelay == (float)Config.IIConfig.Weapons.EmplacementWeapons.HeavyRailgun.shotFireTime) {
                te.func_145831_w().func_184148_a(null, (double)te.func_174877_v().func_177958_n(), (double)te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p(), IESounds.chargeSlow, SoundCategory.PLAYERS, 1.5f, 0.0f);
            }
            this.shootDelay -= 1.0f;
        }
        return this.vv != null && te.isDoorOpened && this.shootDelay == 0.0f && this.magazine.size() > 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(TileEntityEmplacement te, float partialTicks) {
        GlStateManager.func_179094_E();
        float p = this.nextPitch - this.pitch;
        float y = this.nextYaw - this.yaw;
        boolean power = te.energyStorage.getEnergyStored() >= this.getEnergyUpkeepCost();
        float pp = this.pitch + (power ? Math.signum(p) * MathHelper.func_76131_a((float)Math.abs(p), (float)0.0f, (float)1.0f) * partialTicks * this.getPitchTurnSpeed() : 0.0f);
        float yy = this.yaw + (power ? Math.signum(y) * MathHelper.func_76131_a((float)Math.abs(y), (float)0.0f, (float)1.0f) * partialTicks * this.getYawTurnSpeed() : 0.0f);
        Utils.bindTexture(EmplacementRenderer.textureHeavyRailgun);
        GlStateManager.func_179114_b((float)yy, (float)0.0f, (float)1.0f, (float)0.0f);
        for (ModelRendererTurbo mod : EmplacementRenderer.modelHeavyRailgun.baseModel) {
            mod.render();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)1.25f, (float)0.25f);
        GlStateManager.func_179114_b((float)pp, (float)1.0f, (float)0.0f, (float)0.0f);
        for (ModelRendererTurbo mod : EmplacementRenderer.modelHeavyRailgun.gunModel) {
            mod.render();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179109_b((float)-0.75f, (float)0.5f, (float)-0.75f);
        float craneYaw = 0.0f;
        float craneDist = 0.75f;
        float craneDrop = 0.0f;
        float craneGrab = 0.0f;
        if (this.reloadDelay > 0 && this.pitch == 0.0f) {
            float craneProgress = Math.min(((float)this.reloadDelay + partialTicks) / (float)Config.IIConfig.Weapons.EmplacementWeapons.HeavyRailgun.reloadAmmoBoxTime, 1.0f);
            if ((double)craneProgress < 0.2) {
                craneDrop = craneProgress / 0.2f;
            } else if ((double)craneProgress < 0.25) {
                craneDrop = 1.0f;
                craneGrab = (craneProgress - 0.2f) / 0.05f;
            } else if ((double)craneProgress < 0.4) {
                craneGrab = 1.0f;
                craneDrop = 1.0f - (craneProgress - 0.25f) / 0.15f;
                craneDist = 0.75f - (craneProgress - 0.25f) / 0.15f * 0.4f;
            } else if ((double)craneProgress < 0.65) {
                craneGrab = 1.0f;
                craneDrop = 0.0f;
                craneDist = 0.35f;
                craneYaw = 125.0f * ((craneProgress - 0.4f) / 0.25f);
            } else if (craneProgress < 0.75f) {
                craneDrop = (craneProgress - 0.65f) / 0.1f * 0.125f;
                craneDist = 0.35f;
                craneYaw = 125.0f;
            } else if (craneProgress < 0.8f) {
                craneDrop = 0.125f * (1.0f - (craneProgress - 0.75f) / 0.05f);
                craneGrab = 1.0f - (craneProgress - 0.75f) / 0.05f;
                craneDist = 0.35f;
                craneYaw = 125.0f;
            } else if (craneProgress < 0.925f) {
                craneYaw = 125.0f * (1.0f - (craneProgress - 0.8f) / 0.125f);
                craneDist = 0.35f;
            }
        }
        EmplacementRenderer.renderCrane(craneYaw, craneDist, craneDrop, craneGrab, () -> {});
        GlStateManager.func_179121_F();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderUpgradeProgress(int clientProgress, int serverProgress, float partialTicks) {
        GlStateManager.func_179094_E();
        int req = IIContent.UPGRADE_EMPLACEMENT_WEAPON_HEAVY_RAILGUN.getProgressRequired();
        int l = EmplacementRenderer.modelHeavyRailgunConstruction.length;
        double maxClientProgress = Utils.getMaxClientProgress(serverProgress, req, l);
        double cc = (int)Math.min((double)((float)clientProgress + partialTicks * ((float)Config.IIConfig.Tools.wrench_upgrade_progress / 2.0f)), maxClientProgress);
        double progress = MathHelper.func_151237_a((double)(cc / (double)req), (double)0.0, (double)1.0);
        Utils.bindTexture(EmplacementRenderer.textureHeavyRailgun);
        int i = 0;
        while ((double)i < (double)l * progress) {
            if ((long)(1 + i) > Math.round((double)l * progress)) {
                GlStateManager.func_179094_E();
                double scale = 1.0 - progress * (double)l % 1.0 / 1.0;
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)Math.min(scale, 1.0)));
                GlStateManager.func_179137_b((double)0.0, (double)(scale * 1.5), (double)0.0);
                EmplacementRenderer.modelHeavyRailgunConstruction[i].func_78785_a(0.0625f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
            } else {
                EmplacementRenderer.modelHeavyRailgunConstruction[i].func_78785_a(0.0625f);
            }
            ++i;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179152_a((float)0.98f, (float)0.98f, (float)0.98f);
        GlStateManager.func_179109_b((float)0.03125f, (float)0.0f, (float)-0.01325f);
        ShaderUtil.blueprint_static(0.35f, (float)ClientUtils.mc().field_71439_g.field_70173_aa + partialTicks);
        i = l - 1;
        while ((double)i >= Math.max((double)l * progress - 1.0, 0.0)) {
            EmplacementRenderer.modelHeavyRailgunConstruction[i].func_78785_a(0.0625f);
            --i;
        }
        ShaderUtil.releaseShader();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    @Override
    public AxisAlignedBB getVisionAABB() {
        return this.vision;
    }

    @Override
    public void syncWithEntity(EntityEmplacementWeapon entity) {
        super.syncWithEntity(entity);
        if (entity == this.entity) {
            entity.aabb = new AxisAlignedBB(-3.0, 0.0, -3.0, 3.0, 3.0, 3.0);
        }
    }

    @Override
    public EntityEmplacementWeapon.EmplacementHitboxEntity[] getCollisionBoxes() {
        if (this.entity == null) {
            return new EntityEmplacementWeapon.EmplacementHitboxEntity[0];
        }
        ArrayList<EntityEmplacementWeapon.EmplacementHitboxEntity> list = new ArrayList<EntityEmplacementWeapon.EmplacementHitboxEntity>();
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "baseBox", 1.0f, 1.5f, new Vec3d(0.0, 1.0, 0.0), Vec3d.field_186680_a, 4));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "shieldRight", 0.75f, 2.0f, new Vec3d(-0.5, 1.0, -0.625), Vec3d.field_186680_a, 14));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "shieldRightBack", 0.75f, 2.0f, new Vec3d(0.0, 1.0, -0.625), Vec3d.field_186680_a, 14));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "shieldMiddle", 0.75f, 0.5f, new Vec3d(-0.5, 0.0, -0.625), Vec3d.field_186680_a, 14));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "shieldLeft", 0.75f, 2.0f, new Vec3d(-0.5, 1.0, 0.625), Vec3d.field_186680_a, 14));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "barrel", 0.625f, 0.625f, new Vec3d(-0.5, 1.5, 0.0), new Vec3d(-0.625, 0.0, 0.0), 12));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "barrel", 0.625f, 0.625f, new Vec3d(-0.5, 1.5, 0.0), new Vec3d(-1.25, 0.0, 0.0), 12));
        list.add(new EntityEmplacementWeapon.EmplacementHitboxEntity(this.entity, "barrel", 0.625f, 0.625f, new Vec3d(-0.5, 1.5, 0.0), new Vec3d(-1.875, 0.0, 0.0), 12));
        return list.toArray(new EntityEmplacementWeapon.EmplacementHitboxEntity[0]);
    }

    @Override
    public NonNullList<ItemStack> getBaseInventory() {
        return this.inventory;
    }

    @Override
    public void renderStorageInventory(GuiEmplacementPageStorage gui, int mx, int my, float partialTicks, boolean first) {
    }

    @Override
    public void performPlatformRefill(TileEntityEmplacement te) {
        for (int i = 0; i < this.inventoryPlatform.size(); ++i) {
            te.doProcessOutput((ItemStack)this.inventoryPlatform.get(i));
            this.inventoryPlatform.set(i, (Object)ItemStack.field_190927_a);
        }
        int moved = 0;
        for (int i = 0; i < this.inventory.size() && moved < this.inventoryPlatform.size(); ++i) {
            ItemStack s = (ItemStack)this.inventory.get(i);
            if (s.func_190926_b()) continue;
            this.inventoryPlatform.set(moved, (Object)s);
            this.inventory.set(i, (Object)ItemStack.field_190927_a);
            ++moved;
        }
        if (this.inventoryPlatform.stream().anyMatch(stack -> !stack.func_190926_b())) {
            this.requiresPlatformRefill = false;
            this.syncWithClient(te);
        }
    }

    @Override
    public int getEnergyUpkeepCost() {
        return Config.IIConfig.Weapons.EmplacementWeapons.HeavyRailgun.energyUpkeepCost;
    }

    @Override
    public int getMaxHealth() {
        return Config.IIConfig.Weapons.EmplacementWeapons.HeavyRailgun.maxHealth;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected Tuple<ResourceLocation, List<ModelRendererTurbo>> getDebris() {
        return new Tuple((Object)EmplacementRenderer.textureHeavyRailgun, Arrays.asList(EmplacementRenderer.modelHeavyRailgunConstruction));
    }

    @Override
    @Nullable
    public IItemHandler getItemHandler(boolean in) {
        return in ? this.inventoryHandler : super.getItemHandler(in);
    }
}

