/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.entities.EntityChemthrowerShot;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.DataWireNetwork;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeBoolean;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeInteger;

public class TileEntityChemicalDispenser
extends TileEntityImmersiveConnectable
implements ITickable,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IBlockBounds,
IDataConnector {
    public static ItemStack conn_data;
    public static ItemStack conn_mv;
    public int energyStorage = 0;
    public int plannedAmount = 0;
    public int scatter = 0;
    public float pitch = 0.0f;
    public float plannedPitch = 0.0f;
    public float yaw = 0.0f;
    public float plannedYaw = 0.0f;
    public boolean shouldIgnite = false;
    public FluidTank tank = new FluidTank(12000);
    public EnumFacing facing = EnumFacing.DOWN;
    protected Set<String> acceptablePowerWires = ImmutableSet.of((Object)"LV", (Object)"MV");
    protected DataWireNetwork wireNetwork = new DataWireNetwork().add(this);
    WireType secondCable;
    SidedFluidHandler fluidHandler = new SidedFluidHandler(this, null);
    private boolean refreshWireNetwork = false;

    protected boolean canTakeLV() {
        return true;
    }

    protected boolean canTakeMV() {
        return true;
    }

    public boolean canConnect() {
        return true;
    }

    public boolean isEnergyOutput() {
        return true;
    }

    public int outputEnergy(int amount, boolean simulate, int energyType) {
        if (amount > 0 && this.energyStorage < Config.IIConfig.Machines.ChemicalDispenser.energyCapacity) {
            if (!simulate) {
                int rec = Math.min(Config.IIConfig.Machines.ChemicalDispenser.energyCapacity - this.energyStorage, Config.IIConfig.Machines.ChemicalDispenser.energyUsage);
                this.energyStorage += rec;
                return rec;
            }
            return Math.min(Config.IIConfig.Machines.ChemicalDispenser.energyCapacity - this.energyStorage, Config.IIConfig.Machines.ChemicalDispenser.energyUsage);
        }
        return 0;
    }

    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        int tc = this.getTargetedConnector(target);
        return this.canAttach(cableType, tc);
    }

    private boolean canAttach(WireType toAttach, int conn) {
        String attachCat = toAttach.getCategory();
        if (attachCat == null) {
            return false;
        }
        if (conn == 0) {
            return attachCat.equals("DATA") && this.limitType == null;
        }
        if (conn == 1) {
            return this.acceptablePowerWires.contains(attachCat) && this.secondCable == null;
        }
        return false;
    }

    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        switch (this.getTargetedConnector(target)) {
            case 0: {
                if (this.limitType != null) break;
                DataWireNetwork.updateConnectors(this.field_174879_c, this.field_145850_b, this.wireNetwork);
                this.limitType = cableType;
                break;
            }
            case 1: {
                if (this.secondCable != null) break;
                this.secondCable = cableType;
            }
        }
        this.markContainingBlockForUpdate(null);
    }

    public WireType getCableLimiter(TargetingInfo target) {
        switch (this.getTargetedConnector(target)) {
            case 0: {
                return this.limitType;
            }
            case 1: {
                return this.secondCable;
            }
        }
        return null;
    }

    public void removeCable(ImmersiveNetHandler.Connection connection) {
        WireType type;
        WireType wireType = type = connection != null ? connection.cableType : null;
        if (type == null) {
            this.limitType = null;
            this.secondCable = null;
        }
        if (type == this.limitType) {
            this.wireNetwork.removeFromNetwork(this);
            this.limitType = null;
        }
        if (type == this.secondCable) {
            this.secondCable = null;
        }
        this.markContainingBlockForUpdate(null);
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        boolean right = con.cableType == this.limitType;
        return this.getConnectionOffset(con, right);
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con, TargetingInfo target, Vec3i offsetLink) {
        return this.getConnectionOffset(con, this.getTargetedConnector(target) == 0);
    }

    private Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con, boolean data) {
        if (data) {
            switch (this.facing) {
                default: {
                    return new Vec3d(0.875, 0.5, 0.125);
                }
                case DOWN: {
                    return new Vec3d(0.125, 0.75, 0.125);
                }
                case SOUTH: {
                    return new Vec3d(0.125, 0.125, 0.5);
                }
                case NORTH: {
                    return new Vec3d(0.125, 0.875, 0.5);
                }
                case EAST: {
                    return new Vec3d(0.5, 0.875, 0.125);
                }
                case WEST: 
            }
            return new Vec3d(0.5, 0.875, 0.875);
        }
        switch (this.facing) {
            default: {
                return new Vec3d(0.125, (double)0.525f, 0.875);
            }
            case DOWN: {
                return new Vec3d(0.875, (double)0.525f, 0.875);
            }
            case SOUTH: {
                return new Vec3d(0.875, 0.875, 0.5);
            }
            case NORTH: {
                return new Vec3d(0.875, 0.125, 0.5);
            }
            case EAST: {
                return new Vec3d(0.5, 0.125, 0.875);
            }
            case WEST: 
        }
        return new Vec3d(0.5, 0.125, 0.125);
    }

    public int getTargetedConnector(TargetingInfo target) {
        switch (this.facing) {
            case UP: {
                if (target.hitX <= 1.0f && target.hitX >= 0.75f && target.hitZ <= 0.25f && target.hitZ >= 0.0f) {
                    return 0;
                }
                if (!((double)target.hitX <= 0.25) || !(target.hitX >= 0.0f) || !(target.hitZ <= 1.0f) || !((double)target.hitZ >= 0.75)) break;
                return 1;
            }
            case DOWN: {
                if ((double)target.hitX <= 0.25 && target.hitX >= 0.0f && target.hitZ <= 0.25f && target.hitZ >= 0.0f) {
                    return 0;
                }
                if (!(target.hitX <= 1.0f) || !(target.hitX >= 0.75f) || !(target.hitZ <= 1.0f) || !((double)target.hitZ >= 0.75)) break;
                return 1;
            }
            case NORTH: {
                if ((double)target.hitX <= 0.25 && target.hitX >= 0.0f && target.hitY <= 1.0f && (double)target.hitY >= 0.75) {
                    return 0;
                }
                if (!(target.hitX <= 1.0f) || !(target.hitX >= 0.75f) || !(target.hitY <= 0.25f) || !(target.hitY >= 0.0f)) break;
                return 1;
            }
            case SOUTH: {
                if ((double)target.hitX <= 0.25 && target.hitX >= 0.0f && target.hitY <= 0.25f && target.hitY >= 0.0f) {
                    return 0;
                }
                if (!(target.hitX <= 1.0f) || !(target.hitX >= 0.75f) || !(target.hitY <= 1.0f) || !((double)target.hitY >= 0.75)) break;
                return 1;
            }
            case WEST: {
                if (target.hitZ <= 1.0f && target.hitZ >= 0.75f && target.hitY <= 1.0f && (double)target.hitY >= 0.75) {
                    return 0;
                }
                if (!((double)target.hitZ <= 0.25) || !(target.hitZ >= 0.0f) || !(target.hitY <= 0.25f) || !(target.hitY >= 0.0f)) break;
                return 1;
            }
            case EAST: {
                if ((double)target.hitZ <= 0.25 && target.hitZ >= 0.0f && target.hitY <= 1.0f && (double)target.hitY >= 0.75) {
                    return 0;
                }
                if (!(target.hitZ <= 1.0f) || !(target.hitZ >= 0.75f) || !(target.hitY <= 0.25f) || !(target.hitY >= 0.0f)) break;
                return 1;
            }
        }
        return -1;
    }

    public WireType getLimiter(int side) {
        if (side == 0) {
            return this.limitType;
        }
        return this.secondCable;
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (message.func_74764_b("energyStorage")) {
            this.energyStorage = message.func_74762_e("energyStorage");
        }
        if (message.func_74764_b("plannedAmount")) {
            this.plannedAmount = message.func_74762_e("plannedAmount");
        }
        if (message.func_74764_b("scatter")) {
            this.scatter = message.func_74762_e("scatter");
        }
        if (message.func_74764_b("pitch")) {
            this.pitch = message.func_74760_g("pitch");
        }
        if (message.func_74764_b("yaw")) {
            this.yaw = message.func_74760_g("yaw");
        }
        if (message.func_74764_b("plannedYaw")) {
            this.plannedYaw = message.func_74760_g("plannedYaw");
        }
        if (message.func_74764_b("plannedPitch")) {
            this.plannedPitch = message.func_74760_g("plannedPitch");
        }
        if (message.func_74764_b("tank")) {
            this.tank.readFromNBT(message.func_74775_l("tank"));
        }
        if (message.func_74764_b("shouldIgnite")) {
            this.shouldIgnite = message.func_74767_n("shouldIgnite");
        }
        if (message.func_74764_b("facing")) {
            this.facing = EnumFacing.func_82600_a((int)message.func_74762_e("facing"));
        }
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.secondCable = nbt.func_74764_b("secondCable") ? ApiUtils.getWireTypeFromNBT((NBTTagCompound)nbt, (String)"secondCable") : null;
        this.energyStorage = nbt.func_74762_e("energyStorage");
        this.plannedAmount = nbt.func_74762_e("plannedAmount");
        this.scatter = nbt.func_74762_e("scatter");
        this.shouldIgnite = nbt.func_74767_n("shouldIgnite");
        this.pitch = nbt.func_74762_e("pitch");
        this.yaw = nbt.func_74762_e("yaw");
        if (nbt.func_74764_b("facing")) {
            this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        }
        if (nbt.func_74764_b("tank")) {
            this.tank.readFromNBT(nbt.func_74775_l("tank"));
        }
        if (nbt.func_74764_b("plannedYaw")) {
            this.plannedYaw = nbt.func_74760_g("plannedYaw");
        }
        if (nbt.func_74764_b("plannedPitch")) {
            this.plannedPitch = nbt.func_74760_g("plannedPitch");
        }
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.secondCable != null) {
            nbt.func_74778_a("secondCable", this.secondCable.getUniqueName());
        }
        nbt.func_74768_a("energyStorage", this.energyStorage);
        nbt.func_74768_a("plannedAmount", this.plannedAmount);
        nbt.func_74768_a("scatter", this.scatter);
        nbt.func_74757_a("shouldIgnite", this.shouldIgnite);
        nbt.func_74776_a("pitch", this.pitch);
        nbt.func_74776_a("yaw", this.yaw);
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        nbt.func_74776_a("plannedYaw", this.plannedYaw);
        nbt.func_74776_a("plannedPitch", this.plannedPitch);
    }

    public float[] getBlockBounds() {
        switch (this.facing) {
            case UP: {
                return new float[]{0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f};
            }
            case DOWN: {
                return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f};
            }
            case SOUTH: {
                return new float[]{0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f};
            }
            case NORTH: {
                return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f};
            }
            case EAST: {
                return new float[]{0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
            }
            case WEST: {
                return new float[]{0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f};
            }
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public void func_73660_a() {
        if (this.plannedPitch > this.pitch) {
            this.pitch += 45.0f / ((float)Config.IIConfig.Machines.ChemicalDispenser.rotateVTime / 20.0f);
        }
        if (this.plannedPitch < this.pitch) {
            this.pitch -= 45.0f / ((float)Config.IIConfig.Machines.ChemicalDispenser.rotateVTime / 20.0f);
        }
        if (Math.abs(this.plannedPitch - this.pitch) < 45.0f / ((float)Config.IIConfig.Machines.ChemicalDispenser.rotateVTime / 20.0f)) {
            this.pitch = this.plannedPitch;
        }
        this.pitch = MathHelper.func_76131_a((float)this.pitch, (float)-45.0f, (float)45.0f);
        if (this.plannedYaw > this.yaw) {
            this.yaw += 45.0f / ((float)Config.IIConfig.Machines.ChemicalDispenser.rotateHTime / 20.0f);
        }
        if (this.plannedYaw < this.yaw) {
            this.yaw -= 45.0f / ((float)Config.IIConfig.Machines.ChemicalDispenser.rotateHTime / 20.0f);
        }
        if (Math.abs(this.plannedYaw - this.yaw) < 45.0f / ((float)Config.IIConfig.Machines.ChemicalDispenser.rotateHTime / 20.0f)) {
            this.yaw = this.plannedYaw;
        }
        this.yaw = MathHelper.func_76131_a((float)this.yaw, (float)-45.0f, (float)45.0f);
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && !this.refreshWireNetwork) {
            this.refreshWireNetwork = true;
            this.wireNetwork.removeFromNetwork(null);
        }
        if (this.field_145850_b.func_175640_z(this.func_174877_v())) {
            this.plannedAmount = 20;
        }
        if (!this.field_145850_b.field_72995_K && this.plannedAmount > 0 && this.tank.getFluid() != null && this.plannedYaw == this.yaw && this.plannedPitch == this.pitch) {
            int consumed = Config.IEConfig.Tools.chemthrower_consumption;
            FluidStack fs = this.tank.getFluid();
            if (this.energyStorage >= Config.IIConfig.Machines.ChemicalDispenser.energyUsage && Math.min(consumed, this.plannedAmount) <= fs.amount) {
                this.energyStorage -= Config.IIConfig.Machines.ChemicalDispenser.energyUsage;
                Vec3i vi = this.facing.func_176734_d().func_176730_m();
                Vec3d v = new Vec3d((double)vi.func_177958_n(), (double)vi.func_177956_o(), (double)vi.func_177952_p()).func_178785_b((float)Math.toRadians(this.yaw) * (float)(this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? -1 : 1));
                if (this.facing.func_176736_b() != -1) {
                    v = v.func_72441_c(0.0, Math.toRadians(this.pitch), 0.0);
                } else {
                    v = new Vec3d((double)vi.func_177958_n(), (double)vi.func_177956_o(), (double)vi.func_177952_p());
                    v = v.func_72441_c(Math.toRadians(-this.pitch), 0.0, Math.toRadians(this.yaw));
                }
                int split = 8;
                boolean isGas = fs.getFluid().isGaseous() || ChemthrowerHandler.isGas((Fluid)fs.getFluid());
                float scatter = isGas ? 0.05f : 0.025f;
                float range = isGas ? 1.0f : 1.25f;
                scatter *= (1.0f - (float)this.scatter / 100.0f) * 3.0f;
                range = (float)((double)range * ((double)((float)this.scatter / 100.0f) * 0.5));
                scatter = MathHelper.func_76131_a((float)scatter, (float)0.05f, (float)10.0f);
                range = MathHelper.func_76131_a((float)range, (float)0.25f, (float)10.0f);
                for (int i = 0; i < split; ++i) {
                    Vec3d vecDir = v.func_72441_c(blusunrize.immersiveengineering.common.util.Utils.RAND.nextGaussian() * (double)scatter, blusunrize.immersiveengineering.common.util.Utils.RAND.nextGaussian() * (double)scatter, blusunrize.immersiveengineering.common.util.Utils.RAND.nextGaussian() * (double)scatter);
                    EntityChemthrowerShot chem = new EntityChemthrowerShot(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f) + v.field_72450_a / 2.0, (double)((float)this.field_174879_c.func_177956_o() + 0.5f) + v.field_72448_b / 2.0, (double)((float)this.field_174879_c.func_177952_p() + 0.5f) + v.field_72449_c / 2.0, vecDir.field_72450_a * 0.5, vecDir.field_72448_b * 0.5, vecDir.field_72449_c * 0.5, fs);
                    chem.field_70159_w = vecDir.field_72450_a * (double)range;
                    chem.field_70181_x = vecDir.field_72448_b * (double)range;
                    chem.field_70179_y = vecDir.field_72449_c * (double)range;
                    if (this.shouldIgnite) {
                        chem.func_70015_d(10);
                    }
                    this.field_145850_b.func_72838_d((Entity)chem);
                }
                if (this.field_145850_b.func_82737_E() % 4L == 0L) {
                    if (this.shouldIgnite) {
                        this.field_145850_b.func_184148_a(null, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() - 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), IESounds.sprayFire, SoundCategory.PLAYERS, 0.5f, 1.5f);
                    } else {
                        this.field_145850_b.func_184148_a(null, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() - 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), IESounds.spray, SoundCategory.PLAYERS, 0.5f, 0.75f);
                    }
                }
            }
            this.tank.drain(Math.min(this.plannedAmount, consumed), true);
            this.plannedAmount -= consumed;
            this.plannedAmount = Math.max(this.plannedAmount, 0);
        }
    }

    @Override
    public DataWireNetwork getDataNetwork() {
        return this.wireNetwork;
    }

    @Override
    public void setDataNetwork(DataWireNetwork net) {
        this.wireNetwork = net;
    }

    @Override
    public void onDataChange() {
        if (!this.func_145837_r()) {
            this.func_70296_d();
            IBlockState stateHere = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.markContainingBlockForUpdate(stateHere);
        }
    }

    @Override
    public World getConnectorWorld() {
        return this.func_145831_w();
    }

    @Override
    public void onPacketReceive(DataPacket packet) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (packet.getPacketVariable(Character.valueOf('p')) instanceof DataPacketTypeInteger) {
            this.plannedPitch = ((DataPacketTypeInteger)packet.getPacketVariable((Character)Character.valueOf((char)'p'))).value;
            this.plannedPitch = MathHelper.func_76131_a((float)this.plannedPitch, (float)-45.0f, (float)45.0f);
            nbt.func_74776_a("plannedPitch", this.plannedPitch);
            nbt.func_74776_a("pitch", this.pitch);
        }
        if (packet.getPacketVariable(Character.valueOf('y')) instanceof DataPacketTypeInteger) {
            this.plannedYaw = ((DataPacketTypeInteger)packet.getPacketVariable((Character)Character.valueOf((char)'y'))).value;
            this.plannedYaw = MathHelper.func_76131_a((float)this.plannedYaw, (float)-45.0f, (float)45.0f);
            nbt.func_74776_a("plannedYaw", this.plannedYaw);
            nbt.func_74776_a("yaw", this.yaw);
        }
        if (packet.getPacketVariable(Character.valueOf('a')) instanceof DataPacketTypeInteger) {
            this.plannedAmount = ((DataPacketTypeInteger)packet.getPacketVariable((Character)Character.valueOf((char)'a'))).value;
            nbt.func_74768_a("plannedAmount", this.plannedAmount);
        }
        if (packet.getPacketVariable(Character.valueOf('s')) instanceof DataPacketTypeInteger) {
            this.scatter = ((DataPacketTypeInteger)packet.getPacketVariable((Character)Character.valueOf((char)'s'))).value;
            this.scatter = MathHelper.func_76125_a((int)this.scatter, (int)0, (int)100);
            nbt.func_74768_a("scatter", this.scatter);
        }
        if (packet.getPacketVariable(Character.valueOf('i')) instanceof DataPacketTypeBoolean) {
            this.shouldIgnite = ((DataPacketTypeBoolean)packet.getPacketVariable((Character)Character.valueOf((char)'i'))).value;
            nbt.func_74757_a("shouldIgnite", this.shouldIgnite);
        }
        if (!nbt.func_82582_d()) {
            ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, nbt), Utils.targetPointFromTile((TileEntity)this, 24));
        }
    }

    @Override
    public void sendPacket(DataPacket packet) {
    }

    public boolean moveConnectionTo(ImmersiveNetHandler.Connection c, BlockPos newEnd) {
        return true;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public int getFacingLimitation() {
        return 0;
    }

    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return true;
    }

    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing == this.facing) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing == this.facing) {
            return (T)this.fluidHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    static class SidedFluidHandler
    implements IFluidHandler {
        TileEntityChemicalDispenser tile;
        EnumFacing facing;

        SidedFluidHandler(TileEntityChemicalDispenser tile, EnumFacing facing) {
            this.tile = tile;
            this.facing = facing;
        }

        public int fill(FluidStack resource, boolean doFill) {
            int i = this.tile.tank.fill(resource, doFill);
            if (i > 0) {
                this.tile.func_70296_d();
                this.tile.markContainingBlockForUpdate(null);
            }
            return i;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return this.tile.tank.drain(resource.amount, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return this.tile.tank.drain(maxDrain, doDrain);
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.tile.tank.getTankProperties();
        }
    }
}

