/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.network.MessageNoSpamChatComponents;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.DataWireNetwork;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.common.wire.IIDataWireType;

public class TileEntityDataDebugger
extends TileEntityImmersiveConnectable
implements ITickable,
IDataConnector,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IDirectionalTile,
IOBJModelCallback<IBlockState>,
IEBlockInterfaces.IBlockOverlayText {
    private boolean toggle = false;
    public int mode = 0;
    EnumFacing facing = EnumFacing.NORTH;
    public int setupTime = 25;
    protected DataWireNetwork wireNetwork = new DataWireNetwork().add(this);
    private boolean refreshWireNetwork = false;
    private DataPacket lastPacket = null;
    private String[] packetString = new String[0];

    public void func_73660_a() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && !this.refreshWireNetwork) {
            this.refreshWireNetwork = true;
            this.wireNetwork.removeFromNetwork(null);
        }
        if (this.field_145850_b.field_72995_K && this.setupTime > 0) {
            --this.setupTime;
        } else if (!this.field_145850_b.field_72995_K && this.mode < 2) {
            if (this.field_145850_b.func_175676_y(this.func_174877_v()) > 0 && !this.toggle) {
                this.toggle = true;
                DataPacket pack = new DataPacket();
                pack.setVariable(Character.valueOf('a'), new DataPacketTypeString("Hello World!"));
                this.getDataNetwork().sendPacket(pack, this);
            } else if (this.field_145850_b.func_175676_y(this.func_174877_v()) == 0 && this.toggle) {
                this.toggle = false;
            }
        }
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.mode = nbt.func_74762_e("mode");
        if (nbt.func_74764_b("noSetup")) {
            this.setupTime = 0;
        }
        this.setFacing(EnumFacing.func_82600_a((int)nbt.func_74762_e("facing")));
        if (nbt.func_74764_b("packet")) {
            this.lastPacket = new DataPacket();
            this.lastPacket.fromNBT(nbt.func_74775_l("packet"));
            if (!this.field_145850_b.field_72995_K) {
                this.packetString = this.compilePacketString();
            }
        }
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74768_a("mode", this.mode);
        if (this.setupTime < 25) {
            nbt.func_74757_a("noSetup", true);
        }
        nbt.func_74768_a("facing", this.facing.ordinal());
        if (this.lastPacket != null) {
            if (!this.field_145850_b.field_72995_K) {
                this.packetString = this.compilePacketString();
            }
            nbt.func_74782_a("packet", (NBTBase)this.lastPacket.toNBT());
        }
    }

    private String[] compilePacketString() {
        return (String[])this.lastPacket.variables.entrySet().stream().map(entry -> {
            TextFormatting ff = TextFormatting.func_96300_b((String)Utils.getRGBTextFormatting(((IDataType)entry.getValue()).getTypeColour()).func_176610_l());
            if (ff == TextFormatting.BLACK) {
                ff = TextFormatting.DARK_GRAY;
            }
            return String.format("%s%s\u00c2\u00a7r %s = %s", ff, ((IDataType)entry.getValue()).getName(), entry.getKey(), ((IDataType)entry.getValue()).valueToString());
        }).toArray(String[]::new);
    }

    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            ++this.mode;
            if (this.mode > 2) {
                this.mode = 0;
            }
            ImmersiveEngineering.packetHandler.sendTo((IMessage)new MessageNoSpamChatComponents(new ITextComponent[]{new TextComponentTranslation("info.immersiveintelligence.debugger_mode", new Object[]{new TextComponentTranslation("info.immersiveintelligence.debugger_mode." + this.mode, new Object[0])})}), (EntityPlayerMP)player);
            this.func_70296_d();
            this.markBlockForUpdate(this.field_174879_c, null);
        }
        return true;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing.func_176740_k().func_176722_c() ? facing : EnumFacing.NORTH;
    }

    public int getFacingLimitation() {
        return 2;
    }

    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return true;
    }

    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return !entity.func_70093_af();
    }

    public boolean canRotate(EnumFacing axis) {
        return true;
    }

    @Override
    public void setDataNetwork(DataWireNetwork net) {
        this.wireNetwork = net;
    }

    @Override
    public DataWireNetwork getDataNetwork() {
        return this.wireNetwork;
    }

    @Override
    public void onDataChange() {
        if (!this.func_145837_r()) {
            this.func_70296_d();
            IBlockState stateHere = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.markContainingBlockForUpdate(stateHere);
            this.markBlockForUpdate(this.field_174879_c.func_177972_a(this.facing), stateHere);
        }
    }

    @Override
    public World getConnectorWorld() {
        return this.func_145831_w();
    }

    @Override
    public void onPacketReceive(DataPacket packet) {
        if (this.mode == 0 || this.mode == 2) {
            this.lastPacket = packet;
            ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)new MessageNoSpamChatComponents(new ITextComponent[]{new TextComponentString(packet.toString())}), Utils.targetPointFromTile((TileEntity)this, 8));
            this.func_70296_d();
            this.markBlockForUpdate(this.field_174879_c, null);
        }
    }

    @Override
    public void sendPacket(DataPacket packet) {
    }

    protected boolean isRelay() {
        return true;
    }

    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        if (cableType != IIDataWireType.DATA) {
            return false;
        }
        return this.limitType == null || this.limitType == cableType;
    }

    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        super.connectCable(cableType, target, other);
        DataWireNetwork.updateConnectors(this.field_174879_c, this.field_145850_b, this.wireNetwork);
    }

    public void removeCable(@Nullable ImmersiveNetHandler.Connection connection) {
        super.removeCable(connection);
        this.wireNetwork.removeFromNetwork(this);
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        EnumFacing side = this.facing.func_176734_d();
        double conRadius = con.cableType.getRenderDiameter() / 2.0;
        return new Vec3d(0.5 + (double)side.func_82601_c() * 0.8 * (0.5 - conRadius), 0.95, 0.5 + (double)side.func_82599_e() * 0.8 * (0.5 - conRadius));
    }

    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        String s_out = I18n.func_135052_a((String)"info.immersiveintelligence.debugger_mode", (Object[])new Object[]{I18n.func_135052_a((String)("info.immersiveintelligence.debugger_mode." + this.mode), (Object[])new Object[0])});
        if (this.lastPacket != null) {
            ArrayList<String> s = new ArrayList<String>(Arrays.asList(this.packetString));
            s.add(0, s_out);
            return s.toArray(new String[0]);
        }
        return new String[]{s_out};
    }

    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }
}

