/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.metal;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletHelper;
import pl.pabilo8.immersiveintelligence.api.bullets.IBullet;
import pl.pabilo8.immersiveintelligence.common.blocks.metal.TileEntityTellermine;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.items.tools.ItemIITrenchShovel;

public class TileEntityTripMine
extends TileEntityImmersiveConnectable
implements IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.ITileDrop {
    private static final Vec3d CONN_OFFSET = new Vec3d(0.5, 0.25, 0.5);
    private static final AxisAlignedBB[] AABB = new AxisAlignedBB[16];
    public int coreColor = 0xFFFFFF;
    public ItemStack mineStack = ItemStack.field_190927_a;
    private boolean armed = true;
    public boolean grass = false;
    public int digLevel = 0;

    public void readCustomNBT(NBTTagCompound nbtTagCompound, boolean b) {
        super.readCustomNBT(nbtTagCompound, b);
        this.armed = nbtTagCompound.func_74767_n("armed");
        this.grass = nbtTagCompound.func_74767_n("grass");
        this.digLevel = nbtTagCompound.func_74762_e("digLevel");
        this.readOnPlacement(null, new ItemStack(nbtTagCompound.func_74775_l("mineStack")));
    }

    public void writeCustomNBT(NBTTagCompound nbtTagCompound, boolean b) {
        super.writeCustomNBT(nbtTagCompound, b);
        nbtTagCompound.func_74757_a("armed", this.armed);
        nbtTagCompound.func_74757_a("grass", this.grass);
        nbtTagCompound.func_74768_a("digLevel", this.digLevel);
        nbtTagCompound.func_74782_a("mineStack", (NBTBase)this.mineStack.serializeNBT());
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        return CONN_OFFSET;
    }

    protected boolean isRelay() {
        return true;
    }

    public void explode() {
        if (!this.armed) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.mineStack.func_77973_b() instanceof IBullet) {
            EntityBullet bullet = BulletHelper.createBullet(this.field_145850_b, this.mineStack, new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5), new Vec3d(0.0, 1.0, 0.0), 0.5f);
            bullet.fuse = 20;
            this.field_145850_b.func_72838_d((Entity)bullet);
        }
        this.field_145850_b.func_175698_g(this.func_174877_v());
    }

    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        return "TRIPWIRE".equals(cableType.getCategory());
    }

    public float getDamageAmount(Entity e, ImmersiveNetHandler.Connection c) {
        return 1.0f;
    }

    public void processDamage(Entity e, float amount, ImmersiveNetHandler.Connection c) {
        TileEntity tileStart = this.field_145850_b.func_175625_s(c.start);
        TileEntity tileEnd = this.field_145850_b.func_175625_s(c.end);
        if (tileStart instanceof TileEntityTripMine) {
            ((TileEntityTripMine)tileStart).explode();
        }
        if (tileEnd instanceof TileEntityTripMine) {
            ((TileEntityTripMine)tileEnd).explode();
        }
    }

    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (this.digLevel < 15 && heldItem.func_77973_b().getToolClasses(heldItem).contains("shovel")) {
            heldItem.func_77972_a(1, (EntityLivingBase)player);
            Material material = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_185904_a();
            if (Arrays.stream(TileEntityTellermine.MATCHING_MATERIALS).noneMatch(material1 -> material1 == material)) {
                return true;
            }
            this.digLevel += heldItem.func_77973_b() instanceof ItemIITrenchShovel ? 5 : 1;
            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            return true;
        }
        if (this.digLevel == 15 && heldItem.func_77973_b() instanceof ItemBlock && ((ItemBlock)heldItem.func_77973_b()).func_179223_d() == Blocks.field_150329_H) {
            this.grass = true;
            if (!player.func_184812_l_()) {
                heldItem.func_190918_g(1);
            }
            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            return true;
        }
        if (this.armed && heldItem.func_77973_b().getToolClasses(heldItem).contains("IE_WIRECUTTER")) {
            heldItem.func_77972_a(8, (EntityLivingBase)player);
            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            this.armed = false;
            this.grass = false;
        }
        return false;
    }

    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        list.add(AABB[this.digLevel].func_186670_a(this.func_174877_v()));
        return list;
    }

    public float[] getBlockBounds() {
        return new float[]{0.25f, -0.625f * ((float)this.digLevel / 15.0f), 0.25f, 0.75f, 0.625f * (1.0f - (float)this.digLevel / 15.0f), 0.75f};
    }

    public void onEntityCollision(World world, Entity entity) {
        super.onEntityCollision(world, entity);
        if (this.digLevel > 6 || entity.field_70163_u > (double)this.func_174877_v().func_177956_o()) {
            this.explode();
        }
    }

    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IBullet) {
            this.mineStack = stack;
            this.coreColor = ((IBullet)item).getCore(stack).getColour();
        }
    }

    public ItemStack getTileDrop(@Nullable EntityPlayer player, IBlockState state) {
        return this.mineStack;
    }

    public NonNullList<ItemStack> getTileDrops(@Nullable EntityPlayer player, IBlockState state) {
        this.explode();
        return NonNullList.func_193580_a((Object)(this.armed ? ItemStack.field_190927_a : this.mineStack), (Object[])new ItemStack[0]);
    }

    static {
        for (int i = 0; i < 16; ++i) {
            TileEntityTripMine.AABB[i] = new AxisAlignedBB(0.25, (double)(-0.625f * ((float)i / 15.0f)), 0.25, 0.75, (double)(0.625f * (1.0f - (float)i / 15.0f)), 0.75);
        }
    }
}

