/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.metal.inserter;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.util.FakePlayerUtil;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.operators.DataOperator;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeItemStack;
import pl.pabilo8.immersiveintelligence.api.data.types.DataPacketTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.api.utils.IMinecartBlockPickable;
import pl.pabilo8.immersiveintelligence.api.utils.MinecartBlockHelper;
import pl.pabilo8.immersiveintelligence.common.blocks.metal.inserter.TileEntityInserterBase;

public class TileEntityInserter
extends TileEntityInserterBase {
    public static final HashMap<String, Function<NBTTagCompound, TileEntityInserterBase.InserterTask>> TASKS = new HashMap();
    private static final Set<String> WIRES = ImmutableSet.of((Object)"LV", (Object)"MV");

    @Override
    @Nonnull
    protected Set<String> getAcceptedPowerWires() {
        return WIRES;
    }

    @Override
    public int getPickupSpeed() {
        return Config.IIConfig.Machines.Inserter.taskTime;
    }

    @Override
    public int getEnergyUsage() {
        return Config.IIConfig.Machines.Inserter.energyUsage;
    }

    @Override
    public int getEnergyCapacity() {
        return Config.IIConfig.Machines.Inserter.energyCapacity;
    }

    @Override
    public int getMaxTakeAmount() {
        return Config.IIConfig.Machines.Inserter.maxTake;
    }

    @Override
    @Nonnull
    protected HashMap<String, Function<NBTTagCompound, TileEntityInserterBase.InserterTask>> getAvailableTasks() {
        return TASKS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void handleSounds() {
    }

    @Override
    public void onPacketReceive(DataPacket packet) {
        super.onPacketReceive(packet);
        IDataType c = packet.getPacketVariable(Character.valueOf('c'));
        IDataType m = packet.getPacketVariable(Character.valueOf('m'));
        IDataType s = packet.getPacketVariable(Character.valueOf('s'));
        IDataType a = packet.getPacketVariable(Character.valueOf('a'));
        IDataType i = packet.getPacketVariable(Character.valueOf('i'));
        IDataType o = packet.getPacketVariable(Character.valueOf('o'));
        if (m.valueToString().equals("set") || m.valueToString().equals("add")) {
            IngredientStack ss;
            DataPacketTypeInteger count = DataOperator.getVarInType(DataPacketTypeInteger.class, c, packet);
            if (packet.hasVariable(Character.valueOf('s'))) {
                ss = new IngredientStack(DataOperator.getVarInType(DataPacketTypeItemStack.class, (IDataType)s, (DataPacket)packet).value);
                ss.inputSize = count.value;
            } else {
                ss = new IngredientStack("*", count.value);
            }
            InserterTaskItem task2 = new InserterTaskItem(ss, null, null);
            task2.overrideTakeAmount = 1;
            task2.isJob = false;
            this.tasks.add(task2);
        } else {
            switch (c.valueToString()) {
                case "add": {
                    String ss;
                    EnumFacing f;
                    if (!packet.hasVariable(Character.valueOf('a')) || !TASKS.containsKey(a.valueToString())) break;
                    Function<NBTTagCompound, TileEntityInserterBase.InserterTask> fun = TASKS.get(a.valueToString());
                    TileEntityInserterBase.InserterTask task3 = fun.apply(new NBTTagCompound());
                    if (packet.hasVariable(Character.valueOf('i'))) {
                        f = null;
                        if (i instanceof DataPacketTypeInteger) {
                            f = EnumFacing.func_176731_b((int)EnumFacing.func_82600_a((int)((DataPacketTypeInteger)i).value).func_176736_b());
                        } else if (i instanceof DataPacketTypeString) {
                            ss = i.valueToString().toUpperCase();
                            f = Arrays.stream(EnumFacing.values()).filter(e -> e.name().equals(ss)).findFirst().orElse(null);
                        }
                        if (f != null) {
                            task3.facingIn = f;
                        }
                    }
                    if (packet.hasVariable(Character.valueOf('o'))) {
                        f = null;
                        if (o instanceof DataPacketTypeInteger) {
                            f = EnumFacing.func_176731_b((int)EnumFacing.func_82600_a((int)((DataPacketTypeInteger)o).value).func_176736_b());
                        } else if (o instanceof DataPacketTypeString) {
                            ss = o.valueToString().toUpperCase();
                            f = Arrays.stream(EnumFacing.values()).filter(e -> e.name().equals(ss)).findFirst().orElse(null);
                        }
                        if (f != null) {
                            task3.facingOut = f;
                        }
                    }
                    if (packet.getPacketVariable(Character.valueOf('1')) instanceof DataPacketTypeInteger) {
                        task3.distanceIn = MathHelper.func_76125_a((int)((DataPacketTypeInteger)packet.getPacketVariable((Character)Character.valueOf((char)'1'))).value, (int)-1, (int)2);
                    }
                    if (packet.getPacketVariable(Character.valueOf('0')) instanceof DataPacketTypeInteger) {
                        task3.distanceOut = MathHelper.func_76125_a((int)((DataPacketTypeInteger)packet.getPacketVariable((Character)Character.valueOf((char)'0'))).value, (int)-1, (int)2);
                    }
                    if (packet.hasVariable(Character.valueOf('s'))) {
                        task3.stack = Utils.ingredientFromData(packet.getPacketVariable(Character.valueOf('s')));
                    }
                    if (packet.hasVariable(Character.valueOf('e'))) {
                        int requested = packet.getPacketVariable(Character.valueOf('e')) instanceof DataPacketTypeInteger ? DataOperator.getVarInType(DataPacketTypeInteger.class, (IDataType)packet.getPacketVariable((Character)Character.valueOf((char)'e')), (DataPacket)packet).value : task3.stack.inputSize;
                        task3.overrideTakeAmount = task3.stack.inputSize;
                        task3.stack.inputSize = requested;
                        task3.isJob = false;
                    }
                    if (packet.hasVariable(Character.valueOf('t'))) {
                        task3.overrideTakeAmount = MathHelper.func_76125_a((int)DataOperator.getVarInType(DataPacketTypeInteger.class, (IDataType)packet.getPacketVariable((Character)Character.valueOf((char)'t')), (DataPacket)packet).value, (int)1, (int)64);
                        task3.strictAmount = true;
                    }
                    this.tasks.add(task3);
                    break;
                }
                case "remove": {
                    if (a instanceof DataPacketTypeInteger) {
                        this.tasks.remove(((DataPacketTypeInteger)a).value);
                        break;
                    }
                    Predicate<TileEntityInserterBase.InserterTask> p = s instanceof DataPacketTypeString ? packerTask -> packerTask.stack.oreName.equals(s.valueToString()) : (s instanceof DataPacketTypeItemStack ? packerTask -> packerTask.stack.equals((Object)Utils.ingredientFromData(s)) : packerTask -> true);
                    if (packet.hasVariable(Character.valueOf('a'))) {
                        p = p.and(task -> task.getName().equals(a.valueToString()));
                    }
                    this.tasks.removeIf(p);
                    break;
                }
                case "clear": {
                    this.tasks.clear();
                    this.current = null;
                }
            }
            this.sendUpdate();
        }
    }

    static {
        TASKS.put("item", InserterTaskItem::new);
        TASKS.put("place_block", InserterTaskPlaceBlock::new);
        TASKS.put("from_minecart", InserterTaskFromMinecart::new);
        TASKS.put("into_minecart", InserterTaskIntoMinecart::new);
    }

    public static class InserterTaskIntoMinecart
    extends InserterTaskItem {
        public InserterTaskIntoMinecart(NBTTagCompound nbt) {
            super(nbt);
        }

        @Override
        public boolean canExecute(TileEntityInserterBase tile, World world, BlockPos posIn, BlockPos posOut, EnumFacing facingIn, EnumFacing facingOut, boolean in) {
            if (!in) {
                return world.func_72872_a(EntityMinecartEmpty.class, new AxisAlignedBB(posOut)).stream().findFirst().isPresent();
            }
            return super.canExecute(tile, world, posIn, posOut, facingIn, facingOut, in);
        }

        @Override
        public boolean execute(TileEntityInserterBase tile, World world, BlockPos posIn, BlockPos posOut, EnumFacing facingIn, EnumFacing facingOut, boolean in) {
            if (!in) {
                Optional first = world.func_72872_a(EntityMinecartEmpty.class, new AxisAlignedBB(posOut)).stream().findFirst();
                if (first.isPresent()) {
                    EntityMinecartEmpty cart = (EntityMinecartEmpty)first.get();
                    ItemStack placed = ((ItemStack)tile.inventory.get(0)).func_77946_l();
                    placed.func_190920_e(1);
                    ((ItemStack)tile.inventory.get(0)).func_190918_g(1);
                    EntityMinecart c = MinecartBlockHelper.getMinecartFromBlockStack(placed, world);
                    c.func_70107_b(cart.field_70165_t, cart.field_70163_u, cart.field_70161_v);
                    ((IMinecartBlockPickable)c).setMinecartBlock(placed);
                    cart.func_70106_y();
                    world.func_72838_d((Entity)c);
                    return true;
                }
                return false;
            }
            return super.execute(tile, world, posIn, posOut, facingIn, facingOut, in);
        }

        @Override
        String getName() {
            return "into_minecart";
        }

        @Override
        public float getTimeModifier() {
            return 2.0f;
        }
    }

    public static class InserterTaskFromMinecart
    extends InserterTaskItem {
        public InserterTaskFromMinecart(NBTTagCompound nbt) {
            super(nbt);
        }

        @Override
        public boolean canExecute(TileEntityInserterBase tile, World world, BlockPos posIn, BlockPos posOut, EnumFacing facingIn, EnumFacing facingOut, boolean in) {
            if (in) {
                Optional first = world.func_175647_a(EntityMinecart.class, new AxisAlignedBB(posIn), entity -> entity instanceof IMinecartBlockPickable).stream().findFirst();
                return first.isPresent();
            }
            return super.canExecute(tile, world, posIn, posOut, facingIn, facingOut, in);
        }

        @Override
        public boolean execute(TileEntityInserterBase tile, World world, BlockPos posIn, BlockPos posOut, EnumFacing facingIn, EnumFacing facingOut, boolean in) {
            if (in) {
                Optional first = world.func_175647_a(EntityMinecart.class, new AxisAlignedBB(posIn), entity -> entity instanceof IMinecartBlockPickable).stream().findFirst();
                if (first.isPresent()) {
                    EntityMinecart cart = (EntityMinecart)first.get();
                    Tuple<ItemStack, EntityMinecart> block = ((IMinecartBlockPickable)cart).getBlockForPickup();
                    tile.inventory.set(0, (Object)((ItemStack)block.func_76341_a()).func_77946_l());
                    EntityMinecart c = MinecartBlockHelper.getMinecartFromBlockStack(ItemStack.field_190927_a, world);
                    c.func_70107_b(cart.field_70165_t, cart.field_70163_u, cart.field_70161_v);
                    cart.func_70106_y();
                    world.func_72838_d((Entity)c);
                    if (!this.isJob) {
                        this.stack.inputSize = Math.max(0, this.stack.inputSize - 1);
                    }
                    return true;
                }
                return false;
            }
            return super.execute(tile, world, posIn, posOut, facingIn, facingOut, in);
        }

        @Override
        String getName() {
            return "from_minecart";
        }

        @Override
        public float getTimeModifier() {
            return 2.0f;
        }
    }

    public static class InserterTaskPlaceBlock
    extends InserterTaskItem {
        public InserterTaskPlaceBlock(NBTTagCompound nbt) {
            super(nbt);
        }

        @Override
        public boolean canExecute(TileEntityInserterBase tile, World world, BlockPos posIn, BlockPos posOut, EnumFacing facingIn, EnumFacing facingOut, boolean in) {
            if (!in) {
                return true;
            }
            return super.canExecute(tile, world, posIn, posOut, facingIn, facingOut, in);
        }

        @Override
        public boolean execute(TileEntityInserterBase tile, World world, BlockPos posIn, BlockPos posOut, EnumFacing facingIn, EnumFacing facingOut, boolean in) {
            if (!in) {
                ItemStack stack = (ItemStack)tile.inventory.get(0);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBlock)) {
                    return false;
                }
                if (world.func_190527_a(((ItemBlock)stack.func_77973_b()).func_179223_d(), posOut, false, facingOut, null)) {
                    FakePlayer fakePlayer = FakePlayerUtil.getFakePlayer((World)world);
                    IBlockState state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_180642_a(world, posOut, facingOut, 0.5f, 0.5f, 0.5f, stack.func_77960_j(), (EntityLivingBase)fakePlayer);
                    boolean b = ((ItemBlock)stack.func_77973_b()).placeBlockAt((ItemStack)tile.inventory.get(0), (EntityPlayer)fakePlayer, world, posOut, facingOut, 0.5f, 0.5f, 0.5f, state);
                    if (b) {
                        ((ItemStack)tile.inventory.get(0)).func_190918_g(1);
                    }
                    if (!this.isJob) {
                        this.stack.inputSize = Math.max(0, this.stack.inputSize - 1);
                    }
                    return b;
                }
                return false;
            }
            return super.execute(tile, world, posIn, posOut, facingIn, facingOut, in);
        }

        @Override
        String getName() {
            return "place_block";
        }

        @Override
        public float getTimeModifier() {
            return 0.5f;
        }
    }

    public static class InserterTaskItem
    extends TileEntityInserterBase.InserterTask {
        public InserterTaskItem(IngredientStack stack, @Nullable EnumFacing facingIn, @Nullable EnumFacing facingOut) {
            super(facingIn, facingOut);
            this.stack = stack;
        }

        public InserterTaskItem(NBTTagCompound nbt) {
            super(nbt);
            this.stack = IngredientStack.readFromNBT((NBTTagCompound)((NBTTagCompound)nbt.func_74781_a("stack")));
        }

        @Override
        @ParametersAreNonnullByDefault
        public boolean canExecute(TileEntityInserterBase tile, World world, BlockPos posIn, BlockPos posOut, EnumFacing facingIn, EnumFacing facingOut, boolean in) {
            EnumFacing facing;
            IItemHandler cap = null;
            TileEntity te = world.func_175625_s(in ? posIn : posOut);
            EnumFacing enumFacing = facing = in ? facingIn : facingOut;
            if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
                cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            } else {
                Optional first = world.func_175647_a(Entity.class, new AxisAlignedBB(in ? posIn : posOut), input -> input.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())).stream().findFirst();
                if (first.isPresent()) {
                    cap = (IItemHandler)((Entity)first.get()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
                }
            }
            if (cap != null) {
                if (in) {
                    int toBeTaken = this.overrideTakeAmount != -1 ? this.overrideTakeAmount : Math.min(tile.takeAmount, this.isJob ? this.stack.inputSize : tile.takeAmount);
                    for (int slot = 0; slot < cap.getSlots(); ++slot) {
                        ItemStack inSlot = cap.getStackInSlot(slot);
                        if (inSlot.func_190926_b() || !"*".equals(this.stack.oreName) && !this.stack.matchesItemStackIgnoringSize(inSlot)) continue;
                        int actualSize = Math.min(inSlot.func_190916_E(), toBeTaken);
                        cap.extractItem(slot, actualSize, true);
                        if ((toBeTaken -= actualSize) != 0) continue;
                        return true;
                    }
                    return this.strictAmount && !((ItemStack)tile.inventory.get(0)).func_190926_b();
                }
                return ItemHandlerHelper.insertItem((IItemHandler)cap, (ItemStack)((ItemStack)tile.inventory.get(0)), (boolean)true).func_190926_b();
            }
            return false;
        }

        @Override
        public boolean execute(TileEntityInserterBase tile, World world, BlockPos posIn, BlockPos posOut, EnumFacing facingIn, EnumFacing facingOut, boolean in) {
            EnumFacing facing;
            IItemHandler cap = null;
            TileEntity te = world.func_175625_s(in ? posIn : posOut);
            EnumFacing enumFacing = facing = in ? facingIn : facingOut;
            if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
                cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            } else {
                Optional first = world.func_175647_a(Entity.class, new AxisAlignedBB(in ? posIn : posOut), input -> input.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())).stream().findFirst();
                if (first.isPresent()) {
                    cap = (IItemHandler)((Entity)first.get()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
                }
            }
            if (cap != null) {
                if (in) {
                    int toBeTaken = this.overrideTakeAmount != -1 ? this.overrideTakeAmount : Math.min(tile.takeAmount, !this.isJob ? this.stack.inputSize : tile.takeAmount);
                    for (int slot = 0; slot < cap.getSlots(); ++slot) {
                        ItemStack inSlot = cap.getStackInSlot(slot);
                        if (inSlot.func_190926_b() || !"*".equals(this.stack.oreName) && !this.stack.matchesItemStackIgnoringSize(inSlot)) continue;
                        int actualSize = Math.min(inSlot.func_190916_E(), toBeTaken);
                        ItemStack left = tile.insertionHandler.insertItem(0, cap.extractItem(slot, actualSize, false), false);
                        actualSize -= left.func_190916_E();
                        if (!this.isJob) {
                            this.stack.inputSize = Math.max(0, this.stack.inputSize - actualSize);
                        }
                        if ((toBeTaken -= actualSize) != 0) continue;
                        return true;
                    }
                    return this.strictAmount && !((ItemStack)tile.inventory.get(0)).func_190926_b();
                }
                tile.inventory.set(0, (Object)ItemHandlerHelper.insertItem((IItemHandler)cap, (ItemStack)((ItemStack)tile.inventory.get(0)), (boolean)false));
                return ((ItemStack)tile.inventory.get(0)).func_190926_b();
            }
            return false;
        }

        @Override
        public boolean shouldContinue() {
            return this.stack.inputSize > 0;
        }

        @Override
        public NBTTagCompound toNBT() {
            NBTTagCompound nbt = super.toNBT();
            nbt.func_74782_a("stack", (NBTBase)this.stack.writeToNBT(new NBTTagCompound()));
            return nbt;
        }

        @Override
        String getName() {
            return "item";
        }

        @Override
        public float getTimeModifier() {
            return 0.0f;
        }
    }
}

