/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.second;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.oredict.OreDictionary;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.crafting.CoagulatorRecipe;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.second.MultiblockCoagulator;

public class TileEntityCoagulator
extends TileEntityMultiblockMetal<TileEntityCoagulator, CoagulatorRecipe>
implements IEBlockInterfaces.ISoundTile,
IEBlockInterfaces.IGuiTile {
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(Config.IIConfig.Machines.Coagulator.fluidCapacity), new FluidTank(Config.IIConfig.Machines.Coagulator.fluidCapacity)};
    public NonNullList<ItemStack> effect = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    public int[] bucketProgress = new int[]{0, 0, 0, 0, 0, 0};
    public NonNullList<ItemStack> bucketStacks = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    public int cranePosition = 0;
    public int craneBucket = -1;
    public int craneProgress = 0;
    public CraneAnimation craneAnimation = CraneAnimation.NONE;

    public TileEntityCoagulator() {
        super((MultiblockHandler.IMultiblock)MultiblockCoagulator.instance, MultiblockCoagulator.instance.getSize(), Config.IIConfig.Machines.Coagulator.energyCapacity, true);
    }

    public void func_73660_a() {
        int i;
        CoagulatorRecipe recipe;
        super.func_73660_a();
        if (this.isDummy() || this.isRSDisabled()) {
            return;
        }
        if (this.craneBucket != -1) {
            if (this.craneProgress > 0) {
                --this.craneProgress;
            } else {
                switch (this.craneAnimation) {
                    case MOVE_BUCKET: 
                    case MOVE_BACK: {
                        this.cranePosition += Integer.compare(this.craneBucket, this.cranePosition);
                        if (this.cranePosition != this.craneBucket) break;
                        this.craneAnimation = Utils.cycleEnum(true, CraneAnimation.class, this.craneAnimation);
                        break;
                    }
                    case MOVE_MIXER: {
                        this.cranePosition += Integer.compare(2, this.cranePosition);
                        if (this.cranePosition != 2) break;
                        this.craneAnimation = Utils.cycleEnum(true, CraneAnimation.class, this.craneAnimation);
                        break;
                    }
                    default: {
                        this.craneAnimation = Utils.cycleEnum(true, CraneAnimation.class, this.craneAnimation);
                        break;
                    }
                    case RETURN: {
                        if (!this.field_145850_b.field_72995_K) {
                            this.bucketProgress[this.craneBucket] = CoagulatorRecipe.getBucketProgressForStack((ItemStack)this.effect.get(0));
                            this.bucketStacks.set(this.craneBucket, (Object)((ItemStack)this.effect.get(0)).func_77946_l());
                            ((ItemStack)this.bucketStacks.get(this.craneBucket)).func_190920_e(1);
                            ((ItemStack)this.effect.get(0)).func_190918_g(1);
                            this.func_70296_d();
                            this.markContainingBlockForUpdate(null);
                        }
                        this.craneBucket = -1;
                        this.craneProgress = 0;
                        this.craneAnimation = CraneAnimation.NONE;
                    }
                }
                switch (this.craneAnimation) {
                    default: {
                        break;
                    }
                    case MOVE_BUCKET: 
                    case MOVE_BACK: {
                        this.craneProgress = this.cranePosition == this.craneBucket ? 0 : Config.IIConfig.Machines.Coagulator.craneMoveTime;
                        break;
                    }
                    case MOVE_MIXER: {
                        this.craneProgress = this.cranePosition == 2 ? 0 : Config.IIConfig.Machines.Coagulator.craneMoveTime;
                        break;
                    }
                    case ROTATE_IN: 
                    case ROTATE_OUT: {
                        this.craneProgress = Config.IIConfig.Machines.Coagulator.craneMoveTime;
                        break;
                    }
                    case PICK: 
                    case PUT: 
                    case PULL: 
                    case REACH: 
                    case PLACE: 
                    case RETURN: {
                        this.craneProgress = Config.IIConfig.Machines.Coagulator.craneGrabTime;
                    }
                }
            }
        }
        if (this.field_145850_b.field_72995_K) {
            for (int i2 = 0; i2 < this.bucketProgress.length; ++i2) {
                this.bucketProgress[i2] = Math.max(0, this.bucketProgress[i2] - 1);
            }
            return;
        }
        if (this.processQueue.isEmpty() && this.tanks[0].getFluidAmount() > 0 && this.tanks[1].getFluidAmount() > 0 && (recipe = CoagulatorRecipe.findRecipe(this.tanks[0].getFluid(), this.tanks[1].getFluid())) != null && (((ItemStack)this.effect.get(0)).func_190926_b() || OreDictionary.itemMatches((ItemStack)((ItemStack)this.effect.get(0)), (ItemStack)recipe.itemOutput, (boolean)false))) {
            TileEntityMultiblockMetal.MultiblockProcessInMachine process = new TileEntityMultiblockMetal.MultiblockProcessInMachine((IMultiblockRecipe)recipe, new int[0]);
            process.setInputTanks(new int[]{0, 1});
            this.addProcessToQueue((TileEntityMultiblockMetal.MultiblockProcess)process, false);
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
        for (i = 0; i < this.bucketStacks.size(); ++i) {
            if (((ItemStack)this.bucketStacks.get(i)).func_190926_b()) continue;
            int n = i;
            this.bucketProgress[n] = this.bucketProgress[n] - 1;
            if (this.bucketProgress[n] > 0) continue;
            this.bucketProgress[i] = 0;
            ItemStack copy = (ItemStack)this.bucketStacks.get(i);
            this.bucketStacks.set(i, (Object)ItemStack.field_190927_a);
            blusunrize.immersiveengineering.common.util.Utils.dropStackAtPos((World)this.field_145850_b, (BlockPos)this.getBlockPosForPos(28 + i).func_177972_a(this.facing), (ItemStack)copy, null);
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
        if (!((ItemStack)this.effect.get(0)).func_190926_b() && this.craneAnimation == CraneAnimation.NONE && this.craneBucket == -1) {
            for (i = 0; i < this.bucketStacks.size(); ++i) {
                if (!((ItemStack)this.bucketStacks.get(i)).func_190926_b()) continue;
                this.craneBucket = i;
                this.craneProgress = 0;
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
                break;
            }
        }
    }

    public void readCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        this.tanks[0] = this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1] = this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.effect = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)nbt.func_150295_c("effect", 10), (int)1);
        this.bucketStacks = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)nbt.func_150295_c("bucketStacks", 10), (int)6);
        this.bucketProgress = nbt.func_74759_k("bucketProgress");
        if (this.bucketProgress.length != 6) {
            this.bucketProgress = new int[]{0, 0, 0, 0, 0, 0};
        }
        this.cranePosition = nbt.func_74762_e("cranePosition");
        this.craneBucket = nbt.func_74762_e("craneBucket");
        this.craneProgress = nbt.func_74762_e("craneProgress");
        this.craneAnimation = CraneAnimation.values()[MathHelper.func_76125_a((int)nbt.func_74762_e("craneAnimation"), (int)0, (int)CraneAnimation.values().length)];
    }

    public void writeCustomNBT(@Nonnull NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.isDummy()) {
            return;
        }
        nbt.func_74782_a("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank1", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("effect", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.effect));
        nbt.func_74782_a("bucketStacks", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.bucketStacks));
        nbt.func_74783_a("bucketProgress", this.bucketProgress);
        nbt.func_74768_a("cranePosition", this.cranePosition);
        nbt.func_74768_a("craneBucket", this.craneBucket);
        nbt.func_74768_a("craneProgress", this.craneProgress);
        nbt.func_74768_a("craneAnimation", this.craneAnimation.ordinal());
    }

    public void receiveMessageFromServer(@Nonnull NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (this.isDummy()) {
            return;
        }
        if (message.func_74764_b("tank0")) {
            this.tanks[0] = this.tanks[0].readFromNBT(message.func_74775_l("tank0"));
        }
        if (message.func_74764_b("tank1")) {
            this.tanks[1] = this.tanks[1].readFromNBT(message.func_74775_l("tank1"));
        }
        if (message.func_74764_b("effect")) {
            this.effect = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)message.func_150295_c("effect", 10), (int)1);
        }
        if (message.func_74764_b("bucketStacks")) {
            this.bucketStacks = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)message.func_150295_c("bucketStacks", 10), (int)6);
        }
        if (message.func_74764_b("bucketProgress")) {
            this.bucketProgress = message.func_74759_k("bucketProgress");
            if (this.bucketProgress.length != 6) {
                this.bucketProgress = new int[]{0, 0, 0, 0, 0, 0};
            }
        }
        if (message.func_74764_b("craneAnimation")) {
            this.cranePosition = message.func_74762_e("cranePosition");
            this.craneBucket = message.func_74762_e("craneBucket");
            this.craneProgress = message.func_74762_e("craneProgress");
            this.craneAnimation = CraneAnimation.values()[MathHelper.func_76125_a((int)message.func_74762_e("craneAnimation"), (int)0, (int)CraneAnimation.values().length)];
        }
    }

    @Nonnull
    protected CoagulatorRecipe readRecipeFromNBT(@Nonnull NBTTagCompound tag) {
        return CoagulatorRecipe.loadFromNBT(tag);
    }

    @Nonnull
    public int[] getEnergyPos() {
        return new int[]{97};
    }

    @Nonnull
    public int[] getRedstonePos() {
        return new int[]{77};
    }

    @Nonnull
    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Nonnull
    public CoagulatorRecipe findRecipeForInsertion(@Nonnull ItemStack inserting) {
        return null;
    }

    @Nonnull
    public int[] getOutputSlots() {
        return new int[]{0};
    }

    @Nonnull
    public int[] getOutputTanks() {
        return new int[0];
    }

    public boolean additionalCanProcessCheck(@Nonnull TileEntityMultiblockMetal.MultiblockProcess<CoagulatorRecipe> process) {
        return true;
    }

    public void doProcessOutput(@Nonnull ItemStack output) {
    }

    public void doProcessFluidOutput(@Nonnull FluidStack output) {
    }

    public void onProcessFinish(@Nonnull TileEntityMultiblockMetal.MultiblockProcess<CoagulatorRecipe> process) {
    }

    public int getMaxProcessPerTick() {
        return 1;
    }

    public int getProcessQueueMaxLength() {
        return 1;
    }

    public float getMinProcessDistance(@Nonnull TileEntityMultiblockMetal.MultiblockProcess<CoagulatorRecipe> process) {
        return 0.84f;
    }

    public boolean isInWorldProcessingMachine() {
        return true;
    }

    @Nonnull
    protected IFluidTank[] getAccessibleFluidTanks(@Nonnull EnumFacing enumFacing) {
        TileEntityCoagulator master;
        if ((this.field_174879_c == 146 || this.field_174879_c == 140) && (master = (TileEntityCoagulator)this.master()) != null) {
            return new IFluidTank[]{this.field_174879_c == 146 ? master.tanks[0] : master.tanks[1]};
        }
        return new IFluidTank[0];
    }

    protected boolean canFillTankFrom(int i, @Nonnull EnumFacing enumFacing, @Nonnull FluidStack fluidStack) {
        return true;
    }

    protected boolean canDrainTankFrom(int i, @Nonnull EnumFacing enumFacing) {
        return false;
    }

    @Nonnull
    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public NonNullList<ItemStack> getInventory() {
        return this.effect;
    }

    public boolean isStackValid(int i, ItemStack itemStack) {
        return true;
    }

    public int getSlotLimit(int i) {
        return 64;
    }

    public void doGraphicalUpdates(int i) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    public boolean shoudlPlaySound(@Nonnull String sound) {
        TileEntityCoagulator master = (TileEntityCoagulator)this.master();
        return false;
    }

    public boolean canOpenGui() {
        return false;
    }

    public int getGuiID() {
        return IIGuiList.GUI_COAGULATOR.ordinal();
    }

    @Nullable
    public TileEntity getGuiMaster() {
        return this.master();
    }

    public static enum CraneAnimation {
        NONE,
        MOVE_BUCKET,
        REACH,
        PICK,
        MOVE_MIXER,
        ROTATE_IN,
        PUT,
        PULL,
        ROTATE_OUT,
        MOVE_BACK,
        PLACE,
        RETURN;

    }
}

