/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.second;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConveyorBelt;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleRedstone;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.crafting.DustStack;
import pl.pabilo8.immersiveintelligence.api.crafting.DustUtils;
import pl.pabilo8.immersiveintelligence.api.crafting.FillerRecipe;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.second.MultiblockFiller;

public class TileEntityFiller
extends TileEntityMultiblockMetal<TileEntityFiller, FillerRecipe>
implements ConveyorHandler.IConveyorAttachable,
IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.IAdvancedSelectionBounds {
    public DustStack dustStorage = DustStack.getEmptyStack();
    public final int dustCapacity = Config.IIConfig.Machines.Filler.dustCapacity;
    NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    IItemHandler insertionHandler = new TileEntityMultiblockMetal.MultiblockInventoryHandler_DirectProcessing((TileEntityMultiblockMetal)this);

    public TileEntityFiller() {
        super((MultiblockHandler.IMultiblock)MultiblockFiller.instance, MultiblockFiller.instance.getSize(), Config.IIConfig.Machines.Filler.energyCapacity, true);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.isDummy() || this.isRSDisabled()) {
            return;
        }
        if (this.dustStorage.amount < this.dustCapacity && this.field_145850_b.func_82737_E() % 4L == 0L && !((ItemStack)this.inventory.get(0)).func_190926_b()) {
            ItemStack copy = ((ItemStack)this.inventory.get(0)).func_77946_l();
            copy.func_190920_e(1);
            DustStack dustStack = DustUtils.fromItemStack(copy);
            if (!dustStack.isEmpty() && this.dustStorage.mergeWith((DustStack)dustStack).amount < this.dustCapacity && (this.dustStorage.isEmpty() || this.dustStorage.canMergeWith(dustStack))) {
                ((ItemStack)this.inventory.get(0)).func_190918_g(1);
                this.dustStorage = this.dustStorage.mergeWith(dustStack);
            }
        }
        if (this.field_145850_b.field_72995_K) {
            for (TileEntityMultiblockMetal.MultiblockProcess process : this.processQueue) {
                float tick = 1.0f / (float)process.maxTicks;
                float fProcess = (float)process.processTick * tick;
                float transportTime = 0.4375f;
                if (!(fProcess >= transportTime) || !(fProcess < 1.0f - transportTime)) continue;
                this.spawnDustParticle((TileEntityMultiblockMetal.MultiblockProcess<FillerRecipe>)process);
                break;
            }
            return;
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("dustStorage", (NBTBase)this.dustStorage.serializeNBT());
            ImmersiveEngineering.packetHandler.sendToAllTracking((IMessage)new MessageTileSync((TileEntityIEBase)this, nbt), Utils.targetPointFromTile((TileEntity)this, 16));
        }
        for (TileEntityMultiblockMetal.MultiblockProcess process : this.processQueue) {
            float tick = 1.0f / (float)process.maxTicks;
            float fProcess = (float)process.processTick * tick;
            float transportTime = 0.4375f;
            float pressTime = 0.03125f;
            if (!(fProcess >= transportTime + pressTime) || !(fProcess < transportTime + pressTime + tick)) continue;
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187753_eE, SoundCategory.BLOCKS, 0.3f, 1.0f);
        }
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (!descPacket) {
            this.dustStorage = new DustStack(nbt.func_74775_l("dustStorage"));
            this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)this.inventory.size());
        }
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!descPacket) {
            nbt.func_74782_a("dustStorage", (NBTBase)this.dustStorage.serializeNBT());
            nbt.func_74782_a("inventory", (NBTBase)blusunrize.immersiveengineering.common.util.Utils.writeInventory(this.inventory));
        }
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
        super.receiveMessageFromServer(message);
        if (message.func_74764_b("dustStorage")) {
            this.dustStorage = new DustStack(message.func_74775_l("dustStorage"));
        }
        if (message.func_74764_b("inventory")) {
            this.inventory = blusunrize.immersiveengineering.common.util.Utils.readInventory((NBTTagList)message.func_150295_c("inventory", 10), (int)this.inventory.size());
        }
    }

    protected FillerRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return FillerRecipe.loadFromNBT(tag);
    }

    public int[] getEnergyPos() {
        return new int[]{21};
    }

    public int[] getRedstonePos() {
        return new int[0];
    }

    public IFluidTank[] getInternalTanks() {
        return null;
    }

    public FillerRecipe findRecipeForInsertion(ItemStack inserting) {
        return FillerRecipe.findRecipe(inserting, this.dustStorage);
    }

    public int[] getOutputSlots() {
        return null;
    }

    public int[] getOutputTanks() {
        return null;
    }

    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<FillerRecipe> process) {
        return true;
    }

    public void doProcessOutput(ItemStack output) {
        BlockPos pos = this.getBlockPosForPos(11).func_177972_a(this.getOutFacing());
        TileEntity inventoryTile = this.field_145850_b.func_175625_s(pos);
        if (inventoryTile != null) {
            output = blusunrize.immersiveengineering.common.util.Utils.insertStackIntoInventory((TileEntity)inventoryTile, (ItemStack)output, (EnumFacing)this.getOutFacing().func_176734_d());
        }
        if (!output.func_190926_b()) {
            blusunrize.immersiveengineering.common.util.Utils.dropStackAtPos((World)this.field_145850_b, (BlockPos)pos, (ItemStack)output, (EnumFacing)this.facing);
        }
    }

    public void doProcessFluidOutput(FluidStack output) {
    }

    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<FillerRecipe> process) {
    }

    public int getMaxProcessPerTick() {
        return 3;
    }

    public int getProcessQueueMaxLength() {
        return 3;
    }

    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<FillerRecipe> process) {
        return 0.53125f;
    }

    public boolean isInWorldProcessingMachine() {
        return true;
    }

    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing enumFacing) {
        return new IFluidTank[0];
    }

    protected boolean canFillTankFrom(int i, EnumFacing enumFacing, FluidStack fluidStack) {
        return false;
    }

    protected boolean canDrainTankFrom(int i, EnumFacing enumFacing) {
        return false;
    }

    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int i, ItemStack itemStack) {
        return DustUtils.isDustStack(itemStack);
    }

    public int getSlotLimit(int i) {
        return 64;
    }

    public void doGraphicalUpdates(int i) {
    }

    public void replaceStructureBlock(BlockPos pos, IBlockState state, ItemStack stack, int h, int l, int w) {
        super.replaceStructureBlock(pos, state, stack, h, l, w);
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        if (tile instanceof TileEntityConveyorBelt) {
            ((TileEntityConveyorBelt)tile).setFacing(this.getOutFacing());
        }
    }

    private EnumFacing getOutFacing() {
        return this.mirrored ? this.facing.func_176735_f() : this.facing.func_176746_e();
    }

    public void onEntityCollision(World world, Entity entity) {
        if (!(this.field_174879_c != 24 && this.field_174879_c != 9 || world.field_72995_K || entity == null || entity.field_70128_L || !(entity instanceof EntityItem) || ((EntityItem)entity).func_92059_d().func_190926_b())) {
            TileEntityFiller master = (TileEntityFiller)this.master();
            if (master == null) {
                return;
            }
            ItemStack stack = ((EntityItem)entity).func_92059_d();
            if (stack.func_190926_b()) {
                return;
            }
            if (this.field_174879_c != 24 && this.field_174879_c == 9) {
                FillerRecipe recipe = master.findRecipeForInsertion(stack);
                if (recipe == null) {
                    return;
                }
                float transformationPoint = 0.46875f;
                ItemStack displayStack = recipe.getDisplayStack(stack);
                TileEntityMultiblockMetal.MultiblockProcessInWorld process = new TileEntityMultiblockMetal.MultiblockProcessInWorld((IMultiblockRecipe)recipe, transformationPoint, blusunrize.immersiveengineering.common.util.Utils.createNonNullItemStackListFromItemStack((ItemStack)displayStack));
                if (master.addProcessToQueue((TileEntityMultiblockMetal.MultiblockProcess)process, true)) {
                    master.addProcessToQueue((TileEntityMultiblockMetal.MultiblockProcess)process, false);
                    stack.func_190918_g(displayStack.func_190916_E());
                    if (stack.func_190916_E() <= 0) {
                        entity.func_70106_y();
                    }
                }
            }
        }
    }

    public boolean addProcessToQueue(TileEntityMultiblockMetal.MultiblockProcess<FillerRecipe> process, boolean simulate, boolean addToPrevious) {
        if (!this.dustStorage.canMergeWith(((FillerRecipe)process.recipe).dust) || this.dustStorage.amount < ((FillerRecipe)process.recipe).dust.amount) {
            return false;
        }
        boolean b = super.addProcessToQueue(process, simulate, addToPrevious);
        if (b && !simulate) {
            this.dustStorage = this.dustStorage.getSubtracted(((FillerRecipe)process.recipe).dust);
        }
        return b;
    }

    public EnumFacing[] sigOutputDirections() {
        if (this.field_174879_c == 11) {
            return new EnumFacing[]{this.getOutFacing()};
        }
        return new EnumFacing[0];
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityFiller master = (TileEntityFiller)this.master();
            if (master == null) {
                return false;
            }
            return this.field_174879_c == 9 && facing == this.getOutFacing().func_176734_d();
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntityFiller master = (TileEntityFiller)this.master();
            if (master == null) {
                return null;
            }
            if (this.field_174879_c == 9 && facing == this.getOutFacing().func_176734_d()) {
                return (T)master.insertionHandler;
            }
            return null;
        }
        return (T)super.getCapability(capability, facing);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnDustParticle(TileEntityMultiblockMetal.MultiblockProcess<FillerRecipe> process) {
        Vec3d pos = new Vec3d((Vec3i)this.getBlockPosForPos(10)).func_72441_c(0.5, 0.0, 0.5);
        float mod = (float)(Math.random() * 2.0);
        ParticleRedstone particle = (ParticleRedstone)ClientUtils.mc().field_71452_i.func_178927_a(EnumParticleTypes.REDSTONE.func_179348_c(), pos.field_72450_a, pos.field_72448_b + 0.85, pos.field_72449_c, 0.0, -4.0, 0.0, new int[0]);
        ParticleRedstone particle2 = (ParticleRedstone)ClientUtils.mc().field_71452_i.func_178927_a(EnumParticleTypes.REDSTONE.func_179348_c(), pos.field_72450_a, pos.field_72448_b + 0.65, pos.field_72449_c, 0.0, -4.0, 0.0, new int[0]);
        ParticleRedstone particle3 = (ParticleRedstone)ClientUtils.mc().field_71452_i.func_178927_a(EnumParticleTypes.REDSTONE.func_179348_c(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, -4.0, 0.0, new int[0]);
        float[] rgb = this.getCurrentProcessColor((FillerRecipe)process.recipe);
        float dmod = 1.3043479f;
        if (particle != null) {
            particle.field_70570_a = 2.0f;
            particle.func_70538_b(rgb[0] * mod, rgb[1] * mod, rgb[2] * mod);
        }
        if (particle2 != null) {
            particle2.field_70570_a = 2.0f;
            particle2.func_70538_b(rgb[0] * 1.3043479f * mod, rgb[1] * 1.3043479f * mod, rgb[2] * 1.3043479f * mod);
        }
        if (particle3 != null) {
            particle3.field_70570_a = 2.0f;
            particle3.func_70538_b(rgb[0] * mod, rgb[1] * mod, rgb[2] * mod);
        }
    }

    private float[] getCurrentProcessColor(FillerRecipe recipe) {
        return Utils.rgbIntToRGB(DustUtils.getColor(((FillerRecipe)((TileEntityMultiblockMetal.MultiblockProcess)this.processQueue.get((int)0)).recipe).dust));
    }

    public NonNullList<ItemStack> getDroppedItems() {
        NonNullList droppedItems = super.getDroppedItems();
        if (!this.isDummy() && !this.dustStorage.isEmpty()) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>((Collection<ItemStack>)droppedItems);
            itemStacks.addAll(Arrays.asList(DustUtils.fromDustStack(this.dustStorage)));
            NonNullList list = NonNullList.func_191197_a((int)itemStacks.size(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < list.size(); ++i) {
                list.set(0, list.get(i));
            }
            return list;
        }
        return droppedItems;
    }

    public boolean canOpenGui() {
        return true;
    }

    public int getGuiID() {
        return IIGuiList.GUI_FILLER.ordinal();
    }

    @Nullable
    public TileEntity getGuiMaster() {
        return this.master();
    }

    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getAdvancedSelectionBounds();
    }

    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        block0 : switch (this.field_174879_c) {
            case 9: 
            case 10: 
            case 11: {
                list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                break;
            }
            case 24: {
                EnumFacing f = this.mirrored ? this.facing.func_176734_d() : this.facing;
                switch (f) {
                    case NORTH: {
                        break block0;
                    }
                    case SOUTH: {
                        list.add(new AxisAlignedBB(0.0, 0.0, 0.0625, 0.5, 0.0625, 0.9375).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                        list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 0.0625).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                        list.add(new AxisAlignedBB(0.0, 0.0, 0.9375, 0.5, 1.0, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                        list.add(new AxisAlignedBB(0.5, 0.375, 0.0, 0.9375, 1.0, 0.0625).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                        list.add(new AxisAlignedBB(0.5, 0.375, 0.9375, 0.9375, 1.0, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                        list.add(new AxisAlignedBB(0.0, 0.0625, 0.0625, 0.0625, 1.0, 0.9375).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                        list.add(new AxisAlignedBB(0.875, 0.375, 0.0625, 0.9375, 1.0, 0.9375).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                        list.add(new AxisAlignedBB(0.5, 0.0, 0.0625, 0.9375, 0.375, 0.9375).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                        break block0;
                    }
                    case EAST: {
                        break block0;
                    }
                }
                break;
            }
            case 21: {
                break;
            }
            case 12: {
                break;
            }
            default: {
                list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
        }
        return list;
    }

    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }
}

