/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.compat;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.Config;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.common.compat.ImmersiveEnergyHelper;
import pl.pabilo8.immersiveintelligence.common.compat.ImmersivePetroleumHelper;
import pl.pabilo8.immersiveintelligence.common.compat.ImmersivePostsHelper;
import pl.pabilo8.immersiveintelligence.common.compat.TerrafirmaHelper;
import pl.pabilo8.immersiveintelligence.common.compat.it.ImmersiveTechnologyHelper;

public abstract class IICompatModule {
    public static HashMap<String, Class<? extends IICompatModule>> moduleClasses = new HashMap();
    public static Set<IICompatModule> modules = new HashSet<IICompatModule>();
    public static boolean serene = false;
    public static boolean ii = false;
    public static boolean serverStartingDone;

    public static void doModulesPreInit() {
        for (Map.Entry<String, Class<? extends IICompatModule>> e : moduleClasses.entrySet()) {
            if (!Loader.isModLoaded((String)e.getKey())) continue;
            try {
                Boolean enabled = Config.IIConfig.compat.get(e.getKey());
                if (enabled == null || !enabled.booleanValue()) continue;
                IICompatModule m = e.getValue().newInstance();
                modules.add(m);
                m.preInit();
            }
            catch (Exception exception) {
                ImmersiveIntelligence.logger.error("Compat module for " + e.getKey() + " could not be preInitialized. Report this and include the error message below!", (Throwable)exception);
            }
        }
    }

    public static void doModulesRecipes() {
        for (IICompatModule compat : modules) {
            try {
                compat.registerRecipes();
            }
            catch (Exception exception) {
                ImmersiveIntelligence.logger.error("Compat module for " + compat + " could not register recipes. Report this and include the error message below!", (Throwable)exception);
            }
        }
    }

    public static void doModulesInit() {
        for (IICompatModule compat : modules) {
            try {
                compat.init();
            }
            catch (Exception exception) {
                ImmersiveIntelligence.logger.error("Compat module for " + compat + " could not be initialized. Report this and include the error message below!", (Throwable)exception);
            }
        }
    }

    public static void doModulesPostInit() {
        for (IICompatModule compat : modules) {
            try {
                compat.postInit();
            }
            catch (Exception exception) {
                ImmersiveIntelligence.logger.error("Compat module for " + compat + " could not be postInitialized. Report this and include the error message below!", (Throwable)exception);
            }
        }
    }

    public static void doModulesLoadComplete() {
        if (!serverStartingDone) {
            serverStartingDone = true;
            for (IICompatModule compat : modules) {
                try {
                    compat.loadComplete();
                }
                catch (Exception exception) {
                    ImmersiveIntelligence.logger.error("Compat module for " + compat + " could not be initialized. Report this and include the error message below!", (Throwable)exception);
                }
            }
        }
    }

    public abstract void preInit();

    public abstract void registerRecipes();

    public abstract void init();

    public abstract void postInit();

    public void loadComplete() {
    }

    @SideOnly(value=Side.CLIENT)
    public void clientPreInit() {
    }

    @SideOnly(value=Side.CLIENT)
    public void clientInit() {
    }

    @SideOnly(value=Side.CLIENT)
    public void clientPostInit() {
    }

    static {
        moduleClasses.put("immersivepetroleum", ImmersivePetroleumHelper.class);
        moduleClasses.put("immersiveposts", ImmersivePostsHelper.class);
        moduleClasses.put("immersivetech", ImmersiveTechnologyHelper.class);
        moduleClasses.put("immersive_energy", ImmersiveEnergyHelper.class);
        moduleClasses.put("tfc", TerrafirmaHelper.class);
        serverStartingDone = false;
    }
}

