/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.compat.crafttweaker;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import pl.pabilo8.immersiveintelligence.api.ShrapnelHandler;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.IBulletCore;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveintelligence.bullet.BulletTweaker")
@ZenRegister
public class BulletTweaker {
    @ZenMethod
    public static void addShrapnel(final String name, int color, String texture, int damage, float mass, float brightness) {
        ShrapnelHandler.addShrapnel(name, color, texture, damage, mass, brightness);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
            }

            public String describe() {
                return "Added shrapnel for " + name;
            }
        });
    }

    @ZenMethod
    public static void removeShrapnel(final String shrapnel) {
        ShrapnelHandler.removeShrapnel(shrapnel);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
            }

            public String describe() {
                return "Removed shrapnel for " + shrapnel;
            }
        });
    }

    @ZenClass(value="mods.immersiveintelligence.bullet.CoreMaterialBuilder")
    @ZenRegister
    public static class CoreMaterialBuilder {
        private final String name;
        private int color;
        private float density;
        private float dmgModifier;
        private float explosionModifier;
        private float penHardness;
        private Object stack;

        private CoreMaterialBuilder(String name) {
            this.name = name;
        }

        @ZenMethod
        public static CoreMaterialBuilder create(String name) {
            return new CoreMaterialBuilder("core_" + Utils.toSnakeCase(name));
        }

        @ZenMethod
        public void setColor(int color) {
            this.color = color;
        }

        @ZenMethod
        public void setDensity(float density) {
            this.density = density;
        }

        @ZenMethod
        public void setDmgModifier(float dmgModifier) {
            this.dmgModifier = dmgModifier;
        }

        @ZenMethod
        public void setExplosionModifier(float explosionModifier) {
            this.explosionModifier = explosionModifier;
        }

        @ZenMethod
        public void setPenHardness(float penHardness) {
            this.penHardness = penHardness;
        }

        @ZenMethod
        public void setStack(IIngredient stack) {
            this.stack = CraftTweakerHelper.toObject((IIngredient)stack);
        }

        @ZenMethod
        public void register() {
            CraftTweakerAPI.apply((IAction)new Add(this));
        }

        private static class Add
        implements IAction {
            private final CoreMaterialBuilder core;

            public Add(CoreMaterialBuilder core) {
                this.core = core;
            }

            public void apply() {
                final IngredientStack s = ApiUtils.createIngredientStack((Object)this.core.stack);
                BulletRegistry.INSTANCE.registerBulletCore(new IBulletCore(){

                    @Override
                    public String getName() {
                        return core.name;
                    }

                    @Override
                    public IngredientStack getMaterial() {
                        return s;
                    }

                    @Override
                    public float getDensity() {
                        return core.density;
                    }

                    @Override
                    public float getDamageModifier() {
                        return core.dmgModifier;
                    }

                    @Override
                    public float getExplosionModifier() {
                        return core.explosionModifier;
                    }

                    @Override
                    public float getPenetrationHardness() {
                        return core.penHardness;
                    }

                    @Override
                    public int getColour() {
                        return core.color;
                    }
                });
            }

            public String describe() {
                return "Adding Bullet Core for material " + this.core.name;
            }
        }
    }
}

