/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.compat.crafttweaker;

import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.List;
import net.minecraft.item.ItemStack;
import pl.pabilo8.immersiveintelligence.api.crafting.SawmillRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveintelligence.Sawmill")
@ZenRegister
public class SawmillRecipeTweaker {
    @ZenMethod
    public static void addRecipe(IIngredient itemInput, IItemStack itemOutput, IItemStack secondaryItemOutput, int torque, int time, int hardness, int dustColor) {
        Object oItemInput = CraftTweakerHelper.toObject((IIngredient)itemInput);
        if (oItemInput == null) {
            CraftTweakerAPI.getLogger().logError("Did not add sawmill recipe for " + itemOutput.getDisplayName() + ", input was null");
            return;
        }
        SawmillRecipe r = new SawmillRecipe(CraftTweakerHelper.toStack((IItemStack)itemOutput), oItemInput, CraftTweakerHelper.toStack((IItemStack)secondaryItemOutput), torque, time, hardness, dustColor);
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack((IItemStack)output)));
    }

    private static class Remove
    implements IAction {
        private final ItemStack output;
        List<SawmillRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = SawmillRecipe.removeRecipesForOutput(this.output);
        }

        public String describe() {
            return "Removing Sawmill Recipe for " + this.output.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final SawmillRecipe recipe;

        public Add(SawmillRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            SawmillRecipe.recipeList.add(this.recipe);
        }

        public String describe() {
            return "Adding SawmillRecipe Recipe for " + this.recipe.itemOutput.func_82833_r();
        }
    }
}

